/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.20 $
/*  $Date: 2005/03/20 18:16:27 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: IM_InterruptManager_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: IM_InterruptManager_op.c,v $
/*  Revision 1.20  2005/03/20 18:16:27  sebastiani
/*  watch dog reenabled; TIM_MMSU_DMA_DELAY cancelled in WriteEOT
/*
/*  Revision 1.19  2005/03/06 14:51:51  sebastiani
/*  fix
/*
/*  Revision 1.18  2005/02/21 08:58:28  sebastiani
/*  all log comments completed
/*
/*  Revision 1.17  2005/02/19 10:05:23  sebastiani
/*  LU_HA introduces in a log line
/*
/*  Revision 1.16  2005/01/26 18:46:19  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.15  2004/10/06 16:38:21  sebastiani
/*  fix watchdog procedure
/*
/*  Revision 1.14  2004/09/28 15:36:05  sebastiani
/*  interrupt manager fix
/*
/*  Revision 1.13  2004/09/22 09:53:53  sebastiani
/*  added watchdog
/*
/*  Revision 1.12  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.11  2004/09/09 14:49:25  sebastiani
/*  add get called
/*
/*  Revision 1.10  2004/09/08 10:39:12  faber
/*  *** empty log message ***
/*
/*  Revision 1.9  2004/08/26 16:53:48  sebastiani
/*  fix some bug
/*
/*  Revision 1.8  2004/07/20 14:31:41  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.7  2004/07/20 08:58:00  faber
/*  simulator mode for EEPROM procedures
/*
/*  Revision 1.6  2004/07/08 16:23:29  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.5  2003/11/18 09:01:14  alfarano
/*  laben patch fixes some problems
/*
/*  Revision 1.4  2003/10/30 16:10:48  faber
/*  GPT disabled. the callback function is a null function
/*
/*  Revision 1.3  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.2  2003/08/07 08:49:07  wizard
/*  interrupt counter array introduced under DEBUF definition
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.12  2003/05/20 12:22:24  aurora
/*  masked HW errors for EM
/*
/*  Revision 1.11  2003/02/26 16:30:32  aurora
/*  improved response time for CRIMEA interrupts
/*
/*  Revision 1.10  2003/01/30 09:43:26  aurora
/*  introduced ifdef for EM and FM
/*
/*  Revision 1.9  2003/01/22 13:50:20  aurora
/*  Added the sw management for three new interrupt on Crimea
/*
/*  Revision 1.8  2002/10/25 08:59:07  zulia
/*  removed clear of interrupt 5 after prepare_page
/*
/*  Revision 1.7  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _IM_InterruptManager_op__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
  
#include <src/BasicSW/InterruptManager/IM_InterruptManager_op.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>


LU_DECL_MASK();


/*****************************************************************************/
/*============================= Object variables ============================*/

#ifdef DEBUG
typedef enum {
  IM_NULL,
  IM_INT1,
  IM_MOD1,
  IM_MOD2,
  IM_1553B,
  IM_PIF_ETO,
  IM_AUX1,
  IM_AUX2,
  IM_AUX3,
  IM_INT2,
  IM_INT3,
  IM_INT4,
  IM_INT5,
  IM_INT_MAX
} IM_INTS;

static unsigned int IM_Called[IM_INT_MAX];
#endif


/*****************************************************************************/

/*=== I M _ I n t e r r u p t M a n a g e r  O P E R .  F U N C T I O N S ===*/

#ifdef DEBUG
unsigned int IM_GetCalled(int i) {
  return IM_Called[i];
}
unsigned int IM_opResetCalled() {
 int i; 
 for(i=0;i<IM_INT_MAX;i++)
   IM_Called[i]=0;  
}
#endif

/*****************************************************************************/
/* @Function: IM_piIntInterruptManager                                       */
/* @Purpose :                                                                */
/*  The function performs the following initialization:                      */
/*  - Establishes an ISR for ERC 32 Data Access interrupt.                   */
/*  - Establishes an ISR for ERC 32 External INT 1...5.                      */
/*  - Establishes an ISR null for for all ERC 32 interrupt not used (UART    */
/*    DMA ..)                                                                */
/*  - Programming of the Interrupts Shape register (Edge and Plolarity of    */
/*    the External Interrupt)                                                */
/*  - Programming of the System Control Register                             */
/*  - Programming of the Interrupts Mask Register                            */
/*  - Clearing of all interrupt.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

void IM_ihWDINT(){
  // static UINT32 intLevel;
  // OS_piInterDisable(&intLevel);
  ERC32_Clear_interrupt(ERC32_INTERRUPT_WATCHDOG_TIMEOUT);
  // OS_piInterEnable(intLevel);

  if(PRH_VAR_WATCHDOG_RESET_DISABLE)
    {
      WATCHDOG_RESET;
#ifdef DEBUG
      console_outbyte_polled(0,'W'); 
      console_outbyte_polled(0,'\n'); 
#endif
    }
  // PRH_WriteEEPROMBootinfo(PRH_BOOTINFO_WD_RESET);
  // PM_CPU_Reboot(TRUE);
}




status_code IM_opIntInterruptManager(void)
{
status_code status;
void*       OldHandler;
#ifdef DEBUG
 IM_opResetCalled(); 
#endif
/*===========================================================================*/
    /*==== DATA ACCESS INTERRUPT (ERC32) INITIALIZATION =========*/
    
    status  =OS_piIsrCatch ( IM_ihInstructionAccessINT,
                             0x01,
                             &OldHandler);

/*===========================================================================*/
    /*==== INSTR. ACCESS INTERRUPT (ERC32) INITIALIZATION ======*/
    
    status  =OS_piIsrCatch ( IM_ihDataAccessINT,
                             0x09,
                             &OldHandler);
/*===========================================================================*/
    /*==== EXTERNAL INTERRUPT (ERC32) 1 -2 -3 -4 -5  INITIALIZATION =========*/
    
    status |=OS_piIsrCatch ( IM_ihExternalINT1,
                             ERC32_INTERRUPT_EXTERNAL_1+0x10,
                             &OldHandler);

    status |=OS_piIsrCatch ( IM_ihExternalINT2,
                            ERC32_INTERRUPT_EXTERNAL_2+0x10,
                            &OldHandler);
    status |=OS_piIsrCatch ( IM_ihExternalINT3,
                             ERC32_INTERRUPT_EXTERNAL_3+0x10,
                             &OldHandler);
    status |=OS_piIsrCatch ( IM_ihExternalINT4,
                             ERC32_INTERRUPT_EXTERNAL_4+0x10,
                             &OldHandler);
    
    status |=OS_piIsrCatch ( IM_ihExternalINT5,
                             ERC32_INTERRUPT_EXTERNAL_5+0x10,
                             &OldHandler);
/*===========================================================================*/
    /*=== INTERRUPT ASYNCHRONOUS (ERC32) INITIALIZATION TO A NULL FUNC.======*/
    
    /*  INTERRUPT MASKED_ERRORS             */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_MASKED_ERRORS+0x10,
                            &OldHandler);

    /*  INTERRUPT UART_A_RX_TX              */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_UART_A_RX_TX+0x10,
                            &OldHandler);
    /*  INTERRUPT UART_B_RX_TX              */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_UART_B_RX_TX+0x10,
                            &OldHandler);
    /*  INTERRUPT CORRECTABLE_MEMORY_ERROR  */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_CORRECTABLE_MEMORY_ERROR+0x10,
                            &OldHandler);
    /*  INTERRUPT UART_ERROR                */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_UART_ERROR+0x10,
                            &OldHandler);
    /*  INTERRUPT DMA_ACCESS_ERROR          */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_DMA_ACCESS_ERROR+0x10,
                            &OldHandler);
    /*  INTERRUPT DMA_TIMEOUT               */
    status |=OS_piIsrCatch ( IM_ihNullINT,
                            ERC32_INTERRUPT_DMA_TIMEOUT+0x10,
                            &OldHandler);

    status |=OS_piIsrCatch ( IM_ihWDINT,
			     ERC32_INTERRUPT_WATCHDOG_TIMEOUT+0x10,
			     &OldHandler);
    

    
    if (status!=SUCCESSFUL)
    {
      /* ISR not successfully established  */
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_IM,HA_E10_INT_CATCH_ERR,status);        
      LU_INFN_LOG(LU_FATAL | LU_HA ,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
    /*===========================================================================*/ 
    /*===== SYSTEM CONTROL REGISTER PROGRAMMING ======*/
#ifndef SIMULATOR
#ifdef __FM__
    ERC32_MEC.Control =0x1288801B;
#else
    /* for EM the HW errors are masked                */
    ERC32_MEC.Control =0x1288A0BB;
#endif
#else // SIMULATOR
    /* same as EM */
    ERC32_MEC.Control =0x1288A0BB;
#endif 
/*===========================================================================*/
    /*===== INTERRUPTS SHAPE REGISTER PROGRAMMING ======*/

    /* 31.....13  12  11  10   9   8   7   6   5   4   3   2   1   0  */
    /* Reserved -      Polarity      -    Ack    -       Edge         */
    /*          -  0   0   0   0   1 - 0   0   0 - 1   1   1   1   0  */

    /* Edge     - (0) Level Triggered    (1) Edge Triggered           */
    /* Polarity - (0) Low Level or Falling Edge                       */
    ERC32_MEC.Interrupt_Shape =0x0000011e;

    /*====== INTERRUPTS MASK REGISTER PROGRAMMING ======*/ 
 
    /* 31.14  13  12  11  10   9   8   7   6   5   4   3   2   1   0  */ 
    /*     1   0   0   0   0   1   1   1   1   0   0   0   0   1   0  */ 
    ERC32_MEC.Interrupt_Mask =0x000043c2; 

/*===========================================================================*/
    /*===== ALL ERC32 INTERRUPTS ARE CLEARED ======*/

    ERC32_Clear_interrupt(ERC32_INTERRUPT_MASKED_ERRORS);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_1);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_2);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_UART_A_RX_TX);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_UART_B_RX_TX);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_CORRECTABLE_MEMORY_ERROR);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_UART_ERROR);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_DMA_ACCESS_ERROR);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_DMA_TIMEOUT);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_3);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_4);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_GENERAL_PURPOSE_TIMER);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_REAL_TIME_CLOCK);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_5);
    ERC32_Clear_interrupt(ERC32_INTERRUPT_WATCHDOG_TIMEOUT);

    return (status);

}


/*****************************************************************************/
/* @Function: IM_opExternalINT1                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the Data Access         */
/*  exception.                                                               */
/*  This interrupt arises when error on data loading is found out.           */
/*  The function performs the following steps:                               */
/*      - Disable all sparc interrupts.                                      */
/*      - Get error information by reading Sistem Fault Status register.     */
/*      - Write System Status Word =0x8000 | SYSFSR(2..15 bits) in the 1553  */
/*        memory area.                                                       */
/*      - Stop any task operation and continuosly perform Watchdog reset.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/
#ifdef SIMULATOR
static unsigned int IM_DataAccessCount = 0;
#endif

void IM_opDataAccessINT (void)
{
#ifdef SIMULATOR
  IM_DataAccessCount++;
#else
  unsigned short statusWord;
  unsigned int   level;
  LU_UART_CR('D');
  level      =sparc_disable_interrupts();
  /* Get ERC32  Status Word                     */
  statusWord =IM_GET_STATUS_WORD;
  /* Write Status Word in the 1553 memory area  */
  BI_pi1553BWriteStatusWord(statusWord);
  /* Stop any task operation                    */
  while( FOREVER ) 
    {
      WATCHDOG_RESET;
    }
#endif
}



/*****************************************************************************/
/* @Function: IM_opDataAccessINT                                             */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the Erc32               */
/*  Instruction Access exeception.                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/









#ifdef SIMULATOR
static unsigned int IM_InstructionAccessCount = 0;
#endif

void  IM_opInstructionAccessINT (void)
{
#ifdef SIMULATOR
  IM_InstructionAccessCount++;
#else
  unsigned short statusWord;
  unsigned int   level;
  LU_UART_CR('U');
  level      =sparc_disable_interrupts();
  /* Get ERC32  Status Word                     */
  statusWord =IM_GET_STATUS_WORD;
  /* Write Status Word in the 1553 memory area  */
  BI_pi1553BWriteStatusWord(statusWord);
  /* Stop any task operation                    */
  while( FOREVER ) 
    {
      WATCHDOG_RESET;
    }
#endif
}



/*****************************************************************************/
/* @Function: IM_opExternalINT1                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the External INT 1.     */
/*  This interrupt is connected to the CRIMEA component.  Reading the        */
/*  CRIMEA Interrupt Pending register can be established which line has      */
/*  produced the interrupt and then called the apropriate management         */
/*  function.                                                                */
/*  The CRIMEA and ERC32 interrupt are cleared.                              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void IM_opExternalINT1 (void)
{
unsigned int InterVect;
unsigned int mask;
#ifdef DEBUG
 IM_Called[IM_INT1]++;
#endif
    mask   =0x00010000;
    CD_piGetCrimeaInterPending (&InterVect);
    if (InterVect & (mask << CD_INTER_MEM_MOD_1))
    {
#ifdef DEBUG
      IM_Called[IM_MOD1]++;
#endif
        /* Local Memory Module 1 interrupt menagement  */
        FT_piMemBoardMod(FT_MEM_MOD_1);  
        CD_piSetCrimeaInterClear (mask << CD_INTER_MEM_MOD_1);
    }
    if (InterVect & (mask << CD_INTER_MEM_MOD_2))
    {
#ifdef DEBUG
      IM_Called[IM_MOD2]++;
#endif
        /* Local Memory Module 2 interrupt menagement  */
        FT_piMemBoardMod(FT_MEM_MOD_2);
        CD_piSetCrimeaInterClear (mask << CD_INTER_MEM_MOD_2);
    }
    if (InterVect & (mask << CD_INTER_1553B_MSG))
    {
#ifdef DEBUG
      IM_Called[IM_1553B]++;
#endif
        /* Bus 1553 interrupt menagement               */
        BI_pi1553BInterruptHandler();
        CD_piSetCrimeaInterClear (mask << CD_INTER_1553B_MSG);
    }
    if (InterVect & (mask << CD_INTER_PIF_ETO))
    {
#ifdef DEBUG
      IM_Called[IM_PIF_ETO]++;
#endif
        /* PIF Event Timeout                           */
        PM_piPageIsEmpty();
        CD_piSetCrimeaInterClear (mask << CD_INTER_PIF_ETO);
    }
    if (InterVect & (mask << CD_AUX_1))
    {
#ifdef DEBUG
      IM_Called[IM_AUX1]++;
#endif
      /* External Interrupt                           */
      /* Add here the function for its management     */
      //TEST!!! remove the next instruction
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_IM,HA_E10_INT_CATCH_ERR,0x1);        
      /*@LOG CD_AUX_1 interrupt */
      LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,InterVect);
      TI_opTimeSyncExtInterrupt();
      CD_piSetCrimeaInterClear (mask << CD_AUX_1);
    }

#ifdef __FM__
    if (InterVect & (mask << CD_AUX_2))
    {
#ifdef DEBUG
      IM_Called[IM_AUX2]++;
#endif
      /* External Interrupt                           */
        /* Add here the function for its management     */
      //TEST!!! remove the next instruction
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_IM,HA_E10_INT_CATCH_ERR,0x2);        
      /*@LOG CD_AUX_2 interrupt */
      LU_INFN_LOG(LU_CRITICAL | LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,0x2);
      CD_piSetCrimeaInterClear (mask << CD_AUX_2);
    }
    if (InterVect & (mask << CD_AUX_3))
    {
#ifdef DEBUG
      IM_Called[IM_AUX3]++;
#endif
      /* External Interrupt                           */
      /* Add here the function for its management     */
      //TEST!!! remove the next instruction
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_IM,HA_E10_INT_CATCH_ERR,0x3);        
      /*@LOG CD_AUX_3 interrupt */
      LU_INFN_LOG(LU_CRITICAL | LU_HA ,LU_MASK(__FILEID__),__FILEID__,__LINE__,0x3);
      CD_piSetCrimeaInterClear (mask << CD_AUX_3);
    }
#endif
    
   /* Clear ERC32 interrupt                           */
    ERC32_Clear_interrupt(ERC32_INTERRUPT_EXTERNAL_1);
}



/*****************************************************************************/
/* @Function: IM_opExternalINT2                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the External INT 2.     */
/*  This interrupt is connected to the Data Timeout signal. The function     */
/*  that menages the Data Timeout interrupt is in SRAMPageManager object.    */
/*  The ERC32 interrupt is cleared.                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void IM_opExternalINT2 (void)
{
    /* Call Data Timeout menagement function in SRAMPageManager  */
#ifdef DEBUG
  IM_Called[IM_INT2]++;
#endif
  PM_piPageHasData();

  /* Due to HW/SW synchro the interrupt pending clear is    */
  /* made in the above ISR                                  */
}



/*****************************************************************************/
/* @Function: IM_opExternalINT3                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the External INT 3.     */
/*  This interrupt is connected to the Read EOT signal.                      */
/* The function that manages the Read EOT interrupt is in MMSUManager object.*/
/*  The ERC32 interrupt is cleared.                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void IM_opExternalINT3 (void)
{
  /* Call Read EOT menagement function in MMSUManager   */
#ifdef DEBUG
  IM_Called[IM_INT3]++;
#endif
  FT_piReadEOT();
  
  /* Due to HW/SW synchro the interrupt pending clear is    */
  /* made in the above ISR                                  */
}



/*****************************************************************************/
/* @Function: IM_opExternalINT4                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the External INT 4.     */
/*  This interrupt is connected to the Write EOT signal.                     */
/*  The function that manages the Write EOT interrupt is in MMSUManager      */
/*  object. The ERC32 interrupt is cleared.                                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/


void IM_MMSU_ISR(rtems_id timer_id, 
		 void *unused) 
{
  FT_piWriteEOT();
}



void IM_opExternalINT4 (void)
{
#ifdef DEBUG
  IM_Called[IM_INT4]++;
#endif

  FT_piWriteEOT();
  
  
  /* Due to HW/SW synchro the interrupt pending clear is    */
  /* made in the above ISR                                  */
}



/*****************************************************************************/
/* @Function: IM_opExternalINT5                                              */
/* @Purpose :                                                                */
/*  The function implements the interrupt handler of the External INT 5.     */
/*  This interrupt is connected to the Event Trigger signal.                 */
/*  The function that manages the Event Triger interrupt is in               */
/*  SRAMPageManager object. The ERC32 interrupt is cleared.                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void IM_opExternalINT5 (void)
{
#ifdef DEBUG
  IM_Called[IM_INT5]++;
#endif
  /* Call Event Trigger menagement function in SRAMPageManager   */

  /* event trigger is not via interrupt in the new system design */
  // PM_piPreparePage();
  
  /* Due to HW/SW synchro the interrupt pending clear is    */
  /* made in the above ISR                                  */
}



/*****************************************************************************/
/* @Function: IM_opNullINT                                                   */
/* @Purpose :                                                                */
/*  The function implements the null interrupt handler.                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void  IM_opNullINT (void)
{
#ifdef DEBUG
  IM_Called[IM_NULL]++;
#endif   
}


#ifdef DEBUG
unsigned int IM_opGetCalled(unsigned int i) {
  if(i<IM_INT_MAX)
    return IM_Called[i];
  return -1;
}

#endif
