/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : HKManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.3 $
/*  $Date: 2003/11/27 17:53:23 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: HA_HistoryArea_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: faber $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: HA_HistoryArea_p.c,v $
/*  Revision 1.3  2003/11/27 17:53:23  faber
/*  -Power management poweron procedure done and some tested in the simulator
/*  -history entry 5 now takes OBT
/*
/*  Revision 1.2  2003/08/22 07:51:22  sebastiani
/*  Entry5 now used only for INFN-style logging.
/*  LOGANALIZER directive introduced
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.6  2002/11/14 09:49:35  zulia
/*  removed unsed status variable
/*
/*  Revision 1.5  2002/06/11 13:14:26  zulia
/*  Added Entry Type 3 for Direct MCMD
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_op.h>


/*****************************************************************************/

/*==== H I S T O R Y    A R E A     P R O V I D E D    I N T E R F A C E ====*/

/*****************************************************************************/


/*****************************************************************************/
/* @Function: HA_piInitHistoryArea                                           */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the History Area Object.                */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code HA_piInitHistoryArea( void )
{
    return HA_opInitHistoryArea();
}



/*****************************************************************************/
/* @Function: HA_piSndMsgHistoryArea                                         */
/* @Purpose :                                                                */
/*  Provided Interface to invoke a specific operation of the History task.   */
/*  This is done by sending a message into History Area mailbox.             */
/*  The sent message has the following structure :                           */
/*  Structure -MsgTsk- :                                                     */
/*  Field -Code-    Code of the task operation                               */
/*  Field -Info-    Buffer that contains the task operation parameters       */
/*  Filed -LlInfo-  Parameters size.                                         */
/*  The operations code and the parameters type of the History task are      */
/*  the following :                                                          */
/*                                                                           */
/*     Code operation         Parameters (Type assigned to -Info- field)     */
/*     HA_RESET               Enumerated                                     */
/*     HA_PREPAREFORMAT       Enumerated                                     */
/*     HA_TRACEVENT           An array of n-words (Log Entry Type 0-15)      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code HA_piSndMsgHistoryArea( MsgTsk* SndMsg )
{
    return HA_opSndMsg(SndMsg);
}

/*****************************************************************************/
/* @Function: HA_piGetAnomCounter                                            */
/* @Purpose :                                                                */
/*  Provided Interface to retrieve the number of anomalies occurred since    */
/*  last reset command. The maximum value of this counter is 63, once this   */
/*  condition is reached it will be reset through e Reset History MCMD       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* anom_cnt             OUT     number of anomalies stored into History      */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piGetAnomCounter(UWORD*  anom_cnt) 
{
    return HA_opGetAnomCounter(anom_cnt);
}


/*****************************************************************************/
/* @Function: HA_piGetFullCondition                                          */
/* @Purpose :                                                                */
/*  Provided Interface to retrieve the status of full-condition (no more     */
/*  space available)                                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* fullcond             OUT     TRUE = full-condition is reached             */
/*                              FALSE = full-condition not reached           */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code HA_piGetFullCondition(UWORD* fullcond)
{
    return HA_opGetFullCondition(fullcond);
}


/*****************************************************************************/
/* @Function: HA_piGetFreeSpace                                              */
/* @Purpose :                                                                */
/*  Provided Interface to retrieve the number of words (16 bit) still        */
/*  available.                                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* freespace            OUT     number of words (16 bit) still available     */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code HA_piGetFreeSpace(UWORD* freespace)
{
    return HA_opGetFreeSpace(freespace);
}


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry0                                          */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #0                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  TransitionType       IN      Starting/Exiting State/Mode                 */
/*  StateMode            IN      State/Mode definition                       */
/*  ModeDetails          IN      Mode details, bit mask definition           */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piLogHistoryEntry0  (unsigned int         TransitionType,
                                    unsigned int         StateMode,
                                    unsigned int         ModeDetails)
{
    return HA_opLogHistoryEntry0 (TransitionType, StateMode, ModeDetails);
}


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry2                                          */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #2                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdType            IN      macrocommand identifier                      */
/*  Report              IN      report to be written                         */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piLogHistoryEntry2 ( unsigned int McmdType, unsigned int Report )
{
    return HA_opLogHistoryEntry2(McmdType, Report);
}

/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry3                                          */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #2                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  CmdName             IN      TC Direct Command Name identifier            */
/*  Value               IN      value of Command                             */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piLogHistoryEntry3  (unsigned int         CmdName, 
                                    unsigned int         Value )
{
    return HA_opLogHistoryEntry3(CmdName, Value);      
}                                    


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry5                                          */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #5                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   **** see comment for HA_opLogHistoryEntry5 ***                          */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piLogHistoryEntry5  (unsigned int         fileid,
                                    unsigned int         line,
                                    unsigned int         info1,
				    TI_TIME obt) {
    return HA_opLogHistoryEntry5(fileid ,line    ,info1,obt);
}


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry10                                         */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #10                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SwOrigin            IN      identifier of the sw origin error            */
/*  Report1             IN      first report to be written                   */
/*  Report2             IN      second report to be written                  */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_piLogHistoryEntry10( unsigned int SwOrigin, unsigned int Report1, unsigned int Report2 )
{
    return HA_opLogHistoryEntry10(SwOrigin, Report1, Report2);
}


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry11                                         */
/* @Purpose :                                                                */
/*  Provided Interface to write a log of entry type #11                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  HwOrigin            IN      identifier of the Hw origin error            */
/*  HwErrorId           IN      first report to be written                   */
/*  ErrorID             IN      Error identifier                             */
/*  ErrorData           IN      Error Data details                           */
/* @@                                                                        */
/*****************************************************************************/
void HA_piLogHistoryEntry11 (unsigned int         HwOrigin, 
                                    unsigned int         HwErrorId,
                                    unsigned int         ErrorData1,
                                    unsigned int         ErrorData2)
{
    HA_opLogHistoryEntry11(HwOrigin, HwErrorId, ErrorData1, ErrorData2);
}
