/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : HKManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.7 $
/*  $Date: 2004/07/27 17:30:17 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: RG_ReportGenerator_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: faber $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: RG_ReportGenerator_int.c,v $
/*  Revision 1.7  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.6  2003/12/05 17:14:34  alfarano
/*  update
/*
/*  Revision 1.5  2003/12/05 13:15:39  sebastiani
/*  TMTC writing in the RTF
/*
/*  Revision 1.4  2003/12/03 14:36:51  faber
/*  more action definition about mcmd (setmode/purge_trd).
/*  SSt word better defined
/*
/*  Revision 1.3  2003/11/28 14:42:48  faber
/*  *** empty log message ***
/*
/*  Revision 1.2  2003/11/27 17:53:23  faber
/*  -Power management poweron procedure done and some tested in the simulator
/*  -history entry 5 now takes OBT
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.9  2003/04/29 13:25:42  aurora
/*  introduced SW status in SSW when INFN files are not included
/*
/*  Revision 1.8  2002/06/11 13:18:06  zulia
/*  Changed subsystem ID to 10H
/*
/*  Revision 1.7  2002/05/13 14:57:52  zulia
/*  * update makefiles
/*  * integration with INFN sw
/*  * filled SSW
/*
/*  Revision 1.6  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

 
/*============================= Include File ================================*/
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_int.h>
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>  
#include <src/FileManager/FileSystem/FS_FileSystem_p.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_p.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>
#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_p.h>
#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_p.h>
/*============================= Include INFN File ===========================*/
#ifdef INFN
#include <src/INFN/RG_ReportGenerator_INFN_p.h>
#endif
/*============================== Local Variables ============================*/

const UWORD RG_SUBSYSTEM_ID       = 0x0010;
const UWORD RG_RTF_BEGIN_ID_VALUE = 0xAAAA;
const UWORD RG_RTF_END_ID_VALUE   = 0x5555;


/*****************************************************************************/
/*      H i s t o r y   A r e a     I N T E R N A L   F U N C T I O N S      */
/*****************************************************************************/

/*****************************************************************************/
/* @Function: RG_ifReset                                                     */
/* @Purpose :                                                                */
/*  This function resets all variables of the object                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* TlmfArea              IN      Address of data area                        */
/* TlmfRTFCnt            IN      Address of the telemetry counter            */
/* @@                                                                        */
/*****************************************************************************/
void RG_ifReset( RG_TLM_DATA_AREA* TlmfArea, UWORD* TlmfRTFCnt )
{
    memset(TlmfArea, 0, sizeof(RG_TLM_DATA_AREA));
    *TlmfRTFCnt = 0;
}


/*****************************************************************************/
/* @Function: RG_ifPrepareHeader                                             */
/* @Purpose :                                                                */
/*  This function writes the header for the specified telemetry type         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmf                 OUT     Destination buffer for address of the        */
/* tlmf_type            IN      type of telemetry are the following:         */
/*                              RG_FORMAT_RT                                 */
/*                              RG_FORMAT_HA                                 */
/*                              RG_FORMAT_DUMP                               */
/* @@                                                                        */
/*****************************************************************************/
void RG_ifPrepareHeader( UWORD* tlmf, UWORD tlmf_type )
{
    RG_RTFHEADER hd; /* this structure just for support and convenience      */
    UWORD   aword;
    TI_TIME obt;
    UINT    actualstate;
    
    /* prepares the header for RTR,RT,RTE Formats Layout              */
    hd.FmtBeginId = RG_RTF_BEGIN_ID_VALUE;
    MC_piGetState(&actualstate);
    switch( actualstate )
    {
       case MC_MAINTENANCE_STATE:
            hd.SourceState = RG_TLM_STATE_MAINTENANCE;
            break;
       case MC_ACTIVE_STATE:
            hd.SourceState = RG_TLM_STATE_ACTIVE;
            break;
    default:
            hd.SourceState = 0;
            break;
    }
    
    hd.SourceState |= (RG_SUBSYSTEM_ID << 8);                  /* TBD */
    RG_piGetTLMRTFCounter(&aword);
    hd.FrmCounter = aword;
#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
    TI_piGetTimeInfo_s(&obt);
    hd.OBTLow  = (UWORD)obt;
    hd.OBTHigh = (UWORD)(obt >> 16);
    HA_piGetAnomCounter(&aword);
    
    /* can be counted 63 anomalies as are used only the first 6 LSB   */
    if( aword < 0x40 )
    {
         hd.AnomCnt_HASpace = aword;                   /* first 6 LSB */
    }
    else
    {
        hd.AnomCnt_HASpace = 0x3F;
    }
    
    /* retriving the free space: if greater than 1022 all bits are    */
    /* set to 1 else the correct number is written                    */
    HA_piGetFreeSpace(&aword);
    if( aword < 0x400 )
    {
         hd.AnomCnt_HASpace |= (aword << 6);           /* last 10 MSB */
    }
    else
    {
        hd.AnomCnt_HASpace |= 0xFFC0; /* last 10 MSB are all set to 1 */
    }
    
    switch( tlmf_type )
    {      
      case RG_FORMAT_RT:
           hd.FmtLength_Type  = RG_LENGTH_RT;
           hd.FmtLength_Type |= RG_MSK_TYPE_RT;      
           break;

      case RG_FORMAT_HA:
           hd.FmtLength_Type  = RG_LENGTH_HA;
           hd.FmtLength_Type |= RG_MSK_TYPE_HA;      
           break;
      
      case RG_FORMAT_DUMP:
           hd.FmtLength_Type  = RG_LENGTH_DUMP;
           hd.FmtLength_Type |= RG_MSK_TYPE_DUMP;      
           break;
           
      default:
           break;
    }
   
    /* writes the header into TLM array */
    *(RG_RTFHEADER*)tlmf = hd;
}



/*****************************************************************************/
/* @Function: RG_ifPrepareRTBody                                             */
/* @Purpose :                                                                */
/*  This function writes the telemetry body into the destination buffer      */
/*  accordingly to the RT layout.                                            */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmf                 OUT     Address of the destination buffer            */
/* @@                                                                        */
/*****************************************************************************/
void RG_ifPrepareRTBody( UWORD* tlmf,UDWORD BootResult )
{
UINT counter;

    /* the TLM header is already prepared */
     
    /* prepares the Real Time Format      */
    RG_ifGetSubStatusWord     (tlmf + RG_IDX_PDHT_STW,BootResult);
    BI_piGetCCAFormat         (tlmf + RG_IDX_PDHT_CCA);
    FT_piMemModuleStat        (tlmf + RG_IDX_MODULE_STATE);
    FT_piGetCMDWErrorCounter  (&counter);
    *(tlmf + RG_IDX_PACKET_ERROR_STATE) = (UWORD)(counter << 8);
    PM_pi_GetLostPktCounter   (&counter);
    *(tlmf + RG_IDX_PACKET_ERROR_STATE) |= (UWORD)counter;
    MA_piGetTlmTimetagRTE     ((MA_TLM_TIMETAG_RTE*)(tlmf + RG_IDX_TT_MCMD_LIST));

    /* Add HK DATA TBD by INFN            */
    
    TM_piGetAllTMValue(tlmf + RG_IDX_INFN_HK_DATA);
    
    /* Add DETECTORS COUNTERS TBD by INFN */
    
    tlmf[RG_IDX_END_RT_IDENTIFIER] = RG_RTF_END_ID_VALUE;
}


/*****************************************************************************/
/* @Function: RG_ifGetSubStatusWord                                          */
/* @Purpose :                                                                */
/*                                                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmf                 OUT     Address of the destination buffer            */
/* @@                                                                        */
/*****************************************************************************/
void RG_ifGetSubStatusWord(UWORD* PdhtStatusWord,UDWORD BootResultCode)
{
   UWORD aword;
   UINT  thebuffer;
   
    /* the TLM header is already prepared                                    */

#ifdef INFN
   UINT AnomalyCode;
   UINT PamelaStatus;
   UINT DownloadReq;
#endif

    /* we have to prepare the Subsystem Status Word                          */
    /* clearing the Subsystem Status Word                                    */
    *PdhtStatusWord = 0;
 
#ifdef INFN
    /* Get Anomaly detection (Bit no.15-12)                                  */
    /* Function TBD by INFN                                                  */

    RG_piGetAnomalyCode_INFN (&AnomalyCode);
    *PdhtStatusWord |= (AnomalyCode & 0x000F); 
    
    /* Function RG_piGetPamelaStatus_INFN return bits 10 and 11              */
    /* Get Pamela Experiment Status (Bit no. 11)                             */
    /* Function TBD by INFN                                                  */    

    /* Get External Equipment  Status (Bit no. 10)                           */
    /* Function TBD by INFN                                                  */
    /*
      RG_piGetPamelaStatus_INFN (&PamelaStatus);
    *PdhtStatusWord |= (PamelaStatus<<4 & 0x0030); 
    */

    /* Get Download request Status (Bit no. 9)                               */
    /* Function TBD by INFN                                                  */    
    
    RG_piGetDownloadRequest_INFN (&DownloadReq);
    *PdhtStatusWord |= (DownloadReq<<6 & 0x0040); 
#endif                                                 */
    
    
    /* Get History area full conditions (Bit no. 8)                          */
    HA_piGetFullCondition(&aword);
    if( aword )
    {
       /* Raising 1 sets the full condition of History Area                  */
       *PdhtStatusWord |= RG_MSK_SSTW_HA_F; 
    }

    /* Get MCMD queue full conditions (Bit no. 7)                            */
    MA_piGetMcmdTimetagQueueFull(&thebuffer);
    if( thebuffer )
    {
        /* Raising 1 sets the MCMD queue full                                */
        *PdhtStatusWord |= RG_MSK_SSTW_MQ_F; 
    }

    /* Get CCA bit required (Bit no. 6)                                   */

    /* Get Switchdown required (Bit no. 5)                                   */
    
    
    /* Get Unrecoverable error detected by EDAC in ther SPV RAM (Bit no. 4)  */
    
    /* Get Result of BOOT/INIT test (Bit no. 3)                              */
    if (BootResultCode)
    {
        /* Raising 1 sets the Boot result fail                               */
        *PdhtStatusWord |= RG_MSK_SSTW_BOOT; 
    }

#ifdef INFN
    /* Get On board software status (Bit no.0-2)                             */
    /* Function TBD by INFN                                                  */
#else
    *PdhtStatusWord |= (MH_GetSubMode() << 13) & 0xE000;
#endif    

}
