/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: LU_LogUtility_INFN.c,v 1.24 2005/03/20 18:21:00 sebastiani Exp $
 *  $Revision: 1.24 $ 
 *  $Date: 2005/03/20 18:21:00 $
 *  $RCSfile: LU_LogUtility_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: sebastiani $                                                                   
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: LU_LogUtility_INFN.c,v $
 *  Revision 1.24  2005/03/20 18:21:00  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.23  2005/03/06 14:54:46  sebastiani
 *  version running on 06 03 2005
 *
 *  Revision 1.22  2005/02/19 10:19:38  sebastiani
 *  ALM_S4_CALIB_00_HARD,ALM_S4_CALIB_00_SOFT,ALM_S4_128TRIGGER_0 added
 *
 *  Revision 1.21  2004/11/25 09:20:17  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.20  2004/11/19 15:14:52  sebastiani
 *  PRH_EXTERN_{VAR,ARR,TABLE} removed and put them on the autogenerated parameter heeader file
 *
 *  Revision 1.19  2004/10/22 16:05:06  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.18  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.17  2004/09/14 15:07:08  faber
 *  New development for TimeSync, managed by interrupt. coding completed but never tested.
 *
 *  Revision 1.16  2004/08/31 09:08:35  sebastiani
 *  fix warning
 *
 *  Revision 1.15  2004/08/26 16:54:34  sebastiani
 *  version work fine
 *
 *  Revision 1.14  2004/07/27 17:30:17  faber
 *  OBT can be now in second or milliseconds, depending of the situazion.
 *  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
 *
 *  Revision 1.13  2004/07/27 10:13:48  faber
 *  LU_ALARM macro introduced,
 *  LU_XXXX bit field "logtype" redefined.
 *  HistoryArea 5 now log a 32 bit word as "info1"
 *  and logging is reformatted.
 *
 *  Revision 1.12  2004/06/23 13:53:16  alfarano
 *  static declaration for fileid
 *
 *  Revision 1.11  2004/05/13 10:47:17  faber
 *  hid the HB_Store funcion in favour of wrapped funcions
 *
 *  Revision 1.10  2004/03/09 09:39:27  faber
 *  LU_TRACE system introduced
 *
 *  Revision 1.9  2003/11/27 17:53:23  faber
 *  -Power management poweron procedure done and some tested in the simulator
 *  -history entry 5 now takes OBT
 *
 *  Revision 1.8  2003/11/06 10:27:12  faber
 *  HB_HKBuffer now implemented as multibuffer (as specified in the
 *  mass memory format). Only compilation, not tested
 *
 *  Revision 1.7  2003/10/21 16:09:12  alfarano
 *  LU_LOG_INFN replacement for all remaining original log functions
 *
 *  Revision 1.6  2003/10/17 09:25:10  sebastiani
 *  __FILEID__ mechanism is now provied by global variables
 *  instead of macro definitions in order to make such simbols
 *  to be resolved at link time instead of compilation time.
 *
 *  Revision 1.5  2003/09/19 15:57:35  faber
 *  Large development update INFN software
 *
 *  Revision 1.4  2003/09/16 08:42:05  faber
 *  StoreOrb/Incl done / new LOG initialization
 *
 *  Revision 1.3  2003/09/15 17:46:27  faber
 *  HB_HKBuffer_INFN module introduced.
 *
 *  Revision 1.2  2003/08/22 07:55:43  sebastiani
 *  conform source to the new loganalizer.c philosophy
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.2  2003/07/17 11:15:04  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.1  2003/06/12 14:49:19  sebastiani
 *  first versione of Log Module source
 *
 *                                                                           
 *****************************************************************************/


/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _LU_LogUtility_INFN__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();

#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_int.h>
#include <src/INFN/CM_Common_INFN.h>
/*============================ Global define ================================*/


/*============================== global types  ==============================*/



/*****************************************************************************/
/*=========================== Structure define ==============================*/


/*****************************************************************************/
/*============================ Enumerate define =============================*/

/*****************************************************************************/

/*=== LogUtility  O P E R A T I O N   E N V I R O N M  ==*/

/*****************************************************************************/


static BOOL LU_StoreInHB_Flag;
#include <src/INFN/LU_COMPILE_STAMP.include>

// variables for TRACE() macros, trace fileid/line of the calling task
UINT16 LU_task_info_line [LU_TOTAL_TASKS];
BYTE LU_task_info_fileid [LU_TOTAL_TASKS];
UINT16 LU_task_info_humanid[LU_TOTAL_TASKS];
UINT16 LU_first_task_index=0;

/* the initialization that have to be done before the Laben initialization exept the OS module */
status_code LU_PreInit() 
{
  LU_InitNames();
  LU_StoreInHB_Flag = FALSE;
  LU_SetLogMaskAll(LU_DEFAULT_MASK);
  return SUCCESSFUL;
}

UINT32 LU_GetCompilationTimeStamp() {
  return LU_COMPILE_STAMP;
}

status_code LU_SetLogMaskAll(UINT16 v)
{
  int i;
  for(i=0;i<PRH_ARR_N_LOG_MASK;i++)
    PRH_ARR_LOG_MASK[i]=v;
}

#ifndef LOGANALIZER
void LU_StoreInHB(BOOL storeflag) {
  LU_StoreInHB_Flag = storeflag;
}
#endif

status_code LU_Init() {
  int i;
#ifdef SIMULATOR
  /* write the magic number for the analizer: */
  static char seq[4] = {0xFA , 0xFE ,0xDE, 0xFA };
  for (i=0;i<4;i++) {
    console_outbyte_polled(0,seq[i]);
    console_outbyte_polled(1,seq[i]);
  }
#endif
  return SUCCESSFUL;
}

void LU_WriteOnUART(unsigned char *string)
{
  unsigned char *s;
  if(PRH_VAR_LU_WRITE_ON_UART) {
    for ( s = string ; *s ; s++ ) 
      console_outbyte_polled( 0, *s );
    console_outbyte_polled( 0, '\r' );
    console_outbyte_polled( 0, '\n' );    
  }
}


#define UWORD unsigned short int
#define UBYTE unsigned char
status_code LU_PutLog (MsgTsk* msg) {
  unsigned char          EntryType;
  static unsigned char  buf[100],str[100],str2[100];
  unsigned int   entry;
  unsigned char  code;
  unsigned int   time;
  unsigned int   rep1,rep2,rep3,line,fileid;

#if 0
  // console_outbyte_polled(0,msg->LlInfo*sizeof(UWORD));
  //console_outbyte_polled(1,msg->LlInfo*sizeof(UWORD));
  for(entry=0;entry<msg->LlInfo*sizeof(UWORD);entry++) {
    console_outbyte_polled(0,msg->Info[entry]);
    //console_outbyte_polled(1,msg->Info[entry]);
  }
#endif
  
  /* ignore all the rest: */
  //return SUCCESSFUL;

  EntryType = msg->Info[0] >> 4;
  
  entry  =EntryType;
  code   =msg->Info[1];
  time   =(((UWORD*)(msg->Info))[1] << 16) + ((UWORD*)(msg->Info))[2];
  rep1   =0;
  rep2   =0;
  rep3   =0;
  
  switch( EntryType ) {
  case HA_EVENT_04:
    sprintf(str,"");
    break;
  case HA_EVENT_00:
  case HA_EVENT_01:
  case HA_EVENT_02:
  case HA_EVENT_03:
  case HA_EVENT_06:
    rep1 = ((UWORD*)(msg->Info))[3];
    sprintf(str,"R1: %10d 0x%X",rep1,rep1);
    break;
    
  case HA_EVENT_10:
    rep1 = ((UWORD*)(msg->Info))[3];
    rep2 = ((UWORD*)(msg->Info))[4];
    sprintf(str,"R1: %10d %X - R2: %10d 0x%X ",rep1,rep1,rep2,rep2);
    break;
    
  case HA_EVENT_05:
    line  = ((UWORD*)(msg->Info))[3];
    rep2  = ((UWORD*)(msg->Info))[4];
    rep1  = ((UWORD*)(msg->Info))[5];
    rep3  = rep1 | (rep2<<16);
    LU_GetSourceInfo(str2,code,line);
    sprintf(str,"INFN: Info1: %9u 0x%08x [%s]",rep3,rep3,str2);
    break;
  case HA_EVENT_07:
  case HA_EVENT_11:
    rep1 = ((UWORD*)(msg->Info))[3];
    rep2 = ((UWORD*)(msg->Info))[4];
    rep3 = ((UWORD*)(msg->Info))[5];
    sprintf(str,"R1: %10d 0x%X - R2: %10d 0x%X  - R3: %10d %X ",rep1,rep1,rep2,rep2,rep3,rep3);
    break;
  default:
    break;
  }
  
  sprintf(buf,"%2d OBT: %5ld Code: %3d - %s",entry,time,code,str);
  
  // TS_piWriteOnUART(buf);
  LU_WriteOnUART(buf);
  return (SUCCESSFUL);
  
}



status_code LU_trace_load_task_info(UINT32 human_id, rtems_id taskid) {
  UINT16 index=(UINT16)(taskid);
  
  /* we assume here that rtems assing an incrementing index field in the object id of every task */
  if(LU_first_task_index==0)
    LU_first_task_index=index;
  /* check if all is OK */
  if(index-LU_first_task_index >= LU_TOTAL_TASKS) /* internal error */
    LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_ALLLOG,__FILEID__,__LINE__,index);
  else
    LU_task_info_humanid[index-LU_first_task_index]=human_id;
}


status_code LU_INFN_LOG(unsigned int thistype,unsigned int localmask,
			unsigned int fileid,unsigned int line,unsigned int info1) {
  BYTE b[8];
  BYTE *pb=b;
  TI_TIME obt_ms,obt_s;
  TI_piGetTimeInfo_ms(&obt_ms);
  if(thistype & localmask) {
    if(LU_StoreInHB_Flag) {
      CM_WRITE_BE_UINT8(pb,thistype);
      CM_WRITE_BE_UINT8(pb,fileid);
      CM_WRITE_BE_UINT16(pb,line);
      CM_WRITE_BE_UINT32(pb,info1);
      HB_StoreLog(sizeof(b),b,obt_ms);
    }

#if 0    
#warning "make all LU_DEBUG_TRACE to go in HA too. this check is only for ground: remove in flight!"
    if( (thistype & LU_DEBUG_TRACE) || (thistype & LU_NORMAL_TRACE) )
      thistype|=LU_HA;
#endif

    /*
#ifndef DEBUG
    if (thistype & LU_HA & localmask)
#endif
    */

#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s

      HA_piLogHistoryEntry5(fileid,line,info1,obt_ms / 1000);
  }
  return SUCCESSFUL;

}








