//****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : HKManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.12 $
/*  $Date: 2005/03/06 14:54:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: HA_HistoryArea_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: HA_HistoryArea_op.c,v $
/*  Revision 1.12  2005/03/06 14:54:21  sebastiani
/*  fix log
/*
/*  Revision 1.11  2005/02/21 08:58:28  sebastiani
/*  all log comments completed
/*
/*  Revision 1.10  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.9  2004/08/31 09:08:32  sebastiani
/*  fix warning
/*
/*  Revision 1.8  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.7  2004/07/27 13:19:35  faber
/*  info1 in Log entry 5 now is 32 bit word.
/*
/*  Revision 1.5  2004/05/10 12:59:17  faber
/*  __FILEID__ right value fixed: many .c files had the wrong value!
/*
/*  Revision 1.4  2003/11/27 17:53:23  faber
/*  -Power management poweron procedure done and some tested in the simulator
/*  -history entry 5 now takes OBT
/*
/*  Revision 1.3  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.2  2003/08/22 07:51:22  sebastiani
/*  Entry5 now used only for INFN-style logging.
/*  LOGANALIZER directive introduced
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.7  2002/11/14 09:49:35  zulia
/*  removed unsed status variable
/*
/*  Revision 1.6  2002/06/11 13:14:26  zulia
/*  Added Entry Type 3 for Direct MCMD
/*
/*  Revision 1.5  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

 
/*============================= Include File ================================*/
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_op.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_int.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _HA_HistoryArea_op__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>

LU_DECL_MASK();

/*======================== Object Internal variables ========================*/

/*****************************************************************************/
/* @Variabble: HA_mInfo                                                      */
/* @Purpose :                                                                */
/*  It collects all values to manage the History Area                        */
/* @@                                                                        */
/*****************************************************************************/
static HA_INFO HA_mInfo;

/*****************************************************************************/
/* @Variabble: HA_HistoryArea                                                */
/* @Purpose :                                                                */
/*  Array of History Area: total of 4096 words including the                 */
/*  header (7words) and the final stub (1 word). This is also the same size  */
/*  of the telemetry format.                                                 */
/* @@                                                                        */
/*****************************************************************************/
static HA_DATA_AREA HA_HistoryArea;

   
/*****************************************************************************/

/*== H i s t o r y  A r e a      O P E R A T I O N A L   F U N C T I O N S ==*/

/*****************************************************************************/
/* @Function: HA_opInitHistoryArea                                           */
/* @Purpose :                                                                */
/*  This function initializes the History Area object (its variables).       */
/*  It moves the task into the READY state and sets its priority             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opInitHistoryArea( void )
{
  status_code   status = SUCCESSFUL;
  UINT          OldPriority;

  status |= OS_piTaskReady(HA_TASK,HA_tkHistoryArea);
  if ( status != SUCCESSFUL )
    {
      /* Task is not correctly started             */
      /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_HA,HA_E10_TSK_READY_ERR,status);     */
      LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }    
  status |= OS_piTaskPriority(HA_TASK, HISTORYAREA_PRIORITY,&OldPriority);
  if ( status != SUCCESSFUL )
    {
      /* Task priority is not correctly updated    */
      /*@LOG  LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_HA,HA_E10_TSK_PRIORITY_ERR,status);    */
      LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
  
  HA_ifInit(&HA_HistoryArea, &HA_mInfo);
  
  return (status);
}



/*****************************************************************************/
/* @Function: HA_opSndMsg                                                    */
/* @Purpose :                                                                */
/*  This function sends a message to the History Area task.                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SndMsg               IN      pointer to message structure                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code HA_opSndMsg(MsgTsk* SndMsg)
{
    return ( OS_piMsgQueueSend(HA_MAILBOX, (void*)SndMsg, sizeof(MsgTsk)) );
}



/*****************************************************************************/
/* @Function: HA_tkHistoryArea                                               */
/* @Purpose :                                                                */
/*  The function is the task handler of the History Area object.             */
/*  When a message is received into task mailbox it wakes up.                */
/*  The information contained in the message (MsgTsk structure) define       */
/*  parameters (Info field), and the operation type that the task performs   */
/*  (Code field).                                                            */
/*  The History Area task activity is to  manage the logging of different    */
/*  entries such as events, errors, conditions, macrocommands an so on.      */
/*  Allowed actions are:                                                     */
/*  _ Reset of all logs                                                      */
/*  _ Store of an entry                                                      */
/*  _ Prepare logs into the telemetry format                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

task HA_tkHistoryArea  (task_argument unused)
{
  MsgTsk      RxMsg;
  status_code status;
  UINT        MsgSize;


    while( FOREVER ) 
    {
        // Check mailbox queue
        RxMsg.Code = NULL_MSG_HA;
        if ((status = OS_piMsgQueueReceive (HA_MAILBOX,(void*)&RxMsg,
             &MsgSize, WAIT, NO_TIMEOUT)) == SUCCESSFUL)
        {
            switch (RxMsg.Code)
            {
                case HA_RESET:
                     HA_ifReset((MA_HEADER_MCMD*)RxMsg.Info, &HA_HistoryArea, &HA_mInfo);
                     break;

                case HA_PREPAREFORMAT:
                     HA_ifPrepareFormat((UWORD*)&HA_HistoryArea, &HA_mInfo);
                     break;

                case HA_TRACEVENT:
                     HA_ifTraceEvent(&RxMsg, &HA_mInfo);
                     break;

                default:
                     break;
            }
        }
    }
}


/*****************************************************************************/
/* @Function: HA_opGetAnomCounter                                            */
/* @Purpose :                                                                */
/*  This function retrieves the number of anomalies occurred since last      */
/*  reset command.                                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  anom_cnt            OUT     number of anomalies currently logged         */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opGetAnomCounter(UWORD*  anom_cnt) 
{
    *anom_cnt = HA_mInfo.AnomCounter;

    return (SUCCESSFUL);
}

/*****************************************************************************/
/* @Function: HA_opGetFullCondition                                          */
/* @Purpose :                                                                */
/*  This function retrieves the status of full-condition that is no more     */
/*  space available.                                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* fullcond             OUT     TRUE = full-condition is reached             */
/*                              FALSE = full-condition not reached           */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opGetFullCondition(UWORD* fullcond)
{
    *fullcond = HA_mInfo.FullCondition;
    
    return (SUCCESSFUL);
}


/*****************************************************************************/
/* @Function: HA_opGetFreeSpace                                              */
/* @Purpose :                                                                */
/*  This function retrieves the number of words (16 bit) still available.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* freespace            OUT     number of words (16 bit) still available     */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opGetFreeSpace(UWORD*  freespace) 
{
    *freespace = HA_mInfo.nWordsAvailable;
    
    return (SUCCESSFUL);
}


/*****************************************************************************/
/* @Function: HA_opLogHistoryEntry0                                          */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #0. First it fills              */
/*  an entry type #0 structure and then sends a log message                  */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  TransitionType       IN      Starting/Exiting State/Mode                 */
/*  StateMode            IN      State/Mode definition                       */
/*  ModeDetails          IN      Mode details, bit mask definition           */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opLogHistoryEntry0  (unsigned int TransitionType,
                                    unsigned int StateMode,
                                    unsigned int ModeDetails)
{
MsgTsk   sndMsg;
TI_TIME  obtime;
#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
    TI_piGetTimeInfo_s(&obtime);
    /* Compile the Entry Type 0 fields           */
    *((unsigned short* )&sndMsg.Info[0]) =HA_HEADER_E0 | TransitionType | StateMode;
    *((unsigned short* )&sndMsg.Info[2]) =(obtime >>16);
    *((unsigned short* )&sndMsg.Info[4]) =(obtime & 0xffff);
    *((unsigned short* )&sndMsg.Info[6]) =ModeDetails;
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E0;
 
    return OS_piMsgQueueSend(HA_MAILBOX, (void*)&sndMsg, sizeof(MsgTsk));

}


/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry2                                          */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #2. First it fills              */
/*  an entry type #2 structure and then sends a log message                  */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdType            IN      macrocommand identifier                      */
/*  Report              IN      report to be written                         */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opLogHistoryEntry2 ( unsigned int McmdType, unsigned int Report )
{
  MsgTsk   sndMsg;
  TI_TIME  obtime;
  unsigned int mcmdId;

#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
  TI_piGetTimeInfo_s(&obtime);

  MA_piGetMCMDId(McmdType, &mcmdId);
  *(UWORD*)&sndMsg.Info[0] = HA_HEADER_E2 | mcmdId;
  *(UWORD*)&sndMsg.Info[2] = obtime >> 16;
  *(UWORD*)&sndMsg.Info[4] = obtime;    
  *(UWORD*)&sndMsg.Info[6] = Report;
  sndMsg.Code   = HA_TRACEVENT;
  sndMsg.LlInfo = HA_SIZEW_E2;
  
  return OS_piMsgQueueSend(HA_MAILBOX, (void*)&sndMsg, sizeof(MsgTsk));
}

/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry3                                          */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #3. First it fills              */
/*  an entry type #3 structure and then sends a log message                  */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  CmdName             IN      TC Direct Command Name identifier            */
/*  Value               IN      value of Command                             */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opLogHistoryEntry3 ( unsigned int CmdName, unsigned int Value )
{
  MsgTsk   sndMsg;
  TI_TIME  obtime;
  unsigned int mcmdId;
#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
    TI_piGetTimeInfo_s(&obtime);
    *(UWORD*)&sndMsg.Info[0] = HA_HEADER_E3 | CmdName;
    *(UWORD*)&sndMsg.Info[2] = obtime >> 16;
    *(UWORD*)&sndMsg.Info[4] = obtime;    
    *(UWORD*)&sndMsg.Info[6] = Value;
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E3;
    
    return OS_piMsgQueueSend(HA_MAILBOX, (void*)&sndMsg, sizeof(MsgTsk));
}



/*****************************************************************************/
/* @Function: HA_opLogHistoryEntry5                                          */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #5. First it fills              */
/*  an entry type #5 structure and then sends a log message                  */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  fileid               IN      the file id where the function had called   */
/*  line                 IN      the line number where the function had      */
/*                               called                                      */
/*  info1,info2,info3    IN      additional information regardint the        */
/*                               specific error                              */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opLogHistoryEntry5  (unsigned int         fileid,
                                    unsigned int         line, 
                                    unsigned int         info1,
				    TI_TIME obt) {
  MsgTsk       sndMsg;
  TI_TIME      obtime=obt;

    /* Get OBT                                    */
    if(obt==0)
#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
      TI_piGetTimeInfo_s(&obtime);

    *((unsigned short int* )&sndMsg.Info[0]) =HA_HEADER_E5 | (fileid & 0x00ff);
    *((unsigned short int* )&sndMsg.Info[2]) =(obtime >>16);
    *((unsigned short int* )&sndMsg.Info[4]) =(obtime & 0xffff);
    *((unsigned short int* )&sndMsg.Info[6]) =line;
    *((unsigned short int* )&sndMsg.Info[8]) =(unsigned short int)(info1 >> 16);
    *((unsigned short int* )&sndMsg.Info[10])=(unsigned short int)(info1);
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E5;
    /* Send message in the Histrory area          */        
    HA_piSndMsgHistoryArea(&sndMsg);

}

/*****************************************************************************/
/* @Function: HA_piLogHistoryEntry10                                         */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #10. First it fills             */
/*  an entry type #10 structure and then sends a log message                 */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SwOrigin            IN      identifier of the sw origin error            */
/*  Report1             IN      first report to be written                   */
/*  Report2             IN      second report to be written                  */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code HA_opLogHistoryEntry10( unsigned int SwOrigin, unsigned int Report1, unsigned int Report2 )
{
  MsgTsk   sndMsg;
  TI_TIME  obtime;
#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
    TI_piGetTimeInfo_s(&obtime);

    *(UWORD*)&sndMsg.Info[0] = HA_HEADER_E10 | SwOrigin;
    *(UWORD*)&sndMsg.Info[2] = obtime >> 16;
    *(UWORD*)&sndMsg.Info[4] = obtime;    
    *(UWORD*)&sndMsg.Info[6] = Report1;
    *(UWORD*)&sndMsg.Info[8] = Report2;
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E10;
    
    return OS_piMsgQueueSend(HA_MAILBOX, (void*)&sndMsg, sizeof(MsgTsk));
}


/*****************************************************************************/
/* @Function: HA_opLogHistoryEntry11                                         */
/* @Purpose :                                                                */
/*  This function writes a log of entry type #11. First it fills             */
/*  an entry type #11 structure and then sends a log message                 */
/*  to the History task                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  HwOrigin            IN      identifier of the Hw origin error            */
/*  HwErrorId           IN      first report to be written                   */
/*  ErrorID             IN      Error identifier                             */
/*  ErrorData           IN      Error Data details                           */
/* @@                                                                        */
/*****************************************************************************/
void HA_opLogHistoryEntry11 (unsigned int HwOrigin, 
                                    unsigned int HwErrorId,
                                    unsigned int ErrorData1,
                                    unsigned int ErrorData2)
{
MsgTsk         sndMsg;
TI_TIME        obtime;

#warning do we want OBT in s or in ms ? if ms, russian must be warned ? TM was in s
    /* Get OBT to time tag the Log                */
    TI_piGetTimeInfo_s(&obtime);

    *((unsigned short* )&sndMsg.Info[0])  =HA_HEADER_E11 | (HwOrigin & 0x0f);
    *((unsigned short* )&sndMsg.Info[2])  =(obtime >>16);
    *((unsigned short* )&sndMsg.Info[4])  =(obtime & 0xffff);
    /* Write HW Error identifier                  */
    *((unsigned short* )&sndMsg.Info[6])  =(HwErrorId & 0xffff);
    /* Write Error Datails                        */
    *((unsigned short* )&sndMsg.Info[8])  =(ErrorData1 & 0xffff);
    /* Write Error Datails                        */
    *((unsigned short* )&sndMsg.Info[10]) =(ErrorData2 & 0xffff);
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E11;
    /* Send message to the Histrory area          */
    HA_piSndMsgHistoryArea(&sndMsg);

}
