<?xml version="1.0" encoding="UTF-8"?>    <!-- Prologo XML -->
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">   <!-- Dichiarazione del documento XSLT -->
<!--    <xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"> -->
    
<!--    
=====================================================================================
 Stylesheet: VarDumpTemplate.xsl
    Version: 1.0 (2005-03-01)
     Author: Maurizio Nagni
     Descr.: Merge the output of the VarDumpToXml.c script with the VarDumpInfo.xml 
    	     file to generate a human readble verion of the VarDump packet
=====================================================================================
-->
    
<!--Contains some utility to converts dec/hex/bin numbers-->
<xsl:include href="numberutils_lib.xsl"/>

<!--Contains all the customer specific parameters-->
<!--<xsl:include href="Configure.xsl"/>-->
   
   <!-- Define which a key called "varDes" 
   	which will search inside the node "var" of the reference
   	VarDumpInfo.xml (or whatever file instead of the is used)
	all values values of the node "idx" matching the valued passed when 
	the key "fileName" is called -->
   <!-- No xml file is defined here because the xsl:key is absolutely generic -->
   <xsl:key name="varDes" match="var" use="idx"/>

   <xsl:template match="/" name="VarDumpReference">
     <xsl:param name="code"/>
     <xsl:param name="varval"/>
     <xsl:for-each select="document('./compilationInfo/PRH_ParamHandler_INFN_auto.var.xml')">
       <xsl:for-each select="key('varDes', $code)">
	 <td><xsl:value-of select="name"/> --  <xsl:value-of select="idx"/></td>
	 <td><xsl:value-of select="comment"/></td>
	 <td>
	   <xsl:call-template name="Dec2Hex">
	     <xsl:with-param name="value" select="$varval"/>
	   </xsl:call-template>
         </td> 
       </xsl:for-each> 
     </xsl:for-each>
   </xsl:template>
   
   <xsl:template match="/" name="VarDumpTemplate">
     <html>
       <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:12pt">
	 <h2>VarDump Event</h2>
	 <table border="1">
	  <xsl:for-each select="//VARDUMP_EVENT">
	     <tr bgcolor="#1acd32">
	       <th align="center">Packet OBT</th>
	       <th align="center">Packet Num</th>
	     </tr>
	     <tr>
		     <td><xsl:value-of select="PACKET_OBT"/></td>
		     <td><xsl:value-of select="PACKET_NUM"/></td>
	     </tr>
	     <tr bgcolor="#9acd32">
			<th align="left">Name (ID)  </th>
	   		<th align="left">Description</th>
		       	<th align="left">Value      </th>
	     </tr>		
	     <!--<xsl:variable name="compTS" select="COMPILATION_TS">  </xsl:variable>-->
	     <xsl:for-each select="VARDUMP_RECORDS/VARDUMP_RECORD">
	       <tr>
		 <xsl:variable name="retTemplate">
		 <xsl:call-template name="VarDumpReference">
		     <xsl:with-param name="code"   select="VAR_ID"/>
		     <xsl:with-param name="varval" select="VAR_VALUE"/>
		 </xsl:call-template>
                 </xsl:variable>
		<xsl:if test='$retTemplate=""'>
			<td><xsl:value-of select="VAR_ID"/> -- n.a.</td>
		  	<td> n.a. </td>
		  	<td>
		  		<xsl:call-template name="Dec2Hex">
					<xsl:with-param name="value" select="VAR_VALUE"/>
				</xsl:call-template>
		  	</td>
			  
		 </xsl:if>
		 <xsl:if test='$retTemplate!=""'>
			<xsl:copy-of select="$retTemplate" />
		 </xsl:if>
<!--
		 <td>
		 0x
		   <xsl:call-template name="Dec2Hex">
              	     <xsl:with-param name="value" select="INFO1"/>
            	   </xsl:call-template>
		   
		   <xsl:value-of select="INFO1"/>
		 </td>
-->
	       </tr> 
	     </xsl:for-each> 
	   </xsl:for-each>
	   
	 </table>
       </body>
     </html>
   </xsl:template>
 
 </xsl:stylesheet>
