<?xml version="1.0" encoding='ISO-8859-1'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- Dichiarazione del documento XSLT -->
<!--    <xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"> -->
    
<!--    
=====================================================================================
 Stylesheet: LogTemplate.xsl
    Version: 1.0 (2005-01-01)
     Author: Maurizio Nagni
     Descr.: Merge the output of the LogToXml.c script with the loginfo.xml 
    	     file to generate a human readble verion of the Log packet
     Note  : Needs customization of the CPUcode parameter into the Configure.xml file
=====================================================================================
-->
    
<!--Contains some utility to converts dec/hex/bin numbers-->
<xsl:include href="numberutils_lib.xsl"/>

<!--Contains all the customer specific parameters-->
<xsl:include href="Configure.xsl"/>
   
   <!-- Define which a key called "fileName" 
   	which will search inside the node "log"
	all values values of the node "fileid" matching the valued passed when 
	the key "fileName" is called -->
   <!-- No xml file is defined here because the xsl:key is absolutely generic -->
   <xsl:key name="fileName" match="log" use="fileid"/>

   <xsl:template match="/" name="LogReference">
     <xsl:param name="code"/>
     <xsl:param name="line_no"/>
     <xsl:param name="obt"/>
     <xsl:param name="info"/>
     <xsl:for-each select="document('./compilationInfo/loginfo.xml')">
	<xsl:for-each select="key('fileName', $code)">
	<xsl:if test="line=$line_no">
		<xsl:variable name="bgcolor">
			<xsl:choose>
				<xsl:when test="alarm='yes'">      <xsl:value-of select="'#ff0000'"/> </xsl:when>
				<xsl:when test="alarm='no'">       <xsl:value-of select="'#ffffff'"/> </xsl:when>
				<xsl:when test="alarm='yes1'">     <xsl:value-of select="'#ff8000'"/> </xsl:when>
				<xsl:when test="alarm='yes2'">     <xsl:value-of select="'#ffcc99'"/> </xsl:when>
				<xsl:when test="alarm='mcalib'">   <xsl:value-of select="'#b3ff66'"/> </xsl:when>
				<xsl:when test="alarm='macq'">     <xsl:value-of select="'#99ffff'"/> </xsl:when>
				<xsl:when test="alarm='minit'">    <xsl:value-of select="'#ffff66'"/> </xsl:when>
				<xsl:when test="alarm='calib'">    <xsl:value-of select="'#e6ffcc'"/> </xsl:when>
				<xsl:when test="alarm='acq'">      <xsl:value-of select="'#ccffff'"/> </xsl:when>
				<xsl:when test="alarm='init'">     <xsl:value-of select="'#ffffcc'"/> </xsl:when>
				<xsl:when test="alarm='ipm'">      <xsl:value-of select="'#F9B7FF'"/> </xsl:when>
				<xsl:otherwise> <xsl:value-of select="'#00ff00'"/> </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	 	<tr bgcolor="{$bgcolor}">
	 		<td><xsl:value-of select="$obt"/></td>
			<td><xsl:value-of select="type"/></td>
			<td>
				<A>
					<xsl:attribute name="href">
						<xsl:value-of select="concat($CPUcode, fullfilename)"/>
					</xsl:attribute>
					<xsl:value-of select="fullfilename"/>
					<div></div>
					<xsl:value-of select="description"/>
				</A>
			</td>
			<td>
				0x
				<xsl:call-template name="Dec2Hex">
					<xsl:with-param name="value" select="$info"/>
				</xsl:call-template>
				----
				<xsl:value-of select="$info"/>
		 	</td>
		</tr>
	 </xsl:if>
       </xsl:for-each>
     </xsl:for-each>
   </xsl:template>

   <xsl:template match="/" name="LogTemplate">
     <html>
       <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:12pt">
	 <h2>Log Records</h2>
	 <table border="1">
	   <xsl:for-each select="//LOG_EVENT">
	     <tr bgcolor="#1acd32">
	       <th align="center">Packet OBT</th>
	       <th align="center">Packet Num</th>
	     </tr>
	     <tr>
	       <th align="left"><xsl:value-of select="PACKET_OBT"/></th>
	       <th align="left"><xsl:value-of select="PACKET_NUM"/></th>
	     </tr>	
	     <tr bgcolor="#9acd32">
	       <xsl:for-each select="//COL">
		 <th align="left"><xsl:value-of select="."/></th>
	       </xsl:for-each>
	     </tr>
	      <xsl:for-each select="LOG_RECORDS/LOG_RECORD">
	      	<xsl:variable name="retTemplate">
			<xsl:call-template name="LogReference">
				<xsl:with-param name="code" select="FILE_ID"/>
				<xsl:with-param name="line_no" select="LINE_NO"/>
				<xsl:with-param name="obt" select="RECORD_OBT"/>
				<xsl:with-param name="info" select="INFO1"/>
			</xsl:call-template>
                </xsl:variable>
		 <xsl:if test='$retTemplate=""'>
		 <tr>
			<td><xsl:value-of select="RECORD_OBT"/></td>
		        <td><xsl:value-of select="MASKTYPE"/></td>
			<td><xsl:value-of select="FILE_ID"/> -- <xsl:value-of select="LINE_NO"/></td>
			<td>
		 		0x
		   		<xsl:call-template name="Dec2Hex">
              	     			<xsl:with-param name="value" select="INFO1"/>
            	   		</xsl:call-template>
		   		----
		   		<xsl:value-of select="INFO1"/>
		 	</td>
		 </tr>
		 </xsl:if>
		 <xsl:if test='$retTemplate!=""'>
			<xsl:copy-of select="$retTemplate" />
		 </xsl:if>
	     </xsl:for-each>
	   </xsl:for-each>
	   
	 </table>
       </body>
     </html>
   </xsl:template>
 
 </xsl:stylesheet>