<?xml version="1.0" encoding="UTF-8"?>    <!-- Prologo XML -->
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">   <!-- Dichiarazione del documento XSLT -->
<!--    <xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"> -->
    
<!--    
=====================================================================================
 Stylesheet: McmdTemplate.xsl
    Version: 1.0 (2005-03-01)
     Author: Maurizio Nagni
     Descr.: Merge the output of the McmdToXML.c script with the McmdInfo.xml 
    	     file to generate a human readble verion of the Mcmd packet.
	     The McmdReference Template build the header for the table that will 
	     contain the several types of MCMDs.
=====================================================================================
-->
    
<!--Contains some utility to converts dec/hex/bin numbers-->
<xsl:include href="numberutils_lib.xsl"/>

<!--Contains all the customer specific parameters-->
<!--<xsl:include href="Configure.xsl"/>-->
   
   <!-- Define which a key called "varDes" 
   	which will search inside the node "param" of the reference
   	McmdInfo.xml (or whatever file instead of the is used)
	all values values of the node "@id" matching the valued passed when 
	the key "param" is called -->
   <!-- No xml file is defined here because the xsl:key is absolutely generic -->
   <xsl:key name="varDes" match="mcmd" use="@id"/>

   <xsl:template match="/" name="McmdReference">
     <xsl:param name="code"/>
     <xsl:for-each select="document('McmdInfo.xml')">
       <xsl:for-each select="key('varDes', $code)">
	 <tr bgcolor="#FF0000"><td align="center" colspan='99'><th><xsl:value-of select="@name"/></th></td></tr>
	 <tr>
	   <xsl:for-each select="param">
	     <td bgcolor="#FF7700" align="left"><th><xsl:value-of select="@name"/></th></td>
	   </xsl:for-each>
	 </tr>
       </xsl:for-each>
     </xsl:for-each>
   </xsl:template>

   <xsl:template match="/" name="McmdTemplate">
     <html>
       <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:10pt">
	 <h2>Mcmd Event</h2>
	 <table border='1'>
	  <xsl:for-each select="//McmdEvent">
	     <tr bgcolor="#1acd32">
	       <th align="center" width='10%'>Packet OBT</th>
	       <th align="center" width='10%'>Packet Num</th>
	     </tr>
	     <tr>
	       <th align="left"><xsl:value-of select="@PacketOBT"/></th>
	       <th align="left"><xsl:value-of select="@PacketNum"/></th>
	     </tr>	
	     <xsl:for-each select="McmdRecord">
	       <tr bgcolor="#7777FF">
		 <th align="center">Mcmd OBT</th>
		 <th align="center">SeqId</th>
		 <th align="center">Type</th>
		 <td rowspan = '2' width='100%'>
		   <table bgcolor="#FFFFFF" width='100%' heigth='4'>
		     <!--Here I fill the table header names -->
		     <xsl:variable name="retTemplate">
		       <xsl:call-template name="McmdReference">
			 <xsl:with-param name="code"   select="@ID1"/>
		       </xsl:call-template>
		     </xsl:variable>
		     <xsl:if test='$retTemplate=""'>
		       <tr><td><th align="left"><xsl:value-of select="ID1"/> - n.a.</th></td></tr>
		     </xsl:if>
		     <xsl:if test='$retTemplate!=""'>
		       <xsl:copy-of select="$retTemplate" />
		     </xsl:if>
		     <!-- Here I fill the table values (take care of order!) -->
		     <tr rowspan='2'>
		       <xsl:for-each select="param">
			 <td><th align="left"><xsl:value-of select="."/></th></td>
		       </xsl:for-each>
		     </tr>
		   </table>
		 </td>
	       </tr> 
	       <tr>
	       	 <th align="left">
			<xsl:value-of select="@McmdOBT"/>
		 </th>
		 <th align="left"><xsl:value-of select="@SeqID"/></th>
		 <th align="left"><xsl:value-of select="@ID1"/></th>
	       </tr>
	     </xsl:for-each> 
	  </xsl:for-each>
	  
	 </table>
	 <!--
		 <td>
		 0x
		   <xsl:call-template name="Dec2Hex">
              	     <xsl:with-param name="value" select="INFO1"/>
            	   </xsl:call-template>
		   
		   <xsl:value-of select="INFO1"/>
		 </td>
-->

       </body>
     </html>
   </xsl:template>
 
 </xsl:stylesheet>