/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.8 $
/*  $Date: 2005/01/26 18:46:26 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: TI_TimingInfo_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: TI_TimingInfo_p.c,v $
/*  Revision 1.8  2005/01/26 18:46:26  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.7  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.6  2004/05/27 17:50:38  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.5  2004/05/06 15:50:57  faber
/*  GetTimeSyncInfo introduced
/*
/*  Revision 1.4  2003/09/12 10:52:56  faber
/*  introduced PTH_VAR_TC_CYC_RATE
/*
/*  Revision 1.3  2003/08/29 11:13:30  faber
/*  TI_StartTimerMoscowTime  introduced
/*
/*  Revision 1.2  2003/08/28 10:11:44  faber
/*  New timer management. GPT is now possible to be disabled. (DisableGPT,EnableGPT)
/*  GetTimeInfo now use the RTEMS clock instead reading the TI_SystemTime.
/*  GetTimeInfo now returns seconds, instead of milliseconds.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/11/14 09:46:42  zulia
/*  removed unsed status variable
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/BasicSW/TimingInfo/TI_TimingInfo_p.h>
#include <src/BasicSW/TimingInfo/TI_TimingInfo_op.h>


/*****************************************************************************/

/*======== T i m i n g I n f o   P R O V I D E D    I N T E R F A C E =======*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: TI_piInitTimingInfo                                            */
/* @Purpose :                                                                */
/*  Provided Interface to implement the TimingInfo object initialization.    */
/*  No parameters are requested.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TI_piInitTimingInfo(void)
{
status_code status;

    status =TI_opInitTimingInfo();
    return (status);

}



/*****************************************************************************/
/* @Function: TI_ihTimingInfo                                                */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the             */
/*  On Board Time (OBT) information.                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void TI_ihTimingInfo(void)
{

    TI_opTimingOperation();
   
}



/*****************************************************************************/
/* @Function: TI_piGetTimeInfo                                               */
/* @Purpose :                                                                */
/*  Provided Interface for return the On Board Time (OBT) information.       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  pTime                OUT     OBT read                                    */
/*  status_code          OUT     Return code (Always SUCCESSFUL)             */
/* @@                                                                        */
/*****************************************************************************/

status_code TI_piGetTimeInfo_s(TI_TIME* pTime)
{

    TI_opGetTimeInfo_s (pTime);
    return (SUCCESSFUL);
}

status_code TI_piGetTimeInfo_ms(TI_TIME* pTime)
{

    TI_opGetTimeInfo_ms (pTime);
    return (SUCCESSFUL);
}


/*****************************************************************************/
/* @Function: TI_piUpdateTimeInfo                                            */
/* @Purpose :                                                                */
/*  Provided Interface to update the On Board Time (OBT) information.        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Time                 IN      Value of the time to update                 */
/*  status_code          OUT     Return code (Always SUCCESSFUL)             */
/* @@                                                                        */
/*****************************************************************************/

status_code TI_piUpdateTimeInfo_s(TI_TIME  Time)
{
    TI_opUpdateTimeInfo_s (Time);
    return (SUCCESSFUL);
}

/*****************************************************************************/
/* @Function: DisableGPT                                                     */
/* @Purpose :                                                                */
/*  Provided Interface to disable the GPT interrupt                          */
/*                                                                           */
/* @@                                                                        */
/*****************************************************************************/

void TI_piDisableGPT() {
  TI_opDisableGPT();
}


/*****************************************************************************/
/* @Function: EnableGPT                                                      */
/* @Purpose :                                                                */
/*  Provided Interface to disable the GPT interrupt                          */
/*                                                                           */
/* @@                                                                        */
/*****************************************************************************/

void TI_piEnableGPT() {
  TI_opEnableGPT();
}


status_code TI_piSetObtOrbit_s() {
  return TI_opSetObtOrbit_s();
}

status_code TI_piGetObtOrbit_s(TI_TIME *t) {
  return TI_opGetObtOrbit_s(t);
}

status_code TI_piGetOrbitOffset_s(TI_TIME *t) {
  return TI_opGetOrbitOffset_s(t);
}

status_code  TI_piGetTimeSyncOffset_s(TI_TIME *t) {
  return TI_opGetTimeSyncOffset_s(t);
}

status_code TI_piGetCurrentMoscowTime_s(TI_TIME *t) {
  return TI_opGetCurrentMoscowTime_s(t);
}

status_code TI_piStartTimer_INFN_MoscowTime_s(unsigned int   Tim,TI_TIME   Time,void*     Routine,void*     UserData) {
  return TI_opStartTimer_INFN_MoscowTime_s(Tim,Time,Routine,UserData);
}

status_code TI_piTimeSyncIsAvailable(BOOL* avail) {
  return TI_opTimeSyncIsAvailable(avail);
}

status_code TI_piGetTimeSyncInfo_s(TI_TIME *obt_ts,TI_TIME *ts) {
  return TI_opGetTimeSyncInfo_s(obt_ts,ts);
}
