//
// CaloCHKCALIB.cc -- standalone program to call the CaloCHKCALIB macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <iostream>
//
extern void FCaloCHKCALIB(TString,  Long64_t, TString, int, TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir;
  TString format;
  int matra;
  Long64_t calibno;
  if ( numinp != 6 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n FCaloCHKCALIB file calib_number output_directory matra figure_format \n");
    printf("\n - file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - calib_number     is an integer (progressive calibration number), 0 = all \n");
    printf(  " - output_dir       directory where to store figures \n");
    printf(  " - matra            integer, 1 to print the strip rms in a box plot 0 to skip it\n");
    printf(  " - figure format    any format recognized by ROOT (eps,gif,...)\n");
    printf("\nExample: \n\nFCaloCHKCALIB /home/pamela/filesfromyoda/dw_050301_00100/ 0 /tmp/ 0 eps \n\n");
    return(0);
    //
  } else {
    printf("\n Welcome to FCaloCHKCALIB! \n");
    name = (TString)inps[1];
    char *pEnd;
    calibno = strtoull(inps[2],&pEnd,0);
    //    calibno = atoi(inps[2]);
    outdir = (TString)inps[3];
    matra = atoi(inps[4]);
    format = (TString)inps[5];
  };
  //
  FCaloCHKCALIB(name,calibno,outdir,matra,format);
  //
  return(0);
}
