/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: PD_PatchDumpManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: PD_PatchDumpManager_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.5  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_p.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_op.h>

/*****************************************************************************/

/*== P a t c h D u m p M a n a g e r    P R O V I D E D   I N T E R F A C E =*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: PD_piInitPatchDumpManager                                      */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the Patch/Dump Manager                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code PD_piInitPatchDumpManager(void)
{
    return PD_opInitPatchDumpManager();
}


/*****************************************************************************/
/* @Function: PD_piSndMsgPatchDumpManager                                    */
/* @Purpose :                                                                */
/*  Provided Interface to send a message to the PatchDump task.              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SndMsg               IN      pointer to the message structure             */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code PD_piSndMsgPatchDumpManager (MsgTsk* SndMsg)
{
    return PD_opSndMsgPatchDumpManager(SndMsg);
}

/*****************************************************************************/
/* @Function: PD_piGetDumpDataAddress                                        */
/* @Purpose :                                                                */
/*  This function gets the address of dumped data. Dumped data are stored    */
/*  into an array resident in RAM memory. This function retrieves the        */
/*  pointer to the first location.                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* pDump                IN      pointer to the address of dumped data        */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code PD_piGetDumpDataAddress(unsigned short int** pDump)
{
    return PD_opGetDumpDataAddress(pDump);
}

