/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MA_MCMDArea_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MA_MCMDArea_int.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_int.h>

/*============================== Local Variables ============================*/


/*****************************************************************************/

/*========== M C M D A r e a    I N T E R N A L   F U N C T I O N S =========*/

/*****************************************************************************/
/* @Function: MA_ifUpdateMcmdHeader                                          */
/* @Purpose :                                                                */
/* The function scans the list of the MCMD with timetag and it updates the   */
/* MCMD in top to the list with the more recent MCMD in order of time to be  */
/* executed.                                                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrHeaderMcmd        IN      Pointer to the MCMDs timetag list           */
/*  Obt                  IN      On board Time (OBT)                         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

void MA_ifUpdateMcmdHeader  (MA_HEADER_MCMD* PtrHeaderMcmd, TI_TIME Obt)
{
MA_HEADER_MCMD* pHOverObt;
MA_HEADER_MCMD* pHUnderObt;
MA_HEADER_MCMD* pt;
MA_HEADER_MCMD  tmpMcmd;
unsigned int    ttOverObt,ttUnderObt;
unsigned int    ttOverFlag,ttUnderFlag;
unsigned short  i;
unsigned int    psr;
float           a;

    ttOverObt   =MAX_TIMETAG;
    ttUnderObt  =MAX_TIMETAG;
    ttOverFlag  =FALSE;
    ttUnderFlag =FALSE;
    /* Search the more recent MCMD to execute                            */
    for (i=0,pt =PtrHeaderMcmd; i < MAX_MCMD_TIMETAG; i++,pt++)
    {
        if(pt->Type != NULL_MCMD)
        {
            if (pt->TimeTag < Obt)
            {
                /* Timetag which expires after the obt counter overflow  */
                if (pt->TimeTag < ttUnderObt)
                {
                 pHUnderObt  =pt;
                 ttUnderObt  =pt->TimeTag;
                 ttUnderFlag =TRUE;
                } 
            }
            else
            {
                /* Timetag which expires before the obt counter overflow */
                if (pt->TimeTag <= ttOverObt)
                {
                  pHOverObt  =pt;
                  ttOverObt  =pt->TimeTag;
                  ttOverFlag =TRUE;
                }                     
            }
        }
    }
    /* Check if next MCMD to execute has been found                      */
    tmpMcmd =*PtrHeaderMcmd;
    if (ttOverFlag)
    {
        *PtrHeaderMcmd =*pHOverObt;
        *pHOverObt     =tmpMcmd;
    }
    else
    { 
        if (ttUnderFlag)
        {
            *PtrHeaderMcmd =*pHUnderObt;
            *pHUnderObt    =tmpMcmd;
        }
    }

}

