/****************************************************************************
 *  F i l e   D a t a                                                        
 *                                                                           
 *  Module       : HKManager
 *  C.I. No.     :                                                           
 *  $Revision: 1.1.1.1 $ 
 *  $Date: 2006/04/25 09:00:20 $     
 *  Belonging to :                                                           
 *
 *  $RCSFile$ 
 *  Program Type :                                                           
 *  Sub-modules  :                                                           
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  Host system  :                                                           
 *  SW Compiler  :                                                           
 *  $Author: kusanagi $                                                                   
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: RG_ReportGenerator_INFN_op.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.2  2003/11/28 14:42:48  faber
 *  *** empty log message ***
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.1.1.1  2003/05/27 08:13:24  wizard
 *  Import of the Official Laben CD Release Software as the  pamela-EM_delivery_20030521_1454.tar.bz2
 *
 *  Revision 1.2  2002/04/24 09:56:29  ale
 *  Changed directory organization
 *
 *  Revision 1.1  2002/04/23 16:14:52  ale
 *  Imported Sources
 *
 *  Revision 1.2  2002/04/23 14:09:37  zulia
 *  Modified header file
 *
 *                                                                           
 *                                                                           
 *****************************************************************************/

/*============================= Include File ================================*/

#include <src/INFN/RG_ReportGenerator_INFN_op.h>  
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/FileManager/FileSystem/FS_FileSystem_p.h>

/*****************************************************************************/

/*============================== local define ===============================*/

#define MAX_DOWNLINK_SIZE 60

/*============================= Object variables ============================*/


/*****************************************************************************/

/*= HouseKeeping Manager  O P E R A T I O N A L  F U N C T I O N S =*/

/*****************************************************************************/
/* @Function: RG_opInitHKManager_INFN                                        */
/* @Purpose :                                                                */
/*  The function initializes the HK variables                                */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opInitReportGenerator_INFN(void)
{
    
    /* Initialize AnomalyCode a null                 */
     RG_IdAnomaly  =NULL_CODE;              
     RG_PeStatus  = NULL_STATUS;
    return (SUCCESSFUL);

}


/*****************************************************************************/
/* @Function: RG_opSetAnomalyCode_INFN                                       */
/* @Purpose :                                                                */
/*  The function sets the AnomalyCode of SSW.                                */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  AnomalyCode          IN      AnomalyCode (RG_INFN_ANOMALY type)          */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opSetAnomalyCode_INFN (RG_INFN_ANOMALY AnomalyCode)
{
status_code status = SUCCESSFUL;

  /* Check if a valid state is selected */
  if (AnomalyCode>NULL_CODE && AnomalyCode<MAX_INFN_ANOMALY)
  {
     
      RG_IdAnomaly = AnomalyCode;
 }
  else
  {
    /* Submode not identified   */
    status =HA_E10_STATE_ERR;
  }
  return (status);
}




/*****************************************************************************/
/* @Function: RG_opGetAnomalyCode_INFN                                       */
/* @Purpose :                                                                */
/*  The function returns the current state of the system.                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  AnomalyCode         OUT     AnomalyCode (RG_INFN_ANOMALY type)           */
/*  status_code         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opGetAnomalyCode_INFN (RG_INFN_ANOMALY* AnomalyCode)
{
status_code status = SUCCESSFUL;

  /* Copy the anomaly code into return variable    */

// *AnomalyCode = RG_IdAnomaly & 0x0F;
// TM: force Anomaly to zero 
 *AnomalyCode = 0 ;
  return (status);
}



status_code RG_opSetDownloadRequest_INFN (unsigned int DownloadReq)
{
status_code status;
unsigned short size;
FS_FILE_DESCR  fileInfo;

        DownloadReq = 0;
        
        status = SUCCESSFUL;
        
        FS_piGetFileInfo(FS_FILE1,&fileInfo);
        size = fileInfo.Size;
	/*        FS_piGetFileInfo(FS_FILE2,&fileInfo);
		  size = size + fileInfo.Size;   */
        if (size > MAX_DOWNLINK_SIZE) 
        {
          DownloadReq = 1;
        }
	RG_IdDownloadReq = DownloadReq;
        return(status);
} 

status_code RG_opGetDownloadRequest_INFN (unsigned int* DownloadReq)
{
status_code status = SUCCESSFUL;

  /* Copy the anomaly code into return variable    */

  *DownloadReq = RG_IdDownloadReq & 0x01;
  return (status);
}


/*****************************************************************************/
/* @Function: RG_opSetPamelaStatus_INFN                                      */
/* @Purpose :                                                                */
/*  The function sets the Pamela Experiment/Equipment Status  bits of SSW.   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  AnomalyCode          IN      AnomalyCode (RG_INFN_ANOMALY type)          */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opSetPamelaStatus_INFN (RG_INFN_STATUS PamelaStatus)
{
status_code status = SUCCESSFUL;

  /* Check if a valid state is selected */
  if (PamelaStatus>NULL_CODE && PamelaStatus<MAX_INFN_STATUS)
  {
      /* Set the Status bits */
      RG_PeStatus = PamelaStatus;
 }
  else
  {
    /* Status not identified   */
    status =HA_E10_STATE_ERR;
  }
  return (status);
}




/*****************************************************************************/
/* @Function: RG_opGetPamelaStatus_INFN                                      */
/* @Purpose :                                                                */
/*  The function returns the status of the Pamela Experiment/Equipment.      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PamelaStatus         OUT    PamelaStatus(RG_INFN_STATUStype)             */
/*  status_code         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opGetPamelaStatus_INFN (RG_INFN_STATUS* PamelaStatus)
{
status_code status = SUCCESSFUL;


  *PamelaStatus= RG_PeStatus & 0x3;
  return (status);
}
