/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: PD_PatchDumpManager_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: PD_PatchDumpManager_op.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.3  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.7  2002/11/14 09:45:07  zulia
/*  correct use of status returned value
/*
/*  Revision 1.6  2002/08/05 14:25:35  zulia
/*  Fixed Patch & Dump
/*
/*  Revision 1.5  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_op.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_int.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _PD_PatchDumpManager_op__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>

LU_DECL_MASK();



/*****************************************************************************/
/*============================= Object variables ============================*/
/*****************************************************************************/
/* @Variable: PD_PatchBuff                                                   */
/* @Purpose :                                                                */
/*   Array of words 16 bits wide to stores data to be patched                */
/* @@                                                                        */
/*****************************************************************************/
static UWORD PD_PatchBuff[PD_BUFFER_PATCH_MAX_SIZE];

/*****************************************************************************/
/* @Variable: PD_DumpBuff                                                    */
/* @Purpose :                                                                */
/*   Array of words 16 bits wide to store dumped data                        */
/* @@                                                                        */
/*****************************************************************************/
static UWORD PD_DumpBuff [PD_BUFFER_DUMP_MAX_SIZE];

/*****************************************************************************/
/* @Variable: PD_DumpInfo                                                    */
/* @Purpose :                                                                */
/*   Structure to collect relevant data to manages patch/dump object         */
/*                                                                           */
/* @@                                                                        */
/*****************************************************************************/
static PD_INFO PD_DumpInfo;

/*****************************************************************************/

/* P a t c h D u m p M a n a g e r  O P E R A T I O N A L  F U N C T I O N S */

/*****************************************************************************/
/* @Function: PD_opInitPatchDumpManager                                      */
/* @Purpose :                                                                */
/*  This function initalize the PatchDump object setting the task to         */
/*  the READY state and setting its priority                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code PD_opInitPatchDumpManager( void )
{
  status_code  status;        
  unsigned int OldPriority;
    
    status  = SUCCESSFUL;
    
    status |= OS_piTaskReady(PD_TASK,PD_tkPatchDumpManager);
    if ( status != SUCCESSFUL )
    {
      /* Task is not correctly started             */
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_HA,HA_E10_TSK_READY_ERR,status);    
      LU_INFN_LOG(LU_FATAL | LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }    

    status |= OS_piTaskPriority( PD_TASK,PATCHDUMPMANAGER_PRIORITY,&OldPriority);
    if ( status != SUCCESSFUL )
      {
        /* Task priority is not correctly updated    */
	// LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_HA,HA_E10_TSK_READY_ERR,status);    
	LU_INFN_LOG(LU_FATAL | LU_HA ,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      }

    PD_DumpInfo.pAppend         = PD_DumpBuff;
    PD_DumpInfo.nWordsAvailable = PD_BUFFER_DUMP_MAX_SIZE;
        
    return (status);

}


/*****************************************************************************/
/* @Function: PD_opSndMsgPatchDumpManager                                    */
/* @Purpose :                                                                */
/*  This function sends a message to the PatchDump task.                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SndMsg               IN      pointer to message structure                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
 
status_code PD_opSndMsgPatchDumpManager(MsgTsk* SndMsg)
{
    return OS_piMsgQueueSend(PD_MAILBOX,(void*)SndMsg,sizeof(MsgTsk));
}


/*****************************************************************************/
/* @Function: PD_tkPatchDumpManager                                          */
/* @Purpose :                                                                */
/*  The function is the task handler of the PatchDump object.                */
/*  When a message is received into task mailbox it wakes up.                */
/*  The information contained in the message (MsgTsk structure) define       */
/*  parameters (Info field), and the operation type that the task performs   */
/*  (Code field).                                                            */
/*  The PatchDump task activity is to  manage the Patch or Dump mcmd.        */
/*  The function switches between these two commands.                        */
/*  The allowed messages for this task are:                                  */
/*  Message code	    Action                                               */
/*  RG_RESET	        Puts the ReportGenerator object into its             */
/*                      initial state                                        */
/*  RG_PREPARE_FRM_RT	Commands the task to prepare the telemetry           */
/*                      real time format                                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

task PD_tkPatchDumpManager(task_argument unused)
{
  status_code  status;
  MsgTsk       RxMsg;
  unsigned int MsgSize;
  UWORD*       pw;

    
    while( FOREVER ) 
    {
        RxMsg.Code = NULL_MSG_PD;
        /* Wait for a message to become available                */
        if ((status = OS_piMsgQueueReceive(PD_MAILBOX,(void*)&RxMsg,
                      &MsgSize, WAIT, NO_TIMEOUT)) == SUCCESSFUL )
        {
            switch ( RxMsg.Code )
            {
                case PD_PATCH:   /*=== MCMD PATCH management     */
                     PD_ifPatch((MA_HEADER_MCMD*)RxMsg.Info, &PD_PatchBuff[0]);
                     break;
                
                case PD_DUMP:    /*=== MCMD DUMP management     */
                     PD_ifDump((MA_HEADER_MCMD*)RxMsg.Info, &PD_DumpBuff[0],&PD_DumpInfo);
                     break;
                
                default:
                break;
            }
        }
    }
}


/*****************************************************************************/
/* @Function: PD_opGetDumpDataAddress                                        */
/* @Purpose :                                                                */
/*  This function gets the address of dumped data. Dumped data are stored    */
/*  into an array resident in RAM memory. This function retrieves the        */
/*  pointer to the first location.                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* pDump                IN      pointer to dump memory area address          */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
 
status_code PD_opGetDumpDataAddress(unsigned short int** pDump)
{
    *pDump = &PD_DumpBuff[0];
    return (SUCCESSFUL);
}

