/****************************************************************************
 *  F i l e   D a t a                                                        
 *                                                                           
 *  Module       : RTEMSInterface
 *  C.I. No.     :                                                           
 *  $Revision: 1.1.1.1 $ 
 *  $Date: 2006/04/25 09:00:20 $     
 *  Belonging to :                                                           
 *
 *  $RCSFile$ 
 *  Program Type :                                                           
 *  Sub-modules  :                                                           
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  Host system  :                                                           
 *  SW Compiler  :                                                           
 *  $Author: kusanagi $                                                                   
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: OS_rtems_INFN_p.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.17  2005/02/21 08:58:29  sebastiani
 *  all log comments completed
 *
 *  Revision 1.16  2004/12/21 14:16:23  sebastiani
 *   OS_piSuspendUnlessEvent bugfix if timeout is zero
 *
 *  Revision 1.15  2004/11/10 17:00:00  sebastiani
 *  - GS_COMPILE directive introduced and be undef by default
 *  - automatic flush mechanism by run manager mailbox timeout
 *
 *  Revision 1.14  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.13  2004/09/09 14:52:55  sebastiani
 *  using PreparePage to send cmd to idaq/FE
 *  added some test
 *  added trigger param
 *  added/tested Force Send KHB_to_FE
 *  added/tested Send Cmd to IDAQ/FE
 *
 *  Revision 1.12  2004/08/26 16:54:34  sebastiani
 *  version work fine
 *
 *  Revision 1.11  2004/06/01 16:41:19  sebastiani
 *  EventReceive ANY
 *
 *  Revision 1.10  2004/05/26 15:31:54  sebastiani
 *  some fixing on CAL/TRK/ACQ
 *
 *  Revision 1.9  2004/05/26 11:15:16  sebastiani
 *  SentTrigger() introduced; RM_TaskSuspendUnlessSINT() introduced
 *
 *  Revision 1.8  2004/03/09 16:41:51  sebastiani
 *  introduced LU_TRACE in OS_rtems_INFN_p
 *  check in LU_TRACE of interrupt mode
 *
 *  Revision 1.7  2004/03/09 09:39:27  faber
 *  LU_TRACE system introduced
 *
 *  Revision 1.6  2003/11/20 10:24:46  faber
 *  - interrupt_is_in_progress check inside the OS_Obtain
 *  - CM_RETURN_CODE type starting from RTEMS_STATUS_CODES_LAST, in order to have a unique error space coding
 *
 *  Revision 1.5  2003/10/21 16:09:12  alfarano
 *  LU_LOG_INFN replacement for all remaining original log functions
 *
 *  Revision 1.4  2003/08/27 09:49:17  wizard
 *  Fix last sector in donwload.
 *  Set Sector size to 1024*1015
 *  Fix Donwload procedure... ( set size set lastsector flag.....)
 *  bye
 *
 *  Revision 1.3  2003/08/26 07:41:20  faber
 *  Events macros introduced
 *
 *  Revision 1.2  2003/08/07 08:44:40  wizard
 *  *** empty log message ***
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.5  2003/07/25 10:31:23  sebastiani
 *  bug fix semaphore creation and mailbox creation
 *
 *  Revision 1.4  2003/07/10 15:56:27  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.3  2003/07/03 12:39:29  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.2  2003/06/09 17:04:28  sebastiani
 *  Added handling of partition to manage INFN MCMD.
 *
 *  Revision 1.1.1.1  2003/05/27 08:13:24  wizard
 *  Import of the Official Laben CD Release Software as the  pamela-EM_delivery_20030521_1454.tar.bz2
 *
 *  Revision 1.6  2002/04/24 17:15:51  ale
 *  added MessageQueueGetNumberPending
 *
 *  Revision 1.5  2002/04/24 12:15:16  ale
 *  Fixed start task
 *
 *  Revision 1.4  2002/04/24 09:45:57  ale
 *  added new task (HK)
 *
 *  Revision 1.3  2002/04/23 14:31:09  zulia
 *  converted to unix format
 *
 *  Revision 1.2  2002/04/23 14:22:07  zulia
 *  Modified header file
 *
 *                                                                           
 *                                                                           
 *****************************************************************************/
 
/*============================= Include File ================================*/
  
#include <tmacros.h>
#include <src/INFN/OS_rtems_INFN_p.h>
#include <src/INFN/OS_rtems_INFN_op.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _OS_rtems_INFN_p__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();
LU_DECL_TRACE();

#include <src/INFN/CM_Common_INFN.h> 
/*****************************************************************************/
/*==================== RTEMS configuration variables ========================*/

/*****************************************************************************/
/* @Variable: Task_id                                                        */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS tasks identification.                                             */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Task_INFN_id        [MAX_INFN_TASKS];       

/*****************************************************************************/
/* @Variable: Task_name                                                      */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS tasks name.                                                       */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Task_INFN_name      [MAX_INFN_TASKS];       

/*****************************************************************************/
/* @Variable: Msg_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS mailboxes identification.                                         */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Msg_INFN_id         [MAX_INFN_MBOX];

/*****************************************************************************/
/* @Variable: Msg_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS mailboxes name.                                                   */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Msg_INFN_name       [MAX_INFN_MBOX];

/*****************************************************************************/
/* @Variable: Sem_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS semaphores identification.                                        */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Sem_INFN_id         [MAX_INFN_RES];    

/*****************************************************************************/
/* @Variable: Sem_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS semaphores name.                                                  */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Sem_INFN_name       [MAX_INFN_RES];

/*****************************************************************************/
/* @Variable: Part_id                                                        */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS patitios identification.                                          */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Part_INFN_id        [MAX_INFN_PART];    

/*****************************************************************************/
/* @Variable: Part_name                                                      */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS patitios name.                                                    */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Part_INFN_name      [MAX_INFN_PART];  

/*****************************************************************************/
/* @Variable: Tim_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS timers identification.                                            */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Tim_INFN_id         [MAX_INFN_TIM];     

/*****************************************************************************/
/* @Variable: Tim_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS timers name.                                                      */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Tim_INFN_name       [MAX_INFN_TIM];     

/*****************************************************************************/
/* @Variable: MA_Partition                                                   */
/* @Purpose :                                                                */
/*   Array of rtems_unsigned32                                               */
/*   MCMD area patition.                                                     */
/* @@                                                                        */
/*****************************************************************************/
static rtems_unsigned32 MCMD_INFN_Partition [MCMD_INFN_PART_SIZE];  

/*****************************************************************************/

/*============ R T E M S   P R O V I D E D    I N T E R F A C E =============*/

/*****************************************************************************/
/* @Function: OS_piInitOS                                                    */
/* @Purpose :                                                                */
/* Initialization of the Operating System global resources.                  */
/* All Task, mailboxes, semaphores, partitons, timers are created and        */
/* allocated. RTEMS directives are called for resources creation.            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                       IN                                                  */
/* status_code           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piInitOS_INFN(void)
{
  rtems_status_code status;
  rtems_time_of_day time;
  rtems_unsigned32  tmpPart;
  rtems_unsigned32  trashPart;
  unsigned long     statusRc;
  unsigned int      i;
  unsigned char     c;
  
    status     =SUCCESSFUL; 
    statusRc   =SUCCESSFUL;


/*===========================================================================*/
    /*==== TASKS CREATION  ========================*/
    for (i=1,c=49; i<MAX_INFN_TASK_2; i++,c++)
    {
        Task_INFN_name[i] =rtems_build_name( 'T', 'S', 'K', c );
        status =rtems_task_create(Task_INFN_name[i],255, RTEMS_MINIMUM_STACK_SIZE, 
                                  RTEMS_DEFAULT_MODES,RTEMS_DEFAULT_ATTRIBUTES,
                                  &Task_INFN_id[i]);
        if (status!=SUCCESSFUL)
        {
	  /* Error during task resource creation, log in history area      */
	  /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_TSK_CREATION_ERR,status); */
	  LU_INFN_LOG(LU_FATAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  statusRc =HA_E2_INTERNAL_ERR;
        } else
	  LU_TRACE_LOAD_TASK_INFO(i,Task_INFN_id[i]);
    }




/*===========================================================================*/
    /*==== TASKS MAILBOXES CREATION ===================*/
    for (i=1,c=49; i<MAX_INFN_MESSAGE_QUEUES_2; i++,c++)
    {

        Msg_INFN_name[i] = rtems_build_name( 'M', 'B', 'X', c );
        status =rtems_message_queue_create(Msg_INFN_name[i], MAX_INFN_MSG_MBOX_1, 
                                           MAX_INFN_MSG_MBOX_SIZE_1, RTEMS_PRIORITY,
                                           &Msg_INFN_id[i]);
        if (status!=SUCCESSFUL)
        {
            /* Error during mailbox resource creation, log in history area   */
            /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_MBOX_CREATION_ERR,status); */
	    LU_INFN_LOG(LU_FATAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
            statusRc =HA_E2_INTERNAL_ERR;
        }
    }
    /*==== GENERIC MAILBOXES CREATION ================*/
    for ( ; i<MAX_INFN_MBOX; i++,c++)
    {

        Msg_INFN_name[i] = rtems_build_name( 'M', 'B', 'X', c );
        status =rtems_message_queue_create(Msg_INFN_name[i], MAX_INFN_MSG_MBOX_2, 
                                           MAX_INFN_MSG_MBOX_SIZE_2, RTEMS_PRIORITY,
                                           &Msg_INFN_id[i]);
        if (status!=SUCCESSFUL)
        {
            /* Error during mailbox resource creation, log in history area   */
            /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_MBOX_CREATION_ERR,status); */
	    LU_INFN_LOG(LU_FATAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
            statusRc =HA_E2_INTERNAL_ERR;
        }
    }


/*===========================================================================*/
    /*==== SEMAPHORES CREATION ========================*/
    for (i=1,c=49; i<MAX_INFN_RES; i++,c++)
    {
        Sem_INFN_name[i] =rtems_build_name( 'S', 'E', 'M', c );

	/*
        status =rtems_semaphore_create(Sem_INFN_name[i], 1,
	 			       RTEMS_FIFO | RTEMS_NO_INHERIT_PRIORITY | 
				       RTEMS_BINARY_SEMAPHORE | RTEMS_LOCAL, 
				       RTEMS_NO_PRIORITY_CEILING,&Sem_INFN_id[i]);
	
	*/
	
	status =rtems_semaphore_create(Sem_INFN_name[i], 1,RTEMS_DEFAULT_ATTRIBUTES, 
				       RTEMS_NO_PRIORITY_CEILING,&Sem_INFN_id[i]);
	
	/*
	  status =rtems_semaphore_create(Sem_INFN_name[i], 1,
	  RTEMS_FIFO | RTEMS_INHERIT_PRIORITY | RTEMS_BINARY_SEMAPHORE | RTEMS_LOCAL , 
	  RTEMS_NO_PRIORITY_CEILING,&Sem_INFN_id[i]);
	*/
        if (status!=SUCCESSFUL)
        {
            /* Error during semaphore resource creation, log in history area */
            /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_SEM_CREATION_ERR,status); */
	    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
            statusRc =HA_E2_INTERNAL_ERR;
        }
    }

/*===========================================================================*/
    /*==== PARTITIONS CREATION ========================*/
   
    for (i=1,c=1; i<MAX_INFN_PART; i++,c++)
      { 
	Part_INFN_name[i] =rtems_build_name( 'P', 'I', 'N',c);
      }

    for (i=0 ; i < MCMD_INFN_PART_SIZE; i++)
	  MCMD_INFN_Partition[i] =0; 
       
    // MCMD partion creation                      
    tmpPart   = (rtems_unsigned32) &MCMD_INFN_Partition;
    tmpPart   &= 0xfffffff0;
    status   =rtems_partition_create(Part_INFN_name[MCMD_INFN_PART],
				     MCMD_INFN_Partition,  
				     MCMD_INFN_PART_SIZE-4,
				     MCMD_INFN_PART_BUFFER_SIZE,
				     RTEMS_LOCAL,
				     &Part_INFN_id[MCMD_INFN_PART]
				     );
    if(status != RTEMS_SUCCESSFUL) {
      /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_PAR_CREATION_ERR,status); */
      LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      statusRc =HA_E2_INTERNAL_ERR;
    }

/*===========================================================================*/
    /*==== TIMERS CREATION ========================*/
    for (i=1,c=49; i<MAX_INFN_TIM; i++,c++)
    {
        Tim_INFN_name[i] = rtems_build_name( 'T', 'I', c, ' ' );
        status =rtems_timer_create(Tim_INFN_name[i], &Tim_INFN_id[i]);
        if (status!=SUCCESSFUL)
        {
            /* Error during timer resource creation, log in history area     */
            /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_TIM_CREATION_ERR,status); */
	    LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
            statusRc =HA_E2_INTERNAL_ERR;
        }
    }

/*===========================================================================*/

    return (statusRc);

}



/*****************************************************************************/
/* @Function: OS_piSWReset                                                   */
/* @Purpose :                                                                */
/* Reset the software. Destroys all obects created during the initialization */
/* of the INFN initialization.                                               */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                       IN                                                  */
/* return                OUT                                                 */
/* @@                                                                        */
/*****************************************************************************/

#ifdef TEST_I
status_code OS_piSWReset_INFN() {
  /*==== INFN TASKS DELETION  ========================*/
  int i;
  status_code status;
  for (i=1; i<MAX_INFN_TASK_2; i++)
    {
      status =rtems_task_delete(Task_INFN_id[i]);
      if (status!=SUCCESSFUL)
	{
	  /* Error during task resource creation, log in history area      */
	  /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_TSK_CREATION_ERR,status); */
	  LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  return HA_E2_INTERNAL_ERR;
	}
    }
  return SUCCESSFUL;
}
#endif // TEST_I

/*****************************************************************************/
/* @Function: OS_piTaskReady                                                 */
/* @Purpose :                                                                */
/* The function readies the task specified (Task  param.). The starting      */
/* address of the task is given Entry parameter.                             */
/* The RTEMS directive is called to performs the start task.                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Task                 IN      Task ID                                     */
/*  Entry                IN      Function entry point                        */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskReady_INFN ( unsigned int Task,
                             void*        Entry)
{
rtems_status_code status;

    /* Check Task ID validity   */
    if(Task < MAX_INFN_TASK_2)
    {
        /* Start task           */
        status =rtems_task_start(Task_INFN_id[Task],(rtems_task_entry)Entry,Task);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}



/*****************************************************************************/
/* @Function: OS_piTaskPriority                                              */
/* @Purpose :                                                                */
/* The function manipulates the task priority. The parameters -Task- and     */
/* and -NewPriority_  identifies  respectively the task ID and the new       */
/* priority. The RTEMS directive is called to performs priority setting.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Task                 IN      Task ID                                     */
/*  NewPriority          IN      Priority value                              */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  OldPriority          OUT     Current priority                            */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskPriority_INFN    ( unsigned int   Task,
                                   unsigned int   NewPriority,
                                   unsigned int*  OldPriority)
{
rtems_status_code status;

    /* Check Task ID validity and Priority parameters range */
    if(Task < MAX_INFN_TASK_2 && NewPriority < MAX_INFN_PRIORITY_RANGE)
    {
        /* Call RTEMS directive for priority setting        */
        status =rtems_task_set_priority(Task_INFN_id[Task],NewPriority,
                (rtems_task_priority*)OldPriority);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}





/*****************************************************************************/
/* @Function: OS_piMsgQueueSend                                              */
/* @Purpose :                                                                */
/*  The function interface performs the send masssge to a mail box queue     */
/*  addressed.                                                               */
/*  The RTEMS directive is called to performs the mailbox send message.      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  mBox                 IN      Mailbox ID                                  */
/*  MsgToSend            IN      Poniter to message information              */
/*  MsgLenght            IN      Message lenght                              */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piMsgQueueSend_INFN(unsigned int mBox,
                              void*        MsgToSend,
                              unsigned int MsgLenght)
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);
  /* Check Mailbox queue address validity            */
  if(mBox < MAX_INFN_MBOX)
    {
      /* RTEMS directive to send message to mailbox  */
      status =rtems_message_queue_send(Msg_INFN_id[mBox],MsgToSend,
				       (rtems_unsigned32)MsgLenght);
    }
  else
    {
      status =RTEMS_INVALID_ID;
    }
  LU_TRACE(__FILEID__,__LINE__);
  return (status);

}



/*****************************************************************************/
/* @Function: OS_piMsgQueueReceive                                           */
/* @Purpose :                                                                */
/*  The function receives a message from the message queue specified in mBox */
/*  parameter. The WAIT and NO_WAIT options of the -OptionSet- parameter     */
/*  allow the calling task to specify whether to wait for a message to become*/
/*  available o return immediately. The -Timeout- parameter specifies the    */
/*  timeout value for WAIT option. If NO_TIMEOUT value is set the calling    */
/*  task wait forever.                                                       */
/*  The RTEMS directive is called to performs the receive message.           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  mBox                 IN      Mailbox ID                                  */
/*  OptionSet            IN      WAITt and NO_WAIT option                    */
/*  Timeout              IN      Timeout value for Wait option               */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  MsgToRx              OUT     Buffer pointer where message is returned    */
/*  MsgSize              OUT     Size pointer where message size is returned */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piMsgQueueReceive_INFN ( unsigned int  mBox,
                                   void*         MsgToRx,
                                   unsigned int* MsgSize,
                                   unsigned int  OptionSet,
                                   unsigned int  Timeout)
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);
  /* Check Mailbox queue address validity                           */
  if(mBox < MAX_INFN_MBOX)
    
    /* RTEMS directive to receive message from the message queue  */
    status =rtems_message_queue_receive(Msg_INFN_id[mBox],MsgToRx,
					(rtems_unsigned32 *)MsgSize,
					  OptionSet,Timeout);
  
  else
    status =RTEMS_INVALID_ID;
  
  LU_TRACE(__FILEID__,__LINE__);
  return (status);
}






/*****************************************************************************/
/* @Function: OS_piResourceObtain                                            */
/* @Purpose :                                                                */
/*  The function acquires the semaphore specified in the -Res- parameter.    */
/*  The WAIT and NO_WAIT options of the -OptionSet- parameter allow          */
/*  the calling task to specify whether to wait for a message to become      */
/*  available o return immediately. The -Timeout- parameter specifies the    */
/*  timeout value for WAIT option. If NO_TIMEOUT value is set the calling    */
/*  task wait forever.                                                       */
/*  The RTEMS directive is called to performs the semaphore acquisition.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Res                  IN      Semaphore ID                                */
/*  OptionSet            IN      WAIT and NO_WAIT option                     */
/*  Timeout              IN      Timeout value for Wait option               */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piResourceObtain_INFN ( unsigned int Res,
				       unsigned int OptionSet,
				       unsigned int Timeout)
{
  rtems_status_code status;
  if(rtems_interrupt_is_in_progress()) {
    /*@LOG OS_piResourceObtain_INFN: during interrupt. Bug !!*/
    LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,0xffff);
    return CM_RC_INTERRUPT_IS_IN_PROGRESS;
  }
  LU_TRACE(__FILEID__,__LINE__);
  /* Check semaphore ID validity                       */
  if(Res < MAX_INFN_RES)
      /* RTEMS directive to obtain semaphore resource  */
      status =rtems_semaphore_obtain(Sem_INFN_id[Res], OptionSet, Timeout);
  else
      status =RTEMS_INVALID_ID;    
  LU_TRACE(__FILEID__,__LINE__);
  return (status);

}
 
 
 
/*****************************************************************************/
/* @Function: OS_piResourceRelease                                           */
/* @Purpose :                                                                */
/*  The function releases the semaphore specified in the -Res- parameter.    */
/*  The RTEMS directive is called to performs the semaphore release.         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Res                  IN      Semaphore ID                                */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piResourceRelease_INFN ( unsigned int Res )
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);
  /* Check semaphore ID validity                       */
  if(Res < MAX_INFN_RES)
    /* RTEMS directive to release semaphore resource */
    status =rtems_semaphore_release (Sem_INFN_id[Res]);
  else
    status =RTEMS_INVALID_ID;
  LU_TRACE(__FILEID__,__LINE__);
  return (status);
    
}



/*****************************************************************************/
/* @Function: OS_piStartTimer                                                */
/* @Purpose :                                                                */
/*  The function initiates the timer specified by -Tim- parameter.           */
/*  The timer is scheduled to fire after a time interval expressed in system */
/*  ticks into -Time- parameter. When the timer fires, the timer service     */
/*  routine will be invoked with user data.                                  */
/*  The RTEMS directive is called to performs the start timer after interval.*/
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Tim                  IN      Timer ID                                    */
/*  Time                 IN      Interval time                               */
/*  Routine              IN      Pointer to timer service routine            */
/*  UserData             IN      Pointer to user data                        */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piStartTimer_INFN ( unsigned int Tim,
                              unsigned int Time,
                              void*        Routine,
                              void*        UserData)
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);  
  /* Check timer ID validity                */
  if (Tim < MAX_INFN_TIM)
    /* RTEMS directive to start timeer    */
    status =rtems_timer_fire_after(Tim_INFN_id[Tim],Time,Routine,UserData);
  else  
    status =RTEMS_INVALID_ID;
  LU_TRACE(__FILEID__,__LINE__);  
  return (status);

}



/*****************************************************************************/
/* @Function: OS_piCancelTimer                                               */
/* @Purpose :                                                                */
/*  The function cancels the timer specified by -Tim- parameter.             */
/*  The RTEMS directive is called to performs the timer cancelation          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Tim                  IN      Timer ID                                    */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piCancelTimer_INFN ( unsigned int Tim)
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);  
  /* Check timer ID validity               */
  if (Tim < MAX_INFN_TIM)
    /* RTEMS directive to cancel timer   */
    status =rtems_timer_cancel(Tim_INFN_id[Tim]);
  else
    status =RTEMS_INVALID_ID;
  LU_TRACE(__FILEID__,__LINE__);  
  return (status);
}


/*****************************************************************************/
/* @Function:                                                */
/* @Purpose :                                                                */
/*  The function cancels the timer specified by -Tim- parameter.             */
/*  The RTEMS directive is called to performs the timer cancelation          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Tim                  IN      Timer ID                                    */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piMessageQueueGetNumberPending_INFN (unsigned int mBox,
                                                 unsigned int* Count)
{
  rtems_status_code status;
  LU_TRACE(__FILEID__,__LINE__);  
  /* Check Task ID validity */
  if(mBox < MAX_INFN_MBOX )
      /* Call RTEMS directive for get the number of msgs pending on a queue */
    status = rtems_message_queue_get_number_pending(Msg_INFN_id[mBox], Count);
  else
    status =RTEMS_INVALID_ID;
  LU_TRACE(__FILEID__,__LINE__);
  return (status);
}


/*****************************************************************************/
/* @Function: OS_piPartGetBuffer                                             */
/* @Purpose :                                                                */
/*  The function allows a buffer to be obtained from the partition specified */
/*  in -Part- parameter.                                                     */
/*  The RTEMS directive is called to performs the get buffer from a          */
/*  partition.                                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Part                 IN      Partition ID                                */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  pBuf                 OUT     Partition buffer pointer returned           */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piPartGetBuffer_INFN   ( unsigned int   Part,
					void**         pBuf) {
  status_code status;
  if(Part > NULL_INFN_PART && 
     Part < MAX_INFN_PART) {
    status = rtems_partition_get_buffer(Part_INFN_id[Part],pBuf);
  }else
    status = RTEMS_INVALID_ID;
  return status;
}

/*****************************************************************************/
/* @Function: OS_piPartReturnBuffer                                          */
/* @Purpose :                                                                */
/*  The function returns the buffer specified to the partition.              */
/*  The RTEMS directive is called to performs the return buffer to a         */
/*  partition.                                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Part                 IN      Partition ID                                */
/*  pBuf                 IN      Partition buffer pointer released           */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piPartReturnBuffer_INFN ( unsigned int   Part,
					 void*          pBuf) {
  status_code status;
  if(Part > NULL_INFN_PART && 
     Part < MAX_INFN_PART) {
    status = rtems_partition_return_buffer(Part_INFN_id[Part],pBuf);
  }else
    status = RTEMS_INVALID_ID;
  return status;
}


/*****************************************************************************/
/* @Function: OS_pEventSend                                                  */
/* @Purpose :                                                                */
/* Send an event to a task                                                   */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*****************************************************************************/

status_code OS_piEventSend(unsigned int Task,rtems_event_set event_in) {
  /* Check Task ID validity   */
  status_code status;
  LU_TRACE(__FILEID__,__LINE__);
  if(Task < MAX_INFN_TASK_2)
      status = rtems_event_send(Task_INFN_id[Task],event_in);
  else
      status =RTEMS_INVALID_ID;
  LU_TRACE(__FILEID__,__LINE__);
  return (status);
}


status_code OS_piEventReceive(rtems_event_set event_in, rtems_option option_set,rtems_interval timeout,rtems_event_set *event_out) {
  status_code status;
  LU_TRACE(__FILEID__,__LINE__);
  status = rtems_event_receive(event_in,option_set,timeout,event_out);
  LU_TRACE(__FILEID__,__LINE__);
  return status;
}


status_code OS_piSuspendUnlessEvent(rtems_event_set event_in, 
				    rtems_interval timeout,
				    rtems_event_set *event_out) {
  rtems_event_set local_event_out;
  status_code s;
  s = OS_piEventReceive(event_in,timeout?RTEMS_WAIT:RTEMS_NO_WAIT,timeout,&local_event_out);
  if(event_out != NULL)
    *event_out = local_event_out;
  return s;
}

/* the proceduce clean an event or an event set. If the event flag(s) is zero
   ignore this, otherwise receives the event and clear it. 
   the function always return successful */
status_code OS_piEventClear(rtems_event_set event_in) {
  rtems_event_set unused;
  return rtems_event_receive(event_in,RTEMS_EVENT_ANY|RTEMS_NO_WAIT,0,&unused);
}
