/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : FileManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: FS_FileSystem_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: FS_FileSystem_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.3  2003/10/29 17:41:48  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.2  2003/09/10 13:38:13  laben
/*  New File System Model:
/*  jusy one file used like a circular buffer.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/FileManager/FileSystem/FS_FileSystem_p.h>
#include <src/FileManager/FileSystem/FS_FileSystem_op.h>


/*****************************************************************************/

/*======= F i l e   S y s t e m   P R O V I D E D    I N T E R F A C E ======*/

/*****************************************************************************/

/*========================= E N T R Y    P O I N T ==========================*/

/*****************************************************************************/
/* @Function: FS_piInitFileSystem                                            */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the FileSystem                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piInitFileSystem(void)
{
FS_EXITCODE status;

  status = FS_opInitFileSystem();
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piGetFileInfo                                               */
/* @Purpose :                                                                */
/*  Provided Interface to get the status of the selected file                */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FileId              IN      File ID                                      */
/*  *FileInfo           OUT     File status                                  */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piGetFileInfo(FS_FILEID FileId, FS_FILE_DESCR* FileInfo)
{
FS_EXITCODE status;

  status = FS_opGetFileInfo(FileId, FileInfo);
  return (status);
}


/*****************************************************************************/
/* @Function: FS_piWriteFile                                                 */
/* @Purpose :                                                                */
/*  Provided Interface to check if a file could be written. The status of the*/
/*  selected file is not updated until the UpdateFile operation is called    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FileId              IN      File ID                                      */
/*  WriteSize           IN      Size of the data to be saved (in samples)    */
/*  WriteAddr           OUT     Address where to store data in the file      */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piWriteFile(FS_FILEID FileId, UINT32 WriteSize,
                           UINT32 *WriteAddr)
{
FS_EXITCODE status;

  status = FS_opWriteFile(FileId, WriteSize, WriteAddr);
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piUpdateFile                                                */
/* @Purpose :                                                                */
/*  Provided Interface to update file size after a store operation           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piUpdateFile(void)
{
FS_EXITCODE status;

  status = FS_opUpdateFile();
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piMakeFileImage                                             */
/* @Purpose :                                                                */
/*  Provided Interface to build the sector chain for the download operation  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  StartSector         IN      First sector of the partition to add to the  */
/*                              sector chain                                 */
/*  Size                IN      Size of the partition (in sample)            */
/*  New                 IN      This flag is used to build a new chain or to */
/*                              append a partition to an existing chain      */
/*  nsect               OUT     Number of sectors added to the chain         */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piMakeFileImage(UINT32 StartSector, UINT32 Size, UINT32* nsect,
                               BOOL New)
{
FS_EXITCODE status;

  status = FS_opMakeFileImage(StartSector, Size, nsect, New);
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piGetCurrentSector                                          */
/* @Purpose :                                                                */
/*  Provided Interface to retrive the current sector information to be used  */
/*  in a downlink sequence                                                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  *SectorInfo         OUT     Current sector information                   */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piGetCurrentSector(FS_SECT_DESCR *SectorInfo)
{
FS_EXITCODE status;

  status = FS_opGetCurrentSector(SectorInfo);
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piGetNextSector                                             */
/* @Purpose :                                                                */
/*  Provided Interface to retrive the next sector information to be used     */
/*  in a downlink sequence                                                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  *SectorInfo         OUT     Next sector information                      */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piGetNextSector(FS_SECT_DESCR *SectorInfo)
{
FS_EXITCODE status;

  status = FS_opGetNextSector(SectorInfo);
  return (status);
}

/*****************************************************************************/
/* @Function: FS_piResetFile                                                 */
/* @Purpose :                                                                */
/*  Provided Interface to reset the status of a file. By now it means that   */
/*  the size is set to 0                                                     */
/*  in a downlink sequence                                                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  *SectorInfo         OUT     Next sector information                      */
/*  FS_EXITCODE         OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

FS_EXITCODE FS_piResetFile(FS_FILEID FileId)
{
FS_EXITCODE status;

  status = FS_opResetFile(FileId);
  return (status);
}

FS_EXITCODE FS_piUpdateSectorPointer(){

  FS_EXITCODE status;
  status = FS_opUpdateSectorPointer();
  return (status);
}

void FS_piLogInfo() {
  FS_opLogInfo();
}
