/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MD_MCMDDispatcher_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MD_MCMDDispatcher_int.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.22  2005/02/21 08:58:29  sebastiani
/*  all log comments completed
/*
/*  Revision 1.21  2004/10/08 07:27:29  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.20  2004/09/28 15:36:38  sebastiani
/*  interrupt manager fix
/*
/*  Revision 1.19  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.18  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.17  2004/07/27 10:13:48  faber
/*  LU_ALARM macro introduced,
/*  LU_XXXX bit field "logtype" redefined.
/*  HistoryArea 5 now log a 32 bit word as "info1"
/*  and logging is reformatted.
/*
/*  Revision 1.16  2004/05/20 09:04:22  sebastiani
/*  ok
/*
/*  Revision 1.15  2004/05/13 10:47:17  faber
/*  hid the HB_Store funcion in favour of wrapped funcions
/*
/*  Revision 1.14  2004/05/11 09:11:06  faber
/*  *** empty log message ***
/*
/*  Revision 1.13  2004/05/03 16:08:21  sebastiani
/*  fix time sync store
/*
/*  Revision 1.12  2004/05/03 10:42:04  faber
/*  HB_StoreTimeSync called in MCMDTimeSync and
/*  HB_Store called _before_ dispatching inside MD_ifDispatch
/*
/*  Revision 1.11  2004/04/29 10:23:34  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.10  2004/04/29 07:12:44  faber
/*  HB_Store called before and not after, the Dispatching
/*
/*  Revision 1.9  2004/04/20 14:54:13  faber
/*  work before Brussel
/*
/*  Revision 1.8  2003/12/07 15:07:11  sebastiani
/*  GAS_TEST renamed to GAS_CONTAINER_PURGE
/*
/*  Revision 1.7  2003/12/05 17:14:34  alfarano
/*  update
/*
/*  Revision 1.6  2003/11/27 17:53:23  faber
/*  -Power management poweron procedure done and some tested in the simulator
/*  -history entry 5 now takes OBT
/*
/*  Revision 1.5  2003/11/18 09:01:15  alfarano
/*  laben patch fixes some problems
/*
/*  Revision 1.4  2003/11/10 14:16:56  faber
/*  MCMD in HB_Store (store all MCMD)
/*
/*  Revision 1.3  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.2  2003/10/17 09:15:26  sebastiani
/*  log every type of MCMD
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.11  2003/04/30 09:22:12  aurora
/*  execute REBOOT mcmd always
/*
/*  Revision 1.10  2003/04/29 14:50:59  aurora
/*  correct eligibility check of REBOOT mcmd
/*
/*  Revision 1.9  2003/01/30 10:14:57  aurora
/*  introduced ifdef for EM and FM
/*
/*  Revision 1.8  2002/06/11 13:19:18  zulia
/*  call Entry type 3 ( log DIRECT activity ) on direct MCMD
/*
/*  Revision 1.7  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/
 
/*============================= Include File ================================*/


#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _MD_MCMDDispatcher_int__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();

  
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_int.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/MCMDManager/TTManager/MT_TTManager_p.h>
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_p.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_p.h>
#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_p.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_p.h>
#include <src/INFN/PM_PamManager_INFN.h>

#ifdef INFN
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/MD_MCMDDispatcher_INFN_p.h>
#else
#include <src/TestUtility/Test/TS_Test_p.h>
#endif
/*============================== Local Variables ============================*/

/*****************************************************************************/

/*===== M C M D i s p a t c h e r   I N T E R N A L   F U N C T I O N S =====*/

/*****************************************************************************/
/* @Function: MD_ifDispatch                                                  */
/* @Purpose :                                                                */
/*  The function checks the MCMD execution elegibility therefore  dispatches */
/*  the MCDM to the object executor.                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  pMcmdExec            IN      Pointer to MCMD header                      */
/*                       OUT                                                 */
/* @@                                                                        */
/*****************************************************************************/

void MD_ifDispatch  (MA_HEADER_MCMD* pMcmdExec)
{
status_code     status;
MsgTsk          sndMsgMCMD;
unsigned int    dispatchMCMDflag;
unsigned int    dispatchINFNMCMDflag;
unsigned int    code;
unsigned int    timetagFlag;
unsigned short* pMcmdInfo;
status_code     (*pf)(MsgTsk* msg); 
unsigned int    code1;


    /* Default condition dispatch MCMD                               */
    dispatchMCMDflag     =TRUE;
    dispatchINFNMCMDflag =FALSE;
    pf   =NULL;
    /* Select the MCMD executor                                      */

    
    //HB_Store(HB_MCMD,pMcmdExec->Length*sizeof(UINT16),pMcmdExec->PtrMCMD,0);   
    HB_StoreMcmd(pMcmdExec);
    switch(pMcmdExec->Type)
    {
        case DOWN_LINK :    /* MCMD object executor : MMSUManager    */
            status =MC_piGetMcmdAbilityExec(DOWN_LINK);
            code   =FT_MCMD_DOWN_LINK;
            pf     =FT_piSndMsgMMSUManager;
	    /*@LOG Downlink macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case BITE :         /* MCMD object executor : MMSUManager    */
            status =MC_piGetMcmdAbilityExec(BITE);
            code   =FT_MCMD_BITE;
            pf     =FT_piSndMsgMMSUManager;
	    /*@LOG BITE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case RESET_HISTORY :
            status =MC_piGetMcmdAbilityExec(RESET_HISTORY);
            code   =HA_RESET;
            pf     =HA_piSndMsgHistoryArea;
	    /*@LOG RESET_HISTORY macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case PATCH :      /* MCMD object executor : PatchDumpManager */
            status = MC_piGetMcmdAbilityExec(PATCH);
            code   = PD_PATCH;
            pf     = PD_piSndMsgPatchDumpManager;
	    /*@LOG PATCH macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case DUMP :       /* MCMD object executor : PatchDumpManager */
            status = MC_piGetMcmdAbilityExec(DUMP);
            code   = PD_DUMP;
            pf     = PD_piSndMsgPatchDumpManager;
	    /*@LOG DUMP macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case REBOOT :
	  status = MC_piGetMcmdAbilityExec(REBOOT);
	  if (status == SUCCESSFUL)
            {
	      status = PRH_WriteEEPROMBootinfo(PRH_BOOTINFO_REBOOT);
	      if(status != CM_RC_SUCCESSFUL)
		/*@LOG REBOOT: Write EEPROM Boot info error - status  */
		LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	      PM_CPU_Reboot(TRUE);
	      /*@LOG REBOOT macrocommand */
	      LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
	    }
	  dispatchMCMDflag =FALSE;
            break;
        case DIRECT :
            status =MD_ifMcmdDirect(pMcmdExec);
            dispatchMCMDflag =FALSE;
	    /*@LOG DIRECT macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case DEL_MCMD_QUEUE :/* MCMD object executor : TTManager     */
            status =MC_piGetMcmdAbilityExec(DEL_MCMD_QUEUE);
            code   =MT_DEL_MCMD_QUEUE;
            pf     =MT_piSndMsgTTManager;
	    /*@LOG DEL_MCMD_QUEUE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case EXE_MEM_CONF : /* MCMD object executor : MMSUManager    */
            status =MC_piGetMcmdAbilityExec(EXE_MEM_CONF);
            code   =FT_MCMD_EXE_MEM_CONF;
            pf     =FT_piSndMsgMMSUManager;
	    /*@LOG EXE_MEM_CONF macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case ABORT :
            status =MC_piGetMcmdAbilityExec(ABORT);
            code   =FT_ABORT;
            pf     =FT_piSndMsgMMSUManager;
	    /*@LOG ABORT macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case TIME_SYNCHRONISE :
            status = MC_piGetMcmdAbilityExec(TIME_SYNCHRONISE);
            if (status == SUCCESSFUL)
            {
              status =MD_ifMcmdTimeSynchronised(pMcmdExec);
            }
            dispatchMCMDflag =FALSE;
	    /*@LOG TIME_SYNCHRONISE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case TEST :         /* MCMD object executor : MMSUManager    */
            status =MC_piGetMcmdAbilityExec(TEST);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG TEST macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case PURGE_TRD :
            status =MC_piGetMcmdAbilityExec(PURGE_TRD);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG PURGE TRD macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case GAS_CONTAINER_PURGE :
            status =MC_piGetMcmdAbilityExec(GAS_CONTAINER_PURGE);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG CONTAINER_PURGE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case CALIBRATE :
            status =MC_piGetMcmdAbilityExec(CALIBRATE);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG CALIBRATE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;

#ifndef INFN
        case SELECT_MODE :
            status =MC_piGetMcmdAbilityExec(SELECT_MODE);
            code   =TS_GO_SELECT_MODE;
            pf     =TS_piSndMsgTest;
	    /*@LOG SELECT MODE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
#endif

#ifdef INFN
        case SELECT_MODE :
            status =MC_piGetMcmdAbilityExec(SELECT_MODE);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG SELECT MODE macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
#endif

        case NEUTRON_DETECTOR :
            status =MC_piGetMcmdAbilityExec(NEUTRON_DETECTOR);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG NEUTRON_DETECTOR macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case ORBITAL_INFORMATION :
            status =MC_piGetMcmdAbilityExec(ORBITAL_INFORMATION);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG ORBITAL_INFORMATION macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        case INCLINATION_INFORMATION :
            status =MC_piGetMcmdAbilityExec(INCLINATION_INFORMATION);
            dispatchINFNMCMDflag =TRUE;
	    /*@LOG INCLINATION_INFORMATION macrocommand */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
            break;
        default :
            /* MCMD not identified                                   */
            status =HA_E10_MCMD_ERR;
	    /*@LOG mcmd not identified  */
	    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,pMcmdExec->Type);
        break;    
    }
    
    /* Check pointer to MCMD area                                    */
    if (!pMcmdExec->PtrMCMD)
    {
      status =HA_E10_MCMD_ERR;
    }
    
    /* Check if MCMD must be dispatched, his eligibility is OK, and  */
    /* is not INFN MCMD                                              */
    if (status==SUCCESSFUL && dispatchMCMDflag && !dispatchINFNMCMDflag)
    {
        /*==================== MCMD dispatched ======================*/
        /* MCMD eligibility found                                    */
        /* Send message to the object executor                       */                    
        sndMsgMCMD.Code   =code;
        *(MA_HEADER_MCMD* )sndMsgMCMD.Info =*pMcmdExec;     
        sndMsgMCMD.LlInfo =sizeof(MA_HEADER_MCMD); 
        status =(*pf)(&sndMsgMCMD);
        if (status != SUCCESSFUL)
        {

            /*=============== Log in History Area ===================*/
            /*@LOG  Mailbox full MCMD not dispatched (Internal error)  LOG_INFN HA_piLogHistoryEntry2 (pMcmdExec->Type,HA_E2_INTERNAL_ERR); */
	    LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,HA_E2_INTERNAL_ERR);
        }else{

	}
    }
    else if (status!=SUCCESSFUL)  
    {
        /*================== MCMD not dispatched ====================*/
        /* MCMD eligibility not found or Internal Error              */
        /*=================== Log in History Area ===================*/
        if (status==HA_E10_MCMD_ERR)
        {
            /*                                       */
            /*@LOG MCMD not defined LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MD,status,HA_E10_REP2_NULL); */
	    LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,HA_E10_REP2_NULL);
	    
            /* Set Internal error                                    */
            status =HA_E2_INTERNAL_ERR;
        }
        else if (status==HA_E10_SEMAPHORE_ERR)
        {
            /* Error during eligibility test                         */
            status =HA_E2_INTERNAL_ERR;
        }
            
        /*@LOG LOG_INFN HA_piLogHistoryEntry2 (pMcmdExec->Type,status);*/
	LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
    else 
    {
      /*=========== MCMD not dispatched  or INFN MCMD =============*/

      if(dispatchINFNMCMDflag)
      {
        /*========================INFN MCMD =========================*/
        /*===========================================================*/
        /*************************************************************/
        /*============================= INFN Interface ==============*/
        // INFN must put here the call to its provided operation in order to
        // make its own copy of the MCMD. When this funcion returns the MCMD is
        // cosidered copied elsewhere and deleted from the MCMD partition.

#ifdef INFN
        MD_piSubmitMCMD_INFN(pMcmdExec);
#endif

      }
    }
    
    if ((status!=SUCCESSFUL && pMcmdExec->PtrMCMD))
    {
        /* MCMD not dispatched                                       */
        /* delete MCMD from partition                                */
        pMcmdInfo   =(unsigned short* )pMcmdExec->PtrMCMD;
        timetagFlag =(*(pMcmdInfo+1)&TIMETAG_MASK) ? TIMETAG_MCMD:IMMEDIATE_MCMD;
        MA_piDelBufferMCMD(pMcmdExec->PtrMCMD,timetagFlag);
    }   
}



/*****************************************************************************/
/* @Function: MD_ifMcmdDirect                                                */
/* @Purpose :                                                                */
/*  The function manages the MCMD DIRECT execution.                          */
/*  It checks first the MCMD execution elegibility, than extracts the        */
/*  Telecommand parameter Id from the MCMD buffer, and executes the          */
/*  Telecommand by calling the specific provided interface of                */
/*  the ExternalEquipmentController object.                                  */
/*  A log is sent to the History area objet to notify the execution of the   */
/*  DIRECT MCMD.                                                             */
/*  The MCMD buffer is released from the MCMDs partition.                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrMcmd              IN      Pointer to MCMD header                      */
/*  status_code          OUT     Return code (always SUCCESSFUL)             */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_ifMcmdDirect(MA_HEADER_MCMD*    PtrMcmd)
{
status_code  status;
unsigned int paramId;
unsigned int value;
unsigned int timetagFlag;

     /* Check MCMD eligibility                                      */
    status =MC_piGetMcmdAbilityExec(DIRECT);

    if (status == SUCCESSFUL)
    {
        /* Get parameter code                                       */
        paramId  =(unsigned int)*(((unsigned short*)PtrMcmd->PtrMCMD)+OFFSET_HEADER);
        paramId &=TM_PARAM_ID_MASK;
        value    =(unsigned int)*(((unsigned short*)PtrMcmd->PtrMCMD)+OFFSET_HEADER+1);
        timetagFlag =( *(((unsigned short*)PtrMcmd->PtrMCMD)+1)&TIMETAG_MASK ) ?
                     TIMETAG_MCMD : IMMEDIATE_MCMD;
        /* Delete MCMD from partition                                 */
        MA_piDelBufferMCMD(PtrMcmd->PtrMCMD,timetagFlag);
        
        status =TM_piSendTC(paramId,value);
        if (status != SUCCESSFUL)
        {
            status =HA_E2_TELECOMMAND_NOT_FOUND;
        }
    }

    // LOG_INFN HA_piLogHistoryEntry2 (PtrMcmd->Type,status);  
    // LOG_INFN HA_piLogHistoryEntry3 (paramId, value);      
    
    /*@LOG MCMD Direct: paramID */
    LU_INFN_LOG(LU_WARNING,LU_MASK(__FILEID__),__FILEID__,__LINE__,paramId);
    /*@LOG MCMD Direct: value */
    LU_INFN_LOG(LU_WARNING,LU_MASK(__FILEID__),__FILEID__,__LINE__,value);   
    /*@LOG MCMD Direct: status */
    LU_INFN_LOG(LU_WARNING,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);   


    /* The function returns always SUCCESSFUL because the error has */
    /* been already managed                                         */
    return (SUCCESSFUL);
}



/*****************************************************************************/
/* @Function: MD_ifMcmdTimeSynchronised                                      */
/* @Purpose :                                                                */
/*  The function manages the MCMD TIME_SYNCHRONISE execution.                */
/*  The OBT is updated by using the MCMD parameter.
/*  A log is sent to the History area objet to notify the execution of the   */
/*  DIRECT MCMD.                                                             */
/*  The MCMD buffer is released from the MCMDs partition.                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrMcmd              IN      Pointer to MCMD header                      */
/*  status_code          OUT     Return code (always SUCCESSFUL)             */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_ifMcmdTimeSynchronised(MA_HEADER_MCMD*    PtrMcmd)
{
status_code  status;
unsigned int paramId;
unsigned int timetagFlag;

     /* Check MCMD eligibility                                      */
    status =MC_piGetMcmdAbilityExec(TIME_SYNCHRONISE);

    if (status == SUCCESSFUL)
    {
        /* Get parameter code                                       */
        paramId   =(unsigned int)*(((unsigned short*)PtrMcmd->PtrMCMD)+OFFSET_HEADER);
        paramId <<=16;
        paramId  |=(unsigned int)*(((unsigned short*)PtrMcmd->PtrMCMD)+OFFSET_HEADER+1);
        timetagFlag =( *(((unsigned short*)PtrMcmd->PtrMCMD)+1)&TIMETAG_MASK ) ?
                     TIMETAG_MCMD : IMMEDIATE_MCMD;

        TI_piUpdateTimeInfo_s((TI_TIME)paramId);
	// status=HB_StoreTimeSync((TI_TIME)paramId);
    }
    /* Delete MCMD from partition                                 */
    MA_piDelBufferMCMD(PtrMcmd->PtrMCMD,timetagFlag);

    /*@LOG Time Syncrhonisec LOG_INFN HA_piLogHistoryEntry2 (PtrMcmd->Type,status); */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    /* The function returns always SUCCESSFUL because the error has */
    /* been already managed                                         */
    return (SUCCESSFUL);
}
