/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : HKManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: RG_ReportGenerator_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: RG_ReportGenerator_op.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.5  2005/02/21 08:58:28  sebastiani
/*  all log comments completed
/*
/*  Revision 1.4  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.3  2004/05/10 12:59:17  faber
/*  __FILEID__ right value fixed: many .c files had the wrong value!
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/

#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_op.h>
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_int.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>
#include <src/FileManager/FileSystem/FS_FileSystem_p.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _RG_ReportGenerator_op__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>

LU_DECL_MASK();

/*============================== Local Variables ============================*/


/*****************************************************************************/
/* @Variable: RG_TlmArea                                                     */
/* @Purpose :                                                                */
/*   RG_TLM_DATA_AREA  structure                                             */
/*   Telemetry area (4096 words).                                            */
/* @@                                                                        */
/*****************************************************************************/
static RG_TLM_DATA_AREA  RG_TlmArea; 

/*****************************************************************************/
/* @Variable: RG_TlmRTFCounter                                               */
/* @Purpose :                                                                */
/*   UWORD   type                                                            */
/*   Real Time format counter.                                               */
/* @@                                                                        */
/*****************************************************************************/
static UWORD  RG_TlmRTFCounter;

/*****************************************************************************/
/* @Variable: RG_BootResult                                                  */
/* @Purpose :                                                                */
/*   UDWORD   type                                                           */
/*   Boot result code.                                                       */
/* @@                                                                        */
/*****************************************************************************/
static UDWORD  RG_BootResultCode;

/*****************************************************************************/

/* R e p o r t G e n e r e t o r   O P E R A T I O N A L   F U N C T I O N S */

/*****************************************************************************/
/* @Function: RG_opInitReportGenerator                                       */
/* @Purpose :                                                                */
/* This function initiates the object setting the task into the READY state  */
/* and its priority to the appropriate value. It also resets all variables.  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opInitReportGenerator (void)
{
  status_code   status = SUCCESSFUL;
  UINT  OldPriority;

    /* Task initialization                           */
    if (OS_piTaskReady(RG_TASK,RG_tkReportGenerator) != SUCCESSFUL)
    {
        /* Task is not correctly started             */
        /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_RG,HA_E10_TSK_READY_ERR,status);    */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    } 
    if (OS_piTaskPriority(RG_TASK, REPORTGEN_PRIORITY,&OldPriority) != SUCCESSFUL)
    {
        /* Task priority is not correctly updated    */
        /*@LOG LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_RG,HA_E10_TSK_PRIORITY_ERR,status);    */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    }    

    /* Reset telemetry area                          */
    RG_ifReset(&RG_TlmArea, &RG_TlmRTFCounter); 
    
    RG_TlmRTFCounter  =0;
    RG_BootResultCode =0;
    
    return (status);
}


/*****************************************************************************/
/* @Function: RG_opSndMsg                                                    */
/* @Purpose :                                                                */
/*  This function sends a message to the Report Generator task.              */
/*  The operations code and the parameters type of the ReportGenerator       */
/*  task are the following:                                                  */
/*                                                                           */
/*     Code operation         Type of Parameter                              */
/*     RG_RESET               Enumerated                                     */
/*     RG_PREPARE_FRM_RTR     Enumerated                                     */
/*     RG_PREPARE_FRM_RT      Enumerated                                     */
/*     RG_PREPARE_FRM_RTE     Enumerated                                     */
/*     RG_PREPARE_FRM_IDF     Enumerated                                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_opSndMsg(MsgTsk* SndMsg)
{
    return ( OS_piMsgQueueSend(RG_MAILBOX, (void*)SndMsg, sizeof(MsgTsk)) );
}


/*****************************************************************************/
/* @Function: RG_tkReportGenerator                                           */
/* @Purpose :                                                                */
/*  The operations code and the parameters type of the ReportGenerator       */
/*  task are the following:                                                  */
/*                                                                           */
/*     Code operation         Parameters                                     */
/*     RG_RESET               Enumerated                                     */
/*     RG_PREPARE_FRM_RTR     Enumerated                                     */
/*     RG_PREPARE_FRM_RT      Enumerated                                     */
/*     RG_PREPARE_FRM_RTE     Enumerated                                     */
/*     RG_PREPARE_FRM_IDF     Enumerated                                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

task RG_tkReportGenerator(task_argument unused)
{
  MsgTsk      RxMsg;
  status_code status;
  UINT        MsgSize;


    while ( FOREVER ) 
    {
        // Check mailbox queue
        RxMsg.Code = NULL_MSG_RG;
        if( (status = OS_piMsgQueueReceive (RG_MAILBOX,(void*)&RxMsg,
             &MsgSize, WAIT, NO_TIMEOUT)) == SUCCESSFUL )
        {
            switch (RxMsg.Code)
            {
                case RG_RESET:
                    RG_ifReset(&RG_TlmArea, &RG_TlmRTFCounter);
                    break;

                case RG_PREPARE_FRM_RT:
                    RG_TlmRTFCounter++;
                    RG_ifPrepareHeader((UWORD*)&RG_TlmArea, RG_FORMAT_RT);
                    RG_ifPrepareRTBody((UWORD*)&RG_TlmArea,RG_BootResultCode);
		    BI_pi1553BWriteRTFrm((UWORD*)&RG_TlmArea,RG_LENGTH_RT);
                    break;
                
                case RG_BOOT_RESULT :
                    RG_BootResultCode =*((UDWORD*)RxMsg.Info);
                    break;
                default:
                     break;
            }
        }
    }
}



/*****************************************************************************/
/* @Function: RG_opGetTLMRTFCounter                                          */
/* @Purpose :                                                                */
/*  This function gets the number of acquired real time format               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* cnt                  OUT     number of acquired real time formats         */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opGetTLMRTFCounter(UWORD* cnt)
{
    *cnt = RG_TlmRTFCounter;
    return (SUCCESSFUL);
}


/*****************************************************************************/
/* @Function: RG_opIncTLMRTFCounter                                          */
/* @Purpose :                                                                */
/*  This function increments the counter of acquired real time format        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opIncTLMRTFCounter( void )
{
    
    RG_TlmRTFCounter++;
    return (SUCCESSFUL);
}

/*****************************************************************************/
/* @Function:   RG_opGetSubStatusWord                                        */
/* @Purpose :                                                                */
/* This function gets the subsystem status word                              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* ssw                  OUT     subsystem status word                        */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opGetSubStatusWord( unsigned int* StatusWord )
{
UWORD ssw;
    
    RG_ifGetSubStatusWord(&ssw,RG_BootResultCode);
    *StatusWord =ssw;
    return (SUCCESSFUL);
}


/*****************************************************************************/
/* @Function:  RG_opGetTlmBuffer                                             */
/* @Purpose :                                                                */
/*  This function gets the telemetry array memory address                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmbuffer            OUT     pointer of the address of telemetry array    */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opGetTlmBuffer(unsigned short int** tlmbuffer)
{
   
   *tlmbuffer = &(RG_TlmArea.RG_TlmDataArea[0]);
    return (SUCCESSFUL);
}

/*****************************************************************************/
/* @Function: RG_opPrepareHeader                                             */
/* @Purpose :                                                                */
/*  This function prepares the header for telemetry formats                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmf                 OUT     Destination buffer for address of the        */
/* tlmf_type            IN      type of telemetry are the following:         */
/*                              RG_FORMAT_RT                                 */
/*                              RG_FORMAT_HA                                 */
/*                              RG_FORMAT_DUMP                               */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_opPrepareHeader( UWORD* tlmf, UWORD tlmf_type )
{
   
   RG_ifPrepareHeader( tlmf, tlmf_type );
    return (SUCCESSFUL);
}
