/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: CH_CommandHandler_INFN.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
 *  $Revision: 1.1.1.1 $
 *  $Date: 2006/04/25 09:00:20 $
 *  $RCSfile: CH_CommandHandler_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: CH_CommandHandler_INFN.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.2  2004/05/12 08:10:11  faber
 *  *** empty log message ***
 *
 *  Revision 1.1  2003/09/23 09:41:29  faber
 *  CH_CommandHandler and autogeneration gen_params.pl introduced
 *  some dummy file in src/INFN/commands/
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.1  2003/06/23 15:40:10  sebastiani
 *  Trakcer added: First Compilation of tracker
 *
 *                                                                           
 *****************************************************************************/


/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _CH_CommandHandler_INFN__c

#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>

#include <src/INFN/CH_CommandHandler_INFN_auto.h>
#include <src/INFN/CH_CommandHandler_INFN.h>
#include <src/INFN/CM_Common_INFN.h>

LU_DECL_MASK();



/*============================ Global define ================================*/


/*============================== global types  ==============================*/



/*****************************************************************************/
/*=========================== Structure define ==============================*/


/*****************************************************************************/
/*============================ Enumerate define =============================*/

/*****************************************************************************/

/*=== Common   I N T E R N A L   ==*/

/*****************************************************************************/

void CH_Init() {

}

status_code CH_GetBuf(CH_COMMANDS bufid,DAQ_CMD_BUF **buf) {
  status_code s;
  if(bufid > CH_NULL && bufid < CH_MAX) {
    *buf = CH_auto_GetBuf(bufid);
    s = CM_RC_SUCCESSFUL;
  }else
    s = CM_RC_INVALID_ID;
  return s;
}


status_code CH_GetLen(CH_COMMANDS bufid,unsigned int *len) {
  status_code s;
  DAQ_CMD_BUF *b;
  if(bufid > CH_NULL && bufid < CH_MAX) {
    b = CH_auto_GetBuf(bufid);
    *len = b->len;
    s = CM_RC_SUCCESSFUL;
  }else
    s = CM_RC_INVALID_ID;
  return s;
}


status_code CH_SetAtoEto(CH_COMMANDS queue,BYTE ato,BYTE eto)
{
  DAQ_CMD_BUF *com;
  status_code s;
  s = CH_GetBuf(queue,&com);
  if(s == CM_RC_SUCCESSFUL) {
    com->ato = ato;
    com->eto = eto;
  }
  return s;
}
