/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  TM_TCManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: TM_TMTCManager_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: TM_TMTCManager_op.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.28  2005/03/20 18:30:50  sebastiani
/*  unuseful warning cancelled
/*
/*  Revision 1.27  2004/11/19 15:14:59  sebastiani
/*  PRH_EXTERN_{VAR,ARR,TABLE} removed and put them on the autogenerated parameter heeader file
/*
/*  Revision 1.26  2004/11/18 17:52:51  sebastiani
/*  added CAL_WRITE_FPGA_REG_I341_x
/*  and some CAL command modified by Boezio
/*
/*  Revision 1.25  2004/11/18 16:02:46  sebastiani
/*  GAS/TRD removed
/*
/*  Revision 1.24  2004/08/05 16:19:47  sebastiani
/*
/*  fix fefa !? sleep 1 ms after mltc
/*
/*  Revision 1.23  2004/08/04 13:26:01  sebastiani
/*  try again! ancora fefa
/*
/*  Revision 1.22  2004/08/02 12:24:27  sebastiani
/*  fix tmtc
/*
/*  Revision 1.21  2004/06/15 08:25:05  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.20  2004/04/26 11:30:20  sebastiani
/*  fix bug!!!!!!!!!
/*
/*  Revision 1.19  2004/03/10 16:21:40  faber
/*  more powered bugfixing about new implementation of TMTC task. In the simulator looks now to be stable.
/*
/*  Revision 1.18  2004/03/10 14:27:28  alfarano
/*  update
/*
/*  Revision 1.17  2004/03/09 19:09:34  faber
/*  SIMULATOR mode: return SUCCESSFUL and do nothing in the cyclic acq
/*
/*  Revision 1.16  2004/03/09 15:10:29  faber
/*  HK_DoCyclicAcquisition takes a void *all_values_ptr param
/*  removed check cycle in the TMTC Module
/*
/*  Revision 1.15  2004/03/08 15:49:09  alfarano
/*  improved handling functions for FE
/*
/*  Revision 1.14  2004/03/01 17:46:50  tassa
/*  Non testato:
/*  TMTC sample e STORE in SCM
/*  send FECMD bloccante
/*  aggiunto MCMD to send FECMD
/*
/*  Revision 1.13  2004/01/29 11:53:13  alfarano
/*  semaphores in gettmvalue
/*
/*  Revision 1.12  2003/12/06 10:53:41  alfarano
/*  update
/*
/*  Revision 1.11  2003/12/05 17:14:34  alfarano
/*  update
/*
/*  Revision 1.10  2003/12/05 13:15:39  sebastiani
/*  TMTC writing in the RTF
/*
/*  Revision 1.9  2003/12/03 17:50:09  alfarano
/*  update
/*
/*  Revision 1.8  2003/12/03 14:52:09  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.7  2003/12/03 13:46:39  alfarano
/*  update
/*
/*  Revision 1.6  2003/11/10 12:17:46  sebastiani
/*  log info introduced
/*
/*  Revision 1.5  2003/11/04 11:36:35  alfarano
/*  deleted task in TM_TMTC manager and added to HK_Manager, added KHB buffer read task
/*
/*  Revision 1.4  2003/10/31 17:21:29  sebastiani
/*  bug fix on read and write function in TM_TMTCManager: added busy flag control on each read & write
/*  CRC functions updated in the SRAMPageManager
/*
/*  Revision 1.3  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.2  2003/09/16 11:18:05  carota
/*  functions protected by senaphore / KHB func added
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.15  2003/05/21 10:31:47  aurora
/*  fixed the buffer for SD2 cyclic acq
/*
/*  Revision 1.14  2003/02/14 13:22:53  aurora
/*  fixed SD addresses
/*
/*  Revision 1.13  2003/01/30 10:18:32  aurora
/*  introduced ifdef for EM and FM
/*
/*  Revision 1.12  2003/01/22 13:42:52  aurora
/*  Correct the DBL output
/*
/*  Revision 1.11  2003/01/17 09:00:20  aurora
/*  correct reading of Status register
/*
/*  Revision 1.10  2003/01/16 17:08:43  aurora
/*  Correct the table TM_TMtable
/*  disable the cyclic acquisition before ONE SHOT reading
/*
/*  Revision 1.9  2002/10/25 09:02:55  zulia
/*  added the pi for send a sequence of 1-16 ML
/*
/*  Revision 1.8  2002/09/11 15:37:14  zulia
/*  correct TM_TMTCtable for DBL and last 8 CC_acq
/*
/*  Revision 1.7  2002/05/28 13:58:58  aurora
/*  * Fixed single and continuos read from TMTC
/*
/*  Revision 1.6  2002/05/09 08:16:35  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _TM_TMTCManager_op__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/CM_Common_INFN.h>
LU_DECL_MASK();

#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_op.h>

/*****************************************************************************/
/*============================= Object variables ============================*/

/*****************************************************************************/
/* @Constant: TM_TMTCtable                                                   */
/* @Purpose :                                                                */
/*  Array of TM_TM_TC types.                                                 */
/*  High level Commands & VHP Commands information. Memory Load, Bi-Level    */
/*  Output TCs.                                                              */
/* @@                                                                        */
/*****************************************************************************/
const TM_TC TM_TCtable []=
                            {                             
  {TM_HL_CMD_1    ,TM_HPC  ,0xEC00 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_2    ,TM_HPC  ,0x6C01 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_3    ,TM_HPC  ,0x6C02 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_4    ,TM_HPC  ,0xEC03 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_5    ,TM_HPC  ,0x6C04 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_6    ,TM_HPC  ,0xEC05 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_7    ,TM_HPC  ,0xEC06 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_8    ,TM_HPC  ,0x6C07 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_9    ,TM_HPC  ,0x6C08 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_10   ,TM_HPC  ,0xEC09 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_11   ,TM_HPC  ,0xEC0A ,0x0341 ,0x0d00},    
  {TM_HL_CMD_12   ,TM_HPC  ,0x6C0B ,0x0341 ,0x0d00},    
  {TM_HL_CMD_13   ,TM_HPC  ,0xEC0C ,0x0341 ,0x0d00},    
  {TM_HL_CMD_14   ,TM_HPC  ,0x6C0D ,0x0341 ,0x0d00},    
  {TM_HL_CMD_15   ,TM_HPC  ,0x6C0E ,0x0341 ,0x0d00},    
  {TM_HL_CMD_16   ,TM_HPC  ,0xEC0F ,0x0341 ,0x0d00},    
  {TM_HL_CMD_17   ,TM_HPC  ,0x6C10 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_18   ,TM_HPC  ,0xEC11 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_19   ,TM_HPC  ,0xEC12 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_20   ,TM_HPC  ,0x6C13 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_21   ,TM_HPC  ,0xEC14 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_22   ,TM_HPC  ,0x6C15 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_23   ,TM_HPC  ,0x6C16 ,0x0341 ,0x0d00},    
  {TM_HL_CMD_24   ,TM_HPC  ,0xEC17 ,0x0341 ,0x0d00},
      
  {TM_ML_16_CMD_1 ,TM_MLO  ,0x3800 ,0x01C0 ,0x0700},    
  {TM_ML_16_CMD_2 ,TM_MLO  ,0xB801 ,0x01C0 ,0x0700},    
  {TM_DBL_CMD     ,TM_BLO  ,0x0000 ,0x0000 ,0x0000}};


/*****************************************************************************/
/* @Constant: TM_TMTCtable                                                   */
/* @Purpose :                                                                */
/*  Array of TM_TM_TC types.                                                 */
/*  Analog TM,Thermistores Analog TM,CC TM, BL TM & DBL TM information,      */
/* @@                                                                        */
/*****************************************************************************/
// const 
TM_TM TM_TMtable []=
                            {
{TM_DEA_ANA_1      ,TM_ANA ,0x1000 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1200},
{TM_DEA_ANA_2      ,TM_ANA ,0x9001 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1204},
{TM_DEA_ANA_3      ,TM_ANA ,0x9002 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1208},
{TM_DEA_ANA_4      ,TM_ANA ,0x1003 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x120C},
{TM_DEA_ANA_5      ,TM_ANA ,0x9004 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1210},
{TM_DEA_ANA_6      ,TM_ANA ,0x1005 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1214},
{TM_DEA_ANA_7      ,TM_ANA ,0x1006 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1218},
{TM_DEA_ANA_8      ,TM_ANA ,0x9007 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x121C},
{TM_DEA_ANA_9      ,TM_ANA, 0x9008 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1220},
{TM_DEA_ANA_10     ,TM_ANA ,0x1009 ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1224},
{TM_DEA_ANA_11     ,TM_ANA ,0x100A ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1228},
{TM_DEA_ANA_12     ,TM_ANA ,0x900B ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x122C},
{TM_DEA_ANA_13     ,TM_ANA ,0x100C ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1230},
{TM_DEA_ANA_14     ,TM_ANA ,0x900D ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1234},
{TM_DEA_ANA_15     ,TM_ANA ,0x900E ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x1238},
{TM_DEA_ANA_16     ,TM_ANA ,0x100F ,0x00A1 ,0x0000 ,0x0000 ,0x0280 ,0x1280 ,0x123C},
 
{TM_TH_ANA_1       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb000 ,0x0A80 ,0x1A80 ,0x1A00},
{TM_TH_ANA_2       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x3001 ,0x0A80 ,0x1A80 ,0x1A04},
{TM_TH_ANA_3       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x3002 ,0x0A80 ,0x1A80 ,0x1A08},
{TM_TH_ANA_4       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb003 ,0x0A80 ,0x1A80 ,0x1A0C},
{TM_TH_ANA_5       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x3004 ,0x0A80 ,0x1A80 ,0x1A10},
{TM_TH_ANA_6       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb005 ,0x0A80 ,0x1A80 ,0x1A14},
{TM_TH_ANA_7       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb006 ,0x0A80 ,0x1A80 ,0x1A18},
{TM_TH_ANA_8       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x3007 ,0x0A80 ,0x1A80 ,0x1A1C},
{TM_TH_ANA_9       ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x3008 ,0x0A80 ,0x1A80 ,0x1A20},
{TM_TH_ANA_10      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb009 ,0x0A80 ,0x1A80 ,0x1A24},
{TM_TH_ANA_11      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb00a ,0x0A80 ,0x1A80 ,0x1A28},
{TM_TH_ANA_12      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x300b ,0x0A80 ,0x1A80 ,0x1A2C},
{TM_TH_ANA_13      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb00c ,0x0A80 ,0x1A80 ,0x1A30},
{TM_TH_ANA_14      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x300d ,0x0A80 ,0x1A80 ,0x1A34},
{TM_TH_ANA_15      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0x300e ,0x0A80 ,0x1A80 ,0x1A38},
{TM_TH_ANA_16      ,TM_TEM ,0x5020 ,0x02A1 ,0x0000 ,0xb00f ,0x0A80 ,0x1A80 ,0x1A3C},
 
{TM_BIL_DIAG_ACQ_1 ,TM_BIL ,0x0800 ,0x0061 ,0x8000 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_2 ,TM_BIL ,0x0800 ,0x0061 ,0x4000 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_3 ,TM_BIL ,0x0800 ,0x0061 ,0x2000 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_4 ,TM_BIL ,0x0800 ,0x0061 ,0x1000 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_5 ,TM_BIL ,0x0800 ,0x0061 ,0x0800 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_6 ,TM_BIL ,0x0800 ,0x0061 ,0x0400 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_7 ,TM_BIL ,0x0800 ,0x0061 ,0x0200 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_BIL_DIAG_ACQ_8 ,TM_BIL ,0x0800 ,0x0061 ,0x0100 ,0x0000 ,0x0180 ,0x1180 ,0x1100},

{TM_CC_DIAG_ACQ_1  ,TM_BIL ,0x0800 ,0x0061 ,0x0080 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_2  ,TM_BIL ,0x0800 ,0x0061 ,0x0040 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_3  ,TM_BIL ,0x0800 ,0x0061 ,0x0020 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_4  ,TM_BIL ,0x0800 ,0x0061 ,0x0010 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_5  ,TM_BIL ,0x0800 ,0x0061 ,0x0008 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_6  ,TM_BIL ,0x0800 ,0x0061 ,0x0004 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_7  ,TM_BIL ,0x0800 ,0x0061 ,0x0002 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
{TM_CC_DIAG_ACQ_8  ,TM_BIL ,0x0800 ,0x0061 ,0x0001 ,0x0000 ,0x0180 ,0x1180 ,0x1100},
 
{TM_CC_DIAG_ACQ_9  ,TM_BIL ,0x8810 ,0x0061 ,0x8000 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_10 ,TM_BIL ,0x8810 ,0x0061 ,0x4000 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_11 ,TM_BIL ,0x8810 ,0x0061 ,0x2000 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_12 ,TM_BIL ,0x8810 ,0x0061 ,0x1000 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_13 ,TM_BIL ,0x8810 ,0x0061 ,0x0800 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_14 ,TM_BIL ,0x8810 ,0x0061 ,0x0400 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_15 ,TM_BIL ,0x8810 ,0x0061 ,0x0200 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_16 ,TM_BIL ,0x8810 ,0x0061 ,0x0100 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_17 ,TM_BIL ,0x8810 ,0x0061 ,0x0080 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_18 ,TM_BIL ,0x8810 ,0x0061 ,0x0040 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_19 ,TM_BIL ,0x8810 ,0x0061 ,0x0020 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_20 ,TM_BIL ,0x8810 ,0x0061 ,0x0010 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_21 ,TM_BIL ,0x8810 ,0x0061 ,0x0008 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_22 ,TM_BIL ,0x8810 ,0x0061 ,0x0004 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_23 ,TM_BIL ,0x8810 ,0x0061 ,0x0002 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
{TM_CC_DIAG_ACQ_24 ,TM_BIL ,0x8810 ,0x0061 ,0x0001 ,0x0000 ,0x0184 ,0x1184 ,0x1104},
 
{TM_CC_DIAG_ACQ_25 ,TM_BIL ,0x8820 ,0x0061 ,0x8000 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_26 ,TM_BIL ,0x8820 ,0x0061 ,0x4000 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_27 ,TM_BIL ,0x8820 ,0x0061 ,0x2000 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_28 ,TM_BIL ,0x8820 ,0x0061 ,0x1000 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_29 ,TM_BIL ,0x8820 ,0x0061 ,0x0800 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_30 ,TM_BIL ,0x8820 ,0x0061 ,0x0400 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_31 ,TM_BIL ,0x8820 ,0x0061 ,0x0200 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
{TM_CC_DIAG_ACQ_32 ,TM_BIL ,0x8820 ,0x0061 ,0x0100 ,0x0000 ,0x0188 ,0x1188 ,0x1108},
 
{TM_DBL_ACQ_3      ,TM_BIL ,0x0830 ,0x0061 ,0x2000 ,0x0000 ,0x018c ,0x118c ,0x110C},
{TM_DBL_ACQ_4      ,TM_BIL ,0x0830 ,0x0061 ,0x1000 ,0x0000 ,0x018c ,0x118c ,0x110C},
{TM_DBL_ACQ_7      ,TM_BIL ,0x0830 ,0x0061 ,0x0200 ,0x0000 ,0x018c ,0x118c ,0x110C},
{TM_DBL_ACQ_8      ,TM_BIL ,0x0830 ,0x0061 ,0x0100 ,0x0000 ,0x018c ,0x118c ,0x110C},
 
{TM_DS_16_ACQ_1    ,TM_SDG ,0xA040 ,0x0101 ,0x0000 ,0x0000 ,0x0400 ,0x1400 ,0x1400},
{TM_DS_16_ACQ_2    ,TM_SDG ,0x2041 ,0x0121 ,0x0000 ,0x0000 ,0x0480 ,0x1480 ,0x1404}
                           };


/*****************************************************************************/
/* @Constant: TM_TMTCReg                                                     */
/* @Purpose :                                                                */
/*  Array of unsigned short pointerEG type.                                  */
/*  TM TC registers address.                                                 */
/* @@                                                                        */
/*****************************************************************************/
const unsigned short* TM_TMTCReg[] =
                            {
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2000),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2004),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2008),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x200c),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2010),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2014),
                            (unsigned short*)(BASE_TM_TC_ADDR + 0x2018)
                            };

/*****************************************************************************/
/* @Variable: TM_AllTMValue                                                  */
/* @Purpose :                                                                */
/*  TM_ALL_TM_PARAM  structure.                                              */
/*  All Telemetry parameters measure.                                        */
/* @@                                                                        */
/*****************************************************************************/
TM_ALL_TM_PARAM TM_AllTMValue;

/*****************************************************************************/
/* @Variable: TM_AutoAcqCounter                                              */
/* @Purpose :                                                                */
/* @@                                                                        */
/*****************************************************************************/

/*****************************************************************************/


void tmtc_patch(){
  unsigned int i;
  for (i=TM_CC_DIAG_ACQ_9;i<=TM_CC_DIAG_ACQ_32;i++)
    {
      TM_TMtable[i].WrCurrent=0x180;
      TM_TMtable[i].RdCurrent=0x1180;
    }
}
/*       P a y l o a d s   O P E R A T I O N A L  F U N C T I O N S          */

/*****************************************************************************/
/* @Function: TM_opInitTMTCManager                                           */
/* @Purpose :                                                                */
/*  Initialialization function of the TMTC component.                        */
/*  The TMTC CONFSTATREG register is initialized as follows:                 */
/*  CONFSTATREG configures                                                   */
/* AVF disabled, High Pwr CMD enabled CyclicTM enabled                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_opInitTMTCManager (void)
{
status_code     status;
void*           p;
unsigned short* pR;
unsigned int    OldPriority;
    
#ifndef SIMULATOR
    /* Program CONFSTATREG register                          */
    /* AVF disabled, High Pwr CMD enabled, Cyclic TM enabled */
    p   =(void* )TM_TMTCReg[TM_TC_CONF_STAT_REG];
    pR  =(unsigned short* )p;
    *pR =(unsigned short)TM_TC_CONF_STAT_REG_INIT_VALUE;

    /* Start Cyclic TM acquisition                           */
    p   =(void* )TM_TMTCReg[TM_TC_COMM_REG];
    pR  =(unsigned short* )p;
    *pR =START_AUTOMATIC_TM_SEQ;

    tmtc_patch();
    return (SUCCESSFUL);
#else
    return SUCCESSFUL;
#endif // SIMULATOR
}


/*****************************************************************************/
/* @Function: TM_opGetTMValue                                                */
/* @Purpose :                                                                */
/*  The function returns a telemetry value read from the current or cyclic   */
/*  Transmit Memory page. The - RdMode - parameter specifies the type of     */
/*  the reading measure (TM_CURRENT_VAL, TM_CYCLIC_VAL).  The TM parameter   */
/*  informations are find out from TM parameters table by taking as index    */
/*  the LSByte of the code.                                                  */
/*  For reading the current measured value are performed the following steps:*/
/*      - If TM parameter is a thermistor is programmed the specific Bilevel *
/*        OUT to power up the device. The format word is written into        */
/*        Receiving Memory page, and command word (strobe) is written into   */
/*        Command Word register.                                             */
/*      - Programmming of the specific TM parameter format word into         */
/*        Receiving Memory page, and command word (strobe) into Command Word */
/*        register.                                                          */
/*      - Waiting for the measure end. The measure is ended when the bit 15  */
/*        of the Config Status register from one returns to zero.            */
/*      - Reading value into Trasmitting Memory page of the current measured */
/*        value. If TM parameter is a Bilevel type, the value is read by     */
/*        using the specific bit mask information ( the 16 bit word hold     */
/*        the 16 Bilevel parameter value measured).                          */
/*  For reading the cyclic measured value are performed the following steps: */
/*      - Reading value into Trasmitting Memory page of the cyclic measured  */
/*        values. If TM parameter is a Bilevel type, the value is read by    */
/*        using the specific bit mask information ( the 16 bit word hold     */
/*        the 16 Bilevel parameter value measured).                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   Code                IN      Telecommand code                            */
/*   RdMode              IN      Reading mode (TM_CURRENT_VAL,TM_CYCLIC_VAL) */
/*   status_code         OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_opGetTMValue(unsigned int  Code, unsigned int RdMode,
                             unsigned int* Value)
{
  status_code status = CM_RC_SUCCESSFUL;
#ifndef SIMULATOR
  unsigned int    index;
  unsigned int    waitRd;
  unsigned int    value;
  unsigned int    error;
  void*           p;
  unsigned short* pCR;
  unsigned short* pSR;
  unsigned short* pB;
  
  
  /* Take the LSByte value as index                          */
  index   =(Code & 0x00ff);
  /* Check TM parameter index validity                       */
  if (index<TM_MAX_TELEMETRY)
    {
      status =SUCCESSFUL;
      /* Get Command register pointer                        */
      p    =(void* )TM_TMTCReg[TM_TC_COMM_REG];
      pCR  =(unsigned short* )p;
      
      /* Get Status register pointer                         */
      p    =(void* )TM_TMTCReg[TM_TC_CONF_STAT_REG];
      pSR  =(unsigned short* )p;
      
      /* Check if current or cyclic value must be read       */
      if (RdMode==TM_CURRENT_VAL)
        {
	  /* if the cyclic is ongoing then wait for 10ms     
	     it is not possible to do one-shot acq. 
	     and cyl acq together                         */
	  /*BEGIN INFN*/
	  //   if ((*pSR) & TM_CYCLIC_BUSY_MASK)
          //      OS_piTaskSuspend (10);	   	    
	  while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK| TM_SEQUENCERUN_BUSY_MASK ) ) 
	    OS_piTaskSuspend (1);
	  /*END INFN*/

	  /*========= Reading of a current TM value =========*/
	  /* Check if TM paramter is a thermistor            */
	  if (TM_TMtable[index].Type == TM_TEM)
            {
	      /* Program Bilevel OUT to power up and         */
	      /* select the thermistor                       */
	      /* Program format word (Receive page)          */
	      pB  =THERMISTOR_BILEVEL_OUT_MEM;
	      *pB =TM_TMtable[index].ThrSel;
	      /* Program command word (FPGA Strobe)          */
	      pB  =THERMISTOR_BILEVEL_OUT_CMD;
	      *pB =THERMISTOR_BILEVEL_OUT_CMD_VALUE;
	      /* Wait after TH selection at least 136 us     */
	      for(waitRd=0; waitRd<TM_WAIT_136_4_uS; waitRd++) ;
            }
	  /* Get Memory area pointer (Receive page)          */
	  pB      =(unsigned short*)(BASE_TM_TC_ADDR + TM_TMtable[index].WrCurrent);
	  /* Program format word                             */
	  *pB     =TM_TMtable[index].Format;
	  /* Program command word (FPGA Strobe)              */
	  *pCR    =TM_TMtable[index].Command;
	  /* Wait at least 136 us before reading the measure */
	  for(waitRd=0; waitRd<TM_WAIT_136_4_uS; waitRd++) ;
	  while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK| TM_SEQUENCERUN_BUSY_MASK ) ) 
	    OS_piTaskSuspend (1);	  
	  /* Get Memory area pointer (Transmit page)         */
	  pB      =(unsigned short*)(BASE_TM_TC_ADDR + TM_TMtable[index].RdCurrent);            
	  value =*pB;
	  /* Check not cyclic telemetry error                */
	  error =*pSR & TM_NOCYCLIC_ERROR_MASK;
	  error =0;
        }
      else /* TM_CYCLIC_VAL */
        {
	  /*========== Reading of a cyclic TM value =========*/
	  /* Get Memory area pointer (Transmit page)         */
	  pB    =(unsigned short*)(BASE_TM_TC_ADDR + TM_TMtable[index].RdCycle);            
	  value =*pB;
	  /* Check  cyclic telemetry error                   */
	  error =*pSR & TM_CYCLIC_ERROR_MASK;
        }

      if (!error)
        {
	  switch (TM_TMtable[index].Type)
            {
	    case TM_BIL: 
	      /* Get bit value of the TM Bilevel param.  */
	      *Value =(value & TM_TMtable[index].BilMask) ? TRUE : FALSE;
	      break;
	    case TM_ANA:
	      /* Get value of the TM Analogic param.     */
	      if (value < TM_MIN_ANA_VALUE)
		{
		  value =TM_MIN_ANA_VALUE;
		}
	      *Value =((value-TM_MIN_ANA_VALUE)>>3);
	      break;
	    case TM_TEM:
	      /* Get value of the TM Thermistor param.   */
	      *Value =value;
	      break;
	    case TM_SDG:
	      *Value =value;
	      break;
	    default:
	      /* Get Serial Digit param.                  */
	      *Value =value;
	      break;
            }
        }    	
      else
        {
	  status =UNSATISFIED;
	  *Value =0;
        }
    }
  else
    {
      /* Invalid telemetry code                             */
      status =UNSATISFIED;
    }


#endif
  return (status);

}


/*****************************************************************************/
/* @Function: TM_opGetKHBValue                                               */
/* @Purpose :                                                                */
/*  The function gets nWords 16 bit words from the serialID TMTC serial line */
/*  and writes them in the buffer pointet by pBuffer. The sequence of reads  */
/*  from the selected serial line cannot be interrupted by the automatic acq.*/
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   serialID            IN      serial line identifier                      */
/*   pBuffer             IN      pointer to the buffer                       */
/*   nWords              IN      # of words to read from the serial line     */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_opGetKHBValue (unsigned int serialID, unsigned short * pBuffer,  unsigned char nWords)
{
  status_code      status = SUCCESSFUL;
  unsigned int     word;
  int              i;
  
  for (i = 0; i < nWords; i++)
    {
      status = TM_opGetTMValue(serialID, TM_CURRENT_VAL, &word);
      if (status)
	break;
      *pBuffer++ = (unsigned short) word;
    }
  
  return status;
}

/*****************************************************************************/
/* @Function: TM_opGetAllTMValue                                             */
/* @Purpose :                                                                */
/*  The function returns all telemetry values read from the cyclic           */
/*  acquisition.                                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   AllTmValue          IN      Telemetry parameters structure.             */
/*   status_code         OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code  TM_opGetAllTMValue (UINT32 * AllTmValue)
 {
   status_code  status = SUCCESSFUL;

   if (!TM_AllTMValue.MeasureValidity)
     memcpy (AllTmValue, TM_AllTMValue.Param, TM_MAX_TELEMETRY * sizeof(unsigned int));
   else
     status = TM_TMTC_PARITY_ERR;
   
   return status;
 }



/*****************************************************************************/
/* @Function: TM_opSendTC                                                    */
/* @Purpose :                                                                */
/*  The function sends a telecommand.                                        */
/*  The LSByte of the 16 bit word is the index of the telecommand prameter   */
/*  into Telecommands table. With the information read from the Telecommands */
/*  table are performed the following programmings:                          */
/*      -  Writing of the TMTC word format in the receiving RAM.             */
/*      -  Writing of the command word in the Command word register (strobe  */
/*         to the FPGA device).                                              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Code                 IN      Telecommand code                            */
/*  Value                IN      Value                                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_opSendTC (unsigned int  Code, unsigned int Value)
{
  status_code status = CM_RC_SUCCESSFUL;
#ifndef SIMULATOR
  
  unsigned int    index;
  void*           p;
  unsigned short* pR;
  unsigned short* pB;
  unsigned short* pSR;
  unsigned int    wait;
    

  //we are no sure but ...
  /* Check TC parameter code validity                      */
  if (Code>TM_NULL_TC && Code<TM_MAX_TELECOMMAND)
    {
      status  =SUCCESSFUL;
      /* Take the LSByte value as index                    */
      index =((Code & 0x00ff)-1);
      
      /*BEGIN INFN*/
      /* Get Status register pointer                         */
      p    =(void* )TM_TMTCReg[TM_TC_CONF_STAT_REG];
      pSR  =(unsigned short* )p;
      /* if the NO cyclic is ongoing then wait for 10ms     
	 it is not possible to do one-shot acq. 
	 and cyl acq together                         */
      while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
	OS_piTaskSuspend (1);
      /*END INFN*/	  
      
      if (TM_TCtable[index].Type == TM_BLO)
	{            
	  /*=============== Bi-Level Output ===============*/	     
	  TM_opWritePointReg(TM_PONITREG_VAL);
	  TM_opWriteLoadDumpReg((unsigned short)Value);
	  /* ReWrite the sequence to correct FPGA bug      */
	  TM_opWritePointReg(TM_PONITREG_VAL);
	  TM_opWriteLoadDumpReg((unsigned short)Value);
	  TM_opWritePointReg(0x0000);
	}                     
      else                     
	{      
	  /*=====  High Power Command or Memory Load  =====*/
	  /* Get Memory area pointer                       */
	  pB    =(unsigned short*)(BASE_TM_TC_ADDR + TM_TCtable[index].WrCurrent);
	     
	  /* Get Command register pointer                  */
	  p   =(void* )TM_TMTCReg[TM_TC_COMM_REG];
	  pR  =(unsigned short* )p;	    	     	     
	     
	  /* Program format word                           */
	  *pB = TM_TCtable[index].Format;
	  /* Program format word into next memory location     */
	  /* to correct FPGA pointer bug                       */
	  *(pB+2) = TM_TCtable[index].Format;
	  *(pB+4) = TM_TCtable[index].Format;
	     
	  if (TM_TCtable[index].Type == TM_MLO)
	    {
	      *(pB+2) =(unsigned short)Value;
	      /* Program command word (Strobe to the FPGA device) */
	      *pR =TM_TCtable[index].Command + 2;
	    }
	  else
	    {
	      /* Program command word (Strobe to the FPGA device) */
	      *pR =TM_TCtable[index].Command;
	    }
	}
      /* Wait I don't know why at least 136 us */
      for(wait=0; wait<TM_WAIT_136_4_uS; wait++) ;
      while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
	OS_piTaskSuspend (1);
    }    
  else
    {
      /* Invalid telecommand code                          */
      status =UNSATISFIED;
    }
#endif // ndef SIMULATOR
 return (status);
}

/*****************************************************************************/
/* @Function: TM_opSendMLTC                                                  */
/* @Purpose :                                                                */
/*  The function sends a MemoryLoad telecommand.                             */
/*  The LSByte of the 16 bit word is the index of the telecommand prameter   */
/*  into Telecommands table. With the information read from the Telecommands */
/*  table are performed the following programmings:                          */
/*      -  Writing of the TMTC word format in the receiving RAM.             */
/*      -  Writing of the command word in the Command word register (strobe  */
/*         to the FPGA device).                                              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Sequence             IN      pointer to a sequence of memory Load        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_opSendMLTC (TM_TC_ML*     Sequence, 
                           unsigned int  Length)
{
  status_code status = CM_RC_SUCCESSFUL;
#ifndef SIMULATOR
  unsigned int    index;
  unsigned int    i,k;
  void*           p;
  unsigned int*   pR;
  unsigned int*   pB;
  unsigned int    offset;
  unsigned short* pSR;


  status  =SUCCESSFUL;
  if ((Length <= TM_MAX_MEMORYLOAD_LENGTH_SEQUENCE) && (Length > 0))	
    {
      for (i=0; i<Length; i++)
	{  
	  /* Check TC parameter code validity                      */
	  if (!(((*(Sequence+i)).Code == TM_ML_16_CMD_1) || ((*(Sequence+i)).Code == TM_ML_16_CMD_2)))
	    {
	      /* Invalid telecommand code                          */
	      status=UNSATISFIED;
	    }
	}    
    }
  else
    {
      /* Invalid telecommand length                          */
      status =UNSATISFIED;
    }
 
  if (status == SUCCESSFUL)
    {
          
      /* Get Command register pointer                  */                         
      p   =(void* )TM_TMTCReg[TM_TC_COMM_REG];                                    
      pR  = p;                                                   
     
     
      /*BEGIN INFN*/
      /* Get Status register pointer                         */
      p    =(void* )TM_TMTCReg[TM_TC_CONF_STAT_REG];
      pSR  =(unsigned short* )p;
      /* if the NO cyclic is ongoing then wait for 10ms     
	 it is not possible to do one-shot acq. 
	 and cyl acq together                         */
      while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
	OS_piTaskSuspend (1);
      /*END INFN*/	
     
      for (i=0, k=0; k<Length; i+=2,k++)
	{
	  /* Take the LSByte value as index                    */
	  index =(((*(Sequence+k)).Code & 0x00ff)-1);
	  /*=====  Memory Load  =====*/                                               
	  /* Get Memory area pointer                       */                         
	  pB = (unsigned int*)(BASE_TM_TC_ADDR + TM_TCtable[index].WrCurrent);    
	 
	  /* Program format word                           */                         
	  *(pB+i) = TM_TCtable[index].Format;                                             
	  *(pB+i+1) = (unsigned short)((*(Sequence+k)).Value & 0xFFFF);                                                          
	}
      /* number of command to going out; with 0 write 16 cmds */
      offset = (Length==TM_MAX_MEMORYLOAD_LENGTH_SEQUENCE) ? 0: Length<<1;
      /* Program command word (Strobe to the FPGA device) */
      *pR =TM_TCtable[index].Command + offset;
      while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
	OS_piTaskSuspend (1);
      {
	static int tmtc_bug_time=1;      
	OS_piTaskSuspend (tmtc_bug_time);
      }
    }
#endif
  return (status);
}

/*****************************************************************************/
/* @Function: TM_opWriteLoadDumpReg                                          */
/* @Purpose :                                                                */
/*  The function write on Load and Dump register                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Value                IN      Value to write in register                  */
/* @@                                                                        */
/*****************************************************************************/

void TM_opWriteLoadDumpReg (unsigned short Value)
{
#ifndef SIMULATOR
  void*           p;
  unsigned short* pB;
  
  p   =(void* )TM_TMTCReg[TM_TC_LOAD_DUMP];
  pB  =(unsigned short* )p;
  *pB = Value;
#endif
}


/*****************************************************************************/
/* @Function: TM_opWritePointReg                                             */
/* @Purpose :                                                                */
/*  The function write on Point register                                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Value                IN      Value to write in register                  */
/* @@                                                                        */
/*****************************************************************************/

void TM_opWritePointReg (unsigned short Value)
{
#ifndef SIMULATOR
  void*           p;
  unsigned short* pR;
  
  p   =(void* )TM_TMTCReg[TM_TC_POINTREG];
  pR  =(unsigned short* )p;
  *pR = Value;
#endif
}

status_code TM_DoCyclicAcq()
{
#ifndef SIMULATOR
  status_code      status;
  unsigned int     MsgSize;
  unsigned int     value;
  unsigned int     error;
  unsigned int     i;
  void           *p;
  unsigned short *pCR,*pSR,*pR;

  p     = (void *) TM_TMTCReg [TM_TC_COMM_REG];	       // Get Command register pointer
  pCR   = (unsigned short *) p;
  
  p     = (void *) TM_TMTCReg [TM_TC_CONF_STAT_REG];   // Get Status register pointer
  pSR   = (unsigned short *) p;
  
  /*Check for KHB_ReadBuffer ongoing*/
  // wait until the end of the automatic telemetry sequence
      
  while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
    OS_piTaskSuspend (1);
  
  *pCR  = START_AUTOMATIC_TM_SEQ;		       // Executes automatic telemetry seq. 0 (one shot)
  
  OS_piTaskSuspend (10);
  while ( (*pSR) & ( TM_NOCYCLIC_BUSY_MASK | TM_CYCLIC_BUSY_MASK | TM_SEQUENCERUN_BUSY_MASK) ) 
    OS_piTaskSuspend (1);
  
  // CYC_ERR bit is set to 1, when a parity error occurs (is reset by reading CONFSTATREG register)
	  
  error = *pSR & TM_CYCLIC_ERROR_MASK;
      
  for (i = 0; i < TM_MAX_TELEMETRY; i++)
    {
      pR    = (unsigned short *) (BASE_TM_TC_ADDR + TM_TMtable[i].RdCycle);     // Get Memory area pointer (Receive page)
      value = (!error) ?  *pR : 0;
	      
      switch (TM_TMtable[i].Type)
	{
	case TM_BIL : // Get bit value of the TM Bilevel param. 
		  
	  TM_AllTMValue.Param[i] = (value & TM_TMtable[i].BilMask) ? TRUE : FALSE;
	  break;
		  
	case TM_ANA : // Get value of the TM Analogic param.
	  if (value < TM_MIN_ANA_VALUE)
	    value = TM_MIN_ANA_VALUE;
		  
	  TM_AllTMValue.Param[i] = ((value - TM_MIN_ANA_VALUE) >> 3);
	  break;
		  
	case TM_TEM : // Get value of the TM Thermistor param.
	  TM_AllTMValue.Param[i] = value;
	  break;
		  
	case TM_SDG : // Get Serial Digit param.
	  TM_AllTMValue.Param[i] = value;
	  break;
		  
	default : 
	  TM_AllTMValue.Param[i] = value;
	  break;
	}
    } // for
      
  TM_AllTMValue.MeasureValidity = error;
      
#endif // ifndef SIMULATOR
  return(CM_RC_SUCCESSFUL);
}

UINT32 TM_ConverTemp2ADC(int temp)
{
  // TBD
}


UINT32 TM_ConverPress2ADC(int press)
{

  // TBD
}

