/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MT_TTManager_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MT_TTManager_int.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.6  2005/02/21 08:58:29  sebastiani
/*  all log comments completed
/*
/*  Revision 1.5  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.4  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.3  2003/11/18 09:01:15  alfarano
/*  laben patch fixes some problems
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.5  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/MCMDManager/TTManager/MT_TTManager_int.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _OS_rtems_INFN_p__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();

/*============================== Local Variables ============================*/



/*****************************************************************************/

/*========= T T M a n a g e r   I N T E R N A L   F U N C T I O N S =========*/

/*****************************************************************************/
/* @Function: MT_ifCheckIfTimetagIsElapsed                                   */
/* @Purpose :                                                                */
/*  The function gets the MCMD timetag at top of list and checks if the time */
/*  is elapsed. The reference time is the -Obt- parameter (On Board Time).   */
/*  If the time is expired, a message to MCMDDispatcher object is send to    */
/*  put the MCMD in execution.                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Obt                  IN      On Board Time (OBT)                         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

void MT_ifCheckIfTimetagIsElapsed (TI_TIME Obt)
{
status_code     status;
MA_HEADER_MCMD  mcmd;
MsgTsk          sndMsg;
    
    MA_piGetMCMDtimetag (&mcmd,WAIT,NO_TIMEOUT);
    /* Check if timetag is elapsed          */
    if (mcmd.Type)
    {
        if (mcmd.TimeTag == Obt)
        {
            /* Send MCMD to MCMDDispatcher  */
            sndMsg.Code                    =MD_MCMD_EXEC;  
            *(MA_HEADER_MCMD* )sndMsg.Info =mcmd;
            sndMsg.LlInfo                  =sizeof(MA_HEADER_MCMD);
            status =MD_piSndMsgMCMDDispatcher(&sndMsg);
            if (status==SUCCESSFUL)
            {
                /* MCMD sent to MCMDDispatcher, delete it from the list  */
                status =MA_piDelMCMDtimetag(&mcmd,Obt,WAIT,NO_TIMEOUT);
                if (status==HA_E10_MCMD_ERR)
                {
                    /*@LOG MCMD indefined,not deleted from the TT MCMD queue LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MT,HA_E10_MCMD_ERR,HA_E10_REP2_NULL); */
		    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,HA_E10_REP2_NULL);
                }
            }
            else
            {
                /*@LOG MCMD not sent, MCMDDispatcher queue full  LOG_INFN HA_piLogHistoryEntry2 (mcmd.Type,HA_E2_INTERNAL_ERR); */
		LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,HA_E2_INTERNAL_ERR);
                MA_piDelBufferMCMD(mcmd.PtrMCMD,TIMETAG_MCMD);
            }
        }
    }

}



/*****************************************************************************/
/* @Function: MT_ifVerifyTimeTag                                             */
/* @Purpose :                                                                */
/*  The Function verifies if MCMD timetag is included in the defined time    */
/*  window  (OBT + 46.875 ms <= timetag <= OBT + Twin).                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrMcmd              IN      Pointer to MCMD header                      */
/*  Twin                 IN      MCMD timetag window                         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MT_ifVerifyTimeTag (MA_HEADER_MCMD* PtrMcmd, TI_TIME Twin)
{
status_code     status;
TI_TIME         time;    
TI_TIME         timeMin, timeMax;    
    
    /* Get OBT         */
#warning do we want OBT in s or in ms ? if ms, russian must be warned ?        
    TI_piGetTimeInfo_ms(&time); 
    /* calculates the timetag window                     */
    timeMin =time + MCMD_MIN_WIN;
    timeMax =time + Twin;
    /* The last seven bits of the Timetag must be zero   */
    PtrMcmd->TimeTag &=LAST_SEVEN_BIT_ZERO;
    
    /* Check Timetag window                              */
    status =HA_E1_TIMETAG_NOT_ALLOWED;
    if(time<timeMin && time>timeMax)
    {
        /* The timetag window is across the boundery     */
        if ((PtrMcmd->TimeTag>timeMin && PtrMcmd->TimeTag<=0xFFFFFFFF) ||
            (PtrMcmd->TimeTag>=0 && PtrMcmd->TimeTag<timeMax))
        {
            status =SUCCESSFUL;
        }
    }
    else
    {
        /* The timetag window is not across the boundery */
        if (PtrMcmd->TimeTag>timeMin && PtrMcmd->TimeTag<timeMax)
        {
            status =SUCCESSFUL;
        }
    }
    return (status);
}



/*****************************************************************************/
/* @Function: MT_ifStoreTimetagMcmd                                          */
/* @Purpose :                                                                */
/*  The Function inserts the MCMD into the MCMD timetag list by calling the  */
/*  MCMDArea provided interface. If during MCMD inserition another MCMD with */
/*  the same timetag is found, the MCMD is not stored into the list.  A log  */
/*  into the history area notifies the MCMD rejection for timetag already    */
/*  existing.                                                                */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrMcmd              IN      Pointer to MCMD header                      */
/* @@                                                                        */
/*****************************************************************************/

void MT_ifStoreTimetagMcmd (MA_HEADER_MCMD* PtrMcmd)
{
status_code     status;
TI_TIME         time;    
    
    /* Get OBT                                           */
#warning do we want OBT in s or in ms ? if ms, russian must be warned ?        
    TI_piGetTimeInfo_ms(&time);     
    /* Put the MCMD in a timetag list                    */
    status =MA_piPutMCMDtimetag(PtrMcmd,time,WAIT,NO_TIMEOUT);
    
    if (status != SUCCESSFUL)    
    {
        if (status != HA_E2_TIMETAG_ALREADY_EXIST && 
            status != HA_E2_MCMD_QUEUE_FULL)
        {
          status = HA_E2_INTERNAL_ERR;
        }
        /* Delete MCMD from partition                    */
        MA_piDelBufferMCMD(PtrMcmd->PtrMCMD,TIMETAG_MCMD);
        /*@LOG MCMD refused - LOG_INFN HA_piLogHistoryEntry2 (PtrMcmd->Type,status); */
	LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
}



/*****************************************************************************/
/* @Function: MT_ifDeleteMcmdQueue                                           */
/* @Purpose :                                                                */
/*  The function manages the MCMD (DEL_MCMD_QUEUE) execution.                */
/*  The MCMD information are extracted from the MCMD buffer partition that   */
/*  then is deleted.  The MCMD is executed by calling the MCMD area provided */
/*  interface  that allows, as specified from the delete strategy, to delete */
/*  one (specified by the parameter timetag) or all queued MCMD.             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PtrMcmd              IN      Pointer to MCMD header                      */
/*                       OUT                                                 */
/* @@                                                                        */
/*****************************************************************************/

void MT_ifDeleteMcmdQueue (MA_HEADER_MCMD* PtrMcmd)
{
status_code     status;
unsigned short* pMcmdInfo;
unsigned int    mcmdDelAllFalg;
unsigned int    timetag;
unsigned int    timetagFlag;

    /* Extract MCMD information                         */
    pMcmdInfo   =(unsigned short* )(PtrMcmd->PtrMCMD);
    timetagFlag =(*(pMcmdInfo+1)&TIMETAG_MASK) ? TIMETAG_MCMD : IMMEDIATE_MCMD;
    pMcmdInfo +=OFFSET_HEADER;
    /* Extract the first bit (Delete All MCMD flag)     */
    mcmdDelAllFalg =(unsigned int)(*pMcmdInfo & 0x01);
    /* Extract timetag parameter                        */
    pMcmdInfo++;
    timetag  =(*pMcmdInfo<<16) + (*(pMcmdInfo+1));
    /* Delete MCMD from partition                       */
    MA_piDelBufferMCMD(PtrMcmd->PtrMCMD,timetagFlag);

    /* Delete all or one timetag MCMDs                  */
    status =MA_piDelAllMCMDtimetag (mcmdDelAllFalg,timetag,WAIT,NO_TIMEOUT);
    if (status==HA_E10_PARTITION_ERR)
    {
        /* MCMDs not all deleted                        */
        status =HA_E2_INTERNAL_ERR;
    }
    else if (status==HA_E10_MCMD_ERR)
    {
        /* MCMD timetag not found                       */
        status =HA_E2_TIMETAG_ERR;
    }
    else if (status==HA_E10_SEMAPHORE_ERR)
    {
        /* Semaphore error, MCMDs not deleted           */
        status =HA_E2_INTERNAL_ERR;
    }
    
    /*============== Log into History Area =============*/
    /*@LOG DeleteMacrocommand Queue LOG_INFN HA_piLogHistoryEntry2 (PtrMcmd->Type,status); */
    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
}



