/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: TRG_Trigger_INFN.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
 *  $Revision: 1.1.1.1 $
 *  $Date: 2006/04/25 09:00:20 $
 *  $RCSfile: TRG_Trigger_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: TRG_Trigger_INFN.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.27  2005/03/06 14:54:46  sebastiani
 *  version running on 06 03 2005
 *
 *  Revision 1.26  2005/02/22 18:09:25  sebastiani
 *  various bugfixes
 *
 *  Revision 1.25  2005/01/10 14:02:13  faber
 *  TRG,AC_1,AC_2,TOF Error Handler reviewed
 *
 *  Revision 1.24  2004/11/19 15:41:50  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.23  2004/11/19 15:14:52  sebastiani
 *  PRH_EXTERN_{VAR,ARR,TABLE} removed and put them on the autogenerated parameter heeader file
 *
 *  Revision 1.22  2004/10/18 15:09:24  faber
 *  *** empty log message ***
 *
 *  Revision 1.21  2004/09/17 15:52:00  faber
 *  fix command queue Cmd2Fe/Fe2Daq right invocation for Test funcion inf TOF and TRG
 *
 *  Revision 1.20  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.19  2004/09/13 14:16:53  faber
 *  ErrorHandler for TOF/TRG + Test function TOF/TRG
 *
 *  Revision 1.18  2004/09/09 14:52:55  sebastiani
 *  using PreparePage to send cmd to idaq/FE
 *  added some test
 *  added trigger param
 *  added/tested Force Send KHB_to_FE
 *  added/tested Send Cmd to IDAQ/FE
 *
 *  Revision 1.17  2004/09/09 11:24:10  faber
 *  *** empty log message ***
 *
 *  Revision 1.16  2004/08/27 13:30:39  alfarano
 *  cvs header
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/

/*============================= Include File ================================*/


#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _TRG_Trigger_INFN__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();
#include <src/INFN/DAQ_IDAQ_INFN.h>
#include <src/INFN/CM_Common_INFN.h>
#include <src/INFN/CH_CommandHandler_INFN.h>
#include <src/INFN/TRG_Trigger_INFN.h>
#include <src/INFN/KHB_Driver_INFN.h>
#include <src/INFN/HK_Manager_INFN.h>
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/ALM_Alarm_INFN.h>
#include <src/INFN/MH_ModeHandler_INFN.h>

/*============================ Global define ================================*/


#define TRG_TB_SET_TRIGGER_CONF_BASE_ID CH_TB_SET_TRIGGER_CONF_01
#define TRG_TB_SET_BUSY_CONTROL_BASE_ID CH_TB_SET_BUSY_CONTROL_0


DAQ_DECLBUF(TRG_TempPif0,TRG_MAXTEMPBUFFER);


static DAQ_CMD_BUF TB_SET_ALARM_MASK;

static DAQ_CMD_BUF TB_SET_PMT_MASK;

static DAQ_CMD_BUF TB_SET_S4_CAL_MASK;
static DAQ_CMD_BUF TB_SET_BUSY_MASK_IDAQ_HOT;
static DAQ_CMD_BUF TB_SET_BUSY_MASK_IDAQ_COLD;

static int TB_STATUS;




status_code Init_ParamBuffers()
{
  DAQ_INIT_BUF_FROM_PARAMBUF(TB_SET_ALARM_MASK);
  DAQ_INIT_BUF_FROM_PARAMBUF(TB_SET_PMT_MASK);
  DAQ_INIT_BUF_FROM_PARAMBUF(TB_SET_S4_CAL_MASK);
  DAQ_INIT_BUF_FROM_PARAMBUF(TB_SET_BUSY_MASK_IDAQ_HOT);
  DAQ_INIT_BUF_FROM_PARAMBUF(TB_SET_BUSY_MASK_IDAQ_COLD);
}

status_code TRG_Init_ETOATO()
{
  int i;
  status_code status;
  CH_PARAMBUF_SET_ATO_ETO(TB_SET_ALARM_MASK,0,1);

  
  CH_SetAtoEto(CH_TB_READ_ALARM_MASK,1,2);
  CH_SetAtoEto(CH_TB_READ_ALARM,1,2);
  
  CH_PARAMBUF_SET_ATO_ETO(TB_SET_PMT_MASK,0,1);

  CH_SetAtoEto(CH_TB_READ_PMT_MASK,1,2);

  CH_PARAMBUF_SET_ATO_ETO(TB_SET_S4_CAL_MASK,0,1);

  CH_SetAtoEto(CH_TB_READ_S4_CAL_MASK,1,2);
  CH_PARAMBUF_SET_ATO_ETO(TB_SET_BUSY_MASK_IDAQ_HOT,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TB_SET_BUSY_MASK_IDAQ_COLD,0,1);

  CH_SetAtoEto(CH_TB_READ_BUSY_MASK,1,2);

  for (i=0; i < 31; i++)
    CH_SetAtoEto(TRG_TB_SET_TRIGGER_CONF_BASE_ID+i,0,1);
  
  CH_SetAtoEto(CH_TB_READ_TRIGGER_CONF,1,2);
  CH_SetAtoEto(CH_TB_READ_PATTERN_TRIGGER,1,2);
  CH_SetAtoEto(CH_TB_GIVE_ME_TRIGGER,0,1);
  CH_SetAtoEto(CH_TB_OPEN_CALIB_GATE,0,1);
  CH_SetAtoEto(CH_TB_CLOSE_CALIB_GATE,0,1);
  CH_SetAtoEto(CH_TB_READ_PATTERN_BUSY,1,2);
  
  for (i=0; i < 8; i++)
    CH_SetAtoEto(TRG_TB_SET_BUSY_CONTROL_BASE_ID+i,0,1);

  CH_SetAtoEto(CH_TB_START_ACQ,0,1);
  CH_SetAtoEto(CH_TB_STOP_ACQ,0,1);
  CH_SetAtoEto(CH_TB_READ_PMT_COUNT1,1,3);
  CH_SetAtoEto(CH_TB_READ_PMT_COUNT2,1,3);
  CH_SetAtoEto(CH_TB_READ_S4_CAL_COUNT,1,2);
  CH_SetAtoEto(CH_TB_READ_D_L_TIME,1,2);
  CH_SetAtoEto(CH_TB_READ_EVENT_COUNT,1,2);
  CH_SetAtoEto(CH_TB_READ_PMT_PLANE,1,2);
  CH_SetAtoEto(CH_TB_READ_TRIGGER_RATE,1,2);
  CH_SetAtoEto(CH_DUMMY_COMMAND,0,1);
}

status_code TRG_Init() 
{
  DAQ_BUFFER_INIT(TRG_TempPif0);
  Init_ParamBuffers();
  TRG_Init_ETOATO();

  return CM_RC_SUCCESSFUL;
}

status_code TRG_Initialization() 
{
  status_code status;
  DAQ_CMD_BUF* auto_buf;
  CM_HOT_COLD hc;
  DAQ_FE fe_tb = DAQ_SELECT_TRIG(PRH_VAR_TB_LINK);
  volatile static BOOL do_tb_set_pmt_mask=TRUE;

  TB_STATUS = 1;
#warning perche' e' commentato questo ?
  //  DAQ_ResetPIF(DAQ_DEFAULT_ETO_TICS,DAQ_DEFAULT_DTO_TICS,SM_DAQSETUP,HB_PKTTYPE_TRG_INIT);
  
  DAQ_Format_CMD_Empty(&TRG_TempPif0);
  
  DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_ALARM_MASK,fe_tb);

  CH_GetBuf(CH_DUMMY_COMMAND,&auto_buf );
  DAQ_Format_Cmd2Fe(&TRG_TempPif0,auto_buf,DAQ_FE_SPARE);

  if(do_tb_set_pmt_mask)
    DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_PMT_MASK,fe_tb);

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_S4_CAL_MASK,fe_tb);
  DAQ_Format_Cmd2Fe(&TRG_TempPif0,auto_buf,DAQ_FE_SPARE);

  status=HK_KHB_GetHotCold(&hc);
  LU_EXIT_IFERROR(status);

  if(hc == CM_HOT) {
    DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_BUSY_MASK_IDAQ_HOT,fe_tb);
  }else{
    DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_BUSY_MASK_IDAQ_COLD,fe_tb);
  }

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,auto_buf,DAQ_FE_SPARE);

  status = DAQ_StoreCmdQueue2PIF(SM_CALEXP0,&TRG_TempPif0);
  // if (status) loginternal
  LU_EXIT_IFERROR(status);

  status = DAQ_SendCmdQueue2CMDIF(SM_CALEXP0);
  LU_EXIT_IFERROR(status);

  TB_STATUS = 0;

  return status;
}

status_code TRG_Test()
{
  status_code status;
  CM_HOT_COLD hc;
  DAQ_CMD_BUF* auto_buf, *dummy_cmd;
  DAQ_FE fe_tb = DAQ_SELECT_TRIG(PRH_VAR_TB_LINK);
 
  CH_GetBuf(CH_DUMMY_COMMAND,&dummy_cmd);

  // HK_UpdateKHBMaskRegister(KHB_MASK_ALL,KHB_PRESET);
  DAQ_Format_CMD_Empty(&TRG_TempPif0);

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_ALARM_MASK,fe_tb);  

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,dummy_cmd,DAQ_FE_SPARE);

  CH_GetBuf(CH_TB_READ_ALARM_MASK,&auto_buf );
  DAQ_Format_Fe2Daq(&TRG_TempPif0,auto_buf,fe_tb);

  
  DAQ_Format_Fe2Daq(&TRG_TempPif0,&TB_SET_PMT_MASK,fe_tb);

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,dummy_cmd,DAQ_FE_SPARE);

  CH_GetBuf(CH_TB_READ_PMT_MASK,&auto_buf);
  DAQ_Format_Fe2Daq(&TRG_TempPif0,auto_buf,fe_tb);

  DAQ_Format_Fe2Daq(&TRG_TempPif0,&TB_SET_S4_CAL_MASK,fe_tb);

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,dummy_cmd,DAQ_FE_SPARE);

  CH_GetBuf(CH_TB_READ_S4_CAL_MASK,&auto_buf );
  DAQ_Format_Fe2Daq(&TRG_TempPif0,auto_buf,fe_tb);

  HK_KHB_GetHotCold(&hc);
  LU_EXIT_IFERROR(status);

  if(hc == CM_HOT) {
    DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_BUSY_MASK_IDAQ_HOT,fe_tb);
  }else{
    DAQ_Format_Cmd2Fe(&TRG_TempPif0,&TB_SET_BUSY_MASK_IDAQ_COLD,fe_tb);
  }

  DAQ_Format_Cmd2Fe(&TRG_TempPif0,dummy_cmd,DAQ_FE_SPARE);
  
  CH_GetBuf(CH_TB_READ_BUSY_MASK,&auto_buf );
  DAQ_Format_Fe2Daq(&TRG_TempPif0,auto_buf,fe_tb);
  
  DAQ_StoreCmdQueue2PIF(SM_CALEXP0,&TRG_TempPif0);	    
  status = DAQ_SendCmd2PIFWaitDAQReply(SM_CALEXP0,DAQ_STORE_MM,NULL,DAQ_NO_STORE_RAM);
  
  return status;
}

status_code TRG_StartTrigger()
{
}

status_code TRG_Error_Handler()
{
  status_code status = CM_RC_SUCCESSFUL;
  DAQ_CMD_BUF* auto_buf;
  DAQ_FE fe_tb = DAQ_SELECT_TRIG(PRH_VAR_TB_LINK);
  UINT16 khb_sr;

  DAQ_Format_CMD_Empty(&TRG_TempPif0);
  
  CH_GetBuf(CH_TB_READ_ALARM,&auto_buf);  
  DAQ_Format_Fe2Daq(&TRG_TempPif0,auto_buf,fe_tb);

  DAQ_StoreCmdQueue2PIF(SM_CALEXP3,&TRG_TempPif0);
  
  status = DAQ_SendCmd2PIFWaitDAQReply(SM_CALEXP3,DAQ_STORE_MM,&TRG_TempPif0,DAQ_STORE_RAM);
  if(status != CM_RC_SUCCESSFUL || TRG_TempPif0.len < SM_PKTHEADER_LEN+3) {
    status=CM_RC_DO_RESET_IF_ALM;
  }else{
    
    if( ((TRG_TempPif0.buf[SM_PKTHEADER_LEN]   & 0xFF) != 0) ||
	((TRG_TempPif0.buf[SM_PKTHEADER_LEN+1] & 0xFC) != 0)
	) {
      status=HK_ReadKHBStatusRegister(&khb_sr);
      if((khb_sr & (KHB_STS_ALARM_IDAQ | KHB_STS_ALARM_TRG)) 
	 || status!=CM_RC_SUCCESSFUL)
	return CM_RC_DO_POWER_OFF_ON;
      if( PRH_VAR_GOM_DURING_ALARM == MH_GOM_INITIALIZATION || 
	  PRH_VAR_GOM_DURING_ALARM == MH_GOM_ACQUISITION ) {
	return CM_RC_DO_RESET_IF_ALM;
      }
    }
  }
  
  return status;
}
