/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : FileManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: FT_MMSUManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: FT_MMSUManager_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.2  2004/06/30 07:26:24  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_op.h>

/*****************************************************************************/

/*====== M M S U M a n a g e r    P R O V I D E D    I N T E R F A C E ======*/

/*****************************************************************************/
/* @Function: FT_piInitMMSUManager                                           */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the MMSUManager object.                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piInitMMSUManager (void)
{
status_code status;

    status =FT_opInitMMSUManager();
    return (status);
}

/*****************************************************************************/
/* @Function: FT_piSndMsgMMSUManager                                         */
/* @Purpose :                                                                */
/*  Provided Interface to invoke a specific operation of the MMSUManager     */
/*  task. This is done by sending a message in the MMSUManager mailbox.      */
/*  The sent message has the following structure :                           */
/*  Structure -MsgTsk- :                                                     */
/*  Field -Code-    Code of the task operation                               */
/*  Field -Info-    Buffer that contains the task operation parameters       */
/*  Filed -LlInfo-  Parameters size.                                         */
/*  The operations code and the parameters type of the MMSUManager task are  */
/*  the following :                                                          */
/*                                                                           */
/*     Code operation           Parameters (Type assigned to -Info- field)   */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piSndMsgMMSUManager (MsgTsk* SndMsg)
{
status_code status;

    status =FT_opSndMsgMMSUManager(SndMsg);
    return (status);

}

status_code FT_piInitFileSystem() {
  MsgTsk SndMsg;
  SndMsg.Code = FT_INIT_FS;
  return FT_opSndMsgMMSUManager(&SndMsg);
}

/*****************************************************************************/
/* @Function: FT_piMemBoardMod                                               */
/* @Purpose :                                                                */
/*  Provided Interface to handle the Memory Module interrupt raised by the   */
/*  DRAMMA device due to an internal failure.                                */
/*  The -MemModule- parameter specify the MMSU and Memory Module where the  <*/
/*  failure is occured.                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Box                  IN      MMSU (MMSU_LOCAL,MMSU_REMOTE)               */
/*  MemModule            IN      Memory Module (FT_MEMORY_MODULE type)       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piMemBoardMod (unsigned int MemModule)
{
status_code status;

    status =FT_opMemBoardMod(MemModule);
    return (status);
}



/*****************************************************************************/
/* @Function: FT_piMemModuleON                                               */
/* @Purpose :                                                                */
/*  Provided Interface to switch ON a Memory Module.                         */
/*  The -MemModule- parameter specifies the Memory Module that must be       */
/*  switched ON.                                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  MemModule            IN      Memory Module (FT_MEMORY_MODULE type)       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piMemModuleON (unsigned int MemModule)
{
status_code status;

    status =FT_opMemModuleON (MemModule);
    return (status);
}



/*****************************************************************************/
/* @Function: FT_piMemModuleOFF                                              */
/* @Purpose :                                                                */
/*  Provided Interface to switch OFF a Memory Module.                        */
/*  The -MemModule- parameter specifies the Memory Module that must be       */
/*  switched OFF.                                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  MemModule            IN      Memory Module (FT_MEMORY_MODULE type)       */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piMemModuleOFF (unsigned int MemModule)
{
status_code status;

    status =FT_opMemModuleOFF (MemModule);
    return (status);
}

/*****************************************************************************/
/* @Function: FT_piSavePage                                                  */
/* @Purpose :                                                                */
/*  This function store the selected SRAM page into the memory module. If a  */
/*  previous storage is in progress than the store request is saved in the   */
/*  store request queue.                                                     */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PageId               IN      ID of the SRAM page to be saved             */
/*  PageInfo             IN      DAQ write result for the SRAM page          */
/*  FileId               IN      Destination file                            */
/*  FT_SAVE_RESULT       OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

FT_SAVE_RESULT FT_piSavePage(SM_PAGEID PageId, SD_DAQ_WRESULT PageInfo,
                             FS_FILEID FileId)
{
FT_SAVE_RESULT status;

  status = FT_opSavePage(PageId, PageInfo, FileId);
  return (status);
}

/*****************************************************************************/
/* @Function: FT_piGetCMDWErrorCounter                                       */
/* @Purpose :                                                                */
/*  This function returns the number of write errors towards the CMD I/F     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piGetCMDWErrorCounter(UINT32* Counter)
{
status_code status = SUCCESSFUL;

  FT_opGetCMDWErrorCounter(Counter);
  return (status);
}

/*****************************************************************************/
/* @Function: FT_piWriteEOT                                                  */
/* @Purpose :                                                                */
/*  This function is called by the WPBUS EOT interrupt and closes the store  */
/*  of a single SRAM page. If the save requests queue is not empty then the  */
/*  new SRAM page store is started                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void FT_piWriteEOT(void)
{
  FT_opWriteEOT();
}

/*****************************************************************************/
/* @Function: FT_piReadEOT                                                   */
/* @Purpose :                                                                */
/*  This function is called by the RPBUS EOT interrupt and signals the end   */
/*  of a single sector transfer to the TAM I/F. If the there are some more   */
/*  sector left than a new transfer is started.                              */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void FT_piReadEOT(void)
{
  FT_opReadEOT();
}

/*****************************************************************************/
/* @Function: FT_piMemModuleStat                                             */
/* @Purpose :                                                                */
/*  This function return a 16 bit word containing the status of the memory   */
/*  modules as described in RTF Data Area Layout                             */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     status of the operation                     */
/*  PtrModStat           OUT     modules status word                         */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piMemModuleStat(UINT16* PtrModStat)
{
status_code status = SUCCESSFUL;

    FT_opMemModuleStat(PtrModStat);
    return (status);
}

/*****************************************************************************/
/* @Function: FT_piChangeAcqMode                                             */
/* @Purpose :                                                                */
/*  This function is used to switch between the three possible acquisition   */
/*  modes.                                                                   */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FT_CHACQ_RESULT      OUT     Return code                                 */
/*  mode                 IN      Acquisition mode                            */
/* @@                                                                        */
/*****************************************************************************/

FT_CHACQ_RESULT FT_piChangeAcqMode(SM_ACQMODE mode)
{
FT_CHACQ_RESULT status;

  status = FT_opChangeAcqMode(mode);
  return (status);
}

/*****************************************************************************/
/* @Function: FT_piChangeOpMode                                              */
/* @Purpose :                                                                */
/*  The function performs all the operations necessary to switch the system  */
/*  operational status                                                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  FT_CHMODE_RESULT    OUT      Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

FT_CHMODE_RESULT FT_piChangeOpMode(MC_STATE state)
{
FT_CHMODE_RESULT status;

  status = FT_opChangeOpMode(state);
  return (status);
}

/*****************************************************************************/
/* @Function: FT_piModuleTest                                                */
/* @Purpose :                                                                */
/*  The function sends a message to the MMSUManager task in order to start   */
/*  the memory module test                                                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     status of the operation                     */
/* @@                                                                        */
/*****************************************************************************/

status_code FT_piModuleTest(void)
{
status_code status = SUCCESSFUL;

  FT_opModuleTest();
  return (status);
}
