
#define TEST_I
#define LOGANALIZER


#define  HA_EVENT_00    0
#define  HA_EVENT_01    1
#define  HA_EVENT_02    2
#define  HA_EVENT_03    3
#define  HA_EVENT_04    4
#define  HA_EVENT_05    5
#define  HA_EVENT_06    6
#define  HA_EVENT_07    7
#define  HA_EVENT_08    8
#define  HA_EVENT_09    9
#define  HA_EVENT_10    10
#define  HA_EVENT_11    11
#define  HA_EVENT_12    12
#define  HA_EVENT_13    13
#define  HA_EVENT_14    14
#define  HA_EVENT_15    15

typedef unsigned char       UBYTE;
typedef unsigned short int  UWORD;
typedef unsigned long  int  UDWORD;


//#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <sys/types.h>
#include <unistd.h>
//#include <src/INFN/loganalizer_auto.c>

#include <stdio.h>


unsigned short swap(unsigned short x) {
  unsigned char *p=(unsigned char*)&x;
  unsigned char h;
  h=*p;
  p++;
  return h << 8 | *p;
}

int ReadByte() {
  int b=getchar();
  // printf("\nReceived char: %d 0x%X '%c'",b,b,(unsigned char)b);
  return b;
}

#define UBYTE unsigned char
#define UWORD unsigned short int


int main(void) {
  int status=0;
  int b;
  int pid;
  int len;
  UBYTE          EntryType;
  static unsigned char  buf[1024],str[100],str2[100];
  unsigned int Report,Value;
  unsigned int   entry;
  unsigned char  code,stop;
  unsigned int   time,i;
  unsigned int   rep1,rep2,rep3,line,fileid;
  /* look for the magic sequence 0xFAFEDEFA, to start logging: */
  status=0;
  while(status != 4) {
    b=ReadByte();
    if(b == EOF)
      exit(120);
    switch(status) {
    case 0:
      if(b == 0xFA)
	status=1;
      break;
    case 1:
      if ( b== 0xFE)
	status=2;
      break;
    case 2:
      if (b==0xDE)
	status=3;
      break;
    case 3:
      if (b==0xFA)
	status=4;
      break;
    }
    //putc(b);
    putchar(b);
      // printf("\nReceived char: %d 0x%X '%c' NewStatus %d",b,b,(unsigned char)b,status);
  }
  /* start logging: */
  pid=getpid();
  stop = 0;
  printf("\n*************** Log Analizer Started as PID %d : ******************\n",pid);
  while((b=ReadByte()) != EOF && !stop) {
    len=b;
#ifdef VERBOSE
    printf("-> len: %d\n",len);
#endif
    for(i=0;i<len;i++)
      if((b=ReadByte()) != EOF)
	buf[i]=(unsigned char)b;
      else
	exit(1);
#ifdef VERBOSE
    for(i=0;i<len;i++) 
      printf(" - %2d: %5d 0x%4X\n",i,buf[i],buf[i]);  
    printf("\n\n");
#endif
    EntryType = buf[0] >> 4;
    
    entry  =EntryType;
    code   =buf[1];

    time   = *(UWORD*)(&buf[2]);
    time   = time << 16;
    time   |= *(UWORD*)(&buf[4]);

    rep1   =0;
    rep2   =0;
    rep3   =0;
    
    switch( EntryType ) {
    case HA_EVENT_04:      
      sprintf(str,"");
      break;
    case HA_EVENT_00:
      Report = swap( ((UWORD*)(buf))[3] );
      sprintf(str,"StateMode: %d 0x%X - ModeDetails : %d 0x%X",code,code,Report,Report);
      break;
    case HA_EVENT_02:
      Report = swap( ((UWORD*)(buf))[3] );
      sprintf(str,"mcmd Type: %d - Report: %d 0x%X",code,Report,Report,Value,Value);
      break;
    case HA_EVENT_03:
      Value = swap( ((UWORD*)(buf))[3] );
      sprintf(str,"CmdName: %d 0x%X - Value: %d 0x%X",code,code,Value,Value);
      break;
    case HA_EVENT_05:
      line  = swap( ((UWORD*)(buf))[3] );
      rep1  = swap( ((UWORD*)(buf))[4] );
      LU_GetSourceInfo(str2,code,line);
      sprintf(str,"INFN SW: FileID: %d Info1: %6d 0x%x [%s]",code,rep1,rep1,str2);
      break;
    case HA_EVENT_06:
      rep1 = swap( ((UWORD*)(buf))[3] );
      sprintf(str,"Info (Word 3): %10d 0x%x",rep1,rep1);
      break;
      
    case HA_EVENT_10:
      rep1 = swap ( ((UWORD*)(buf))[3] );
      rep2 = swap ( ((UWORD*)(buf))[4] );
      sprintf(str,"SwOrigin: %d 0x%X R1: %10d %x - R2: %10d 0x%x ",code,code,rep1,rep1,rep2,rep2);
      break;
      
    case HA_EVENT_11:
      rep1 = swap( ((UWORD*)(buf))[3] );
      rep2 = swap( ((UWORD*)(buf))[4] );
      rep3 = swap( ((UWORD*)(buf))[5] );
      sprintf(str,"HwOrigin: %d 0x%X - R1: %10d 0x%x - R2: %10d 0x%x - R3: %10d %x ",code,code,rep1,rep1,rep2,rep2,rep3,rep3);
      break;
    default:
      sprintf(str,"ENTRY TYPE NOT RECOGNIZED BY LOG-ANALIZER");
      stop=1;
      break;
    }
    
    printf("Type %2d - OBT: %5u - %s\n",entry,time,str);
    
  }
  return stop;
}
