/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: MISC_generator.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
 *  $Revision: 1.1.1.1 $
 *  $Date: 2006/04/25 09:00:20 $
 *  $RCSfile: MISC_generator.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: MISC_generator.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.4  2004/02/05 15:38:15  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.3  2004/02/05 11:39:29  sebastiani
 *  produce DUMMY command queue
 *
 *  Revision 1.2  2003/11/06 10:27:12  faber
 *  HB_HKBuffer now implemented as multibuffer (as specified in the
 *  mass memory format). Only compilation, not tested
 *
 *  Revision 1.1  2003/11/04 11:59:52  sebastiani
 *  MISC_generator.c added
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/


#include "cmdgenerator.h"




DECL_FUNC(MISC_RAM_READ_128K) {
  DAQ_Format_CMD_Empty(b);
  
  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  // write_buf(filename,b);
}

#define BASE 0
#define NPAGES 20
#define PAGSIZE (1024*12)

DECL_FUNC(MISC_RAM_WRITE_PAGE) {
  static int page=0;
  unsigned int i;
  DAQ_DECLBUF(data,PAGSIZE);
  DAQ_BUFFER_INIT(data);

  page++;
  EXEC(DAQ_Format_CMD_Empty(b),__LINE__);

  for(i=0;i<data.size;i++) {
    data.buf[i]=i & 0xff;
  }
  data.len=data.size;
  EXEC(DAQ_Format_Cmd2Ram_SetAddress(b,BASE+page*data.size),__LINE__);
  EXEC(DAQ_Format_Cmd2Ram_WriteData(b,&data),__LINE__);

  // write_buf(filename,b);
}

DECL_FUNC(MISC_RAM_READ_PAGE) {
  EXEC(DAQ_Format_CMD_Empty(b),__LINE__);
  EXEC(DAQ_Format_Cmd2Ram_SetAddress(b,BASE+NPAGES*PAGSIZE),__LINE__);
  EXEC(DAQ_Format_Cmd2Ram_EndBlock(b),__LINE__);
  EXEC(DAQ_Format_Cmd2Ram_SetAddress(b,BASE),__LINE__);
  EXEC(DAQ_Format_Cmd2Ram_ReadData(b),__LINE__);
  // write_buf(filename,b);
}


DECL_FUNC(MISC_SHORT_DUMMY_CMD) {
  DAQ_DECLBUF(dummy,3);
  DAQ_BUFFER_INIT(dummy);

  dummy.eto=0;
  dummy.ato=0;
  EXEC(DAQ_Format_CMD_Empty(b),__LINE__);
  EXEC(DAQ_Format_OneByteCmd(&dummy,0xFF),__LINE__);
  EXEC(DAQ_Format_Cmd2Fe(b,&dummy,DAQ_FE_DUMMY),__LINE__);
  write_buf(filename,b);
}

int main() {
  unsigned int i;
  DAQ_DECLBUF(idaqbuf,1024*128);
  char s[40];
  DAQ_BUFFER_INIT(idaqbuf);

  DAQ_Init();

  for(i=0;i<NPAGES;i++) {
    sprintf(s,"MISC_RAM_WRITE_PAGE%0d",i);
    MISC_RAM_WRITE_PAGE(s,&idaqbuf);
  }
  MISC_RAM_READ_PAGE("MISC_RAM_READ_PAGE",&idaqbuf);
  MISC_SHORT_DUMMY_CMD("MISC_SHORT_DUMMY_CMD",&idaqbuf);
  

  DAQ_Format_CMD_Empty(&idaqbuf);
  write_buf("last_run_tag",&idaqbuf);



  exit(0);
  return 0;
}

