/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/quicklook/OrbitalRate/inc/Exception.h,v $
 * $Id: Exception.h,v 1.1 2006/12/05 19:49:14 pam-rm2 Exp $
 * $Author: pam-rm2 $
 * 
 * Header file for the exceptions of Pamela.
 */
#ifndef EXCEPTION_H
#define EXCEPTION_H
#include <exception>
#include <stdio.h>

#define  UINT32 unsigned int
#define  UINT16 unsigned short
#define  UINT8  unsigned char

using namespace std;
namespace pamela {

  class Exception: public exception {
    
  private:
    
  protected:
    const char *message;
    char buff [100];
  public:
    Exception(const char *msg = "message"): message(msg){ }
    virtual ~Exception () throw(){ }
    virtual const char* print () const throw () { return message; }
  };

  class NotFoundEnvironmentVarException: public Exception {
  public:
    NotFoundEnvironmentVarException::NotFoundEnvironmentVarException(const char* msg):  Exception(msg) {}
    NotFoundEnvironmentVarException::~NotFoundEnvironmentVarException () throw(){ }
  };

  class UnidentifiedPacketException: public Exception {
  private:
    UINT8     pktId;
  public:
    UnidentifiedPacketException::UnidentifiedPacketException(UINT8 id): 
    Exception("Unidentified PacketType - Id: ") {
        pktId = id;
    }
    UnidentifiedPacketException::~UnidentifiedPacketException () throw(){ }
    const char* UnidentifiedPacketException::print () const throw () { 
        sprintf((char*)buff," %s 0x%x", message, pktId);
        return buff;
    }
  };

  class WrongCRCException: public Exception {
  public:
    WrongCRCException::WrongCRCException(const char* msg):  Exception(msg) {}
    WrongCRCException::~WrongCRCException () throw(){ }
  };

  class WrongCRCHeaderException: public Exception {
  public:
    WrongCRCHeaderException::WrongCRCHeaderException(const char* msg):  Exception(msg) {}
    WrongCRCHeaderException::~WrongCRCHeaderException () throw(){ }
  };


  class LengthException: public Exception {
  public:
    LengthException::LengthException(const char* msg):  Exception(msg) { }
    LengthException::~LengthException () throw(){ }
  };


  class NotExistingAlgorithmException: public Exception {
  public:
    NotExistingAlgorithmException::NotExistingAlgorithmException(const char *msg):  Exception(msg) { }
    NotExistingAlgorithmException::~NotExistingAlgorithmException () throw(){ }
  };
  
  class NotExistingCounterException: public Exception {
  public:
    NotExistingCounterException::NotExistingCounterException(const char *msg):  Exception(msg) { }
    NotExistingCounterException::~NotExistingCounterException () throw(){ }
  };

  class BackwardCounterException: public Exception {
  public:
    BackwardCounterException::BackwardCounterException(const char *msg):  Exception(msg) { }
    BackwardCounterException::~BackwardCounterException () throw(){ }
  };
}
#endif /* EXCEPTION_H */
