/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MA_MCMDArea_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MA_MCMDArea_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.2  2003/11/18 09:01:15  alfarano
/*  laben patch fixes some problems
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/15 13:46:34  zulia
/*  check of MCMD Lenght improved
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_op.h>


/*****************************************************************************/

/*========= M C M D A r e a    P R O V I D E D    I N T E R F A C E =========*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: MA_piInitMCMDArea                                              */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the MCMDArea object.                    */
/*  No parameters are requested.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piInitMCMDArea (void)
{
status_code status;

    status =MA_opInitMCMDArea();
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piGetMCMDType                                               */
/* @Purpose :                                                                */
/*  Provided Interface to convert from MCMD code to  MCMD type (enumerate).  */
/*  Return code can be SUCCESSFUL or MCMD type not identified.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdId               IN      MCMD code identifier                        */
/*  McmdType             OUT     MCMD type (enumerate)                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetMCMDType (unsigned int  McmdId, unsigned int* McmdType)
{
status_code status;

    status =MA_opGetMCMDType (McmdId,McmdType);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piGetMCMDId                                                 */
/* @Purpose :                                                                */
/*  Provided Interface to convert from MCMD type (enumerate) to  MCMD code.  */
/*  Return code can be SUCCESSFUL or MCMD type not identified.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdType             IN      MCMD type (enumerate)                       */
/*  McmdId               OUT     MCMD code identifier                        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetMCMDId (unsigned int McmdType,unsigned int* McmdId)
{
status_code status;
    
    status =MA_opGetMCMDId (McmdType,McmdId);
    return (status);

}

/*****************************************************************************/
/* @Function: MA_piGetMCMDLenght                                             */
/* @Purpose :                                                                */
/*  Provided Interface to check the MCMD lenght.                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdType             IN      MCMD type (enumerate)                       */
/*  McmdLen              OUT     MCMD lenght                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetMCMDLenght (unsigned int McmdType,
                                unsigned int McmdLen)
{
status_code status;

    status =MA_opGetMCMDLenght (McmdType,McmdLen);
    return (status);
}


/*****************************************************************************/
/* @Function: MA_piPutMCMDtimetag                                            */
/* @Purpose :                                                                */
/*  Provided Interface to insert a MCMD with timetag into timetag MCMD list. */
/*  Option paramater can be defined by WAIT (wait for resource) or NO_WAIT   */
/*  constant.                                                                */
/*  The Timeout value has effect when the option parameter is WAIT.          */
/*  The Timeout parameter can be defined with the NO_TIMEOUT constant, in    */
/*  this case the task will wait forever.                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Mcmd                 IN      Pointer to MCMD header structure            */
/*  Obt                  IN      On Board Time                               */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value                               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piPutMCMDtimetag (MA_HEADER_MCMD* Mcmd, TI_TIME Obt,
                                 unsigned int Option,  unsigned int Timeout)
{
status_code status;

    status =MA_opPutMCMDtimetag (Mcmd,Obt,Option,Timeout);
    return (status);
}




/*****************************************************************************/
/* @Function: MA_piGetMCMDtimetag                                            */
/* @Purpose :                                                                */
/*  Provided Interface to obtain the MCMD with the most recent timetag of    */
/*  the list.                                                                */
/*  Option paramater can be defined by WAIT (wait for resource) or NO_WAIT   */
/*  constant.                                                                */
/*  The Timeout value has effect when the option parameter is WAIT.          */
/*  The Timeout parameter can be defined with the NO_TIMEOUT constant, in    */
/*  this case the task will wait forever.                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Mcmd                 IN      Pointer to MCMD header structure            */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value                               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetMCMDtimetag (MA_HEADER_MCMD* Mcmd, unsigned int Option, 
                                 unsigned int Timeout)
{
status_code status;

    status =MA_opGetMCMDtimetag (Mcmd,Option,Timeout);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piUpdateMCMDtimetag                                         */
/* @Purpose :                                                                */
/*  Provided Interface to update the header position in the timetag MCMD     */
/*  list with most recent MCMD.                                              */
/*  Option paramater can be defined by WAIT (wait for resource) or NO_WAIT   */
/*  constant.                                                                */
/*  The Timeout value has effect when the option parameter is WAIT.          */
/*  The Timeout parameter can be defined with the NO_TIMEOUT constant, in    */
/*  this case the task will wait forever.                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Obt                  IN      On Board Time                               */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value                               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piUpdateMCMDtimetag (TI_TIME Obt,unsigned int Option, 
                                    unsigned int Timeout)
{
status_code status;

    status =MA_opUpdateMCMDtimetag (Obt,Option,Timeout);
    return (status);

}


/*****************************************************************************/
/* @Function: MA_piDelMCMDtimetag                                            */
/* @Purpose :                                                                */
/*  Provided Interface to delete a MCMD in the timetag MCMD list.            */
/*  Option paramater can be defined by WAIT (wait for resource) or NO_WAIT   */
/*  constant.                                                                */
/*  The Timeout value has effect when the option parameter is WAIT.          */
/*  The Timeout parameter can be defined with the NO_TIMEOUT constant, in    */
/*  this case the task will wait forever.                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Mcmd                 IN      Pointer to MCMD header structure            */
/*  Obt                  IN      On Board Time                               */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value                               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piDelMCMDtimetag (MA_HEADER_MCMD* Mcmd, TI_TIME Obt,
                                 unsigned int Option,  unsigned int Timeout)
{
status_code status;

    status =MA_opDelMCMDtimetag(Mcmd,Obt,Option,Timeout);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piDelAllMCMDtimetag                                         */
/* @Purpose :                                                                */
/*  Provided Interface to delete all or a specific MCMD in the list of the   */
/*  MCMD with timetag.                                                       */
/*  Timetag parameter is used as reference to seek the MCMD to delete inside */
/*  the list.                                                                */
/*  Option paramater can be defined by WAIT (wait for resource) or NO_WAIT   */
/*  constant.                                                                */
/*  The Timeout value has effect when the option parameter is WAIT.          */
/*  The Timeout parameter can be defined with the NO_TIMEOUT constant, in    */
/*  this case the task will wait forever.                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  DelAllMcmdFlag       IN      Flag to indicate delete all or a MCMD       */
/*  Timetag              IN      Timetag value                               */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value                               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piDelAllMCMDtimetag (unsigned int DelAllMcmdFlag,
                                    unsigned int Timetag,
                                    unsigned int Option, 
                                    unsigned int Timeout)
{
status_code status;

    status =MA_opDelAllMCMDtimetag (DelAllMcmdFlag,Timetag,Option,Timeout);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piGetTlmTimetagRTE                                          */
/* @Purpose :                                                                */
/*  Provided Interface to obtain the timetag MCMD in the RTE telemetry       */
/*  format.                                                                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  McmdBuffer           OUT     Buffer where MCMD are stored                */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetTlmTimetagRTE (MA_TLM_TIMETAG_RTE* McmdBuffer)
{
status_code status;

    status =MA_opGetTlmTimetagRTE (McmdBuffer);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piGetMcmdTimetagQueueFull                                   */
/* @Purpose :                                                                */
/*  Provided Interface to obtain the timetag MCMD queue full flag.           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  QueueFullFlag        OUT     Variable where flag is stored               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetMcmdTimetagQueueFull (unsigned int* QueueFullFlag)
{
status_code status;

    status =MA_opGetMcmdTimetagQueueFull (QueueFullFlag);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piGetBufferMCMD                                             */
/* @Purpose :                                                                */
/*  Provided Interface to obtain a MCMD buffer from partition resource.      */
/*  In the TimetagFlag parameter can be specified the following constant:    */
/*      IMMEDIATE_MCMD  for the partition of the immediate MCMD.             */
/*      TIMETAG_MCMD    for the partition of the timetag MCMD.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  TimetagFlag          IN      Flag to indicate which partition use        */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value for WAIT option               */
/*  BufMCMD              OUT     Pointer to partition buffer                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piGetBufferMCMD (void** BufMCMD, unsigned int TimetagFlag)
{
status_code status;

 status =MA_opGetBufferMCMD (BufMCMD,TimetagFlag);
    return (status);

}



/*****************************************************************************/
/* @Function: MA_piDelBufferMCMD                                             */
/* @Purpose :                                                                */
/*  Provided Interface to release a MCMD buffer from partition resource.     */
/*  In the TimetagFlag parameter can be specified the following constant:    */
/*      IMMEDIATE_MCMD  for the partition of the immediate MCMD.             */
/*      TIMETAG_MCMD    for the partition of the timetag MCMD.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  BufMCMD              IN      Pointer to the buffer that must be released */
/*  TimetagFlag          IN      Flag to indicate which partition use        */
/*  Option               IN      Flag which defines if await or no the       */
/*                               resource availability (WAIT, NO_WAIT)       */
/*  Timeout              IN      Timeout value for WAIT option               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MA_piDelBufferMCMD (void* BufMCMD, unsigned int TimetagFlag)
{
status_code status;

 status =MA_opDelBufferMCMD (BufMCMD,TimetagFlag);
    return (status);

}
