/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  ModeManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MC_ModeCoordinator_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MC_ModeCoordinator_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/09 08:16:35  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_p.h>
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_op.h>


/*****************************************************************************/

/*=== M o d e C o o r d i n a t o r   P R O V I D E D    I N T E R F A C E ==*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: MC_piInitModeCoordinator                                       */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the ModeCoordinator object.             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_piInitModeCoordinator(void)
{
status_code status;

    status =MC_opInitModeCoordinator();
    return (status);

}



/*****************************************************************************/
/* @Function: MC_piGetMcmdAbilityExec                                        */
/* @Purpose :                                                                */
/*  Provided Interface to verify the MCMD execution eligibility.             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Mcmd                 IN      MCMD type (MA_TYPE_MCMD type)               */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_piGetMcmdAbilityExec (unsigned int Mcmd)
{
status_code status;

    status =MC_opGetMcmdAbilityExec (Mcmd);
    return (status);
}

/*****************************************************************************/
/* @Function: MC_piSetState                                                  */
/* @Purpose :                                                                */
/*  Provided interface to set the state of the system.                       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  State                IN      State of the system (MC_STATE type)         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_piSetState (MC_STATE State)
{
status_code status;
    
    status =MC_opSetState(State);
    return (status);
}

/*****************************************************************************/
/* @Function: MC_piGetState                                                  */
/* @Purpose :                                                                */
/*  Provided interface to get the current state of the system.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  State                OUT     State of the system (MC_STATE type)         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_piGetState (MC_STATE* State)
{
status_code status;
    
    status = MC_opGetState(State);
    return (status);

}

