/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MD_MCMDDispatcher_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MD_MCMDDispatcher_op.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.5  2005/02/21 08:58:29  sebastiani
/*  all log comments completed
/*
/*  Revision 1.4  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.3  2004/05/10 12:59:17  faber
/*  __FILEID__ right value fixed: many .c files had the wrong value!
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/
 
/*============================= Include File ================================*/
  
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_op.h>
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_int.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _MD_MCMDDispatcher_op__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();

/*======================== Object Internal variables ========================*/


/*****************************************************************************/

/*== M C M D i s p a t c h e r   O P E R A T I O N A L   F U N C T I O N S ==*/

/*****************************************************************************/
/* @Function: MD_opInitMCMDDispatcher                                        */
/* @Purpose :                                                                */
/*  The function initializes the MCMDDispatcher object.  The OS directive    */
/*  are called to set priority and to ready the MCMDDispatcher task.         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_opInitMCMDDispatcher (void)
{
status_code   status;
unsigned int  OldPriority;

    status  =SUCCESSFUL;
    /* Task initialization                           */
    if (OS_piTaskReady(MD_TASK,MD_tkMCMDDispatcher) != SUCCESSFUL)
    {
        /*@LOG Task is not correctly started LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MD,HA_E10_TSK_READY_ERR,status);     */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    }
    if (OS_piTaskPriority(MD_TASK,MCMDDISP_PRIORITY,&OldPriority) != SUCCESSFUL)
    {
        /*@LOG Task priority is not correctly updated LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MD,HA_E10_TSK_PRIORITY_ERR,status);     */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    }
    
    return (status);

}



/*****************************************************************************/
/* @Function: MD_opSndMsgMCMDDispatcher                                      */
/* @Purpose :                                                                */
/*  The function  invokes the directive of the OS to send a message to the   */
/*  MCMDDispatcher mailbox.                                                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Message buffer that contains task operation */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_opSndMsgMCMDDispatcher(MsgTsk* SndMsg)
{
status_code   status;

    /* Send message to MCMDDispatcher task mailbox                */
    status =OS_piMsgQueueSend(MD_MAILBOX,(void*)SndMsg,sizeof(MsgTsk));
    if (status != SUCCESSFUL)
    {
      /*@LOG Fail during the send message to MCMDDispatcher mailbox  LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MD,HA_E10_SEND_MSG_ERR,status);     */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
    return (status);

}



/*****************************************************************************/
/* @Function: MD_tkMCMDDispatcher                                            */
/* @Purpose :                                                                */
/*  The function is the task handler of the MCMDDispatcher object.           */
/*  When a message is received into task mailbox it wakes up.                */
/*  The information contained in the message (MsgTsk structure) define       */
/*  parameters (Info field), and the operation type that the task performs   */
/*  (Code field).                                                            */
/*  The MCMDDispatcher task activity is to dispatch MCMD to the proper       */
/*  MCMD executors.                                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

task MD_tkMCMDDispatcher (task_argument unused)
{
MsgTsk        RxMsg;
status_code   status;
unsigned int  MsgSize;


    while( FOREVER ) 
    {
        RxMsg.Code =NULL_MSG_MD;
        /* Wait for a message to become available                 */
        if ((status =OS_piMsgQueueReceive (MD_MAILBOX,(void*)&RxMsg,
             &MsgSize,WAIT, NO_TIMEOUT)) == SUCCESSFUL)
        {
            switch (RxMsg.Code)
            {
                case MD_MCMD_EXEC:
                    /* Dispatch the MCDM to the object executor   */ 
                    MD_ifDispatch((MA_HEADER_MCMD* )RxMsg.Info);
                    break;
                default:
                break;
            }
        }
    }
}


