/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :   Initialization                                                 
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: IN_InitManager_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: IN_InitManager_op.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.4  2004/08/26 16:54:39  sebastiani
/*  version work fine
/*
/*  Revision 1.3  2004/07/27 17:30:17  faber
/*  OBT can be now in second or milliseconds, depending of the situazion.
/*  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
/*
/*  Revision 1.2  2003/09/15 17:46:27  faber
/*  HB_HKBuffer_INFN module introduced.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.10  2002/09/02 12:53:28  zulia
/*  added task test
/*
/*  Revision 1.9  2002/06/11 13:50:33  zulia
/*  TEST_I
/*
/*  Revision 1.8  2002/05/13 14:58:08  zulia
/*  * update makefiles
/*  * integration with INFN sw
/*
/*  Revision 1.7  2002/05/09 13:45:55  aurora
/*  fixed sendMsgCode to reportGenerator
/*
/*  Revision 1.6  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/Initialization/InitManager/IN_InitManager_op.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_p.h>
#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_p.h>
#include <src/BasicSW/InterruptManager/IM_InterruptManager_p.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_p.h>
#include <src/BasicSW/TimingInfo/TI_TimingInfo_p.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/MCMDManager/TTManager/MT_TTManager_p.h>
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_p.h>
#include <src/FileManager/FileSystem/FS_FileSystem_p.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/FileManager/MMSUDriver/FD_MMSUDriver_p.h>
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_p.h>
#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_p.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_p.h>
#include <src/QualitySystem/DiagSupervisor/QS_DiagSupervisor_p.h>
#include <src/SRAMManager/SRAMDriver/SD_SRAMDriver_p.h>
#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_p.h>

#ifdef INFN
#include <src/INFN/IN_InitManager_INFN_p.h>
#endif

#ifdef TEST_I
// #include <src/TestUtility/Test/TS_Test_p.h>
#endif
/*============================= Object variables ============================*/

static unsigned int RetCode;

/*****************************************************************************/

/*==== I n i t M a n a g e r   O P E R A T I O N A L   F U N C T I O N S ====*/

/*****************************************************************************/
/* @Function: IN_opInitAllSystem                                             */
/* @Purpose :                                                                */
/*  This function initializes the rtems resources (tasks,semaphores,         */
/*  partitons, timers, mailboxes) and all the structures data relative       */
/*  to the objects application. The boot result is saved into the History    */
/*  area by log type 6.                                                      */
/*  The ERC32 interrupt (External Interrupt 1..5) are unmasked.              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code IN_opInitAllSystem(void)
{
MsgTsk          sndMsg;
status_code     status;
unsigned int    transiz;
unsigned int    retCode;
TI_TIME         obtime;
IN_BOOT_RESULT* pRc;


    /*================== SW object initialization ================*/
    OS_piInitOS();                  /* RTEMSInterface             */

/* Parameter Handler and Log Utility, even in in the INFN have to be done before any other initialization but
   after the OS intialization  */
    IN_piInit_PreAll();


    TI_piInitTimingInfo ();         /* TimingInfo                 */
    CD_piInitCrimeaDriver();        /* CrimeaDriver               */
    BI_piInitBus1553B();            /* BUS1553B                   */
    PD_piInitPatchDumpManager();    /* PatchDumpManager           */
    IM_piIntInterruptManager();     /* InterruptManager           */
    MA_piInitMCMDArea();            /* MCMDArea                   */
    MD_piInitMCMDDispatcher();      /* MCMDDispatcher             */
    MT_piInitTTManager();           /* TTManager                  */
    FS_piInitFileSystem();          /* FileSystem                 */
    FT_piInitMMSUManager();         /* MMSUManager                */
    FD_piInitMMSUDriver();          /* MMSUDriver                 */
    MC_piInitModeCoordinator();     /* ModeCoordinator            */
    TM_piInitTMTCManager();         /* TMTCManager                */
    HA_piInitHistoryArea();         /* HistoryArea                */
    RG_piInitReportGenerator();     /* ReportGeneretor            */
    QS_piInitDiagSupervisor();      /* DiagSupervisor             */
    SD_piSRAMDriverInit();          /* SRAMDriver                 */
    PM_piSRAMPageManagerInit(TRUE); /* SRAMPageManager            */

    #ifdef TEST_I
    //T    TS_piTestInit();
    #endif

    #ifdef INFN
    IN_piInitAllSystem_INFN();      /* All INFN initialisations   */
    #endif

    /*================== Get the Boot results ====================*/
    retCode =FALSE;
    pRc = (IN_BOOT_RESULT* )BOOT_RESULT_ADDR;
    /* Check Warm start flag    */
    if (pRc->WarmStart)
    {
        retCode |=WARM_START;
    }
    else
    {
        pRc->WarmStart =TRUE;
    }
    /* Check Ram test           */
    if (pRc->Ram)
    {
        retCode |=RAM_ERROR;
    }
    /* Check Board test         */
    retCode |=((pRc->Board<<1) & BOARD_ERROR);    
    /* Check Eeprom test        */
    if (pRc->Eeprom)
    {
        retCode |=EEPROM_ERROR;
    }
    /* Check Prom test          */
    if (pRc->Prom)
    {
        retCode |=PROM_ERROR;
    }
    /* Boot result code         */
    RetCode =retCode;
    
    /*============================================================*/
    /*============ Boot results, Log to History area =============*/
#warning do we want OBT in s or in ms ? if ms, russian must be warned ?        
    TI_piGetTimeInfo_ms(&obtime);
    *((unsigned short*)&sndMsg.Info[0])  =HA_HEADER_E6 | POWER_ON_STATE;
    *((unsigned short* )&sndMsg.Info[2]) =(obtime >>16);
    *((unsigned short* )&sndMsg.Info[4]) =(obtime & 0xffff);
    *((unsigned short*)&sndMsg.Info[6])  =retCode;
    sndMsg.Code   = HA_TRACEVENT;
    sndMsg.LlInfo = HA_SIZEW_E6;
    HA_piSndMsgHistoryArea(&sndMsg);
    /*========== Boot results, Log to Report Generator ===========*/
    sndMsg.Code   = RG_BOOT_RESULT;
    sndMsg.LlInfo   = sizeof(unsigned int);
    *(unsigned int* )&sndMsg.Info =retCode;
    RG_piSndMsgReportGenerator(&sndMsg);

    /*============================================================*/    
    /*============== System in MAINTENANCE state =================*/
    /* Transition to MAINTENANCE state                   */
    MC_piSetState (MC_MAINTENANCE_STATE);
    /* Switch on the Memory Module 1               */
    FT_piMemModuleON(FT_MEM_MOD_1);
    /*============================================================*/

    /*===== EXTERNAL INTERRUPT (ERC32) 1 -2 -3 -4 unmask =========*/

    ERC32_Unmask_interrupt (ERC32_INTERRUPT_EXTERNAL_1);
    ERC32_Unmask_interrupt (ERC32_INTERRUPT_EXTERNAL_2); 
    ERC32_Unmask_interrupt (ERC32_INTERRUPT_EXTERNAL_3); 
    ERC32_Unmask_interrupt (ERC32_INTERRUPT_EXTERNAL_4);
    /* External Interrupt 5 is intentionally lefu MASKED */
    return (SUCCESSFUL);

}
