/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: SMH_SelectModeHandler_INFN.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
 *  $Revision: 1.1.1.1 $ 
 *  $Date: 2006/04/25 09:00:20 $     
 *  $RCSfile: SMH_SelectModeHandler_INFN.c,v $ 
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $                                                                   
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: SMH_SelectModeHandler_INFN.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.44  2005/03/23 10:24:56  sebastiani
 *  SMH_GroundMode() completed implementation
 *
 *  Revision 1.43  2005/03/20 18:26:44  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.42  2005/03/13 18:14:58  sebastiani
 *  log comment fixed
 *
 *  Revision 1.41  2005/03/06 14:54:46  sebastiani
 *  version running on 06 03 2005
 *
 *  Revision 1.40  2005/02/22 18:09:25  sebastiani
 *  various bugfixes
 *
 *  Revision 1.39  2005/02/21 08:58:29  sebastiani
 *  all log comments completed
 *
 *  Revision 1.38  2005/02/19 10:19:39  sebastiani
 *  ALM_S4_CALIB_00_HARD,ALM_S4_CALIB_00_SOFT,ALM_S4_128TRIGGER_0 added
 *
 *  Revision 1.37  2004/12/02 10:43:38  sebastiani
 *  fix AC
 *  fix CAL
 *  fix HK BUFTYPE
 *
 *  Revision 1.36  2004/10/18 14:11:37  faber
 *  *** empty log message ***
 *
 *  Revision 1.35  2004/09/28 15:36:25  sebastiani
 *  interrupt manager fix
 *
 *  Revision 1.34  2004/09/22 09:55:23  sebastiani
 *  Fix Cal error handler bug
 *  fixed fecmd
 *  fix Alarmlog
 *  fix ND cmd to 3
 *
 *  Revision 1.33  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.32  2004/09/09 14:52:55  sebastiani
 *  using PreparePage to send cmd to idaq/FE
 *  added some test
 *  added trigger param
 *  added/tested Force Send KHB_to_FE
 *  added/tested Send Cmd to IDAQ/FE
 *
 *  Revision 1.31  2004/08/26 16:54:34  sebastiani
 *  version work fine
 *
 *  Revision 1.30  2004/08/05 16:19:07  sebastiani
 *  fix close run
 *  add cal handler error
 *  fix tmtc
 *  ok protocol betwen pm-rm-scm
 *
 *  Revision 1.29  2004/08/04 13:25:21  sebastiani
 *  first fix allarm procedure
 *
 *  Revision 1.28  2004/08/02 15:49:47  alfarano
 *  alarm handling , scm & pm communication rewrite
 *
 *  Revision 1.27  2004/08/02 09:28:29  faber
 *  Stamp management into SMH_SetParam
 *  TS_PamManger TM_RMTest moved respectively into PM and RM as PM_MCMDTest and
 *  RM_MCMDTEst. TS_Test_INFN.c will be deleted soon.
 *
 *  Revision 1.26  2004/06/01 16:41:19  sebastiani
 *  EventReceive ANY
 *
 *  Revision 1.25  2004/05/12 14:46:14  faber
 *  *** empty log message ***
 *
 *  Revision 1.24  2004/04/23 14:16:58  tassa
 *  - change for donwloading procedures vrl handling
 *  - fix little bug in error case in DoRun
 *  - add ForceBreakPoint selectmode
 *
 *  Revision 1.23  2004/03/11 14:53:05  faber
 *  HK_SendFEComemand renamed HK_KHB_Cmd2FE
 *
 *  Revision 1.22  2004/03/08 15:49:09  alfarano
 *  improved handling functions for FE
 *
 *  Revision 1.21  2004/03/03 11:25:59  tassa
 *  send idaqmcmd tested
 *
 *  Revision 1.20  2004/03/01 17:46:45  tassa
 *  Non testato:
 *  TMTC sample e STORE in SCM
 *  send FECMD bloccante
 *  aggiunto MCMD to send FECMD
 *
 *  Revision 1.19  2004/02/26 11:27:30  faber
 *  PARAMGEN for array/tab/direct idaq command introduced. first implementation. never tested
 *
 *  Revision 1.18  2004/02/17 12:34:51  faber
 *  USERDATA2BUF USERDATA2{ARR,TAB} introduced with CRC.
 *  Never tested.
 *  Some adjustment in Logging in SHM module
 *
 *  Revision 1.17  2004/01/22 10:10:25  faber
 *  *** empty log message ***
 *
 *  Revision 1.16  2004/01/12 17:51:28  tassa
 *  manca solo la parte di invio e ricezione sulla/dalla IDAQ
 *
 *  Revision 1.15  2004/01/09 17:29:34  tassa
 *  add the force command queue procedure
 *
 *  Revision 1.14  2003/12/03 14:36:51  faber
 *  more action definition about mcmd (setmode/purge_trd).
 *  SSt word better defined
 *
 *  Revision 1.13  2003/12/02 11:05:33  faber
 *  first CCA info for IPMs
 *  first technologica model's SELECT MODE management
 *
 *  Revision 1.12  2003/12/01 15:44:09  faber
 *  Donwlink duration field is a 16 bit word, not 32 (only HSB)
 *
 *  Revision 1.11  2003/11/28 14:42:48  faber
 *  *** empty log message ***
 *
 *  Revision 1.10  2003/10/21 13:17:44  sebastiani
 *  more sofisticated tests (via test_debug SOM)
 *
 *  Revision 1.9  2003/10/17 09:55:08  sebastiani
 *   SMH_TEST_DEBUG introduced as submode
 *
 *  Revision 1.8  2003/09/22 09:59:35  faber
 *  new select mode definitions
 *
 *  Revision 1.7  2003/09/12 10:57:41  faber
 *  development in proress (Working schedule module)
 *
 *  Revision 1.6  2003/09/10 16:15:52  faber
 *  PRH_EXTERN_VAR(XX_LOGMASK) removed (not needed any more)
 *
 *  Revision 1.5  2003/09/10 11:55:07  faber
 *  LU_MASK introduced. Log mask for module is now an unique array (PRH_ARR_LOG_MASK) indexed by __FILEID__
 *
 *  Revision 1.4  2003/09/10 10:32:37  faber
 *  Large implementation of PamManager/RunManager Pam Sowfare. (compiled,never run)
 *
 *  Revision 1.3  2003/08/22 07:57:09  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.2  2003/08/07 08:44:40  wizard
 *  *** empty log message ***
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.7  2003/07/18 13:35:10  sebastiani
 *  PRH_ParamHandler_INFN_int.c sobstitues PRH_ParamHandler_INFN_*.*
 *  introduced DAQTEST directive
 *
 *  Revision 1.6  2003/07/17 11:15:52  sebastiani
 *  idaq manager
 *  new print for logging in minicom
 *
 *  Revision 1.5  2003/07/03 12:39:29  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.4  2003/06/20 13:42:29  sebastiani
 *  Pam/Run manager first prototype release
 *
 *  Revision 1.3  2003/06/18 16:53:20  sebastiani
 *  Pam/Run Manager development update. ExpSeq sequence is receiven from the RunManager (simulator mode)
 *
 *  Revision 1.2  2003/06/12 15:32:31  sebastiani
 *  first chenge mode code. FAMILY/TYPE support for the mode (4MSB/4LSB)
 *
 *  Revision 1.1  2003/06/09 16:41:12  sebastiani
 *  First selectmode MCMD handler scheleton.
 *
 *  Revision 1.1  2003/06/05 10:31:12  wizard
 *  added PamMnager (empty skeleton),and other main dirs on INFN
 *
 *                                                                           
 *****************************************************************************/


/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _SMH_SelectModeHandler_INFN__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();


#include <src/INFN/SMH_SelectModeHandler_INFN.h>
#include <src/INFN/MH_ModeHandler_INFN.h>
#include <src/INFN/PM_PamManager_INFN.h>
#include <src/INFN/RM_RunManager_INFN.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_p.h>
#include <src/INFN/HK_Manager_INFN.h>
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_p.h>

#ifdef TEST_I
//#include <src/INFN/TS_Test_INFN.h>
#endif

/*============================ Global define ================================*/


#define SMH_EXP_SEQ_OFFSET (OFFSET_HEADER+2)

/*============================== global types  ==============================*/


/*****************************************************************************/
/*=========================== Structure define ==============================*/


/*****************************************************************************/
/*============================ Enumerate define =============================*/


/*****************************************************************************/


status_code SMH_Init() {
  return SUCCESSFUL;
}

status_code SMH_Send_IDAQCMD(MA_HEADER_MCMD *headerMcmd) {
  status_code s;
  BYTE buf_no,tmp;
  HB_BUF bufid;
  UINT16 crc;
  volatile BYTE *CurPtr; 
  if(headerMcmd->Length != SMH_SELECTMODEBODY_OFFSET + 3)
    return CM_RC_BAD_MCMD_LEN;
  CurPtr = (BYTE*)SMH_GETPTR_SELECTMODEBODY(headerMcmd->PtrMCMD);

  CM_READ_BE_UINT8(CurPtr,buf_no);
  CM_READ_BE_UINT16(CurPtr,crc,tmp);
  /*@LOG Send IDAQ Command - buf_no */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);
  /*@LOG Send IDAQ Command - crc */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,crc);
  if(buf_no >= HB_USERDATA_NO)
    return CM_RC_INVALID_BUFFER_ID;
  bufid=(HB_BUF)(buf_no+HB_USERDATA0);
  s=RM_Set_ForceIdaqCmd(bufid,crc);
  if(s==CM_RC_SUCCESSFUL)
    MH_SetGOM(MH_GOM_FORCE_IDAQCMD);
  return s;
}

status_code SMH_Send_FECMD(MA_HEADER_MCMD *headerMcmd) {
  status_code s;
  BYTE buf_no,eto,ato,tmp,fe;
  HB_BUF bufid;
  UINT16 crc;
  volatile BYTE *CurPtr; 
  if(headerMcmd->Length != SMH_SELECTMODEBODY_OFFSET + 4)
    return CM_RC_BAD_MCMD_LEN;
  CurPtr = (BYTE*)SMH_GETPTR_SELECTMODEBODY(headerMcmd->PtrMCMD);

  CM_READ_BE_UINT8(CurPtr,buf_no);
  CM_READ_BE_UINT16(CurPtr,crc,tmp);
  CM_READ_BE_UINT8(CurPtr,fe);
  CM_READ_BE_UINT8(CurPtr,eto);
  CM_READ_BE_UINT8(CurPtr,ato);
  
  /*@LOG Send_FECMD: buf_no */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);
  /*@LOG Send_FECMD: crc */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,crc);
  /*@LOG Send_FECMD: fe */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,fe);
  /*@LOG Send_FECMD: eto */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,eto);
  /*@LOG Send_FECMD: ato */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,ato);

  if(buf_no >= HB_USERDATA_NO)
    return CM_RC_INVALID_BUFFER_ID;
  bufid=(HB_BUF)(buf_no+HB_USERDATA0);
  s=RM_Set_ForceFeCmd(bufid,crc,eto,ato,(DAQ_FE)fe);
  if(s==CM_RC_SUCCESSFUL)
    MH_SetGOM(MH_GOM_FORCE_IDAQCMD);
  return s;
}


status_code SMH_Send_TC(MA_HEADER_MCMD *headerMcmd) {
  status_code s;
  BYTE tmp;
  HB_BUF bufid;
  UINT16 tc;
  volatile BYTE *CurPtr; 
  if(headerMcmd->Length != SMH_SELECTMODEBODY_OFFSET + 2 /* words */ + 1 /* crc */ )
    return CM_RC_BAD_MCMD_LEN;
  CurPtr = (BYTE*)SMH_GETPTR_SELECTMODEBODY(headerMcmd->PtrMCMD);

  CM_READ_BE_UINT16(CurPtr,tc,tmp);
  /*@LOG Send_TC: tc */
  LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,tc);

  if(tc>=TM_MAX_TELECOMMAND)
    /*@LOG Error TC id: out of range */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,tc);

  s=HK_SendTC(tc,TM_HL_DUMMYVALUE);
  if(s!=CM_RC_SUCCESSFUL) {
    /*@LOG Error sending TC - status */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
    
  }
  return s;
}


/*
SMH_Send_KHBFECMD
*/

status_code SMH_Send_KHBFECMD(MA_HEADER_MCMD *headerMcmd) {
BYTE link;
BYTE comlen;
BYTE expected;
UINT16 combuf[16];
UINT16 outbuf[16];
UINT32 timeout;
UINT16 value;
BYTE *CurPtr;
BYTE tmp;
status_code status; 
UINT32 i;

 CurPtr  = (BYTE*)SMH_GETPTR_SELECTMODEBODY(headerMcmd->PtrMCMD);
 
 CM_READ_BE_UINT16(CurPtr,link,tmp);
 CM_READ_BE_UINT16(CurPtr,expected,tmp);
 CM_READ_BE_UINT16(CurPtr,timeout,tmp);
 CM_READ_BE_UINT16(CurPtr,comlen,tmp);

 for(i=0;i<comlen;i++){
   CM_READ_BE_UINT16(CurPtr,value,tmp);
   combuf[i]=value;
 }
 status = HK_KHB_Cmd2FE(link,comlen,expected,combuf,outbuf,timeout);
 // aggiungere eventuale scrittura in MM o altri risorse di log... 
 if(status == CM_RC_SUCCESSFUL) {
   /*@LOG Send_KHBFECMD: expected */
   LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,expected);
   for(i=0;i<expected;i++){
     /*@LOG Send_KHBFECMD: outbuf[i] */
     LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,outbuf[i]);
   } 
 }
 return (status); 
}


status_code SMH_GroundMode(BOOL calibrate) {
  status_code status;
  PRH_VAR_PULSER_ACTION=2;
  PRH_VAR_TRIGGER_MODE_A=11;
  PRH_VAR_TRIGGER_MODE_B=11;
  PRH_VAR_AUTO_RM_MODE=1;
  PRH_VAR_AUTO_SCM_MODE=1;
  if(calibrate)
    PM_ActionForTheAscendingNode();
  status=PWR_SendTC(TM_PULSER_025);
  /*@LOG SMH_GroundMode: Set Pulser 0.25 - status */
  LU_INFN_LOG (LU_CRITICAL|LU_HA, LU_MASK(__FILEID__), __FILEID__, __LINE__,status);
  PM_SendCommand(PM_FORCE_RUNNING);
}

status_code SMH_MCMDSelectMode(MA_HEADER_MCMD* headerMcmd) {
  status_code  status=SUCCESSFUL;
  unsigned int    code;
  unsigned short  *test,test_code,test_value1,test_value2,test_value3,test_value4;
  unsigned short* pMcmdInfo;
  unsigned int mode;
  unsigned int fam,type;
  MsgTsk SndMsg;
  mode = SMH_GetMCMDMode(headerMcmd);

  switch(fam=SMH_INFN_SELECTMODE_GET_FAMILY(mode)){
  case SMH_FAMILY_SUBMODE:
    status=MH_SetModeFromMCMD(mode,headerMcmd);
    if(status != CM_RC_SUCCESSFUL) 
      /*@LOG SMH_FAMILY_SUBMODE error - status  */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    break;
  case SMH_FAMILY_SETPARAM:
    status=PRH_SetParam(mode,headerMcmd);
    if(status != CM_RC_SUCCESSFUL) 
      /*@LOG SMH_FAMILY_SETPARAM error - status  */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    break;
  case SMH_FAMILY_IDAQCMD:
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_IDAQCMD_FROM_USERDATA:
      status=SMH_Send_IDAQCMD(headerMcmd);
      if(status != CM_RC_SUCCESSFUL) 
	/*@LOG SMH_IDAQCMD_FROM_USERDATA error - status  */
	LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      break;
    case SMH_FECMD_FROM_USERDATA:
      status=SMH_Send_FECMD(headerMcmd);
      if(status != CM_RC_SUCCESSFUL) 
	/*@LOG SMH_FECMD_FROM_USERDATA: error - status  */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      break;
    default:
      /*@LOG unrecognized submode of FAMILY_IDAQMCD in select mode mcmd:  - type  */
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    break;
  case SMH_FAMILY_KHBFECMD:
    status=SMH_Send_KHBFECMD(headerMcmd);
    if(status != CM_RC_SUCCESSFUL) 
      /*@LOG SMH_FAMILY_KHBFECMD: - status */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    break;
  case SMH_FAMILY_SENDTC:
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_SEND_TC:
      status=SMH_Send_TC(headerMcmd);
      if(status != CM_RC_SUCCESSFUL) 
	/*@LOG SMH_SEND_TC error - status  */
	LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      break;
    default:
      /*@LOG unrecognized submode of FAMILY_SENDTC in select mode mcmd:  - type  */
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    
    break;
  case SMH_FAMILY_START:
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_START_NORMAL_MODE:
      // PM_SetGom(PM_CPU_START_UP,SCM_NO_ACTION);
      OS_piCancelTimer_INFN(PM_FORCERUNNING_TIM);
      PM_SendCommand(PM_FORCE_RUNNING);
      break;
    case SMH_START_CPU_START_UP :
      PM_SetGom(PM_CPU_START_UP,SCM_POWER_ON);
      /*@LOG SMH_START_CPU_START_UP received  - type  */
      LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    default:
      LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    break;
  case SMH_FAMILY_SHUTDOWN:
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_SHUTDOWN_PREPARE:
      /* TBD: */
      status=SMH_PrepareShutDown();
      /*@LOG SMH_SHUTDOWN_PREPARE : - status */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      break;
    case SMH_SHUTDOWN_DO:
      status=SMH_DoShutDown();
      /*@LOG SMH_SHUTDOWN_DO : - status */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      break;
    default:
      LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    break;
  case SMH_FAMILY_TEST:
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_TEST_LOGSTATUS:
      PM_LogStatus();
      break;
    case SMH_TEST_BREAKPOINT:
#ifdef TEST_I
      LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      PM_FORCE_BREAKPOINT();
#endif
      break;
    case SMH_TEST_COMPLEX_HARDWARE:
      
      break;
    case SMH_TEST_DEBUG: 
#ifdef DEBUG
      test = SMH_GETPTR_BODYAREA(headerMcmd->PtrMCMD);
      test += 2;
      test_code = *test;
      test++;
      test_value1 = *test;
      test++;
      test_value2 = *test;
      test++;
      test_value3 = *test;
      test++;
      test_value4 = *test;
      PM_MCMDTest(test_code,test_value1,test_value2,test_value3,test_value4);
#endif // DEBUG 
      break;
    default:
      LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    break;

#define SMH_AUTO_MODE(v) (PRH_VAR_AUTO_RM_MODE=(v3); PRH_VAR_AUTO_SCM_MODE=(v))

  case SMH_FAMILY_TECHNOLOGICAL:
    OS_piCancelTimer_INFN(PM_FORCERUNNING_TIM);
    switch(type=SMH_INFN_SELECTMODE_GET_TYPE(mode)) {
    case SMH_TM_START_NO_TRD_PURGE:
      /* force POWER_ON to return Stop&Wait */
      PRH_VAR_PWR_VOLTAGE_N_ATTEMPT=0;
      break;
    case SMH_TM_START_TRD_PRUGE:

      break;
    case SMH_TM_PREPARE_P_AND_D:
      
      break;
    case SMH_TM_NOMINAL_ACQ:
    case SMH_TM_SPARE_ELECTRONIC:
      SMH_GroundMode(TRUE);
      break;
    case SMH_TM_PREPARE_CALIBRATE:
      SMH_GroundMode(FALSE);
      break;
    case SMH_TM_NOMINAL_ACQ_AFTER_DOWNLINK:
    case SMH_TM_NOMINAL_ACQ_AFTER_EXE_MEM_CONF:
    case SMH_TM_NOMINAL_ACQ_AFTER_CALIBRATE:      
      break;
    case SMH_TM_NOMINAL_ACQ_AFTER_BITE:
    case SMH_TM_IMITATING_MODE_PAM_MEM_1:
    case SMH_TM_IMITATING_MODE_PAM_MEM_2:
      break;
    case SMH_TM_PREPARE_BITE:
    case SMH_TM_PRE_BITE:
    case SMH_TM_PREPARE_BITE_JOIN_OPS:
    case SMH_TM_PREPARE_MEM_CONF:
      break;
    default:
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
      break;
    }
    break;
  default:
    LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,fam);
    break;
  }

  PM_RemoveMCMDInPartition(headerMcmd->PtrMCMD);
  return (status);
}

//BYTE SMH_GetMCMDMode(MA_HEADER_MCMD* headerMcmd){
BYTE SMH_GetMCMDMode(MA_HEADER_MCMD* headerMcmd){
  BYTE b;
  b = (BYTE)*(((unsigned short*)headerMcmd->PtrMCMD)+OFFSET_HEADER);
  return b;
}

status_code SMH_PrepareShutDown() {
  status_code s;

  s = PRH_var_write2eeprom(PRH_EEPROM_CURRENT,PRH_VAR_DOWNLOAD_HEADER_IDX);
  if (s)
    /*@LOG Error updating DOWNLOAD_HEADER at end of download - status */
    LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);

  s=MH_SetGOM(MH_GOM_MAINTENANCE);
  return s;
  /* TBD: write params 2 eeprom */
}

status_code SMH_DoShutDown() {
  status_code s;


  s=PRH_WriteEEPROMBootinfo(PRH_BOOTINFO_SHUTDOWN);
  if(s!=CM_RC_SUCCESSFUL)
    /*@LOG Do Shutdown : error writing EEPROM info - status */
    LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);

  PM_SetGom(PM_STOP_AND_WAIT,SCM_POWEROFFSHUTDOWN);
}
