/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: CD_CrimeaDriver_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: CD_CrimeaDriver_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/

#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_p.h>
#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_op.h>

/*****************************************************************************/

/*=== C D _ C r i m e a D r i v e r   P R O V I D E D   I N T E R F A C E ===*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: CD_piInitCrimeaDriver                                          */
/* @Purpose :                                                                */
/*  Provided Interface to implement the CRIMEA driver initialization.        */
/*  No parameters are requested.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piInitCrimeaDriver (void)
{
status_code status;

    status =CD_opInitCrimeaDriver();    
    return (status);

}


    
/*****************************************************************************/
/* @Function: CD_piWrCrimeaReg                                               */
/* @Purpose :                                                                */
/*  Provided Interface for writing the generic CRIMEA register.              */
/*  The possible function return code can be SUCCESSFUL or INVALID_ADDRESS   */
/*  (bad register specification)                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Reg                  IN      Crimea register (CD_CRIMEA_REG type)        */
/*  Value                IN      Value to write into the register            */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piWrCrimeaReg (unsigned int Reg, unsigned int Value)
{
status_code status;

    status =CD_opWrCrimeaReg (Reg, Value);
    return (status);

}



/*****************************************************************************/
/* @Function: CD_piRdCrimeaReg                                               */
/* @Purpose :                                                                */
/*  Provided Interface for reading the generic CRIMEA register.              */
/*  The possible function return code can be SUCCESSFUL or INVALID_ADDRESS   */
/*  (bad register specification)                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Reg                  IN      Crimea register (CD_CRIMEA_REG type)        */
/*  Value                OUT     Value read                                  */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piRdCrimeaReg (unsigned int Reg, unsigned int* Value)
{
status_code status;

    status =CD_opRdCrimeaReg (Reg, Value);
    return (status);

}



/*****************************************************************************/
/* @Function: CD_piGetCrimeaInterPending                                     */
/* @Purpose :                                                                */
/*  Provided Interface for reading the Crimea Interrupt Pending register.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterPending         OUT     Interrupt Pending value read                */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piGetCrimeaInterPending (unsigned int* InterPending)
{
status_code status;

    status =CD_opGetCrimeaInterPending (InterPending);
    return (status);

}



/*****************************************************************************/
/* @Function: CD_piSetCrimeaInterClear                                       */
/* @Purpose :                                                                */
/*  Provided Interface for clearing the Crimea Interrupt Clear register.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterClear           IN      Interrupt Clear value                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piSetCrimeaInterClear (unsigned int  InterClear)
{
status_code status;

    status =CD_opSetCrimeaInterClear(InterClear);
    return (status);

}


/*****************************************************************************/
/* @Function: CD_piSetCrimeaInterMask                                        */
/* @Purpose :                                                                */
/*  Provided Interface for setting the Crimea Interrupt Mask register.       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterMask            IN      Interrupt mask value                        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piSetCrimeaInterMask (unsigned int  InterMask)
{
status_code status;

    status =CD_opSetCrimeaInterMask(InterMask);
    return (status);

}



/*****************************************************************************/
/* @Function: CD_piGetCrimeaInterMask                                        */
/* @Purpose :                                                                */
/*  Provided Interface for getting the Crimea Interrupt Mask register.       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterMask            OUT     Interrupt mask value                        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_piGetCrimeaInterMask (unsigned int* InterMask)
{
status_code status;

    status =CD_opGetCrimeaInterMask(InterMask);
    return (status);

}
