/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: crc_cm.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
 *  $Revision: 1.1.1.1 $
 *  $Date: 2006/04/25 09:00:20 $
 *  $RCSfile: crc_cm.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: crc_cm.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.1  2004/07/02 09:01:35  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.4  2004/05/20 16:03:52  faber
 *  ACQ flow dev continuing
 *
 *  Revision 1.3  2004/05/20 12:24:44  faber
 *  getchar bugfixed
 *
 *  Revision 1.2  2004/05/20 10:47:17  faber
 *  printf stderr
 
 *  Revision 1.1  2004/02/26 16:30:07  faber
 *  crc.c added
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/


/* #include "CM_Common_INFN.h" */
#include "DAQ_IDAQ_INFN.h"
#include <stdio.h>

DAQ_DECLBUF(B,1024*1024);

int main(void) {
  int c;
  unsigned short crc=0;
  unsigned char b;

  status_code s;
  DAQ_BUFFER_INIT(B);
  // fprintf(stderr,"\n-------\n ");
  while( (c=getchar()) != EOF) {
    if(B.len < B.size) {
      B.buf[B.len++]=c;
      /*
	fprintf(stderr,"%02X ",c);
      if(B.len % 16 == 0) {
       fprintf(stderr,"\n");
       }
      */
    }
    else
      return 1;
  }
  // fprintf(stderr,"\n [Size: %d]\n",B.len);
  B.crc16=CM_Compute_CRC16(0,B.buf, B.len);
  b=B.crc16 & 0xff;

  printf("%02X %04X",b,B.crc16);
  return 0;
}
