/****************************************************************************
 *  F i l e   D a t a                                                        
 *                                                                           
 *  Module       : RGManager
 *  C.I. No.     :                                                           
 *  $Revision: 1.1.1.1 $ 
 *  $Date: 2006/04/25 09:00:20 $     
 *  Belonging to :                                                           
 *
 *  $RCSfile: RG_ReportGenerator_INFN_p.c,v $ 
 *  Program Type :                                                           
 *  Sub-modules  :                                                           
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  Host system  :                                                           
 *  SW Compiler  :                                                           
 *  $Author: kusanagi $                                                                   
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: RG_ReportGenerator_INFN_p.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.1.1.1  2003/05/27 08:13:24  wizard
 *  Import of the Official Laben CD Release Software as the  pamela-EM_delivery_20030521_1454.tar.bz2
 *
 *  Revision 1.2  2002/04/24 09:56:29  ale
 *  Changed directory organization
 *
 *  Revision 1.1  2002/04/23 16:14:52  ale
 *  Imported Sources
 *
 *  Revision 1.2  2002/04/23 14:09:49  zulia
 *  Modified header file
 *
 *                                                                           
 *                                                                           
 *****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/INFN/RG_ReportGenerator_INFN_p.h>
#include <src/INFN/RG_ReportGenerator_INFN_op.h>


/*****************************************************************************/

/*=== M o d e C o o r d i n a t o r   P R O V I D E D    I N T E R F A C E ==*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: RG_piInitReportGenerator_INFN                                        */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the RGManager object.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piInitReportGenerator_INFN(void)
{
status_code status;

    status =RG_opInitReportGenerator_INFN();
    return (status);

}



/*****************************************************************************/
/* @Function: RG_piSetAnomalyCode_INFN                                       */
/* @Purpose :                                                                */
/*  Provided interface to set the AnomalyCode bits in SSW.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  AnomalyCode           IN     AnomalyCode (RG_INFN_ANOMALY type)          */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piSetAnomalyCode_INFN (RG_INFN_ANOMALY AnomalyCode)
{
status_code status;
    
    status =RG_opSetAnomalyCode_INFN(AnomalyCode);
    return (status);
}

/*****************************************************************************/
/* @Function: RG_piGetAnomalyCodeode_INFN                                    */
/* @Purpose :                                                                */
/*  Provided interface to get the AnomalyCode bits in SSW.                   */
/*                                                                           */
/* @Parameter Name      @Mode   @Description                                 */
/*  AnomalyCode           IN     AnomalyCode (RG_INFN_ANOMALY type)          */
/*  status_code          OUT     Return code                                 */                              
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piGetAnomalyCode_INFN (RG_INFN_ANOMALY *AnomalyCode)
{
status_code status;
    
    status = RG_opGetAnomalyCode_INFN(AnomalyCode);
    return (status);

}

/*****************************************************************************/
/* @Function: RG_piSetDownloadRequest_INFN                                   */
/* @Purpose :                                                                */
/*  Provided interface to set the Download Requast bit in SSW.               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  DownloadRequest       IN     DownloadRequest                             */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piSetDownloadRequest_INFN (unsigned int DownloadReq)
{
status_code status;
    
    status =RG_opSetDownloadRequest_INFN(DownloadReq);
    return (status);
}

/*****************************************************************************/
/* @Function: RG_piGetDownloadRequest_INFN                                   */
/* @Purpose :                                                                */
/*  Provided interface to get the Download Request bit in SSW.               */
/*                                                                           */
/* @Parameter Name      @Mode   @Description                                 */
/*  DownloadRequest       IN     DownloadRequest (RG_INFN_ANOMALY type)      */
/*  status_code          OUT     Return code                                 */                              
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piGetDownloadRequest_INFN (unsigned int *DownloadReq)
{
status_code status;
    
    status = RG_opGetDownloadRequest_INFN(DownloadReq);
    return (status);

}
/*****************************************************************************/
/* @Function: RG_piSetPamelaStatus_INFN                                       */
/* @Purpose :                                                                */
/*  Provided interface to set the PamelaStatus bits in SSW.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  PamelaStatus           IN     PamelaStatus (RG_INFN_STATUS type)          */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piSetPamelaStatus_INFN (RG_INFN_STATUS PamelaStatus)
{
status_code status;
    
    status =RG_opSetPamelaStatus_INFN(PamelaStatus);
    return (status);
}

/*****************************************************************************/
/* @Function: RG_piGetPamelaStatus_INFN                                      */
/* @Purpose :                                                                */
/*  Provided interface to get the PamelaStatus bits in SSW.                  */
/*                                                                           */
/* @Parameter Name      @Mode   @Description                                 */
/*  PamelaStatus           IN     PamelaStatus (RG_INFN_STATUS type)         */
/*  status_code          OUT     Return code                                 */                              
/* @@                                                                        */
/*****************************************************************************/

status_code RG_piGetPamelaStatus_INFN (RG_INFN_STATUS *PamelaStatus)
{
status_code status;
    
    status = RG_opGetPamelaStatus_INFN(PamelaStatus);
    return (status);

}
