/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : FileManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: FD_MMSUDriver_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: FD_MMSUDriver_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.5  2002/10/17 10:03:54  zulia
/*  removed FD_PIFReset
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/FileManager/MMSUDriver/FD_MMSUDriver_p.h>
#include <src/FileManager/MMSUDriver/FD_MMSUDriver_op.h>


/*****************************************************************************/

/*======= M M S U D r i v e r    P R O V I D E D    I N T E R F A C E =======*/

/*****************************************************************************/
/* @Function: FD_piInitMMSUDriver                                            */
/* @Purpose :                                                                */

/*  Provided Interface to initialize the MMSUDriver object.                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piInitMMSUDriver (void)
{
status_code status;

    status =FD_opInitMMSUDriver();
    return (status);

}




/*****************************************************************************/
/* @Function: FD_piDrammaWrWPBUSReg                                          */
/* @Purpose :                                                                */
/*  Provided Interface to program a writing into the Dramma WPBUS register.  */
/*  The Dramma register is located by the box, board address, and register   */
/*  type parameters.                                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  BoardId              IN      Board address   (0 to MAX_BOARD_ADDR)       */
/*  Reg                  IN      Register indentifier                        */
/*                                               (FD_DRAMMA_REG_WPBUS type)  */
/*  Value                IN      Value to write into the Dramma register     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piDrammaWrWPBUSReg (unsigned int BoardId,
                                   unsigned int Reg, 
                                   unsigned int Value)
{
status_code status;

    status =FD_opDrammaWrWPBUSReg (BoardId,Reg,Value);
    return (status);

}



/*****************************************************************************/
/* @Function: FD_piDrammaRdRPBUSReg                                          */
/* @Purpose :                                                                */
/*  Provided Interface to program a reading from the Dramma RPBUS register.  */
/*  The Dramma register is located by the box, board address, and register   */
/*  type.                                                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  BoardId              IN      Board address   (0 to MAX_BOARD_ADDR)       */
/*  Reg                  IN      Register indentifier                        */
/*                                               (FD_DRAMMA_REG_RPBUS type)  */
/*  Value                OUT     Value read from the Dramma register         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/


status_code FD_piDrammaRdRPBUSReg (unsigned int  BoardId,
                                   unsigned int  Reg, 
                                   unsigned int* Value)
{
status_code status;

    status =FD_opDrammaRdRPBUSReg (BoardId,Reg,Value);
    return (status);

}

/*****************************************************************************/
/* @Function: FD_piStartTransferToMemory                                     */
/* @Purpose :                                                                */
/*  Provided Interface to start the WPBUS writing into the memory module.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Module               IN      Module ID to write to                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piStartTransferToMemory(FD_MODID Module)
{
status_code status;

    status = FD_opStartTransferToMemory(Module);
    return (status);
}

/*****************************************************************************/
/* @Function: FD_piStartTransferFromMemory                                     */
/* @Purpose :                                                                */
/*  Provided Interface to start the WPBUS writing into the memory module.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Module               IN      Module ID to write to                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piStartTransferFromMemory(FD_MODID Module, BOOL LastSector)
{
status_code status;

  status = FD_opStartTransferFromMemory(Module, LastSector);
  return (status);
}

/*****************************************************************************/
/* @Function: FD_piAbortTransfer                                             */
/* @Purpose :                                                                */
/*  Provided Interface to start the WPBUS writing into the memory module.    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Module               IN      Module ID to write to                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piAbortTransfer(FD_ABT_TYPE Aborttype)
{
status_code status;

    status = FD_opAbortTransfer(Aborttype);
    return (status);
}

/*****************************************************************************/
/* @Function: FD_piSetWPBUSWaitState                                         */
/* @Purpose :                                                                */
/*  Provided Interface to set the WPBUS wait state counter                   */
/*  packets.                                                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Counter              IN      Number of WPBUS wait states                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piSetWPBUSWaitState(UINT32 Counter)
{
status_code status = SUCCESSFUL;

    FD_opSetWPBUSWaitState(Counter);
    return (status);
}

/*****************************************************************************/
/* @Function: FD_piSetRPBUSWaitState                                         */
/* @Purpose :                                                                */
/*  Provided Interface to set the RPBUS wait state counter                   */
/*  packets.                                                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Counter              IN      Number of RPBUS wait states                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piSetRPBUSWaitState(UINT32 Counter)
{
status_code status = SUCCESSFUL;

    FD_opSetRPBUSWaitState(Counter);
    return (status);
}

/*****************************************************************************/
/* @Function: FD_piSetBlockLength                                            */
/* @Purpose :                                                                */
/*  Provided Interface to set the last block length for the RPBUS            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Length               IN      block length                                */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code FD_piSetBlockLength(UINT32 Length)
{
status_code status = SUCCESSFUL;

    FD_opSetBlockLength(Length);
    return (status);
}

