//****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:20 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: OS_rtems_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: OS_rtems_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.11  2005/03/10 11:34:20  faber
/*  tmacros include excluded
/*
/*  Revision 1.10  2005/02/24 16:44:59  sebastiani
/*  uncomment log info loading
/*
/*  Revision 1.9  2005/02/21 08:58:28  sebastiani
/*  all log comments completed
/*
/*  Revision 1.8  2004/11/10 16:59:58  sebastiani
/*  - GS_COMPILE directive introduced and be undef by default
/*  - automatic flush mechanism by run manager mailbox timeout
/*
/*  Revision 1.7  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.6  2004/08/26 16:53:56  sebastiani
/*  fix some bug
/*
/*  Revision 1.5  2004/05/12 08:10:11  faber
/*  *** empty log message ***
/*
/*  Revision 1.4  2004/03/09 09:39:27  faber
/*  LU_TRACE system introduced
/*
/*  Revision 1.3  2003/11/20 10:24:46  faber
/*  - interrupt_is_in_progress check inside the OS_Obtain
/*  - CM_RETURN_CODE type starting from RTEMS_STATUS_CODES_LAST, in order to have a unique error space coding
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2003/08/01 09:46:36  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.3  2003/07/25 10:30:17  sebastiani
/*  bug fix semaphore creation and mailbox creation
/*
/*  Revision 1.2  2003/07/03 12:39:29  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.1.1.1  2003/05/27 08:13:24  wizard
/*  Import of the Official Laben CD Release Software as the  pamela-EM_delivery_20030521_1454.tar.bz2
/*
/*  Revision 1.5  2002/11/14 09:45:56  zulia
/*  removed unsed status variable
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

 
/*============================= Include File ================================*/
  
//#include <tmacros.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_p.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_op.h>
#include <src/HKManager/HistoryArea/HA_HistoryArea_p.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _OS_rtems_p__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>

LU_DECL_MASK();


#ifdef TEST_I
#include <src/INFN/OS_rtems_INFN_p.h>
#endif

#include <src/INFN/CM_Common_INFN.h>
 
/*****************************************************************************/
/*==================== RTEMS configuration variables ========================*/

/*****************************************************************************/
/* @Variable: Task_id                                                        */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS tasks identification.                                             */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Task_id        [MAX_TASK];       

/*****************************************************************************/
/* @Variable: Task_name                                                      */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS tasks name.                                                       */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Task_name      [MAX_TASK];       

/*****************************************************************************/
/* @Variable: Msg_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS mailboxes identification.                                         */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Msg_id         [MAX_MBOX];

/*****************************************************************************/
/* @Variable: Msg_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS mailboxes name.                                                   */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Msg_name       [MAX_MBOX];

/*****************************************************************************/
/* @Variable: Sem_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS semaphores identification.                                        */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Sem_id         [MAX_RES];    

/*****************************************************************************/
/* @Variable: Sem_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS semaphores name.                                                  */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Sem_name       [MAX_RES];

/*****************************************************************************/
/* @Variable: Part_id                                                        */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS patitios identification.                                          */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Part_id        [MAX_PART];    

/*****************************************************************************/
/* @Variable: Part_name                                                      */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS patitios name.                                                    */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Part_name      [MAX_PART];  

/*****************************************************************************/
/* @Variable: Tim_id                                                         */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS timers identification.                                            */
/* @@                                                                        */
/*****************************************************************************/
static rtems_id   Tim_id         [MAX_TIM];     

/*****************************************************************************/
/* @Variable: Tim_name                                                       */
/* @Purpose :                                                                */
/*   Array of retems_id                                                      */
/*   RTEMS timers name.                                                      */
/* @@                                                                        */
/*****************************************************************************/
static rtems_name Tim_name       [MAX_TIM];     

/*****************************************************************************/
/* @Variable: MA_Partition                                                   */
/* @Purpose :                                                                */
/*   Array of rtems_unsigned32                                               */
/*   MCMD area patition.                                                     */
/* @@                                                                        */
/*****************************************************************************/
static rtems_unsigned32 MA_Partition [TOTAL_MCMD_PART];  




/* for debugging : */

#ifdef DEBUG
#define OS_MAX_PARTITIONS_STORE 1024
static  BYTE *max_partitions_store [OS_MAX_PARTITIONS_STORE];
#endif

/*****************************************************************************/

/*============ R T E M S   P R O V I D E D    I N T E R F A C E =============*/

/*****************************************************************************/
/* @Function: OS_piInitOS                                                    */
/* @Purpose :                                                                */
/* Initialization of the Operating System global resources.                  */
/* All Task, mailboxes, semaphores, partitons, timers are created and        */
/* allocated. RTEMS directives are called for resources creation.            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                       IN                                                  */
/* status_code           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/


status_code OS_piInitOS(void)
{
rtems_status_code status;
rtems_time_of_day time;
rtems_unsigned32  tmpPart;
unsigned long     statusRc;
unsigned int      i;
unsigned char     c;

    status     =SUCCESSFUL; 
    statusRc   =SUCCESSFUL;

/*===========================================================================*/
    /*==== TASKS CREATION  ========================*/
    for (i=1,c='A'; i<MAX_TASK; i++,c++)
    {
        Task_name[i] =rtems_build_name( 'T', 'A', c, ' ' );
        status =rtems_task_create(Task_name[i],255, RTEMS_MINIMUM_STACK_SIZE, 
                                  RTEMS_DEFAULT_MODES,RTEMS_DEFAULT_ATTRIBUTES,
                                  &Task_id[i]);
        if (status!=SUCCESSFUL)
        {
	  /* Error during task resource creation, log in history area      */
	  // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_TSK_CREATION_ERR,status);
	  /*@LOG Error in task creation - status */
	  LU_INFN_LOG(LU_FATAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  statusRc =HA_E2_INTERNAL_ERR;
        }else
	  LU_TRACE_LOAD_TASK_INFO(i+1000,Task_id[i]);
	
    }

/*===========================================================================*/
    /*==== TASKS MAILBOXES CREATION ===================*/
    for (i=1,c='A'; i<MAX_MBOX_1; i++,c++)
    {

        Msg_name[i] = rtems_build_name( 'M', 'A', c, ' ' );
        status =rtems_message_queue_create(Msg_name[i], MAX_MSG_FOR_MBOX_1, 
                                           MAX_MSG_MBOX_SIZE_1, RTEMS_PRIORITY,
                                           &Msg_id[i]);
        if (status!=SUCCESSFUL)
        {
	  /* Error during task mailbox resource creation, log in history area   */
	  // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_MBOX_CREATION_ERR,status);
	  /*@LOG Error during mailbox creation - status */
	  LU_INFN_LOG(LU_FATAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  statusRc =HA_E2_INTERNAL_ERR;
        }
    }
    /*==== GENEREIC MAILBOXES CREATION ================*/
    for ( ; i<MAX_MBOX; i++,c++)
      {

        Msg_name[i] = rtems_build_name( 'M', 'A', c, ' ' );
        status =rtems_message_queue_create(Msg_name[i], MAX_MSG_FOR_MBOX_2, 
                                           MAX_MSG_MBOX_SIZE_2, RTEMS_PRIORITY,
                                           &Msg_id[i]);
        if (status!=SUCCESSFUL)
	  {
	    /* Error during mailbox resource creation, log in history area   */
	    // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_MBOX_CREATION_ERR,status);
	    /*@LOG Error during generic mailbox creation - status */
	    LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	    statusRc =HA_E2_INTERNAL_ERR;
	  }
      }


/*===========================================================================*/
    /*==== SEMAPHORES CREATION ========================*/
    for (i=1,c='A'; i<MAX_RES; i++,c++)
    {
        Sem_name[i] =rtems_build_name( 'S', 'A', c, ' ' );
	/*
        status =rtems_semaphore_create(Sem_name[i], 1,
	 			       RTEMS_FIFO | RTEMS_INHERIT_PRIORITY | RTEMS_BINARY_SEMAPHORE | RTEMS_LOCAL , 
				       RTEMS_NO_PRIORITY_CEILING,&Sem_id[i]);
	*/
        status =rtems_semaphore_create(Sem_name[i], 1,RTEMS_DEFAULT_ATTRIBUTES, 
				       RTEMS_NO_PRIORITY_CEILING,&Sem_id[i]);
	
        if (status!=SUCCESSFUL)
        {
            /* Error during semaphore resource creation, log in history area */
            // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_SEM_CREATION_ERR,status);
	  /*@LOG Error during semaphore creation - status */
	  LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  statusRc =HA_E2_INTERNAL_ERR;
        }
    }

/*===========================================================================*/
    /*==== PARTITIONS CREATION ========================*/
    for (i=1,c='A'; i<MAX_PART; i++,c++)
    { 
        Part_name[i] =rtems_build_name( 'P', 'A', c, ' ' );
    }
    
    for (i=0 ; i < TOTAL_MCMD_PART; i++)
        MA_Partition[i] =0;
    
    /* MCMD partion creation                                                 */
    tmpPart  =(rtems_unsigned32)(&MA_Partition[START_MA_PART_IM]);
    tmpPart &= 0xfffffff0;
    status   =rtems_partition_create(Part_name[MA_PART_IM],(rtems_unsigned32*)tmpPart,  
                                   MAX_MCMD_SIZE_IM << 2,
                                   MAX_MCMD_LEN_IM << 2,
                                   RTEMS_LOCAL,&Part_id[MA_PART_IM]);
    if (status!=SUCCESSFUL)
    {
      /* Error during partition resource creation, log in history area         */
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_PAR_CREATION_ERR,status);
      /*@LOG error in partition creation - status */
      LU_INFN_LOG(LU_FATAL|LU_HA ,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      statusRc =HA_E2_INTERNAL_ERR;
    }

    /* MCMD timetag table partion creation                                   */
    tmpPart  =(rtems_unsigned32)(&MA_Partition[START_MA_PART_TT]);
    tmpPart &= 0xfffffff0;
    status   =rtems_partition_create(Part_name[MA_PART_TT],(rtems_unsigned32*)tmpPart,  
                                     MAX_MCMD_SIZE_TT << 2,
                                     MAX_MCMD_LEN_TT << 2,
                                     RTEMS_LOCAL,&Part_id[MA_PART_TT]);
    if (status!=SUCCESSFUL)
    {
      /* Error during partition resource creation, log in history area         */
      // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_PAR_CREATION_ERR,status);
      /*@LOG error in partition creation - status */
      LU_INFN_LOG(LU_FATAL|LU_HA ,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
      statusRc =HA_E2_INTERNAL_ERR;
    }
        
/*===========================================================================*/
    /*==== TIMERS CREATION ========================*/
    for (i=1,c='A'; i<MAX_TIM; i++,c++)
    {
        Tim_name[i] = rtems_build_name( 'T', 'A', c, ' ' );
        status =rtems_timer_create(Tim_name[i], &Tim_id[i]);
        if (status!=SUCCESSFUL)
        {
	  /* Error during timer resource creation, log in history area     */
	  // LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_OS,HA_E10_TIM_CREATION_ERR,status);
	  /*@LOG error in timer creation - status */
	  LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
	  statusRc =HA_E2_INTERNAL_ERR;
        }
    }

/*===========================================================================*/

#ifdef DEBUG
    for (i=0;i<OS_MAX_PARTITIONS_STORE;i++)
      max_partitions_store[i]=NULL;
#endif

    return (statusRc);

}


/*****************************************************************************/
/* @Function: OS_piTaskReady                                                 */
/* @Purpose :                                                                */
/* The function readies the task specified (Task  param.). The starting      */
/* address of the task is given Entry parameter.                             */
/* The RTEMS directive is called to performs the start task.                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Task                 IN      Task ID                                     */
/*  Entry                IN      Function entry point                        */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskReady ( unsigned int Task,
                             void*        Entry)
{
rtems_status_code status;

    /* Check Task ID validity   */
    if(Task < MAX_TASK)
    {
        /* Start task           */
        status =rtems_task_start(Task_id[Task],(rtems_task_entry)Entry,Task);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}



/*****************************************************************************/
/* @Function: OS_piTaskPriority                                              */
/* @Purpose :                                                                */
/* The function manipulates the task priority. The parameters -Task- and     */
/* and -NewPriority_  identifies  respectively the task ID and the new       */
/* priority. The RTEMS directive is called to performs priority setting.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Task                 IN      Task ID                                     */
/*  NewPriority          IN      Priority value                              */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  OldPriority          OUT     Current priority                            */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskPriority    ( unsigned int   Task,
                                   unsigned int   NewPriority,
                                   unsigned int*  OldPriority)
{
rtems_status_code status;

    /* Check Task ID validity and Priority parameters range */
    if(Task<MAX_TASK && NewPriority<MAX_PRIORITY_RANGE)
    {
        /* Call RTEMS directive for priority setting        */
        status =rtems_task_set_priority(Task_id[Task],NewPriority,
                (rtems_task_priority*)OldPriority);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}



/*****************************************************************************/
/* @Function: OS_piTaskSuspend                                               */
/* @Purpose :                                                                */
/* The function suspends the  current active task from further execution     */
/* by placing it in the suspend state for a number of system ticks specified */
/* into the Ticks parameter.                                                 */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Ticks                IN      System ticks                                */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskSuspend (unsigned int Ticks )
{
rtems_status_code status;

    /* Put task in wait state           */
    status =rtems_task_wake_after(Ticks);
    return (SUCCESSFUL);
}



/*****************************************************************************/
/* @Function: OS_piTaskDelete                                                */
/* @Purpose :                                                                */
/* The function deletes the task specified (Task  param.).                   */
/* The RTEMS directive is called to performs task delete                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Task                 IN      Task ID                                     */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piTaskDelete ( unsigned int Task)
{
rtems_status_code status;

    /* Check Task ID validity              */
    if(Task < MAX_TASK)
    {
        /* RTEMS directive for task delete */
        status =rtems_task_delete(Task);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }

    return (status);

}



/*****************************************************************************/
/* @Function: OS_piMsgQueueSend                                              */
/* @Purpose :                                                                */
/*  The function interface performs the send masssge to a mail box queue     */
/*  addressed.                                                               */
/*  The RTEMS directive is called to performs the mailbox send message.      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  mBox                 IN      Mailbox ID                                  */
/*  MsgToSend            IN      Poniter to message information              */
/*  MsgLenght            IN      Message lenght                              */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piMsgQueueSend(unsigned int mBox,
                              void*        MsgToSend,
                              unsigned int MsgLenght)
{
rtems_status_code status;
    
    /* Check Mailbox queue address validity            */
    if(mBox < MAX_MBOX)
    {
        /* RTEMS directive to send message to mailbox  */
        status =rtems_message_queue_send(Msg_id[mBox],MsgToSend,
                                         (rtems_unsigned32)MsgLenght);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);

}



/*****************************************************************************/
/* @Function: OS_piMsgQueueReceive                                           */
/* @Purpose :                                                                */
/*  The function receives a message from the message queue specified in mBox */
/*  parameter. The WAIT and NO_WAIT options of the -OptionSet- parameter     */
/*  allow the calling task to specify whether to wait for a message to become*/
/*  available o return immediately. The -Timeout- parameter specifies the    */
/*  timeout value for WAIT option. If NO_TIMEOUT value is set the calling    */
/*  task wait forever.                                                       */
/*  The RTEMS directive is called to performs the receive message.           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  mBox                 IN      Mailbox ID                                  */
/*  OptionSet            IN      WAITt and NO_WAIT option                    */
/*  Timeout              IN      Timeout value for Wait option               */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  MsgToRx              OUT     Buffer pointer where message is returned    */
/*  MsgSize              OUT     Size pointer where message size is returned */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piMsgQueueReceive ( unsigned int  mBox,
                                   void*         MsgToRx,
                                   unsigned int* MsgSize,
                                   unsigned int  OptionSet,
                                   unsigned int  Timeout)
{
rtems_status_code status;
    
    /* Check Mailbox queue address validity                           */
    if(mBox < MAX_MBOX)
    {
        /* RTEMS directive to receive message from the message queue  */
        status =rtems_message_queue_receive(Msg_id[mBox],MsgToRx,
                                            (rtems_unsigned32 *)MsgSize,
                                            OptionSet,Timeout);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
    
}



/*****************************************************************************/
/* @Function: OS_piPartGetBuffer                                             */
/* @Purpose :                                                                */
/*  The function allows a buffer to be obtained from the partition specified */
/*  in -Part- parameter.                                                     */
/*  The RTEMS directive is called to performs the get buffer from a          */
/*  partition.                                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Part                 IN      Partition ID                                */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  pBuf                 OUT     Partition buffer pointer returned           */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piPartGetBuffer ( unsigned int Part,
                                 void**       pBuf)
{
rtems_status_code status;

    /* Check partition ID validity       */
    if(Part < MAX_PART)
    {
        switch (Part)
        {
            case MA_TAB_PART :
                /* MCMD timetag list partition  */
                *pBuf =&MA_Partition[0];
                status =SUCCESSFUL;
                break;
            case MA_PART_IM :
            case MA_PART_TT :
                /* MCMD timetag partition       */
                status =rtems_partition_get_buffer(Part_id[Part],pBuf);
#ifdef DEBUG
		//		if(status==RTEMS_SUCCESSFUL) {
		//  for (i=0;i<OS_MAX_PARTITIONS_STORE && max_partitions_stored;i++)
#endif
	
		  
                break;
            default:
                status =RTEMS_INVALID_ID;
                break;
        }
            
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}



/*****************************************************************************/
/* @Function: OS_piPartReturnBuffer                                          */
/* @Purpose :                                                                */
/*  The function returns the buffer specified to the partition.              */
/*  The RTEMS directive is called to performs the return buffer to a         */
/*  partition.                                                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Part                 IN      Partition ID                                */
/*  pBuf                 IN      Partition buffer pointer released           */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piPartReturnBuffer ( unsigned int Part,
                                    void*        pBuf)
{
rtems_status_code status;
    
    /* Check partition ID validity       */
    if(Part < MAX_PART)
    {
        switch (Part)
        {
            case MA_TAB_PART :
                break;
            case MA_PART_IM :
            case MA_PART_TT :
                /* MCMD timetag partition       */
                status =rtems_partition_return_buffer(Part_id[Part],pBuf);
                break;
            default:
                status =RTEMS_INVALID_ID;
                break;
        }
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
    
}



/*****************************************************************************/
/* @Function: OS_piResourceObtain                                            */
/* @Purpose :                                                                */
/*  The function acquires the semaphore specified in the -Res- parameter.    */
/*  The WAIT and NO_WAIT options of the -OptionSet- parameter allow          */
/*  the calling task to specify whether to wait for a message to become      */
/*  available o return immediately. The -Timeout- parameter specifies the    */
/*  timeout value for WAIT option. If NO_TIMEOUT value is set the calling    */
/*  task wait forever.                                                       */
/*  The RTEMS directive is called to performs the semaphore acquisition.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Res                  IN      Semaphore ID                                */
/*  OptionSet            IN      WAIT and NO_WAIT option                     */
/*  Timeout              IN      Timeout value for Wait option               */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piResourceObtain ( unsigned int Res,
                                  unsigned int OptionSet,
                                  unsigned int Timeout)
{
  rtems_status_code status;
  if(rtems_interrupt_is_in_progress()) {
    /*@LOG OS_piResourceObtain during interrupt. this is a bug! */
    LU_INFN_LOG(LU_INTERNAL,LU_MASK(__FILEID__),__FILEID__,__LINE__,0xffff);
    return CM_RC_INTERRUPT_IS_IN_PROGRESS;
  }
  /* Check semaphore ID validity                       */
  if(Res < MAX_RES)
    { 
      /* RTEMS directive to obtain semaphore resource  */
      status =rtems_semaphore_obtain(Sem_id[Res], OptionSet, Timeout);
      if(status)
	/*@LOG OS_piResourceObtain: error code - status */
	LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
    }
  else
    {
      status =RTEMS_INVALID_ID;
    }
  return (status);
}
 
 
 
/*****************************************************************************/
/* @Function: OS_piResourceRelease                                           */
/* @Purpose :                                                                */
/*  The function releases the semaphore specified in the -Res- parameter.    */
/*  The RTEMS directive is called to performs the semaphore release.         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Res                  IN      Semaphore ID                                */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piResourceRelease ( unsigned int Res )
{
rtems_status_code status;

    /* Check semaphore ID validity                       */
    if(Res < MAX_RES)
    { 
        /* RTEMS directive to release semaphore resource */
        status =rtems_semaphore_release (Sem_id[Res]);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
    
}



/*****************************************************************************/
/* @Function: OS_piStartTimer                                                */
/* @Purpose :                                                                */
/*  The function initiates the timer specified by -Tim- parameter.           */
/*  The timer is scheduled to fire after a time interval expressed in system */
/*  ticks into -Time- parameter. When the timer fires, the timer service     */
/*  routine will be invoked with user data.                                  */
/*  The RTEMS directive is called to performs the start timer after interval.*/
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Tim                  IN      Timer ID                                    */
/*  Time                 IN      Interval time                               */
/*  Routine              IN      Pointer to timer service routine            */
/*  UserData             IN      Pointer to user data                        */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piStartTimer ( unsigned int Tim,
                              unsigned int Time,
                              void*        Routine,
                              void*        UserData)
{
rtems_status_code status;
    
    /* Check timer ID validity                */
    if (Tim < MAX_TIM)
    {  
        /* RTEMS directive to start timeer    */
        status =rtems_timer_fire_after(Tim_id[Tim],Time,Routine,UserData);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);

}



/*****************************************************************************/
/* @Function: OS_piCancelTimer                                               */
/* @Purpose :                                                                */
/*  The function cancels the timer specified by -Tim- parameter.             */
/*  The RTEMS directive is called to performs the timer cancelation          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Tim                  IN      Timer ID                                    */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piCancelTimer ( unsigned int Tim)
{
rtems_status_code status;
    
    /* Check timer ID validity               */
    if (Tim < MAX_TIM)
    {  
        /* RTEMS directive to cancel timer   */
        status =rtems_timer_cancel(Tim_id[Tim]);
    }
    else
    {
        status =RTEMS_INVALID_ID;
    }
    return (status);
}



/*****************************************************************************/
/* @Function: OS_piIsrCatch                                                  */
/* @Purpose :                                                                */
/*  The function establishes an interrupt service routine (ISR) fotr the     */
/*  specified interrupt vector number.                                       */
/*  The RTEMS directive is called to performs the establish an ISR           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  IsrHandler           IN      Pointer to ISR handler                      */
/*  Vector               IN      Vector interrupt number                     */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/*  OldIsrHandler        OUT     Previous pointer to ISR handler             */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piIsrCatch ( void*        IsrHandler,
                            unsigned int Vector,
                            void**       OldIsrHandler)
{
rtems_status_code   status;
    
    /* RTEMS directive to establish an interrupt ISR */
    status =rtems_interrupt_catch( (rtems_isr_entry) IsrHandler,
                                   (rtems_vector_number) Vector,
                                   (rtems_isr_entry*) &OldIsrHandler);
    return (status);

}

/*****************************************************************************/
/* @Function: OS_piInterEnable                                               */
/* @Purpose :                                                                */
/*  The function enable the interrupt specified in -Level- parameter.        */
/*  The RTEMS directive is called to performs the establish an ISR           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Level                IN      Interrupt type                                            */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piInterEnable ( unsigned int Level )
{

    /* RTEMS directive to enable interrupt    */
    rtems_interrupt_enable(Level);
    return (RTEMS_SUCCESSFUL);

}



/*****************************************************************************/
/* @Function: OS_piInterDisable                                              */
/* @Purpose :                                                                */
/*  The function disable the interrupt specified in -Level- parameter.       */
/*  The RTEMS directive is called to performs the establish an ISR           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Level                IN      Interrupt type                              */
/*  status_code          OUT     Return code (RTEMS directive status code)   */
/* @@                                                                        */
/*****************************************************************************/

status_code OS_piInterDisable ( unsigned int *Level)
{

    /* RTEMS directive to disable interrupt   */
    rtems_interrupt_disable(*Level);
    return (RTEMS_SUCCESSFUL);
}
