<?xml version="1.0" encoding="UTF-8"?>    <!-- Prologo XML -->
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">   <!-- Dichiarazione del documento XSLT -->
<!--    <xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"> -->
    
<!--    
=====================================================================================
 Stylesheet: RunHeaderTemplate.xsl
    Version: 1.0 (2005-03-14)
     Author: Maurizio Nagni
     Descr.: Format the output of the RunHeaderToXml.c script to generate a human 
             readble verion of the ArrDump packet
=====================================================================================
-->
    
<!--Contains some utility to converts dec/hex/bin numbers-->
<xsl:include href="numberutils_lib.xsl"/>

<!--Contains all the customer specific parameters-->
<!--<xsl:include href="Configure.xsl"/>-->
   
   <!-- Define which a key called "varDes" 
   	which will search inside the node "var" of the reference
   	ArrDumpInfo.xml (or whatever file instead of the is used)
	all values values of the node "idx" matching the valued passed when 
	the key "fileName" is called -->
   <!-- No xml file is defined here because the xsl:key is absolutely generic -->
<!--   <xsl:key name="arrDes" match="arr" use="idx"/>

   <xsl:template match="/" name="ArrDumpReference">
     <xsl:param name="code"/>
     <xsl:param name="arrval"/>
     <xsl:for-each select="document('./compilationInfo/PRH_ParamHandler_INFN_auto.arr.xml')">
       <xsl:for-each select="key('arrDes', $code)">
	 <td> <th align="left"><xsl:value-of select="name"/><xsl:text>(</xsl:text><xsl:value-of select="idx"/><xsl:text>)</xsl:text> </th> </td>
	 <td> <th align="left"><xsl:copy-of select="$arrval"/></th> </td>
	 <td> <th align="left"><xsl:value-of select="comment"/></th> </td>
       </xsl:for-each> 
     </xsl:for-each>
   </xsl:template>
-->
   <xsl:template match="/" name="ArrDumpTemplate">
     <html>
       <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:12pt">
	 <h2>RunHeader Event</h2>
	 <table border="1">
	   <tr bgcolor="#1acd32">
	     <th align="center">Packet OBT</th>
	     <th align="center">Packet Num</th>
	     <th align="center">Acq_Sett_Mode</th>
	     <th align="center">TimeSync (OBT)</th>
	     <th align="center">Last TimeSync Info</th>
	     <th align="center">Fav. Wrk Schedule</th>
	     <th align="center">Eff. Wrk Schedule</th>
	     <th align="center">VarTrig Mode A Schedule</th>
	     <th align="center">VarTrig Mode B Schedule</th>
	     <th align="center">Acq After Calib</th>
	     <th align="center">Trk Calib Used</th>
	     <th align="center">Acq Build Info</th>
	     <th align="center">Acq Var Info</th>
	     <th align="center">Cal DSP Mask</th>
	   </tr>
	   <xsl:for-each select="//RUN_HEADER_EVENT">
	     <tr>
	       <td><xsl:value-of select="PACKET_OBT"/>        </td>
	       <td><xsl:value-of select="PACKET_NUM"/>        </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="RM_SETT_MODE"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="OBT_TM_SYNC"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="LAST_TM_SYNC_INFO"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="FAV_WRK_SCHEDULE"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="EFF_WRK_SCHEDULE"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="PRH_VAR_TRIG_A"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="PRH_VAR_TRIG_B"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="RM_ACQ_AFTER_CALIB"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="TRK_CALIB_USED"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="ACQ_BUILD_INFO"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="ACQ_VAR_INFO"/>
		 </xsl:call-template>
	       </td>
	       <td>
		 <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="CAL_DSP_MASK"/>
		 </xsl:call-template>
	       </td>
	     </tr>	
<!--
		 <td>
		 <xsl:text>0x</xsl:text>
		  <xsl:call-template name="Dec2Hex">
              	     <xsl:with-param name="value" select="INFO1"/>
            	   </xsl:call-template>
		  <xsl:value-of select="INFO1"/>
		 </td>
-->
	  </xsl:for-each>
  	 </table>
       </body>
     </html>
   </xsl:template>
 
 </xsl:stylesheet>