#include <TObject.h>
#include <TFile.h>
#include <TObjString.h>
#include <TString.h>
#include <TTree.h>
#include <TArrayC.h>


using namespace std;
class DataItem : public TObject{
 public:
  string fileName;
  DataItem() : TObject(){}
  ~DataItem() {}
  
  virtual const char* toXML(char* tab = "") {}
  virtual void  fill(TArrayC*) {}
};

class McmdItem : public DataItem{
  public:
    string fileName;
    McmdItem() : DataItem(){}
    ~McmdItem() {}
    
    virtual const char* toXML(char* tab = "") {}
    virtual void  fill(TArrayC*) {}
};

class ElseItem : public McmdItem{
private:

 public:
  ElseItem::ElseItem() : McmdItem(){}
  ElseItem::~ElseItem() {}

  const char* ElseItem::toXML(char*);
  void  ElseItem::fill(TArrayC*) { }
};

class DownLinkItem : public McmdItem{
 public:
  unsigned int   rawModeSectors; // From 4 to 2048 sector to Downlink in RAW mode
  unsigned short rawMode;        // 0 = NormalMode         1 = RawMode
  unsigned short tmSel;          // 0 = TM I/F A       other = TM I/F B
  unsigned short fileId;         // 0 = File 1             1 = File 2
  unsigned int   orbitNumber;    // Number of the orbit
  unsigned short spareAdapt;     // Number of the orbit

  DownLinkItem() : McmdItem(){}
  ~DownLinkItem() {}
  
  void fill(TArrayC* data){ }
  const char* toXML(char*);
};


class TimeSyncItem : public McmdItem{
 public:
  unsigned int newTime;
  TimeSyncItem() : McmdItem(){}
  ~TimeSyncItem()  {}
  
  void fill(TArrayC* data);
  const char* toXML(char*);
};

class OrbitalInfoItem : public McmdItem{
 public:
  double time;
  
  /* Position in Km */
  /*pos[0] = pos_X*/
  /*pos[1] = pos_Y*/
  /*pos[2] = pos_Z*/
  double pos[3];
  
  /* Velocity in Km/s */
  /*vel[0] = vel_X*/
  /*vel[1] = vel_Y*/
  /*vel[2] = vel_Z*/
  double vel[3];
  
  OrbitalInfoItem() : McmdItem(){}
  ~OrbitalInfoItem()  {}
  
  void fill(TArrayC* data);
  const char* toXML(char*);
};

class InclinationInfoItem : public McmdItem{
 public:
  /* Quaternions Lx_y
  / The data are organized in 5 groups according to the format
  / time    -   L0       -     L1     -     L2     -     L3
  / time[0] - quat[0][0] - quat[0][1] - quat[0][2] - quat[0][3]
  / time[1] - quat[1][0] - quat[1][1] - quat[1][2] - quat[1][3]
  / time[2] - quat[2][0] - quat[2][1] - quat[2][2] - quat[2][3]
  / time[3] - quat[3][0] - quat[3][1] - quat[3][2] - quat[3][3]
  / time[4] - quat[4][0] - quat[4][1] - quat[4][2] - quat[4][3]
  / time[5] - quat[5][0] - quat[5][1] - quat[5][2] - quat[5][3]
  */
  double time[6];
  double quat[6][4];
  
  InclinationInfoItem() : McmdItem(){}
  ~InclinationInfoItem()  {}
  
  void fill(TArrayC* data);
  const char* toXML(char*);
};

//For now i dont store the Parameters sequence
class SelectOpModeItem : public McmdItem{
 public:
  unsigned short mode;
  unsigned short paramNumber;
  SelectOpModeItem() : McmdItem(){}
  ~SelectOpModeItem() {}

  void fill(TArrayC* data);
  const char* toXML(char*);
};

class BiteItem : public McmdItem{
 public:
  unsigned int fillerWord;
  BiteItem::BiteItem() : McmdItem(){}
  BiteItem::~BiteItem();

  void fill(TArrayC* data);
  const char* toXML(char* tab);
};


class McmdScan {
 private:
  //In compiled version will use the std::map
  McmdItem *mcmdItem;

 public:
 McmdScan::McmdScan() {}
 const char* McmdScan::extract(TArrayC *data, int id, char* tabs);
};
