/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  TM_TCManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: TM_TMTCManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: TM_TMTCManager_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.7  2004/03/08 15:49:09  alfarano
/*  improved handling functions for FE
/*
/*  Revision 1.6  2004/03/01 17:46:50  tassa
/*  Non testato:
/*  TMTC sample e STORE in SCM
/*  send FECMD bloccante
/*  aggiunto MCMD to send FECMD
/*
/*  Revision 1.5  2004/01/29 11:53:13  alfarano
/*  semaphores in gettmvalue
/*
/*  Revision 1.4  2003/12/05 13:15:39  sebastiani
/*  TMTC writing in the RTF
/*
/*  Revision 1.3  2003/11/04 11:36:35  alfarano
/*  deleted task in TM_TMTC manager and added to HK_Manager, added KHB buffer read task
/*
/*  Revision 1.2  2003/09/16 12:46:40  carota
/*  functions protected by senaphore / KHB func added
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.5  2002/10/25 09:02:55  zulia
/*  added the pi for send a sequence of 1-16 ML
/*
/*  Revision 1.4  2002/05/09 08:16:35  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_p.h>
#include <src/TM_TCManager/TMTCManager/TM_TMTCManager_op.h>

/*****************************************************************************/

/*= A n t e n n a C o n t r o l l e r  P R O V I D E D    I N T E R F A C E =*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: TM_piInitTMTCManager                                           */
/* @Purpose :                                                                */
/*  Provided Interface to implement the TM/TC Manager initialization.        */
/*  No parameters are requested.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piInitTMTCManager (void)
{
status_code status;

    status =TM_opInitTMTCManager();
    return (status);

}


/*****************************************************************************/
/* @Function: TM_piGetTMValue                                                */
/* @Purpose :                                                                */
/*  The provided interface returns a telemetry value read from the current   */
/*  or cyclic acquisition.                                                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   Code                IN      Telecommand code                            */
/*   RdMode              IN      Reading mode (TM_CURRENT_VAL,TM_CYCLIC_VAL) */
/*   status_code         OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piGetTMValue (unsigned int  Code, unsigned int RdMode,
                             unsigned int* Value)
{
  status_code status;
  
  status = TM_opGetTMValue (Code,RdMode,Value);
  return (status);
}

/*****************************************************************************/
/* @Function: TM_piGetKHBValue                                               */
/* @Purpose :                                                                */
/*  The function gets nWords 16 bit words from the serialID TMTC serial line */
/*  and writes them in the buffer pointet by pBuffer. The sequence of reads  */
/*  from the selected serial line cannot be interrupted by the automatic acq.*/
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   serialID            IN      serial line identifier                      */
/*   pBuffer             IN      pointer to the buffer                       */
/*   nWords              IN      # of words to read from the serial line     */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piGetKHBValue (unsigned int serialID, unsigned short * pBuffer,  unsigned char nWords)
  {
    status_code status;

    status = TM_opGetKHBValue (serialID, pBuffer, nWords);
    
    return (status);
  }



/*****************************************************************************/
/* @Function: TM_piGetAllTMValue                                             */
/* @Purpose :                                                                */
/*  The provided interface returns all telemetry values read from the        */
/*  cyclic acquisition.                                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*   Code                IN      Telecommand code                            */
/*   RdMode              IN      Reading mode (TM_CURRENT_VAL,TM_CYCLIC_VAL) */
/*   status_code         OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piGetAllTMValue (void * AllTmValue)
{
status_code status;

    status =TM_opGetAllTMValue (AllTmValue);
    return (status);
}


/*****************************************************************************/
/* @Function: TM_piSendTC                                                    */
/* @Purpose :                                                                */
/*  The provided interface sends a telecommand.                              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Code                 IN      Telecommand code                            */
/*  Value                IN      Value                                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piSendTC (unsigned int  Code, unsigned int Value)
{
status_code status;

    status =TM_opSendTC (Code,Value);
    return (status);
}

/*****************************************************************************/
/* @Function: TM_piSendMLTC                                                  */
/* @Purpose :                                                                */
/*  The provided interface sends a MemoryLoad Telecommand.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Code                 IN      Telecommand code                            */
/*  Value                IN      Value                                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code TM_piSendMLTC (TM_TC_ML* Sequence, unsigned int Length)
{
status_code status;

    status =TM_opSendMLTC (Sequence, Length);
    return (status);
}
