/****************************************************************************
  *  F i l e   D a t a                                                        
  *                                                                           
  *  Module       : LabenInterface                                      
  *  C.I. No.     :                                                           
  *  $Revision: 1.1.1.1 $
  *  $Date: 2006/04/25 09:00:20 $
  *  Belonging to :                                                           
  *  $Id: IN_InitManager_INFN_op.c,v 1.1.1.1 2006/04/25 09:00:20 kusanagi Exp $
  *  $RCSfile: IN_InitManager_INFN_op.c,v $
  *  Program Type :                                                           
  *  Sub-modules  :                                                           
  *                                                                           
  ****************************************************************************
  *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
  *                                                                           
  *  Host system  :                                                           
  *  SW Compiler  :                                                           
  *  $Author: kusanagi $
  *               :                                                           
  ****************************************************************************
  *  U p d a t i n g                                                          
  *                                                                           
  *  $Log: IN_InitManager_INFN_op.c,v $
  *  Revision 1.1.1.1  2006/04/25 09:00:20  kusanagi
  *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
  *
  *  Revision 1.22  2004/11/18 16:02:34  sebastiani
  *  GAS/TRD removed
  *
  *  Revision 1.21  2004/11/10 17:00:00  sebastiani
  *  - GS_COMPILE directive introduced and be undef by default
  *  - automatic flush mechanism by run manager mailbox timeout
  *
  *  Revision 1.20  2004/09/28 15:36:25  sebastiani
  *  interrupt manager fix
  *
  *  Revision 1.19  2004/08/26 16:54:34  sebastiani
  *  version work fine
  *
  *  Revision 1.18  2004/08/13 14:42:19  sebastiani
  *  Add Neutron detector!
  *  need add file ND_READ_ACQ.dat on site ...
  *
  *  Revision 1.17  2004/07/27 17:30:17  faber
  *  OBT can be now in second or milliseconds, depending of the situazion.
  *  OBT_s is used for FM compatibility, OBT_ms basically for MM infos
  *
  *  Revision 1.16  2004/05/27 17:50:40  sebastiani
  *  *** empty log message ***
  *
  *  Revision 1.15  2004/05/12 14:46:14  faber
  *  *** empty log message ***
  *
  *  Revision 1.14  2004/05/10 12:59:17  faber
  *  __FILEID__ right value fixed: many .c files had the wrong value!
  *
  *  Revision 1.13  2004/04/20 14:51:16  alfarano
  *  #ifdef temporaneo su TRK
  *
  *  Revision 1.12  2003/12/07 17:38:02  faber
  *  several tests more in TS_PamManager (as requested by Marco Casolino)
  *
  *  Revision 1.11  2003/11/24 10:57:33  alfarano
  *  gas system function
  *
  *  Revision 1.10  2003/11/19 15:47:03  faber
  *  System Control Manager (SCM) and Power Handler (PWR) modules introduced
  *
  *  Revision 1.9  2003/10/29 08:32:26  sebastiani
  *  *** empty log message ***
  *
  *  Revision 1.8  2003/10/28 18:31:24  sebastiani
  *  Some fix about the KHB driver
  *
  *  Revision 1.7  2003/10/17 09:54:22  sebastiani
  *  all needed include files for some FEs introduced (S4,CAL,AC...)
  *
  *  Revision 1.6  2003/09/24 13:44:14  faber
  *  New list initialization: all detectors added
  *
  *  Revision 1.5  2003/09/23 09:41:29  faber
  *  CH_CommandHandler and autogeneration gen_params.pl introduced
  *  some dummy file in src/INFN/commands/
  *
  *  Revision 1.4  2003/09/19 15:57:35  faber
  *  Large development update INFN software
  *
  *  Revision 1.3  2003/09/15 17:46:27  faber
  *  HB_HKBuffer_INFN module introduced.
  *
  *  Revision 1.2  2003/08/22 07:57:08  sebastiani
  *  *** empty log message ***
  *
  *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
  *  Imported sources laben rel. 19.06.2003 integrated with pam2
  *
  *  Revision 1.5  2003/06/18 07:49:33  sebastiani
  *  initialization of RunManager added
  *
  *  Revision 1.4  2003/06/09 16:57:43  sebastiani
  *  fix include directory path
  *
  *  Revision 1.3  2003/06/05 10:31:12  wizard
  *  added PamMnager (empty skeleton),and other main dirs on INFN
  *
  *  Revision 1.2  2003/05/29 14:35:58  wizard
  *  Added:
  *  	#include <src/INFN/TestUtility/Test/TS_Test_INFN_p.h>
  *  	FS## 29.5.03 comments
  *  	TS_piTestInit_INFN();
  *
  *  Revision 1.1.1.1  2003/05/27 08:13:24  wizard
  *  Import of the Official Laben CD Release Software as the  pamela-EM_delivery_20030521_1454.tar.bz2
  *
  *  Revision 1.2  2002/06/07 14:47:39  ale
  *  added dataquality Init
  *
  *  Revision 1.1  2002/06/06 08:30:04  ale
  *  Added files
  *                                                           
  ****************************************************************************/

/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _IN_InitManager_INFN_op__c
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();


#include <src/INFN/IN_InitManager_INFN_op.h>
#include <src/INFN/OS_rtems_INFN_p.h>
#include <src/INFN/PM_PamManager_INFN.h>
#include <src/INFN/RM_RunManager_INFN.h>
#include <src/INFN/DAQ_IDAQ_INFN.h>
#include <src/INFN/TRK_Tracker_INFN.h>
//# include <src/INFN/TS_Test_INFN.h>
#include <src/INFN/KHB_Driver_INFN.h>
#include <src/INFN/SMH_SelectModeHandler_INFN.h>
#include <src/INFN/WS_WorkingSchedule_INFN.h>
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/MH_ModeHandler_INFN.h>
#include <src/INFN/CH_CommandHandler_INFN_auto.h>
#include <src/INFN/CH_CommandHandler_INFN.h>
#include <src/INFN/AC_Anticoincidence_INFN.h>
#include <src/INFN/CAL_Calorimeter_INFN.h>
#include <src/INFN/S4_INFN.h>
#include <src/INFN/TOF_TimeOfFlight_INFN.h>
#include <src/INFN/TRD_TransRadDetector_INFN.h>
#include <src/INFN/HK_Manager_INFN.h>
#include <src/INFN/SCM_Manager_INFN.h>
#include <src/INFN/GS_Gas_INFN.h>
#include <src/INFN/TRK_Tracker_INFN.h>
#include <src/INFN/SNS_SensorsBoard_INFN.h>
#include <src/INFN/TRG_Trigger_INFN.h>
#include <src/INFN/CM_Common_INFN.h>

#ifdef TEST_I
// #include <src/TestUtility/Test/TS_Test_p.h>
// #include <src/INFN/TS_Test_INFN.h>
#endif

void IN_opInitAllSystem_INFN()
{


    OS_piInitOS_INFN();
    CM_Init();
    CH_auto_Init();
    CH_Init();
    LU_Init();
    
    KHB_Init();
    HB_Init();
    SNS_Init();

    /* Pam manager related module initialization: */
    PM_InitPamManager_INFN();

    SMH_Init();
    MH_Init();
    WS_Init();

#ifdef SIMULATOR
    PM_SIM_Init();
#endif
    
    
    /* Run manager related module initialization: */
    RM_InitRunManager_INFN();
    DAQ_Init();
    /* FEs initialization */
    AC_Init();
    CAL_Init();
    S4_Init();
    TOF_Init();

    TRK_Init();
    TRG_Init();
    //     ND_Init();
    /* HK Manager */
    HK_InitHKManager();    
    
    /* System Control Manager */
    SCM_InitSCManager();    

#ifdef TEST_I
    //    TS_TestInit_INFN();
#endif



}
