

/**
* TmtcTemperature
* author Marcelli
* version 1.1 - 10 December 2005
*
* Version 1.2 - 28 December 2004
* If TFile does not exist the function exit to prompt
* If nevents = 0 the function exit to promt
* Initialize to 0 alla array dedicated to graphs
*
* version 1.3 - 22 February 2005 - Nagni
* For compatibility with batch mode excution:
* 1) Added "include <iostream>" and "using namespace std" 
* 2) Removed gROOT->Reset()
*
* version 1.4 - 25 February 2005 - Marcelli
* Canvas of thermistors divided in 12 pads
*
* Version 1.5
* Date 08 March 2005 - Nagni
* Added "format" parameter for saving the produced image in various formats
* (for a complete list of types refer to TPad::SaveAs method)
*
* version 1.6 
* Date 24 May 2005 - Marcelli
* Added four thermistor (files after DW_050516_007 has 16 thermistors instead of 12)
*
* version 1.7
* Date 02 February 2006 - Marcelli
* Modified to work with new version of YODA
*
* version 1.8 
* Date March 2006 - Marcelli
* For compilation: 
*     Added function "int main(int argc, char* argv[])"
*
* Description : To monitor information from TMTC Packet (voltage, CC,....)
*
* Parameters:
* 	TString base 	- the path to the root directory for the specific Pamela unpack session 
*	TString outDir  - the path where to save the output image (Default = base) 
*       TString format  - the format which will be used fo rsave the produced images (Default = "jpg") 
*
*/




#include <iostream>
#include <sstream>
#include "TStyle.h"
#include "TFile.h"
#include "TAxis.h"
#include "TLegend.h"
#include "TF1.h"
#include "TList.h"
#include "TTree.h"
#include "TObjString.h"
#include "TCanvas.h"
#include "TGraph.h"
#include "TMultiGraph.h"
#include "TH1F.h"
#include "TGaxis.h"
#include "TString.h"
#include "TPaveText.h"
#include "tmtc/TmtcEvent.h"
#include "tmtc/TmtcRecord.h"


using namespace std;

///////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////FUNZIONI DI CONVERSIONE///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////


//reference: Laben Document, TL 18348, pag. 79
float convert_th(int TH) {

  float a,q,deltax,deltay;
  float gradi[111],grado=-1;
  int adc[111]={4095, 3868, 3654, 3454, 3265, 3088, 2922, 2765, 2618, 2479, 2348, 2225, 2110, 2000, 1897, 1800, 1709, 1622, 1541, 1464, 1391, 1322, 1257, 1196, 1138, 1083, 1031, 981, 935, 890, 849, 809, 771, 736, 702, 670, 639, 610, 583, 557, 532, 508, 486, 464, 444, 425, 406, 389, 372, 356, 341, 327, 313, 300, 288, 276, 264, 254, 243, 233, 224, 215, 206, 198, 190, 183, 175, 169, 162, 156, 150, 144, 138, 133, 128, 123, 118, 114, 110, 106, 102, 98, 94, 91, 87, 84, 81, 78, 75, 73, 70, 67, 65, 63, 60, 58, 56, 54, 52, 50, 49, 47, 45, 44, 42, 41, 39, 38, 37, 35, 34};
  int maxpos=-1,minpos=-1,i;
  
  for (i=0;i<111;i++)
    {
      gradi[i]=-35+i;
    }
  
  if (TH > 4095) 
    {
      grado=100.;
      return grado;
    }
  
  if (TH <= 34) 
    {
      grado=100.;
      return grado;
    }  
  
  
  if (TH==4095) 
    {
      grado=-35.;
      return grado;
    }
  else
    {
      
      for (i=1;i<111;i++)
	{
	  if (TH>=adc[i]) 
	    {
	      minpos=i;
	      maxpos=i-1;
	      break;
	    }
	}
      deltax=adc[maxpos]-adc[minpos];
      deltay=gradi[maxpos]-gradi[minpos];
      a=deltay/deltax;
      q=gradi[maxpos]-a*adc[maxpos];
      grado=a*TH+q;		
    }
  return (grado);
}



//reference: Laben Document, TL 18348, pag. 76
float convert_volt(int in) {

  float a,q,deltax,deltay;
  float inputvoltage[52],voltage=-1;
  float adc[52];
  int maxpos=-1,minpos=-1,i;
  
  for (i=0;i<52;i++)
    {
      inputvoltage[i] = (i*0.10);
    }
  for (i=0;i<52;i++)
    {
      adc[i] = (i*5);
    }

  if (in==0) 
    {
      voltage= 0.00;
    }
  else
    {
      
      for (i=0;i<52;i++)
	{
	  if (in<=adc[i]) 
	    {
	      minpos=i;
	      maxpos=i-1;
	      break;
	    }
	}
      deltax=adc[maxpos]-adc[minpos];
      deltay=inputvoltage[maxpos]-inputvoltage[minpos];
      a=deltay/deltax;
      q=inputvoltage[maxpos]-a*adc[maxpos];
      voltage=a*in+q;		
    }
  return (voltage);

}


////////////////////////////////////////////////////////////////////////////////
//////////////////////////  TMTC TEMPERATURE   //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void TmtcTemperature(TString base, TString outDir, TString format){
  
  //------- load root file --------------
  TFile  *file  = new TFile(base.Data());
	
  if ( outDir == "" ) outDir = ".";

  if (!file){
    printf("No such file in the directory has been found");
    return;
  }

  //--- Takes the tree of Tmtc -----------
  TPaveText *pt=0;
  TPaveText *pt1=0;

  TTree *tr = (TTree*)file->Get("Tmtc");
  TBranch *tmtcBr = tr->GetBranch("Tmtc");
 
  pamela::TmtcEvent *tme=0;
  pamela::TmtcRecord *tmr=0; 
  
  tr->SetBranchAddress("Tmtc", &tme);
  
  //////--------to analize data-----------------//////
  Long64_t nevents = tmtcBr->GetEntries();
  if (nevents<=0) {
    file->Close();
    printf("nevents =  %i", nevents);
    return;
  }

string titolocc[] ={"IPM1 input","IPM2 input","IPM3 input","IPM4 input","IPM5 input","IPM6 input","KHB_HOT","KHB_COLD","IDAQ_HOT","IDAQ_COLD","VCB_STANDBY","VRL_HOT","VRL_COLD","PSB","TOFHV_HOT","TOFHV_COLD"};
 
 string titoloth[]	={"IPM_TH","S1_TH","S4_TH","S4_ND_PLATE_TH","TRK_TH1","TRK_TH2","FLUID_IN_TH","FLUID_OUT_TH","VME_TH1","DCDC_TH","CPU_TH1","CPU_TH2", "IPM_CPU_TH", "VRL_TH1", "VRL_TH2", "VME_TH2"}; 


  const Int_t size = nevents;
  std::stringstream oss;
  Int_t recordstot=0;
  Int_t recordstotmax=0;
  Int_t records[size];
  Int_t ev[size];
  Double_t OBT[size];
  Int_t tot=0;
  Int_t m=0;
  Int_t l=0;


  for (Int_t i = 0; i < size; i++){    ///ciclo per decidere le pagine
    tmtcBr->GetEntry(i);  
    Long64_t tmpSize = tme->Records->GetEntries();
    recordstot=recordstot+tmpSize;
    if (tmpSize>0){
      tmr = (pamela::TmtcRecord*)tme->Records->At(0);
      if(i==0){
	ev[0]=0;
	records[0]=0;
	OBT[0]=tmr->TM_RECORD_OBT;
      }else if (fmod(i, 30)==0 || ((tmr->TM_RECORD_OBT)<OBT[i-1]) || (i==(size-1)) ){
	//}else if ((fmod(i, 20)==0) || (i==(size-1)) ){
	tot=tot+1;
	if (recordstotmax<recordstot) recordstotmax=recordstot;
	records[tot]=recordstot;
	OBT[tot]=tmr->TM_RECORD_OBT;
	ev[tot]=i;
	recordstot=0;
      }
    }
  }  


  const Int_t lungmax=16*recordstotmax;
  const Int_t lungmin=6*recordstotmax; 
   
  Float_t xrecordobtcc[lungmax], yccdiagacq[lungmax], ythana[lungmax], xrecordobtth[lungmax], xrecordobtdea[lungmin], ydea[lungmin], xrecordobtcc_1[lungmax], xrecordobtcc_1d[lungmax], xrecordobtcc_1u[lungmax], yccdiagacq_1[lungmax], yccdiagacq_1d[lungmax], yccdiagacq_1u[lungmax],  ythana_1[lungmax], xrecordobtth_1[lungmax], xrecordobtdea_1[lungmin], ydea_1[lungmin];  
   
  Float_t yccdiagacq_11u[lungmax], yccdiagacq_11d[lungmax], yccipm12u[lungmax], yccipm12d[lungmax], yccipmkk1u[lungmax], yccipmkk1d[lungmax], yccipmerror[lungmax],  yccipmerror2[lungmax];
 

 /////ciclo sulle pagine////////////////////
 for (Int_t interval=0; interval<tot; interval++){
   
 ///-------to create canvas--------------------//
   TCanvas *Canvascc = new TCanvas("Tmtc_1", base, 2500, 2000);
   Canvascc->Divide(1,15);
   Canvascc->SetFillColor(10);
   
   TCanvas *Canvasthdea = new TCanvas("Tmtc_4", base, 1280, 1024);
   Canvasthdea->SetFillColor(10);
   Canvasthdea->Divide(4,4);
  
   TCanvas *Canvasvoltdea = new TCanvas("Tmtc_5", base, 1280, 1024);
   Canvasvoltdea->SetFillColor(10);
   Canvasvoltdea->Divide(2,3);
   
   
   recordstot=0;
   
   for (Int_t i = ev[interval]; i < ev[interval+1]; i++){     //ciclo su un sottogruppo
     // cout<<"ciclo da "<<ev[interval]<<" a "<< ev[interval+1]<<"\n";

     tmtcBr->GetEntry(i);  
     l=0;
     m=0;
     Long64_t tmpSize = tme->Records->GetEntries();  
     Int_t size_b = tmpSize; 
     for (Int_t j = 0; j < size_b; j++){
       tmr = (pamela::TmtcRecord*)tme->Records->At(j);
       
       for (Int_t k =0; k <16; k++){
	 yccdiagacq[16*recordstot+16*j+k]   = (((tmr->TM_DIAG_AND_BILEVEL_ACQ)>>(15-k))&0x0001); 	
	 xrecordobtcc[16*recordstot+16*j+k] = tmr->TM_RECORD_OBT;
       }
       
       for (Int_t k =0; k <16; k++){
	 ythana[16*recordstot+16*j+k]       = convert_th(tmr->TM_TH_ANA[k]);      	
	 xrecordobtth[16*recordstot+16*j+k] = tmr->TM_RECORD_OBT;
       }
       
       for (Int_t k =0; k <6; k++){
	 ydea[6*recordstot+6*j+k]	= convert_volt(tmr->TM_DEA_ANA[k]);      	
	 xrecordobtdea[6*recordstot+6*j+k]  = tmr->TM_RECORD_OBT;
       }
     }
     recordstot=recordstot+tmpSize;
   }
   
   TString filename = ((TObjString*)base.Tokenize('/')->Last())->GetString();
   filename = ((TObjString*)filename.Tokenize('.')->First())->GetString();
   
   TLegend *leg1 = new TLegend(0.87,0.80,0.98,0.94, "");
   leg1->SetFillColor(10);
   leg1->SetBorderSize(0);
   
   Canvascc->cd();
   pt = new TPaveText (.87,.95,.98,.98);
   oss.str("");
   oss<<filename.Data();
   pt->AddText(oss.str().c_str());
   pt->SetTextColor(1);
   //pt->SetTextSize(1);
   pt->SetFillColor(10);
   pt->SetBorderSize(0);
   pt->Draw();
   
   /*
     TLine *line = new TLine;
     line->SetLineColor(4);
     line->SetLineWidth(2);
     line->DrawLine(0, 0.60, 1, 0.60);
     line->Draw();
     line->DrawLine(0, 0.33, 1, 0.33);
     line->Draw();
     line->DrawLine(0, 0.20, 1, 0.20);
     line->Draw();
     line->DrawLine(0, 0.13, 1, 0.13);
     line->Draw();
   */
   
   
   
   //CC Graph  
   for (Int_t k =0; k<16; k++){
     for (Int_t i = 0; i < recordstot; i++){
       if (k>0) {
	 yccdiagacq_11u[i]=yccdiagacq_1u[i];
	 yccdiagacq_11d[i]=yccdiagacq_1d[i];
       }
       yccdiagacq_1d[i]=0;
       yccdiagacq_1u[i]=0;
       if (yccdiagacq[16*i+k]==0) {
	 yccdiagacq_1d[i]=-1;
	 xrecordobtcc_1[i]= xrecordobtcc[16*i+k];
       } 
       else if (yccdiagacq[16*i+k]==1){
	 yccdiagacq_1u[i]=1;
	 xrecordobtcc_1[i]= xrecordobtcc[16*i+k];
       }
       if (k==1) {
	 if (yccdiagacq_11u[i]==1 && yccdiagacq_1u[i]==1)  yccipm12u[i]=1;
	 else yccipm12u[i]=0;
	 if (yccdiagacq_11d[i]==-1 && yccdiagacq_1d[i]==-1) yccipm12d[i]=-1;
	 else  yccipm12d[i]=0;
       }
       if (k==1 || k==3 || k==5 || k==7 || k==9) {
	 if (yccdiagacq_11u[i]==1  && yccdiagacq_1u[i]==1)   yccipmkk1u[i]=1;
	 else yccipmkk1u[i]=0;
	 if (yccdiagacq_11d[i]==-1  && yccdiagacq_1d[i]==-1)   yccipmkk1d[i]=-1;
	 else yccipmkk1d[i]=0;
	 if (k==7 || k==9) {
	   /* if (yccipmkk1u[i]==1  && yccipm12d[i]==0 && yccipm12u[i]==0) yccipmerror[i]=1;
	   else if (yccipmkk1d[i]==-1 && yccipm12d[i]==0 && yccipm12u[i]==0 || (yccipmkk1d[i]==-1 && yccipm12u[i]==1)) yccipmerror[i]=-1;
	   else  yccipmerror[i]=0;*/
	   if ((yccipmkk1u[i]==1  && ydea[6*i]<0.65  &&  ydea[6*i+1]>3.15 && ydea[6*i+1]<4.25) || (yccipmkk1u[i]==1  && ydea[6*i+1]<0.65  &&  ydea[6*i]>3.15 && ydea[6*i]<4.25)) yccipmerror[i]=1;
	   else if ((yccipmkk1d[i]==-1 && ydea[6*i]<0.65  && ydea[6*i+1]>3.15 && ydea[6*i+1]<4.25) || (yccipmkk1d[i]==-1 && ydea[6*i+1]<0.65  && ydea[6*i]>3.15 && ydea[6*i]<4.25) || (yccipmkk1d[i]==-1 && ydea[6*i]<0.65 && ydea[6*i+1]<0.65)) yccipmerror[i]=-1;
	   else  yccipmerror[i]=0;
	 }
       }
       if (k==6 || k==7 || k==8 || k==9) {
	 /*if (yccdiagacq_1d[i]==-1 && yccipm12u[i]==1) yccipmerror2[i]=-1;
	 else yccipmerror2[i]=0;*/
	 if (yccdiagacq_1d[i]==-1 && ydea[6*i]<0.65 && ydea[6*i+1]<0.65) yccipmerror2[i]=-1;
	 else yccipmerror2[i]=0;
       }
       if (k==13) {
	 if ((yccdiagacq_1d[i]==-1 && ydea[6*i]<0.65  &&  ydea[6*i+1]>3.15 && ydea[6*i+1]<4.25) || (yccdiagacq_1d[i]==-1 && ydea[6*i+1]<0.65  &&  ydea[6*i]>3.15 && ydea[6*i]<4.25))  yccdiagacq_1d[i]==-1;                                   //psb on
	 if (yccdiagacq_1u[i]==1  && ydea[6*i]<0.65  &&  ydea[6*i+1]<0.65)   yccdiagacq_1u[i]==1;   //psb off
	 /*if (yccdiagacq_1d[i]==-1 && yccipm12d[i]==-1) yccipmerror[i]=-1;
	 else if (yccdiagacq_1u[i]==1  && yccipm12d[i]==0 && yccipm12u[i]==0) yccipmerror[i]=1;
	 else yccipmerror[i]=0;*/      
	 if (yccdiagacq_1d[i]==-1 && ydea[6*i]<0.65  &&  ydea[6*i+1]<0.65) yccipmerror[i]=-1;
	 else if ((yccdiagacq_1u[i]==1 && ydea[6*i]<0.65  &&  ydea[6*i+1]>3.15 && ydea[6*i+1]<4.25) || (yccdiagacq_1u[i]==1 && ydea[6*i+1]<0.65  &&  ydea[6*i]>3.15 && ydea[6*i]<4.25)) yccipmerror[i]=1;
	 else yccipmerror[i]=0;                                                                    //psb alarm
       }
       if (k==15) { 
	 yccdiagacq_11u[i]=0;
	 yccdiagacq_11d[i]=0;
       }
     }
     
     //CC IPM
     if (k==0 || k==1 ||k==2 || k==3 || k==4 || k==5 ){  
       Canvascc->cd(m+1);
       Canvascc->cd(m+1)->SetGridx();
       gPad->SetFillColor(10);
       gPad->SetFrameBorderSize(0);
       gPad->SetLineColor(1);
       gPad->SetFrameBorderMode(0);
       
       
       pt = new TPaveText (.01,.30,.10,.70);
       oss.str("");
       oss<<titolocc[k];
       pt->AddText(oss.str().c_str());
       pt->SetFillColor(10);
       pt->SetBorderSize(0);
       pt->Draw();
       
       
       TGraph *ccrecordd = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1d);
       ccrecordd->SetTitle("");
       ccrecordd->SetFillColor(8);
       ccrecordd->GetXaxis()->SetLabelSize(0);
       ccrecordd->GetXaxis()->SetTickLength(0);
       ccrecordd->GetYaxis()->SetLabelSize(0);
       ccrecordd->GetYaxis()->SetTickLength(0);
       ccrecordd->SetMaximum(1.3);
       ccrecordd->SetMinimum(-1.3);
       ccrecordd->GetXaxis()->SetAxisColor(0);
       ccrecordd->Draw("AB");
       if (k==0) leg1->AddEntry(ccrecordd,"ON","f");
       
       TGraph *ccrecordu = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1u);
       ccrecordu->SetTitle("");
       ccrecordu->SetFillColor(17);
       ccrecordu->GetXaxis()->SetLabelSize(0);
       ccrecordu->GetXaxis()->SetTickLength(0);
       ccrecordu->GetYaxis()->SetLabelSize(0);
       ccrecordu->GetYaxis()->SetTickLength(0);  
       ccrecordu->GetXaxis()->SetAxisColor(0);
       ccrecordu->SetMaximum(1.3);
       ccrecordu->SetMinimum(-1.3);
       ccrecordu->Draw("Bsame");
       if (k==0) leg1->AddEntry(ccrecordu,"OFF","f");
       
    
       if (k==1 || k==3 || k==5){
	 Canvascc->cd(m);
	 TGraph *ccrecorderrord = new TGraph(recordstot, xrecordobtcc_1, yccipmkk1d);
	 ccrecorderrord->SetTitle("");
	 ccrecorderrord->SetFillColor(2);
	 ccrecorderrord->GetXaxis()->SetLabelSize(0);
	 ccrecorderrord->GetXaxis()->SetTickLength(0);
	 ccrecorderrord->GetYaxis()->SetLabelSize(0);
	 ccrecorderrord->GetYaxis()->SetTickLength(0);
	 ccrecorderrord->SetMaximum(1.3);
	 ccrecorderrord->SetMinimum(-1.3);
	 ccrecorderrord->GetXaxis()->SetAxisColor(0);
	 ccrecorderrord->Draw("Bsame");
	 
	 TGraph *ccrecorderroru = new TGraph(recordstot, xrecordobtcc_1, yccipmkk1u);
	 ccrecorderroru->SetTitle("");
	 ccrecorderroru->SetFillColor(2);
	 ccrecorderroru->GetXaxis()->SetLabelSize(0);
	 ccrecorderroru->GetXaxis()->SetTickLength(0);
	 ccrecorderroru->GetYaxis()->SetLabelSize(0);
	 ccrecorderroru->GetYaxis()->SetTickLength(0);
	 ccrecorderroru->SetMaximum(1.3);
	 ccrecorderroru->SetMinimum(-1.3);
	 ccrecorderroru->GetXaxis()->SetAxisColor(0);
	 ccrecorderroru->Draw("Bsame");
	 
	 Canvascc->cd(m+1);
	 ccrecorderrord->Draw("Bsame");
	 ccrecorderroru->Draw("Bsame");
       }
       
       
       Double_t xmin;
       Double_t xmax;
       xmin=ccrecordu->GetXaxis()->GetXmin();
       xmax=ccrecordu->GetXaxis()->GetXmax();
       TGaxis *axis = new TGaxis (xmin, 0, xmax, 0, xmin, xmax, 510, "+-", 0);
       axis->Draw("same");
       /*TF1 *func1 = new TF1("func1", "0");
	 func1->SetRange(xmin,xrecordobtcc_1[recordstot-1]);
	 func1->SetLineColor(1);
	 func1->SetLineStyle(1);
	 func1->SetLineWidth(2);
	 func1->Draw("same");*/
       
       m=m+1;
     }
     
     //CC idaq-khb-tof
     if (k==6 || k==7 || k==8 || k==9 || k==14 || k==15){  
       Canvascc->cd(l+7);
       gPad->SetFillColor(10);
       gPad->SetFrameBorderSize(0);
       
       pt = new TPaveText (.00,.30,.09,.70);
       oss.str("");
       oss<<titolocc[k];
       pt->AddText(oss.str().c_str());
       pt->SetFillColor(10);
       pt->SetBorderSize(0);
       pt->Draw();
       
       
       TGraph *ccrecordd = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1d);
       ccrecordd->SetTitle("");
       if (k==14 || k==15)  ccrecordd->SetFillColor(2);
       else ccrecordd->SetFillColor(8); 
       ccrecordd->GetXaxis()->SetLabelSize(0);
       ccrecordd->GetXaxis()->SetTickLength(0);
       ccrecordd->GetYaxis()->SetLabelSize(0);
       ccrecordd->GetYaxis()->SetTickLength(0); 
       ccrecordd->SetMaximum(1.3);
       ccrecordd->SetMinimum(-1.3);
       ccrecordd->GetXaxis()->SetAxisColor(0);
       ccrecordd->Draw("AB");

       TGraph *ccrecordu = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1u);
       ccrecordu->SetTitle("");
       if (k==14 || k==15) {
	 ccrecordu->SetFillColor(7);
	 if (k==14) leg1->AddEntry(ccrecordu,"ON-OFF-LATCHUP","f");
       }
       else ccrecordu->SetFillColor(17);
       ccrecordu->GetXaxis()->SetAxisColor(0); 
       ccrecordu->GetXaxis()->SetLabelSize(0);
       ccrecordu->GetXaxis()->SetTickLength(0);
       ccrecordu->GetYaxis()->SetLabelSize(0);
       ccrecordu->GetYaxis()->SetTickLength(0); 
       ccrecordu->SetMaximum(1.3);
       ccrecordu->SetMinimum(-1.3);
       ccrecordu->Draw("Bsame");
       
       if (k==6 || k==7 || k==8 || k==9){
	 Canvascc->cd(l+7);
	 TGraph *ccrecorderroru = new TGraph(recordstot, xrecordobtcc_1, yccipmerror2);
	 ccrecorderroru->SetTitle("");
	 ccrecorderroru->SetFillColor(2);
	 ccrecorderroru->GetXaxis()->SetLabelSize(0);
	 ccrecorderroru->GetXaxis()->SetTickLength(0);
	 ccrecorderroru->GetYaxis()->SetLabelSize(0);
	 ccrecorderroru->GetYaxis()->SetTickLength(0);
	 ccrecorderroru->SetMaximum(1.3);
	 ccrecorderroru->SetMinimum(-1.3);
	 ccrecorderroru->GetXaxis()->SetAxisColor(0);
	 ccrecorderroru->Draw("Bsame");
       }
       
       
        if (k==7 || k==9){
	 Canvascc->cd(l+7-1);
	 TGraph *ccrecorderroru = new TGraph(recordstot, xrecordobtcc_1, yccipmerror);
	 ccrecorderroru->SetTitle("");
	 ccrecorderroru->SetFillColor(2);
	 ccrecorderroru->GetXaxis()->SetLabelSize(0);
	 ccrecorderroru->GetXaxis()->SetTickLength(0);
	 ccrecorderroru->GetYaxis()->SetLabelSize(0);
	 ccrecorderroru->GetYaxis()->SetTickLength(0);
	 ccrecorderroru->SetMaximum(1.3);
	 ccrecorderroru->SetMinimum(-1.3);
	 ccrecorderroru->GetXaxis()->SetAxisColor(0);
	 if (k==7) leg1->AddEntry(ccrecorderroru,"ALARM","f");
	 ccrecorderroru->Draw("Bsame");
	 
	 Canvascc->cd(l+7);  
	 ccrecorderroru->Draw("Bsame");
	 }
       
       
       Double_t xmin;
       Double_t xmax;
       xmin=ccrecordu->GetXaxis()->GetXmin();
       xmax=ccrecordu->GetXaxis()->GetXmax();
       TGaxis *axis = new TGaxis (xmin, 0, xmax, 0, xmin, xmax, 510, "+-", 1.5);
       axis->Draw("same");
       /*TF1 *func1 = new TF1("func1", "0");
	 func1->SetRange(xmin,xrecordobtcc_1[recordstot-1]);
	 func1->SetLineColor(1);
	 func1->SetLineStyle(1);
	 func1->SetLineWidth(2);
	 func1->Draw("same");*/
       l=l+1;
       
     }
     
     //CC vrl
     if (k==11 || k==12 || k==13 ){  
       if (k==13) Canvascc->cd(13);
       if (k==11) Canvascc->cd(14);
       if (k==12) Canvascc->cd(15);
       gPad->SetFillColor(10); 
       gPad->SetFrameBorderSize(0);
       
       pt = new TPaveText (.01,.30,.09,.70);
       oss.str("");
       oss<<titolocc[k];
       pt->AddText(oss.str().c_str());
       pt->SetFillColor(10);
       pt->SetBorderSize(0);
       pt->Draw();
       
       if (k==11 || k==12){
	 TGraph *ccrecordd = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1d);
	 ccrecordd->SetTitle("");
	 ccrecordd->SetFillColor(8);
	 ccrecordd->GetXaxis()->SetAxisColor(0);
	 ccrecordd->GetXaxis()->SetLabelSize(0);
	 ccrecordd->GetXaxis()->SetTickLength(0);
	 ccrecordd->GetYaxis()->SetLabelSize(0);
	 ccrecordd->GetYaxis()->SetTickLength(0); 
	 ccrecordd->SetMaximum(1.3);
	 ccrecordd->SetMinimum(-1.3);
	 ccrecordd->Draw("AB");
	 
	 
	 TGraph *ccrecordu = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1u);
	 ccrecordu->SetTitle("");
	 ccrecordu->SetFillColor(17);
	 ccrecordu->GetXaxis()->SetAxisColor(0);
	 ccrecordu->GetXaxis()->SetLabelSize(0);
	 ccrecordu->GetXaxis()->SetTickLength(0);
	 ccrecordu->GetYaxis()->SetLabelSize(0);
	 ccrecordu->GetYaxis()->SetTickLength(0); 
	 ccrecordu->SetMaximum(1.3);
	 ccrecordu->SetMinimum(-1.3);
	 ccrecordu->Draw("Bsame");
	 
	 Double_t xmin;
	 Double_t xmax;
	 xmin=ccrecordu->GetXaxis()->GetXmin();
	 xmax=ccrecordu->GetXaxis()->GetXmax();
	 if (k==12){
	   TGaxis *axis = new TGaxis (xmin, -1, xmax, -1, xmin, xmax, 510, "", 0);
	   axis->SetLabelSize(0.24);
	   axis->SetLabelColor(1);
	   axis->SetTitle("OBT (ms)");
	   //axis->CenterTitle();
	   axis->SetTitleOffset(0.4);
	   axis->SetTitleSize(0.21);
	   axis->Draw();
	   TF1 *func1 = new TF1("func1", "0");
	   func1->SetRange(xmin,xmax);
	   func1->SetLineColor(1);
	   func1->SetLineStyle(1);
	   func1->SetLineWidth(1);
	   func1->Draw("same");
	 }
	 if (k==11){
	   TGaxis *axis = new TGaxis (xmin, 0, xmax, 0, xmin, xmax, 510, "+-", 0);
	   axis->SetLineWidth(1);
	   axis->SetTickSize(2);
	   axis->Draw("same");
	 }
       }
       
       if (k==13){
	 Canvascc->cd(13);
	 
	 TGraph *ccrecordd = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1d);
	 ccrecordd->SetTitle("");
	 ccrecordd->SetFillColor(8);
	 ccrecordd->GetXaxis()->SetAxisColor(0);
	 ccrecordd->GetXaxis()->SetLabelSize(0);
	 ccrecordd->GetXaxis()->SetTickLength(0);
	 ccrecordd->GetYaxis()->SetLabelSize(0);
	 ccrecordd->GetYaxis()->SetTickLength(0); 
	 ccrecordd->SetMaximum(1.3);
	 ccrecordd->SetMinimum(-1.3);
	 ccrecordd->Draw("AB");
	 
	 TGraph *ccrecordu = new TGraph(recordstot, xrecordobtcc_1, yccdiagacq_1u);
	 ccrecordu->SetTitle("");
	 ccrecordu->SetFillColor(17);
	 ccrecordu->GetXaxis()->SetAxisColor(0);
	 ccrecordu->GetXaxis()->SetLabelSize(0);
	 ccrecordu->GetXaxis()->SetTickLength(0);
	 ccrecordu->GetYaxis()->SetLabelSize(0);
	 ccrecordu->GetYaxis()->SetTickLength(0); 
	 ccrecordu->SetMaximum(1.3);
	 ccrecordu->SetMinimum(-1.3);
	 ccrecordu->Draw("Bsame");
	 
	 TGraph *ccrecorderroru = new TGraph(recordstot, xrecordobtcc_1, yccipmerror);
	 ccrecorderroru->SetTitle("");
	 ccrecorderroru->SetFillColor(2);
	 ccrecorderroru->GetXaxis()->SetLabelSize(0);
	 ccrecorderroru->GetXaxis()->SetTickLength(0);
	 ccrecorderroru->GetYaxis()->SetLabelSize(0);
	 ccrecorderroru->GetYaxis()->SetTickLength(0);
	 ccrecorderroru->SetMaximum(1.3);
	 ccrecorderroru->SetMinimum(-1.3);
	 ccrecorderroru->GetXaxis()->SetAxisColor(0);
	 ccrecorderroru->Draw("Bsame");
	 
	 
	 Double_t xmin=ccrecordu->GetXaxis()->GetXmin();
	 Double_t xmax=ccrecordu->GetXaxis()->GetXmax();
	 TGaxis *axis = new TGaxis (xmin, 0, xmax, 0, xmin, xmax, 510, "+-", 0);
	 axis->SetLineWidth(1);
	 axis->SetTickSize(2);
	 axis->Draw("same");
       }
       
     }
     
   }
   
   Canvascc->cd();
   leg1->Draw();	
   Canvascc->Update();
   
   // TH Graph
   Canvasthdea->cd();
   //thermistors number=16
   if (tr->GetBranch("Records.TM_TH_ANA[16]")){
     for (Int_t k =0; k<16; k++){
       for (Int_t i = 0; i < recordstot; i++){
	 ythana_1[i]= ythana[16*i+k];
	 xrecordobtth_1[i]= xrecordobtth[16*i+k];
       }
       Canvasthdea->cd(k+1);
       
       TGraph *threcord = new TGraph(recordstot, xrecordobtth_1, ythana_1);
       // threcord->SetLineColor(kBlue);
       threcord->SetMarkerSize(0.2);
       threcord->SetMarkerColor(kBlue);
       threcord->SetMarkerStyle(21);
       threcord->SetMinimum(-10);
       threcord->SetMaximum(60);
       threcord->GetXaxis()->SetTitle("OBT");
       threcord->GetXaxis()->CenterTitle();
       threcord->GetYaxis()->SetTitle("Temperature value (C)");
       threcord->GetYaxis()->CenterTitle();
       oss.str("");
       oss << filename.Data() <<":  " <<titoloth[k] ;
       threcord->SetTitle(oss.str().c_str());
       
       Double_t xmin=threcord->GetXaxis()->GetXmin();
       Double_t xmax=threcord->GetXaxis()->GetXmax();
       if (k==10 || k==11 ) {
	 TPaveText *pt = new TPaveText (.45,.75,.55,.82);
	 pt->AddText("OFF");
	 pt->SetBorderSize(1);
	 pt->Draw();
	 threcord->Draw("APsame");
	 TF1 *func1 = new TF1("func1", "50");
	 func1->SetRange(xmin,xmax);
	 func1->SetLineColor(2);
	 func1->SetLineStyle(1);
	 func1->SetLineWidth(2);
	 func1->Draw("same");
	 pt->Draw();
       }else {
	 TPaveText *pt = new TPaveText (.45,.7,.55,.77);
	 pt->AddText("OFF");
	 pt->SetBorderSize(1);
	 pt->Draw();
	 threcord->Draw("APsame");
	 TF1 *func1 = new TF1("func1", "45");
	 func1->SetRange(xmin,xmax);
	 func1->SetLineColor(2);
	 func1->SetLineStyle(1);
	 func1->SetLineWidth(2);
	 func1->Draw("same");
	 pt->Draw();
       }
    


     }
   }  
   
   // DEA Graph
   Canvasvoltdea->cd();
   for (Int_t k =0; k<6; k++){
     for (Int_t i = 0; i < recordstot; i++){
       ydea_1[i]= ydea[6*i + k];
       xrecordobtdea_1[i]= xrecordobtdea[6*i+k];
     }
     Canvasvoltdea->cd(k+1);

     TPaveText *pt = new TPaveText (.84,.13,.92,.19);
     pt->AddText("OFF");
     pt->SetBorderSize(1);
     pt->Draw();
     TPaveText *pt1 = new TPaveText (.84,.67,.92,.73);
     pt1->AddText("ON");
     pt1->SetBorderSize(1);
     pt1->Draw();
     
     TGraph *dearecord = new TGraph(recordstot, xrecordobtdea_1, ydea_1);
     //dearecord->SetLineColor(kBlue);
     //dearecord->SetLineWidth(1);
     dearecord->SetMarkerStyle(21);
     dearecord->SetMarkerSize(0.5);
     dearecord->SetMarkerColor(kBlue);
     dearecord->SetMinimum(0.0);
     dearecord->SetMaximum(5.0);
     dearecord->GetXaxis()->SetTitle("OBT");
     dearecord->GetXaxis()->CenterTitle();
     dearecord->GetYaxis()->SetTitle("Voltage value (V)");
     dearecord->GetYaxis()->CenterTitle();
     oss.str("");
     oss <<  filename.Data()<<": IPM "<<k+1<<" output";
     dearecord->SetTitle(oss.str().c_str());
     dearecord->Draw("APsame");
     //dearecord->Draw("ACPLsame");

     Double_t xmin=dearecord->GetXaxis()->GetXmin();
     Double_t xmax=dearecord->GetXaxis()->GetXmax();
     TF1 *func1 = new TF1("func1", "0.65");
     func1->SetRange(xmin, xmax);
     func1->SetLineColor(2);
     func1->SetLineStyle(1);
     func1->SetLineWidth(2);
     func1->Draw("Csame");

     TF1 *func2 = new TF1("func2", "3.15");
     func2->SetRange(xmin, xmax);
     func2->SetLineColor(2);
     func2->SetLineStyle(1);
     func2->SetLineWidth(2);
     func2->Draw("Csame");

     TF1 *func3 = new TF1("func3", "4.25");
     func3->SetRange(xmin, xmax);
     func3->SetLineColor(2);
     func3->SetLineStyle(1);
     func3->SetLineWidth(2);
     func3->Draw("Csame");


     pt1->Draw();
     pt->Draw();
   }
   
   
   stringstream  oss1, oss2, oss3, oss4;
   oss.str("");
   oss1.str("");
   oss2.str("");
   oss  << outDir.Data() << filename.Data() << "_Tmtc_cc_"<<interval+1<<"." << format;
   oss1 << outDir.Data() << filename.Data() << "_Tmtc_th_dea_"<<interval+1<<"." << format;
   oss2 << outDir.Data() << filename.Data() << "_Tmtc_volt_dea_"<<interval+1<<"." << format;
   Canvascc->SaveAs(oss.str().c_str());
   Canvasthdea->SaveAs(oss1.str().c_str());
   Canvasvoltdea->SaveAs(oss2.str().c_str());     //// fine del lavoro sul sottogruppo
   
   Canvascc->Clear();
   Canvasthdea->Clear();
   Canvasvoltdea->Clear();
   //gROOT->GetListOfCanvases()->Delete();
   //gROOT->Reset();
   
 }
 
 
 file->Close(); 
}


//////////////////////////////////////////////////////////////////////////////////
/////////////////////////   MAIN   ///////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////


int main(int argc, char* argv[]){
  TString path;
  TString outDir     = "./";
  TString format     = "jpg";
    
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: TmtcTemperature FILE [OPTION] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t -outDir[path]          Path where to put the output [default ./] \n");
        printf( "\t -format[jpg|ps|gif]    Format for output files [default 'jpg'] \n");
        exit(1);
  }

  path=argv[1];

  for (int i = 2; i < argc; i++){
    
   
    if (!strcmp(argv[i], "-outDir")){
      if (++i >= argc){
	printf( "-outDir needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	outDir = argv[i];
	continue;
      }
    }
    
    if (!strcmp(argv[i], "-format")){
      if (++i >= argc){
	printf( "-format needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	format = argv[i];
	continue;
      }
    }
    
    
  }

  TmtcTemperature(argv[1], outDir, format);
 
}
