/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/mcmd/McmdEvent.h,v $
 * $Id: McmdEvent.h,v 6.0 2006/02/07 17:11:08 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the McmdEvent class.
 */
#ifndef MCMD_EVENT_H
#define MCMD_EVENT_H

#include "McmdRecord.h"
#include <TClonesArray.h>

namespace pamela {
  /**
   * McmdEvent data Wrapper
   *
   * The McmdEvent represents the "McmdEvent" packet generated by the PAMELA CPU software.
   * Is the results of several read of the PAMELA TMTC board.
   */
  class McmdEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
    
  public:
    /**
     * Contain multiple instances of pamela::McmdRecord type.
     */
    TClonesArray        *Records;

    int                  Mcmd_crc_ok;

    McmdEvent(void);
    ~McmdEvent(void);

    ClassDef(McmdEvent, 1)
  };
}

#endif /* MCMD_EVENT_H */

