/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/log/LogEvent.h,v $
 * $Id: LogEvent.h,v 6.0 2006/02/07 17:11:08 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the LogEvent class.
 */
#ifndef LOG_EVENT_H
#define LOG_EVENT_H

#include <vector>
#include "LogRecord.h"
#include <TClonesArray.h>
using namespace std;

namespace pamela {
  /**
   * LogEvent data Wrapper.
   *
   * The LogEvent represents the "LogEvent" packet generated by the PAMELA CPU software
   * and is a collection of several logs generated during PAMELA operations
   * and recorded in the CPU RAM between two storing operations.
   */
  class LogEvent: public pamela::SubPacket {
  private:
  
    static TClonesArray *fgRecords;
  public:
    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32 COMPILATION_TIMESTAMP;

    /**
     * Contain multiple instances of pamela::LogRecord type.
     */
    TClonesArray* Records;
    
    LogEvent(void);
    ~LogEvent(void);
    
    ClassDef(LogEvent, 1)
  };
}

#endif /* LOG_EVENT_H */

