/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/Exception.h,v $
 * $Id: Exception.h,v 6.0 2006/02/07 17:11:07 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the exceptions of Pamela.
 */
#ifndef EXCEPTION_H
#define EXCEPTION_H
#include <exception>
#include <stdio.h>

#define  UINT32 unsigned int
#define  UINT16 unsigned short
#define  UINT8  unsigned char

using namespace std;
namespace pamela {

  class Exception: public exception {
    
  private:
    
  protected:
    const char *message;
    char buff [100];
  public:
    Exception(const char *msg = "message"): message(msg){ }
    virtual ~Exception () throw(){ }
    virtual const char* print () const throw () { return message; }
  };

  class NotFoundEnvironmentVarException: public Exception {
  public:
    NotFoundEnvironmentVarException(const char* msg):  Exception(msg) {}
    ~NotFoundEnvironmentVarException () throw(){ }
  };

  class UnidentifiedPacketException: public Exception {
  private:
    UINT8     pktId;
  public:
    UnidentifiedPacketException(UINT8 id): 
    Exception("Unidentified PacketType - Id: ") {
        pktId = id;
    }
    ~UnidentifiedPacketException () throw(){ }
    const char* print () const throw () { 
        sprintf((char*)buff," %s 0x%x", message, pktId);
        return buff;
    }
  };

  class WrongCRCException: public Exception {
  public:
    WrongCRCException(const char* msg):  Exception(msg) {}
    ~WrongCRCException () throw(){ }
  };

  class WrongCRCHeaderException: public Exception {
  public:
    WrongCRCHeaderException(const char* msg):  Exception(msg) {}
    ~WrongCRCHeaderException () throw(){ }
  };


  class LengthException: public Exception {
  public:
    LengthException(const char* msg):  Exception(msg) { }
    ~LengthException () throw(){ }
  };


  class NotExistingAlgorithmException: public Exception {
  public:
    NotExistingAlgorithmException(const char *msg):  Exception(msg) { }
    ~NotExistingAlgorithmException () throw(){ }
  };
  
  class NotExistingCounterException: public Exception {
  public:
    NotExistingCounterException(const char *msg):  Exception(msg) { }
    ~NotExistingCounterException () throw(){ }
  };

  class BackwardCounterException: public Exception {
  public:
    BackwardCounterException(const char *msg):  Exception(msg) { }
    ~BackwardCounterException () throw(){ }
  };
}
#endif /* EXCEPTION_H */
