
#ifndef NEUTRON_EVENT_H
#define NEUTRON_EVENT_H

#include "NeutronRecord.h"
#include <TClonesArray.h>

namespace pamela {
    namespace neutron {
    /**
    * NeutronEvent data Wrapper
    */
    class NeutronEvent: public pamela::SubPacket {
    private:
        static TClonesArray *fgRecords;
    
    public:
      /**
       * Contain multiple instances of pamela::neutron::NeutronRecord type.
       */
        TClonesArray   *Records;
        
        /**
         * The data validity flag.
         * 
         * Description:               <BR>
         * 1: neutron data NOT found. <BR>
         * 0: neutron data ok.        <BR>
         */
        unsigned short  unpackError;

        NeutronEvent(void);
        ~NeutronEvent(void);

        ClassDef(NeutronEvent, 2)
    };
    }
}
#endif /* NEUTRON_EVENT_H */

