/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : FileManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: FD_MMSUDriver_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: FD_MMSUDriver_int.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


 
/*============================= Include File ================================*/
  
#include <src/FileManager/MMSUDriver/FD_MMSUDriver_op.h>
#include <src/FileManager/MMSUDriver/FD_MMSUDriver_int.h>

/*============================== Local Variables ============================*/


/*****************************************************************************/

/*======== M M S U D r i v e r   I N T E R N A L   F U N C T I O N S ========*/

/*****************************************************************************/
/* @Function: FD_ifDrammaWrWPBUSReg                                          */
/* @Purpose :                                                                */
/*  The function writes through the DMA Write Controller, a data word        */
/*  32 bit long into the DRAMMA registers Data Byte 1 (LSB), Data Byte 2,    */
/*  Data Byte 3,Data Byte 4 (MSB).                                           */
/*  The data present into the DRAMMA Register Data 1..4 are written in the   */
/*  specific memory board, programming the Board Address register with the   */
/*  address of the selected board.                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  BoardId              IN      Board address   (0 to MAX_BOARD_ADDR)       */
/*  pDramma              IN      Pointer to Dramma register table            */
/*  Reg                  IN      Dramma register indentifier (index)         */
/*                                               (FD_DRAMMA_REG type)        */
/*  Value                IN      Value to write into the Dramma register     */
/* @@                                                                        */
/*****************************************************************************/

void FD_ifDrammaWrWPBUSReg (void*        pDramma,
                            unsigned int BoardId,
                            unsigned int Reg, 
                            unsigned int Value)
{
unsigned int    tmpValue;
unsigned int    mask;
FD_DRAMMA_REG*  pD;

    pD        =(FD_DRAMMA_REG* )pDramma;
    mask      =pD->WPBUSreg[Reg];    
    tmpValue  =Value & ~mask;
    tmpValue |=mask;
    /* Write data (4 bytes) into the DRAMMA Register Data on the WPBUS         */
    /* Write Data 1 LSB                                                        */
    *FD_WPBUS_WCMD1 =(unsigned char)(tmpValue & 0xff);
    *FD_WPBUS_WCMD2 =(unsigned char)((tmpValue>>8)&0xff);
    *FD_WPBUS_WCMD3 =(unsigned char)((tmpValue>>16)&0xff);
    /* Write Data 4 MSB                                                        */
    *FD_WPBUS_WCMD4 =(unsigned char)((tmpValue>>24)&0xff);
    /* Write board address into the DRAMMA Board Address Register on the WPBUS */
    *FD_WPBUS_CBID  =(unsigned char)(BoardId & FD_BOARD_ADDR_MASK);

}



/*****************************************************************************/
/* @Function: FD_ifDrammaRdRPBUSReg                                          */
/* @Purpose :                                                                */
/*  The function reads through the DMA Read Controller, a data word 32 bit   */
/*  long from the DRAMMA registers Data Byte 1 (LSB), Data Byte 2,           */
/*  Data Byte 3,Data Byte 4 (MSB).                                           */
/*  Before read the data word needs to program the Dramma Register Adrress   */
/*  with the address of the specific board and the address of the Dramma     */
/*  register.                                                                */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  BoardId              IN      Board address   (0 to MAX_BOARD_ADDR)       */
/*  pDramma              IN      Pointer to Dramma register table            */
/*  Reg                  IN      Dramma register indentifier (index)         */
/*                                               (FD_DRAMMA_REG type)        */
/*  Value                OUT     Value read from the Dramma register         */
/* @@                                                                        */
/*****************************************************************************/
            
void FD_ifDrammaRdRPBUSReg (void*         pDramma,
                            unsigned int  BoardId,
                            unsigned int  Reg, 
                            unsigned int* Value)
{
unsigned int    tmpValue;
unsigned int    mask;
FD_DRAMMA_REG*  pD;

    pD         =(FD_DRAMMA_REG* )pDramma;
    /* Dramma register is the Most Significant Nibble   */
    mask      =(pD->RPBUSreg[Reg] << 4);
    /* Board ID is the Least Significant Nibble         */
    mask      |=BoardId;
    /* Write board and register into the Dramma Register Address        */
    *FD_RPBUS_CBID =(unsigned char)mask;
    /* Read data (4 bytes) into the DRAMMA Register Data on the RPBUS   */
    tmpValue   =0;
    /* Read data 4 MSB                                   */
    tmpValue   =*FD_RPBUS_RCMD4;
    tmpValue <<=8;
    tmpValue  |=*FD_RPBUS_RCMD3;
    tmpValue <<=8;
    tmpValue  |=*FD_RPBUS_RCMD2;
    tmpValue <<=8;
    /* Read data 1 LSB                                   */
    tmpValue  |=*FD_RPBUS_RCMD1;
    *Value     =tmpValue;
}



