#ifndef RUNHEADER_EVENT_H
#define RUNHEADER_EVENT_H

#include "SubPacket.h"

namespace pamela {
    /**
    * RunHeaderEvent data Wrapper.
    * The RunHeaderEvent represent a RunHeader packet generated by the PAMELA CPU software.
    * One RunHeader packet is expected before each Run session.
    */
  class RunHeaderEvent: public pamela::SubPacket {
  private:
   
  public:
    RunHeaderEvent(void);
    
    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32  COMPILATIONTIMESTAMP;

    /**
     * The Acquisition setting mode for the to-be-started run.
     */
    UINT8   RM_ACQ_SETTING_MODE;

    /**
     * The last On-Board-Time on which has been received the LAST_TIME_SYNC_INFO.
     * This parameter is the copy of On-Board-Time received in the last Timesync MCMD.
     * If zero means TimeSync mcmd nerver come.
     */
    UINT32  OBT_TIME_SYNC;

    /**
     * The last received TimeSync.
     * This parameter is the copy of TimeSync received in the last Timesync MCMD.
     * If zero means TimeSync mcmd nerver come.
     */
    UINT32  LAST_TIME_SYNC_INFO;

    /**
     * The Favourite Working Schedule.
     * Description:               <BR>
     */
    UINT8   FAVOURITE_WORKING_SCHEDULE;

    /**
     * The Effective Working Schedule.
     */
    UINT8   EFFECTIVE_WORKING_SCHEDULE;

    /**
     * The Acquisition mode for the trigger mode in A mode.
     * See: sec:Trigger-acquisition-modes.
     */
    UINT32  PRH_VAR_TRIGGER_MODE_A;

    /**
     * The Acquisition mode for the trigger mode in B mode.
     * See sub:working-schedule-3
     */
    UINT32  PRH_VAR_TRIGGER_MODE_B;

    /**
     * This flag Define if this is the first run after a calibration.
     * Description:               <BR>
     * 0: is NOT the first run.   <BR>
     * 1: is the first run.       <BR>
     */
    UINT8   RM_ACQ_AFTER_CALIB;

    /**
     * This flag Define if this is the first run after a calibration.
     * See sub:trk_calib_used.
     */
    UINT32  TRK_CALIB_USED;

    /**
     * Provide information about what FEs commands are assembled inside the acquisition command queue for this run.
     * It is a bitmask whose mean is defined by the constants defined in CM_ACQBI (see sub:RM_ACQBI). 
     * In case of TRIGGER_II mode, it does count, see sec:Trigger-II-Level. <br>
     * Each bit says wheather a certain part of the command queue had been 
     * build into the command aquisition queue.
     * Bit in LSB corresponds  to low-numerical values of the following enum C-type <br>
     * RM_ACQBI_TOF_PLAN_1 is bit (1<<0) <br>
     * RM_ACQBI_TOF_PLAN_2 is bit (1<<1) <br>
     * etc...
     * Note that RM_ACQBI_XXX_BASE and   RM_ACQBI_XXX_1 is the same bit.
     * MSB not used are spere (zeroed)  <br>
     *   typedef enum {                 <br>
     *     RM_ACQBI_TOF_PLAN_1,         <br>
     *     RM_ACQBI_TOF_PLAN_2,         <br>
     *     RM_ACQBI_TOF_PLAN_3,         <br>
     *     RM_ACQBI_TOF_PLAN_4,         <br>
     *     RM_ACQBI_TOF_PLAN_5,         <br>
     *     RM_ACQBI_TOF_PLAN_6,         <br>
     *     RM_ACQBI_AC_1,               <br>
     *     RM_ACQBI_AC_2,               <br>
     *     RM_ACQBI_CAL_BASE,           <br>
     *     RM_ACQBI_CAL_1=RM_ACQBI_CAL_BASE,    <br>
     *     RM_ACQBI_CAL_2,              <br>
     *     RM_ACQBI_CAL_3,              <br>
     *     RM_ACQBI_CAL_4,              <br>
     *     RM_ACQBI_TRK_BASE,           <br>
     *     RM_ACQBI_TRK_1_1=RM_ACQBI_TRK_BASE,  <br>
     *     RM_ACQBI_TRK_1_2,    <br>
     *     RM_ACQBI_TRK_1_3,    <br>
     *     RM_ACQBI_TRK_1_4,    <br>
     *     RM_ACQBI_TRK_1_5,    <br>
     *     RM_ACQBI_TRK_1_6,    <br>
     *     RM_ACQBI_TRK_2_1,    <br>
     *     RM_ACQBI_TRK_2_2,    <br>
     *     RM_ACQBI_TRK_2_3,    <br>
     *     RM_ACQBI_TRK_2_4,    <br>
     *     RM_ACQBI_TRK_2_5,    <br>
     *     RM_ACQBI_TRK_2_6,    <br>
     *     RM_ACQBI_S4,         <br>
     *     RM_ACQBI_ND,         <br>
     *   } RM_ACQBI;            
     */
    UINT32  ACQ_BUILD_INFO;

    /**
     * Provide informations about some variable value in the starting of the acquisition procedure.
     * See sub:trk_calib_used
     *  (PRH_VAR_TOF_OK     ? 1<<0  : 0 ) |
     *  (PRH_VAR_AC_1_OK    ? 1<<1  : 0 ) |
     *  (PRH_VAR_AC_2_OK    ? 1<<2  : 0 ) |
     *  (PRH_VAR_CAL_OK     ? 1<<3  : 0 ) |
     *  (PRH_VAR_TRK_OK     ? 1<<4  : 0 ) |
     *  (PRH_VAR_S4_OK      ? 1<<5  : 0 ) |
     *  (PRH_VAR_S4_WORKING ? 1<<6  : 0 ) |
     *  (PRH_VAR_S4_ATTEMPT ? 1<<7  : 0 ) |
     *  (PRH_VAR_ND_OK      ? 1<<8  : 0 ) |
     *  (RM_use_nd          ? 1<<9  : 0 ) |
     *  (PRH_VAR_ND_ATTEMPT ? 1<<10 : 0 );
     */
    UINT16  ACQ_VAR_INFO;

    /**
     * Provide informations about the calorimter DSP Mask.
     * See sub:trk_calib_used
     */
    UINT8   CAL_DSP_MASK;
    ClassDef(RunHeaderEvent, 3)
  };
}

#endif /* RUNHEADER_EVENT_H */

