/**
* RunHeaderToXML
* author  Nagni
* version 2.0 - 14 February 2006
*
* Description: Generate an XML file starting from a PAMELA unpacked file.
*
* Parameters:
* 	base - the path where to find the PAMELA unpacked root file.
*	outDirectory - the path where to put the output file.
*	xslPath - the path where to find an XSL format for the output.
*
* version 1.0 - 03 March 2005
* First implementation
*
* version 2.0 - 14 February 2006
* Modified for new Yoda unpacking structure (one single file)
*/
#include <RunHeaderEvent.h>
#include <PscuHeader.h>
#include <EventHeader.h>
#include <fstream>
#include <cstdlib>
#include <sys/stat.h>
#include <TFile.h>
#include <TObjString.h>
#include <TString.h>
#include <TTree.h>

void RunHeaderToXML(TString base, TString outDirectory = "", TString xslPath = ""){
  
  //  Int_t    	tmpSize;
  ofstream 	outputFile;
  stringstream 	oss;
  
  pamela::RunHeaderEvent  	*rhe	  = 0;
  pamela::EventHeader 		*eh   	  = 0;
  pamela::PscuHeader		*ph	  = 0;
  TFile   	      		*rootFile = new TFile(base);
  
  if (rootFile->IsZombie()) printf("The %s file does not exist", base.Data());
  TString fileName = ((TObjString*)base.Tokenize('\/')->Last())->GetString();
  TString filePath = base;
  filePath.ReplaceAll(fileName, "");
  fileName.ReplaceAll(".root", "");

  oss.str("");
  if (outDirectory == "") {
  	oss << fileName.Data() << "RunHeader.xml";
  } else {
  	oss << outDirectory.Data() << fileName.Data() << "RunHeader.xml";
  }
  const char* xmlFilePath = oss.str().c_str();
  
  outputFile.open(xmlFilePath, ios::trunc);
  if (!outputFile.is_open()){
  	printf("Cannot open the file %s for the output", xmlFilePath);
	exit(0);
  }
  
    //Takes the tree of the header file
    TTree *tr = (TTree*)rootFile->Get("RunHeader");
    Long64_t nevents    = tr->GetEntries();
    tr->SetBranchAddress("RunHeader", &rhe);
    tr->SetBranchAddress("Header", &eh);
    outputFile << "<?xml version='1.0' encoding='ISO-8859-1'?>\n";
    outputFile << "<!-- Prologo XML -->\n";
    outputFile << "<?xml-stylesheet type='text/xsl' href='" << xslPath.Data() << "'?>\n";
    outputFile << "<ROOT_SOURCE>\n";
    for (int i = 0; i < nevents; i++){
      tr->GetEntry(i);
      ph      = eh->GetPscuHeader();
      outputFile << "<RUN_HEADER_EVENT>\n";
      outputFile << "\t<PACKET_OBT>"          << ph->GetOrbitalTime()                 << "</PACKET_OBT>\n";
      outputFile << "\t<PACKET_NUM>"          << ph->GetCounter()                     << "</PACKET_NUM>\n";
      outputFile << "\t<COMPILATION_TS>"      << rhe->COMPILATIONTIMESTAMP            << "</COMPILATION_TS>\n";
      outputFile << "\t<RM_SETT_MODE>"        << (int)rhe->RM_ACQ_SETTING_MODE        << "</RM_SETT_MODE>\n";
      outputFile << "\t<OBT_TM_SYNC>"         << rhe->OBT_TIME_SYNC                   << "</OBT_TM_SYNC>\n";
      outputFile << "\t<LAST_TM_SYNC_INFO>"   << rhe->LAST_TIME_SYNC_INFO             << "</LAST_TM_SYNC_INFO>\n";
      outputFile << "\t<FAV_WRK_SCHEDULE>"    << (int)rhe->FAVOURITE_WORKING_SCHEDULE << "</FAV_WRK_SCHEDULE>\n";
      outputFile << "\t<EFF_WRK_SCHEDULE>"    << (int)rhe->EFFECTIVE_WORKING_SCHEDULE << "</EFF_WRK_SCHEDULE>\n";
      outputFile << "\t<PRH_VAR_TRIG_A>"      << rhe->PRH_VAR_TRIGGER_MODE_A          << "</PRH_VAR_TRIG_A>\n";
      outputFile << "\t<PRH_VAR_TRIG_B>"      << rhe->PRH_VAR_TRIGGER_MODE_B          << "</PRH_VAR_TRIG_B>\n";
      outputFile << "\t<RM_ACQ_AFTER_CALIB>"  << (int)rhe->RM_ACQ_AFTER_CALIB         << "</RM_ACQ_AFTER_CALIB>\n";
      outputFile << "\t<TRK_CALIB_USED>"      << rhe->TRK_CALIB_USED                  << "</TRK_CALIB_USED>\n";
      outputFile << "\t<ACQ_BUILD_INFO>"      << rhe->ACQ_BUILD_INFO                  << "</ACQ_BUILD_INFO>\n";
      outputFile << "\t<ACQ_VAR_INFO>"        << rhe->ACQ_VAR_INFO                    << "</ACQ_VAR_INFO>\n";
      outputFile << "\t<CAL_DSP_MASK>"        << (int)rhe->CAL_DSP_MASK               << "</CAL_DSP_MASK>\n";
      outputFile << "</RUN_HEADER_EVENT>\n";	
    }
    outputFile << "</ROOT_SOURCE>\n";
    outputFile.close();
}

int main(int argc, char* argv[]){
    TString outDir     = "";
    TString xslPath    = "";
    
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: RunHeaderToXML FILE [OPTION] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t -outDir[path]          Path where to put the output [default ./] \n");
        printf( "\t -xslPath[path]         Set the path to a XSL file for formatting [default  '']\n");
        exit(1);
  }

  for (int i = 2; i < argc; i++){
    if (!strcmp(argv[i], "-outDir")){
        if (++i >= argc){
            printf( "-outDir needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
            outDir = argv[i];
            continue;
        }
    }

    if (!strcmp(argv[i], "-xslPath")){
      if (++i >= argc){
        printf( "-xslPath needs arguments. \n");
        printf( "Try '--help' for more information. \n");
            exit(1);
      } else {
        xslPath = argv[i];
        continue;
      }
    }
    }
	RunHeaderToXML(argv[1], outDir, xslPath);
}


   
