/**
* Packet Scan
* author  Marcelli
* version 1.0 - 2 February 2006
*
* Description: This script creates a Multigraph to show packetID variable (for all packets) vs. OBT with an axplicative legend
*
** Version 1.25 - 13 January 2005
* Changed Int_t to Float because of variable range size
* (UInt_t has been excluded beacuse of uncompatibility with TGraph)
*
* version 1.3 - 22 February 2005 - Nagni
* For compatibility with batch mode excution:
* 1) Added "include <iostream>" and "using namespace std" 
* 2) Removed gROOT->Reset()
*
* Version 1.4
* Date 08 March 2005 - Nagni
* Added "format" parameter for saving the produced image in various formats
* (for a complete list of types refer to TPad::SaveAs method)
*
* Version 1.5
* Date 09 February 2006 - Marcelli
* Update to work with new Yoda output 
*
*
* Version 1.6
* Date 27 February 2006 - Marcelli
* For compilation: 
*     Added function "int main(int argc, char* argv[])"
*
* Version 1.7
* Date 7 March 2007 - Malvezzi
*
* Description: to read correctly the OBT changed the type of time variables from signed to unsigned 
*
* 
* Description: To show packet type recorded by PAMELA (Packet type vs. OBT)
*
* Parameters:
* 	TSTring base          - the path to the root directory for the specific Pamela unpack session
*                               There is no default value, without this input the program will not run
*       TString outDir        - the path where to save the output image (Default = ./) 
*       TString format        - the format which will be used fo rsave the produced images (Default = "jpg") 
*
*/


#include <stdio.h>
#include <string.h>
#include <fstream>
#include <sstream>
#include <iostream>
#include "TString.h"
#include "TFile.h"
#include "TGraph.h"
#include "TTree.h"
#include "TMultiGraph.h"
#include "TCanvas.h"
#include "TLegend.h"
#include "TObjString.h"
#include "EventHeader.h"
#include "PscuHeader.h"


using namespace std;

void PacketScan(TString base, TString outDir, TString format){

  TFile *file = new TFile(base.Data());
  
  if (!file){
    printf("No such file in the directory has been found");
    return;
  }
  if (outDir == "" ) outDir = ".";
  
  TList *list=file->GetListOfKeys();
  
  Int_t numkey = file->GetNkeys();
  
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  
  ULong_t utile=0;
  Double_t obt[1]={0};
  Double_t id[1]={0};
  Int_t cont[48]={0};
  std::stringstream oss, oss1, oss2, oss3;
 
  
  TString filename = ((TObjString*)base.Tokenize('/')->Last())->GetString();
  filename = ((TObjString*)filename.Tokenize('.')->First())->GetString();
  oss.str("");
  oss << "PACKET ID - OBT: " << filename.Data();
  
  
  TCanvas *finalCanv1 = new TCanvas("Packet_1", "PacketScan1", 1280, 1024);
  finalCanv1->SetFillColor(10);
  TMultiGraph *mg1 = new TMultiGraph();
  mg1->SetTitle(oss.str().c_str());
  TLegend *leg1b = new TLegend(0.80,0.67,0.99,0.99, "");
 

  TCanvas *finalCanv2 = new TCanvas("Packet_2", "PacketScan2", 1280, 1024);
  finalCanv2->SetFillColor(10);
  TMultiGraph *mg2 = new TMultiGraph();
  mg2->SetTitle(oss.str().c_str());
  TLegend *leg2 = new TLegend(0.87,0.70,0.99,0.99, "");
  


  TCanvas *finalCanv3 = new TCanvas("Packet_3", "PacketScan3", 1280, 1024);
  finalCanv3->SetFillColor(10);
  TMultiGraph *mg3 = new TMultiGraph();
  mg3->SetTitle(oss.str().c_str());
  TLegend *leg3 = new TLegend(0.87,0.65,0.99,0.99, "");

  TObject *key = new TObject;
  const char *name;
  char *SoftInfo="SoftInfo";
  for (Int_t i=0; i<numkey; i++){
    key = list->At(i);
    name=(char *)(key->GetName());
    if(strcmp(name,SoftInfo)==0)continue;
    TTree* tr = (TTree*)file->Get(name);
    if (tr->IsZombie()) continue;
    Long64_t nevents = tr->GetEntries(); 
    const Int_t size = nevents;
    tr->SetBranchAddress("Header", &eh);  
    for (Int_t j = 0; j < size; j++){
      tr->GetEntry(j); 
      ph = eh->GetPscuHeader();
      utile=ph->GetOrbitalTime();
      obt[0]= utile;
      id[0]=(ph->GetPacketId1());
      Int_t type = (int)id[0];
      switch(type){
	//physic block
      case 7: {
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.6);
	mg1->Add(graph);
	if (cont[0]==0)  leg1b->AddEntry(graph,"PhysEndRun (0x07)","p");
	cont[0]++;
	break;
      }
      case 16:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.5);
	mg1->Add(graph);
	if (cont[1]==0)  leg1b->AddEntry(graph,"Physics (0x10)","p");
	cont[1]++;
	break;
      }
      case 32:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg1->Add(graph);
	if (cont[2]==0)  leg1b->AddEntry(graph,"RunHeader/Trailer (0x20/21)","p");
	cont[2]++;
	break;
      }
      case 33:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg1->Add(graph);
	if (cont[2]==0)  leg1b->AddEntry(graph,"RunHeader/Trailer (0x20/21)","p");
	cont[2]++;
	break;
      }
	//calibration block
      case 8:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[23]==0)  leg1b->AddEntry(graph,"CalibCalPulse1 (0x08)","p");
	cont[23]++;
	break;
      }
      case 9:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[24]==0)  leg1b->AddEntry(graph,"CalibCalPulse2 (0x09)","p");
	cont[24]++;
	break;
      }
      case 17:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[25]==0)  leg1b->AddEntry(graph,"CalibTrkBoth (0x11)","p");
	cont[25]++;
	break;
      }
      case 18:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(5);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[26]==0)  leg1b->AddEntry(graph,"CalibTrk1 (0x12)","p");
	cont[26]++;
	break;
      }
      case 19:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(6);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[27]==0)  leg1b->AddEntry(graph,"CalibTrk2 (0x13)","p");
	cont[27]++;
	break;
      }
      case 29:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(30);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[28]==0)  leg1b->AddEntry(graph,"Calib_Cal (0x1d)","p");
	cont[28]++;
	break;
      }
      case 22:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(9);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[29]==0)  leg1b->AddEntry(graph,"CalibTof (0x16)","p");
	cont[29]++;
	break;
      }
      case 23:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(7);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[30]==0)  leg1b->AddEntry(graph,"CalibS4 (0x17)","p");
	cont[30]++;
	break;
      }
      case 24:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(49);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[31]==0)  leg1b->AddEntry(graph,"CalibCalPed (0x18)","p");
	cont[31]++;
	break;
      }
      case 25:{
	TGraph *graph = new TGraph(1,obt,id);
	graph->SetMarkerColor(33);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[32]==0)  leg1b->AddEntry(graph,"Calib1_Ac1 (0x19)","p");
	cont[32]++;
	break;
      }
      case 26:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(21);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[33]==0)  leg1b->AddEntry(graph,"Calib2_Ac1 (0x1a)","p");
	cont[33]++;
	break;
      }
      case 27:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(16);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[34]==0)  leg1b->AddEntry(graph,"Calib1_Ac2 (0x1b)","p");
	cont[34]++;
	break;
      }
      case 28:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(37);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[35]==0)  leg1b->AddEntry(graph,"Calib2_Ac2 (0x1c)","p");
	cont[35]++;
	break;
      }
      case 34:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(41);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[36]==0)  leg1b->AddEntry(graph,"CalibHeader/Trailer (0x22/23)","p");
	cont[36]++;
	break;
      }
      case 35:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(41);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[36]==0)  leg1b->AddEntry(graph,"CalibHeader/Trailer (0x22/23)","p");
	cont[36]++;
	break;
      }
	//initialization block
      case 36:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(20);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[4]==0)  leg1b->AddEntry(graph,"InitHeader/Trailer (0x24/25)","p");
	cont[4]++;
	break;
      }
      case 37:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(20);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(1.2);
	mg1->Add(graph);
	if (cont[4]==0)  leg1b->AddEntry(graph,"InitHeader/Trailer (0x24/25)","p");
	cont[4]++;
	break;
      } 
      case 48:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[38]==0)  leg2->AddEntry(graph,"EventTrk (0x30)","p");
	cont[38]++;
	break;
      }
	//test block
      case 64:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[39]==0)  leg2->AddEntry(graph,"Test_trk (0x40)","p");
	cont[39]++;
	break;
      }
      case 65:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[40]==0)  leg2->AddEntry(graph,"Test_Tof (0x41)","p");
	cont[40]++;
	break;
      }
	//Log block
      case 80:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[41]==0)  leg2->AddEntry(graph,"Log (0x50)","p");
	cont[41]++;
	break;
      }
	//Arrdump-Vardump-Tabdump block
      case 81:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[42]==0)  leg2->AddEntry(graph,"VarDump (0X51)","p");
	cont[42]++;
	break;
      }
      case 82:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[43]==0)  leg2->AddEntry(graph,"ArrDump (x52)","p");
	cont[43]++;
	break;
      }
      case 83:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(23);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[44]==0)  leg2->AddEntry(graph,"TabDump (0x53)","p");
	cont[44]++;
	break;
      }
	//Tmtc Block
      case 84:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[45]==0)  leg2->AddEntry(graph,"Tmtc (0x54)","p");
	cont[45]++;
	break;
      }
	//Mcmd Block
      case 85:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[46]==0)  leg2->AddEntry(graph,"Mcmd (0x55)","p");
	cont[46]++;
	break;
      } 
     case 96:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(20);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.9);
	mg2->Add(graph);
	if (cont[22]==0) leg2->AddEntry(graph,"ForceFECmd (0x60)","p");
	cont[22]++;
	break;
      }
      case 112:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(1);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[6]==0)  leg3->AddEntry(graph,"Ac1Init (0x70)","p");
	cont[6]++;
	break;
      }
      case 113:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[7]==0)  leg3->AddEntry(graph,"CalInit (0x71)","p");
	cont[7]++;
	break;
      }
      case 114:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[8]==0)  leg3->AddEntry(graph,"TrkInit (0x72)","p");
	cont[8]++;
	break;
      }
      case 115:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[9]==0)  leg3->AddEntry(graph,"TofInit (0x73)","p");
	cont[9]++;
	break;
      }
      case 116:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(5);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[10]==0)  leg3->AddEntry(graph,"TrgInit (0x74)","p");
	cont[10]++;
	break;
      }
      case 117:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(6);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[11]==0)  leg3->AddEntry(graph,"NdInit (0x75)","p");
	cont[11]++;
	break;
      }
      case 118:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(7);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[12]==0)  leg3->AddEntry(graph,"S4Init (0x76)","p");
	cont[12]++;
	break;
      }
      case 119:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(32);
	graph->SetMarkerStyle(22);
	graph->SetMarkerSize(0.9);
	mg3->Add(graph);
	if (cont[13]==0)  leg3->AddEntry(graph,"Ac2Init (0x77)","p");
	cont[13]++;
	break;
      }
	//Alarm block				
      case 129:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(1);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[14]==0)  leg3->AddEntry(graph,"CalAlarm (0x81)","p");
	cont[14]++;
	break;
      }
      case 130:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(42);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[15]==0) leg3->AddEntry(graph,"Ac1Alarm (0x82)","p");
	cont[15]++;
	break;
      }
      case 131:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(3);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph); 
	if (cont[16]==0) leg3->AddEntry(graph,"TrkAlarm (0x83)","p");
	cont[16]++;
	break;
      }
      case 132:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[17]==0) leg3->AddEntry(graph,"TrgAlarm (0x84)","p");
	cont[17]++;
	break;
      }
      case 133:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(5);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[18]==0) leg3->AddEntry(graph,"TofAlarm (0x85)","p");
	cont[18]++;
	break;
      }
      case 134:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(6);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[19]==0) leg3->AddEntry(graph,"S4Alarm (0x86)","p");
	cont[19]++;
	break;
      }
      case 136:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(7);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(0.7);
	mg3->Add(graph);
	if (cont[20]==0) leg3->AddEntry(graph,"Ac2Alarm (0x88)","p");
	cont[20]++;
	break;
      }
	/*case 137:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(32);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(1.3);
	mg3->Add(graph);
	if (cont[21]==0) leg3->AddEntry(graph,"ac2_alarm (137=0x89)","p");
	cont[21]++;
	break;
	}
      case 138:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(20);
	graph->SetMarkerStyle(21);
	graph->SetMarkerSize(1.3);
	mg3->Add(graph);
	if (cont[22]==0) leg3->AddEntry(graph,"s4_adc_ac_2 (138=0x8a)","p");
	cont[22]++;
	break;
      }*/
      case 161:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(2);
	graph->SetMarkerStyle(3);
	graph->SetMarkerSize(1.1);
	mg3->Add(graph);
	if (cont[3]==0) leg3->AddEntry(graph,"TsbT (0xA1)","p");
	cont[3]++;
	break;
      }
      case 171:{
	TGraph *graph = new TGraph(1, obt, id);
	graph->SetMarkerColor(4);
	graph->SetMarkerStyle(3);
	graph->SetMarkerSize(1.1);
	mg3->Add(graph);
	if (cont[5]==0) leg3->AddEntry(graph,"TsbB (0xAB)","p");
	cont[5]++;
	break;
      }
      }
      
    }
  }
  
 
  //*******************************TO DRAW AND SAVE*****************************************************///
   

  finalCanv1->cd();
  mg1->SetMinimum(0);
  mg1->SetMaximum(55);	
  mg1->Draw("AP");
  mg1->GetXaxis()->SetTitle("OBT (ms)");
  mg1->GetXaxis()->CenterTitle();
  mg1->GetYaxis()->SetTitle("Packet ID");
  mg1->GetYaxis()->CenterTitle();	
  leg1b->Draw();
  oss1.str("");
  oss1 << outDir.Data() << filename.Data() << "_PacketScan_1." << format.Data();
  finalCanv1->Update();
  finalCanv1->SaveAs(oss1.str().c_str());
  

  finalCanv2->cd();
  mg2->SetMinimum(60);
  mg2->SetMaximum(100);	
  mg2->Draw("AP");
  mg2->GetXaxis()->SetTitle("OBT (ms)");
  mg2->GetXaxis()->CenterTitle();
  mg2->GetYaxis()->SetTitle("Packet ID");
  mg2->GetYaxis()->CenterTitle();
  leg2->Draw();	
  oss2.str("");
  oss2 << outDir.Data() << filename.Data() << "_PacketScan_2." << format.Data();
  finalCanv2->Update();
  finalCanv2->SaveAs(oss2.str().c_str());
  

  finalCanv3->cd();
  mg3->SetMinimum(110);
  mg3->SetMaximum(180);	
  mg3->Draw("AP");
  mg3->GetXaxis()->SetTitle("OBT (ms)");
  mg3->GetXaxis()->CenterTitle();
  mg3->GetYaxis()->SetTitle("Packet ID");
  mg3->GetYaxis()->CenterTitle();
  leg3->Draw(); 
  oss3.str("");
  oss3 << outDir.Data() << filename.Data() << "_PacketScan_3." << format.Data();
  finalCanv3->Update();
  finalCanv3->SaveAs(oss3.str().c_str());
  
	
  file->Close();

}



int main(int argc, char* argv[]){
  TString path;
  TString outDir     = "./";
  TString format     = "jpg";
    

 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: PacketScan FILE [OPTION] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t -outDir[path]          Path where to put the output [default ./] \n");
        printf( "\t -format[ps|gif|jpg]    Format for output files [default 'jpg'] \n");
        exit(1);
  }

  path=argv[1];
 


  for (int i = 2; i < argc; i++){
  
    if (!strcmp(argv[i], "-outDir")){
      if (++i >= argc){
	printf( "-outDir needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	outDir = argv[i];
	continue;
      }
    }

    if (!strcmp(argv[i], "-format")){
      if (++i >= argc){
	printf( "-format needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	  exit(1);
      } 
      else{
	format = argv[i];
	continue;
      }
    }
   
    
  }
  
  PacketScan(argv[1], outDir, format);

}
