/**
* Header_Scan
* Author  Nagni
* version 1.0
*
* Version 1.1 - 28 December 2004
* If outList does not exist the function exit to prompt
* If nevents = 0 the function exit to promt
*
* Version 1.2 - 3 January 2005
* Two canvases are created to see the graphs better
*
* Version 1.25 - 13 January 2005
* Changed Int_t to Float because of variable range size
* (UInt_t has been excluded beacuse of uncompatibility with TGraph)
*
* version 1.3  - 22 February 2005 - Nagni
* For compatibility with batch mode excution:
* 1) Added "include <iostream>" and "using namespace std" 
* 2) Removed gROOT->Reset()
*
* Version 1.4
* Date 08 March 2005
* Added "format" parameter for saving the produced image in various formats
* (for a complete list of types refer to TPad::SaveAs method)
*
* Version 1.5
* Date 09 February 2006 - Marcelli
* Update to work with new Yoda output
*
* Version 1.6
* Date 27 February 2006 - Marcelli
* For compilation: 
*     Added function "int main(int argc, char* argv[])"
*
*
* Description: This script creates two canvases with five pads. The first pad shows packetID variable (for all packets) vs. OBT.
*     	       The second pad shows the number of physic packets vs. OBT. The third pad shows the lenght of Physic packets (byte) vs. OBT.
*              The fourth pad shows the packetcounter of physic packets vs. OBT. The fifth pad shows PacketCounter vs. File Offset.
*
* Parameters:
* 	       TSTring base          - the path to the root directory for the specific Pamela unpack session
*                                      There is no default value, without this input the program will not run
*              TString outDir        - the path where to save the output image (Default = ./) 
*              TString format        - the format which will be used fo rsave the produced images (Default = "jpg") 
*
*
* Version 1.7
* Date 16 June 2006 - Malvezzi
*
* Description of changes:
*                         Implementation of the case: numebr of events <= 0.
*                         Remove graph "grPcktId1"; see PacketScan for the same information.
*             Fixed bugs: for a large namber of events is not possible to have vectors, so I have subsituted graphs with histograms
*                         or divided the graphs in more than one canvas.
*
* Version 1.8
* Date 8 August 2006 - Malvezzi
*
* Description: changed the scale in the second and third graph of the first canvas; added a pad of text in the second canvas 
*
*/


#include <fstream>
#include <math.h>
#include "TLatex.h"
#include "TF1.h"
#include "TPaveText.h"
#include "TMultiGraph.h"
#include <sstream>
#include <iostream>
#include "TString.h"
#include "TStyle.h"
#include "TFile.h"
#include "TList.h"
#include "TTree.h"
#include "TObjString.h"
#include "TCanvas.h"
#include "TGraph.h"
#include "TH1F.h"
#include "TGaxis.h"
#include "EventHeader.h"
#include "PscuHeader.h"
#include "RunHeaderEvent.h"
#include "TPaveText.h"

using namespace std;

void HeaderScan(TString base, TString outDir, TString format)
{

  
  //------------------- Variables initilization -------------------------//
  Long64_t nevents=0, runnevents; 
  ULong_t lastime, firstime, primotempo, ultimotempo, primoffset=500000000, ultimoffset;
  double obmin=0., time=0.;
  double obmax=0.; 
  stringstream oss, oss1, oss2, oss3, noentries, stringa;
  //------- load root file --------------
  TFile *file = new TFile(base.Data());
  if (!file){
    printf("No such file in the directory has been found");
    return;
  }
  
  TTree *PhysicsTr = (TTree*)file->Get("Physics");
  TBranch *headBr = PhysicsTr->GetBranch("Header");

  pamela::EventHeader  *eh   = 0;
  pamela::PscuHeader   *ph   = 0;

  PhysicsTr->SetBranchAddress("Header", &eh);
  nevents = headBr->GetEntries();
  
  TTree *RunHeadTr = (TTree*)file->Get("RunHeader");  ///run header tree
  pamela::EventHeader *eH=0;
  pamela::RunHeaderEvent *reh=0;
  
  RunHeadTr->SetBranchAddress("Header",&eH);
  RunHeadTr->SetBranchAddress("RunHeader",&reh);
  runnevents = RunHeadTr->GetEntries();
 

  TString filename = ((TObjString*)base.Tokenize('/')->Last())->GetString(); 
  filename = ((TObjString*)filename.Tokenize('.')->First())->GetString();

  //----------- If nevents < = 0 ---------------------------------/
  if (nevents<=0) {
    printf("nevents = %i \n", nevents);
    printf(" \n");

    TCanvas *canv = new TCanvas("No entries", "No entries ", 400, 200);
    canv->SetFillColor(10);
    canv->cd();

    TLatex *l = new TLatex();
    l->SetTextAlign(12);
    l->SetTextSize(0.15);
    l->SetTextColor(2);
    noentries.str("");
    noentries<< "HeaderScan_QL:";
    l->DrawLatex(0.05, 0.7, noentries.str().c_str()); 
    noentries.str("");
    noentries<< "No Physics entries for this files";
    l->DrawLatex(0.05, 0.5, noentries.str().c_str()); 

    if (outDir == "./") {
      oss.str("");
      oss << filename.Data() << "_HeaderScan_QL." << format.Data();
    } else {
      oss.str("");
      oss << outDir.Data() << filename.Data() << "_HeaderScan_QL." << format.Data();
    }
  
    canv->Update();
    canv->SaveAs(oss.str().c_str()); 

    return;
  }

  //-------------- to know the max and min OBT ----------------------------//
   headBr->GetEntry(0);
   ph = eh->GetPscuHeader();
   firstime = ph->GetOrbitalTime();

   int iii =0;
   while(iii < nevents){
     headBr->GetEntry(iii);
     ph = eh->GetPscuHeader();
     if((ph->GetOrbitalTime()) <= firstime) firstime=ph->GetOrbitalTime();
     if((ph->GetOrbitalTime()) >= lastime) lastime=ph->GetOrbitalTime();
     iii++;
     }
  
  //------------------------ First histogram -----------------------------------//
   
  obmin=firstime;
  obmax=lastime;  
  
  oss1.str("");
  oss1 << filename.Data() <<": Physics Packet per minute.  Start time = " << obmin << ", End time = "<< obmax <<" ms";
  Int_t  nbin   = (lastime-firstime)/60000;
  //TH1F *h1 = new TH1F ("histo1", oss1.str().c_str(), nbin, obmin, obmax);
  TH1F *h1 = new TH1F ("histo1", "" , nbin, obmin, obmax);
  
  oss2.str("");
  oss2 << filename.Data() <<": Lenght of Physic packets";
  Int_t  nbin2  =(lastime-firstime);
  //TH1F *packetLength = new TH1F ("packetLength", oss2.str().c_str(), nbin2, obmin, obmax);
  TH1F *packetLength = new TH1F ("packetLength", "", nbin2, obmin, obmax);

  oss3.str("");
  oss3 << filename.Data() <<": Physics Counter vs. OBT";
  //  TH1F *packeCounter = new TH1F ("packeCounter", oss3.str().c_str(), nbin2, obmin, obmax);
  TH1F *packeCounter = new TH1F ("packeCounter", "", nbin2, obmin, obmax);
  //----------------------------------------------------
  TCanvas *finalCanv = new TCanvas("Header", base, 1200, 1600);
  finalCanv->Divide(1,5);
  finalCanv->SetFillColor(10);
  
  TPad *all2= new TPad ("","", 0, 0, 1, 1);
  all2->SetFillColor(10);
  TPad *all3= new TPad ("","", 0, 0, 1, 1);
  all3->SetFillColor(10);
  TPad *all4= new TPad ("","", 0, 0, 1, 1);
  all4->SetFillColor(10);
  TPad *all= new TPad ("","", 0, 0, 1, 1);
  all->SetFillColor(10);
  TPad *all1= new TPad ("","", 0, 0, 1, 1);
  all1->SetFillColor(10);
  TPad *pad = new TPad("pad","pad", .80,.50,.90,.80);
  pad->SetFillColor(10);
  //----------------------------------------------------

  TMultiGraph *mg1 = new TMultiGraph();
 

  TMultiGraph *mg2 = new TMultiGraph();

 
  //--------------------------------------------------------------------------
  for (Int_t l = 0; l < nevents; l++){
    headBr->GetEntry(l);
    ph = eh->GetPscuHeader();  
    h1->Fill(ph->GetOrbitalTime()); 
    packetLength->Fill(ph->GetOrbitalTime(),ph->GetPacketLenght());
    packeCounter->Fill(ph->GetOrbitalTime(),ph->GetCounter());
  }   

  //------------ First Canvas ---------------------//
  TLine li;
  li.SetLineStyle(4);
  li.SetLineWidth(2);
  
  finalCanv->cd(1);
  all2->Draw();
  all2->cd();

  h1->SetStats(kFALSE);
  h1->GetXaxis()->SetTitle("OBT   (ms)");
  h1->GetXaxis()->CenterTitle();
  h1->GetXaxis()->SetLabelSize(0.04);
  h1->GetYaxis()->SetTitle("Number of events ");
  h1->GetYaxis()->CenterTitle();
  h1->GetYaxis()->SetLabelSize(0.06);
  h1->GetYaxis()->SetTitleSize(0.06);
  h1->GetYaxis()->SetTitleOffset(0.6);
  h1->Draw();
  for (Int_t l = 0; l < runnevents; l++){
    RunHeadTr->GetEntry(l);
    ph = eH->GetPscuHeader();
    int ws= reh->RM_ACQ_SETTING_MODE;
    int id = ph->GetPacketId1();
    Int_t obt = ph->GetOrbitalTime();
    if (ws==1){
      li.SetLineColor(3);
      li.DrawLine(obt,0,obt,h1->GetMaximum());
    }
    else if (ws==2){
      li.SetLineColor(4);
      li.DrawLine(obt,0,obt,h1->GetMaximum());
    }
  }  
 
  finalCanv->cd(1);
  stringstream ws1, ws2;
  ws1.str("");
  ws2.str("");
  ws1<<"ACQ_SETTING_MODE = 1";
  ws2<<"ACQ_SETTING_MODE = 2";
  TPaveText *pt=0;
  pt = new TPaveText (.60,.92,.76,.98);
  pt->AddText(ws1.str().c_str());
  pt->SetTextColor(3);
  pt->SetFillColor(10);
  pt->SetBorderSize(0);
  pt->Draw();
  TPaveText *pt1=0;
  pt1 = new TPaveText (.76,.92,.92,.98);
  pt1->AddText(ws2.str().c_str());
  pt1->SetTextColor(4);
  pt1->SetFillColor(10);
  pt1->SetBorderSize(0);
  pt1->Draw();
  //  TPaveText *pt1=0;
  pt1 = new TPaveText (.05,.91,.6,1);
  pt1->AddText(oss1.str().c_str());
  pt1->SetTextColor(1);
  pt1->SetFillColor(10);
  pt1->SetBorderSize(0);
  pt1->Draw();

  finalCanv->cd(2);
  all3->Draw();
  all3->cd();
  packetLength->SetStats(kFALSE);
  packetLength->SetMarkerColor(2);
  packetLength->SetMarkerSize(.5);
  packetLength->SetMarkerStyle(21);
  packetLength->GetXaxis()->SetTitle("OBT    (ms)");
  packetLength->GetXaxis()->CenterTitle();
  packetLength->GetXaxis()->SetLabelSize(0.05);
  packetLength->GetYaxis()->SetTitle("Lenght  (byte)");
  packetLength->GetYaxis()->CenterTitle();
  packetLength->GetYaxis()->SetLabelSize(0.05);
  packetLength->GetYaxis()->SetTitleSize(0.06);
  packetLength->GetYaxis()->SetTitleOffset(0.6);
  packetLength->Draw("9p");
  finalCanv->cd(2);
  //TPaveText *pt=0;
  pt = new TPaveText (.6,.91,.90,1);
  pt->AddText(oss2.str().c_str());
  pt->SetTextColor(2);
  pt->SetFillColor(10);
  pt->SetBorderSize(0);
  pt->Draw();

  finalCanv->cd(3);
  all4->Draw();
  all4->cd();
  packeCounter->GetTitle();
  packeCounter->SetStats(kFALSE);
  packeCounter->SetMarkerColor(4);
  packeCounter->SetMarkerSize(.2);
  packeCounter->SetMarkerStyle(21);
  packeCounter->GetXaxis()->SetTitle("OBT    (ms)");
  packeCounter->GetXaxis()->SetTitleSize(0.05);
  packeCounter->GetXaxis()->CenterTitle();
  packeCounter->GetXaxis()->SetLabelSize(0.05);
  packeCounter->GetYaxis()->SetTitle("Counter");
  packeCounter->GetYaxis()->SetTitleSize(0.05);
  packeCounter->GetYaxis()->CenterTitle();
  packeCounter->GetYaxis()->SetLabelSize(0.05);
  packeCounter->GetYaxis()->SetTitleSize(0.06);
  packeCounter->GetYaxis()->SetTitleOffset(0.6);
   Double_t min = 500000000.;
   for (Int_t l = 0; l < nevents; l++){
     if((packeCounter->GetBinContent(l))<=  min && (packeCounter->GetBinContent(l))!= 0) min = packeCounter->GetBinContent(l);
     }  
  packeCounter->SetMinimum(min);
  packeCounter->Draw("9p");
  finalCanv->cd(3);
  TPaveText *pt2=0;
  pt2 = new TPaveText (.6,.91,.90,1);
  pt2->AddText(oss3.str().c_str());
  pt2->SetTextColor(4);
  pt2->SetFillColor(10);
  pt2->SetBorderSize(0);
  pt2->Draw();
  
  
  //-------------------------------------------------
  TList *list = new TList;
  Int_t numkey;
  TObject *key = new TObject;
  const char *name;
  TTree* tr = new TTree;
  Long64_t nevntskey=0;
  list = file->GetListOfKeys(); 
  numkey = file->GetNkeys();
  int ll=0;
  int kk=0;
 
  for (Int_t i=0; i<numkey; i++){
    key = list->At(i);
    name=(char *)(key->GetName());
    tr = (TTree*)file->Get(name);
    if (tr->IsZombie()) continue;
    tr->SetBranchAddress("Header", &eh);
    TBranch *Br = tr->GetBranch("Header");
    nevntskey = tr->GetEntries();

    if(nevntskey !=0){
      Int_t size1=nevntskey;
      Double_t *PscuCounter1 = new Double_t[size1];
      Double_t *FileOffset1 = new Double_t[size1];
      Double_t *tempo1 = new Double_t[size1];
      //Double_t *salto= new Double_t[100];
      //Double_t *salto1= new Double_t[100];
      
      int l=0;
      while(l<nevntskey){
	Br->GetEntry(l);
	ph = eh->GetPscuHeader();  
	PscuCounter1[l]= ph->GetCounter();
	FileOffset1[l]=ph->GetFileOffset();
	tempo1[l]=ph->GetOrbitalTime();
	if(ph->GetFileOffset()<= primoffset){
	  primoffset =ph->GetFileOffset();
	  primotempo=ph->GetOrbitalTime();
	}
	if(ph->GetFileOffset()>= ultimoffset){
	  ultimoffset = ph->GetFileOffset();
	  ultimotempo = ph->GetOrbitalTime();
	  }
	/*if(l>0){
	  if(tempo1[l] < tempo1[l-1]){
	    salto1[kk] =(const Double_t*)tempo1[l-1];
	    salto[ll]= ph->GetOrbitalTime();
	    ll=ll+1;
	    kk=kk+1;
	  }
	  }*/
	l++;
      }
      
      TGraph *graph3= new TGraph(nevntskey, (const Double_t*)FileOffset1, (const Double_t*)PscuCounter1);
      graph3->SetMarkerColor(3);
      graph3->SetMarkerSize(.2);
      graph3->SetMarkerStyle(21);
      mg1->Add(graph3);
      
      TGraph *graph4= new TGraph(nevntskey, (const Double_t*)FileOffset1, (const Double_t*)tempo1);
      graph4->SetMarkerColor(kBlue);
      graph4->SetMarkerSize(.2);
      graph4->SetMarkerStyle(21);
      mg2->Add(graph4);
    }
  }
 
  kk=kk-1;
  ll=ll-1;

  TLatex *lat = new TLatex();
  lat->SetTextAlign(12);
  lat->SetTextSize(0.15);
  lat->SetTextColor(kBlue);
 //------------ Second Canvas ---------------------//
   finalCanv->cd(4);
   all1->Draw();
   all1->cd();

   oss1.str("");
   oss1 << filename.Data() <<": PscuCounter vs FileOffset.";
   //mg1->SetTitle(oss1.str().c_str());
   mg1->Draw("AP");
   mg1->GetXaxis()->SetTitle("File Offset");
   mg1->GetXaxis()->CenterTitle();
   mg1->GetXaxis()->SetTitleSize(0.045);
   mg1->GetXaxis()->SetLabelSize(0.05);
   mg1->GetYaxis()->SetTitle("Counter");
   mg1->GetYaxis()->CenterTitle();
   mg1->GetYaxis()->SetTitleSize(0.05);
   mg1->GetYaxis()->SetLabelSize(0.06);
   mg1->GetYaxis()->SetTitleOffset(0.7);
   finalCanv->cd(4);
   TPaveText *pt3=0;
   pt3 = new TPaveText (.60,.91,.90,1);
   pt3->AddText(oss1.str().c_str());
   pt3->SetTextColor(3);
   pt3->SetFillColor(10);
   pt3->SetBorderSize(0);
   pt3->Draw();


   finalCanv->cd(5);
   all->Draw();
   all->cd();
   
   oss3.str("");
   oss3 << filename.Data() <<" OBT vs FileOffset. First packet = "<<primotempo <<" ms,  Last packet = "<<ultimotempo<<" ms.";
   //mg2->SetTitle(oss3.str().c_str());
   mg2->Draw("AP");
   mg2->GetXaxis()->SetTitle("File Offset");
   mg2->GetXaxis()->CenterTitle();
   mg2->GetXaxis()->SetTitleSize(0.045);
   mg2->GetXaxis()->SetLabelSize(0.05);
   mg2->GetYaxis()->SetTitle("OBT");
   mg2->GetYaxis()->CenterTitle();
   mg2->GetYaxis()->SetTitleSize(0.05);
   mg2->GetYaxis()->SetLabelSize(0.055);
   mg2->GetYaxis()->SetTitleOffset(0.6);
   /*pad->Draw();
   pad->cd();
   stringa.str("");
   stringa << "new data from "<< primotempo;//<<" to "<< salto1;
   lat->DrawLatex(0.08, 0.8, stringa.str().c_str()); 
   double min2 = 0.8;
   if(ll > 0){
   pad->Draw();
   pad->cd();
    for(Int_t k=0; k <(kk); k++){
      stringa.str("");
      stringa << "old data from "<< salto[kk]<< " to "<<salto1[kk+1];
      min2=min2-0.1;
      lat->DrawLatex(0.08, min2,stringa.str().c_str()); 
      //cout<<salto[kk]<<";\n";
    }
    }*/

   finalCanv->cd(5);
   TPaveText *pt4=0;
   pt4 = new TPaveText (.38 ,.91,.92,1);
   pt4->AddText(oss3.str().c_str());
   pt4->SetTextColor(kBlue);
   pt4->SetFillColor(10);
   pt4->SetBorderSize(0);
   pt4->Draw();

   // finalCanv->Draw();
   finalCanv->Update();

   oss1.str("");
   oss1 << outDir.Data() << filename.Data();
   oss1 << "_HeaderScan"<<"." << format.Data();

   finalCanv->SaveAs(oss1.str().c_str());

  

   file->Close();
  
}

int main(int argc, char* argv[]){
  TString path;
  TString outDir     = "./";
  TString format     = "jpg";
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  
  if (!strcmp(argv[1], "--help")){
        printf( "Usage: HeaderScan FILE [OPTION] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t -outDir[path]          Path where to put the output [default ./] \n");
        printf( "\t -format[jpg|ps|gif]    Format for output files [default 'jpg'] \n");
        exit(1);
  }
  path=argv[1];
  for (int i = 2; i < argc; i++){ 
    if (!strcmp(argv[i], "-outDir")){
      if (++i >= argc){
	printf( "-outDir needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	outDir = argv[i];
	continue;
      }
    }  
    if (!strcmp(argv[i], "-format")){
      if (++i >= argc){
	printf( "-format needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      }
      else{
	format = argv[i];
	continue;
      }
    }
  }
  HeaderScan(argv[1], outDir, format);
}

